from distutils.core import setup
from BeautifulSoup import __version__

setup(name="BeautifulSoup",
      version=__version__,
      py_modules=['BeautifulSoup'],
      description="HTML/XML parser for quick-turnaround applications like screen-scraping.",
      author="Leonard Richardson",
      author_email = "leonardr@segfault.org",
      long_description="""Beautiful Soup parses arbitrarily invalid SGML and provides a variety of methods and Pythonic idioms for iterating and searching the parse tree.""",
      classifiers=["Development Status :: 5 - Production/Stable",
                   "Intended Audience :: Developers",
                   "License :: OSI Approved :: Python Software Foundation License",
                   "Programming Language :: Python",
                   "Topic :: Text Processing :: Markup :: HTML",
                   "Topic :: Text Processing :: Markup :: XML",
                   "Topic :: Text Processing :: Markup :: SGML",
                   "Topic :: Software Development :: Libraries :: Python Modules",
                   ],
      url="http://www.crummy.com/software/BeautifulSoup/",
      license="BSD",
      download_url="http://www.crummy.com/software/BeautifulSoup/download/"
      )
