/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_videowidgetinterface_wrapper.h"

// Extra includes
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

VideoWidgetInterfaceWrapper::VideoWidgetInterfaceWrapper() : Phonon::VideoWidgetInterface() {
    // ... middle
}

Phonon::VideoWidget::AspectRatio VideoWidgetInterfaceWrapper::aspectRatio() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "aspectRatio"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.aspectRatio()' not implemented.");
        return Phonon::VideoWidget::AspectRatio();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Phonon::VideoWidget::AspectRatio();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Phonon::VideoWidget::AspectRatio >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.aspectRatio", SbkType<Phonon::VideoWidget::AspectRatio >()->tp_name, py_result->ob_type->tp_name);
        return Phonon::VideoWidget::AspectRatio();
    }
    Phonon::VideoWidget::AspectRatio cpp_result(Shiboken::Converter<Phonon::VideoWidget::AspectRatio >::toCpp(py_result));
    return cpp_result;
}

qreal VideoWidgetInterfaceWrapper::brightness() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "brightness"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.brightness()' not implemented.");
        return qreal(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qreal(0);
    }
    // Check return type
    bool typeIsValid = PyFloat_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.brightness", SbkType<qreal >()->tp_name, py_result->ob_type->tp_name);
        return qreal(0);
    }
    qreal cpp_result(Shiboken::Converter<double >::toCpp(py_result));
    return cpp_result;
}

qreal VideoWidgetInterfaceWrapper::contrast() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contrast"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.contrast()' not implemented.");
        return qreal(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qreal(0);
    }
    // Check return type
    bool typeIsValid = PyFloat_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.contrast", SbkType<qreal >()->tp_name, py_result->ob_type->tp_name);
        return qreal(0);
    }
    qreal cpp_result(Shiboken::Converter<double >::toCpp(py_result));
    return cpp_result;
}

qreal VideoWidgetInterfaceWrapper::hue() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.hue()' not implemented.");
        return qreal(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qreal(0);
    }
    // Check return type
    bool typeIsValid = PyFloat_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.hue", SbkType<qreal >()->tp_name, py_result->ob_type->tp_name);
        return qreal(0);
    }
    qreal cpp_result(Shiboken::Converter<double >::toCpp(py_result));
    return cpp_result;
}

qreal VideoWidgetInterfaceWrapper::saturation() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saturation"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.saturation()' not implemented.");
        return qreal(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qreal(0);
    }
    // Check return type
    bool typeIsValid = PyFloat_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.saturation", SbkType<qreal >()->tp_name, py_result->ob_type->tp_name);
        return qreal(0);
    }
    qreal cpp_result(Shiboken::Converter<double >::toCpp(py_result));
    return cpp_result;
}

Phonon::VideoWidget::ScaleMode VideoWidgetInterfaceWrapper::scaleMode() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scaleMode"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.scaleMode()' not implemented.");
        return Phonon::VideoWidget::ScaleMode();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Phonon::VideoWidget::ScaleMode();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Phonon::VideoWidget::ScaleMode >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.scaleMode", SbkType<Phonon::VideoWidget::ScaleMode >()->tp_name, py_result->ob_type->tp_name);
        return Phonon::VideoWidget::ScaleMode();
    }
    Phonon::VideoWidget::ScaleMode cpp_result(Shiboken::Converter<Phonon::VideoWidget::ScaleMode >::toCpp(py_result));
    return cpp_result;
}

void VideoWidgetInterfaceWrapper::setAspectRatio(Phonon::VideoWidget::AspectRatio arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setAspectRatio"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setAspectRatio()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::VideoWidget::AspectRatio >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VideoWidgetInterfaceWrapper::setBrightness(qreal arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setBrightness"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setBrightness()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VideoWidgetInterfaceWrapper::setContrast(qreal arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setContrast"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setContrast()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VideoWidgetInterfaceWrapper::setHue(qreal arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setHue()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VideoWidgetInterfaceWrapper::setSaturation(qreal arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSaturation"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setSaturation()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VideoWidgetInterfaceWrapper::setScaleMode(Phonon::VideoWidget::ScaleMode arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setScaleMode"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setScaleMode()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::VideoWidget::ScaleMode >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * VideoWidgetInterfaceWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.widget()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VideoWidgetInterface.widget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

VideoWidgetInterfaceWrapper::~VideoWidgetInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_VideoWidgetInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    VideoWidgetInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGETINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::VideoWidgetInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // VideoWidgetInterface()
    cptr = new VideoWidgetInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::VideoWidgetInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_aspectRatio(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // aspectRatio()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.aspectRatio()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    Phonon::VideoWidget::AspectRatio cpp_result = cppSelf->aspectRatio();
    py_result = Shiboken::Converter<Phonon::VideoWidget::AspectRatio >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_brightness(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brightness()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.brightness()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->brightness();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_contrast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contrast()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.contrast()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->contrast();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_hue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hue()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.hue()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->hue();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_saturation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // saturation()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.saturation()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->saturation();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_scaleMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scaleMode()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.scaleMode()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    Phonon::VideoWidget::ScaleMode cpp_result = cppSelf->scaleMode();
    py_result = Shiboken::Converter<Phonon::VideoWidget::ScaleMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_setAspectRatio(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::VideoWidget::AspectRatio >::isConvertible(arg)) {
        Phonon::VideoWidget::AspectRatio cpp_arg0 = Shiboken::Converter<Phonon::VideoWidget::AspectRatio >::toCpp(arg);
        // setAspectRatio(Phonon::VideoWidget::AspectRatio)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setAspectRatio()' not implemented.");
            return 0;
        }
        Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
        cppSelf->setAspectRatio(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VideoWidgetInterfaceFunc_setAspectRatio_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VideoWidgetInterfaceFunc_setAspectRatio_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::VideoWidget.AspectRatio", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VideoWidgetInterface.setAspectRatio", overloads);
        return 0;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_setBrightness(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBrightness(qreal)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setBrightness()' not implemented.");
            return 0;
        }
        Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
        cppSelf->setBrightness(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VideoWidgetInterfaceFunc_setBrightness_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VideoWidgetInterfaceFunc_setBrightness_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VideoWidgetInterface.setBrightness", overloads);
        return 0;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_setContrast(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setContrast(qreal)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setContrast()' not implemented.");
            return 0;
        }
        Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
        cppSelf->setContrast(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VideoWidgetInterfaceFunc_setContrast_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VideoWidgetInterfaceFunc_setContrast_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VideoWidgetInterface.setContrast", overloads);
        return 0;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_setHue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHue(qreal)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setHue()' not implemented.");
            return 0;
        }
        Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
        cppSelf->setHue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VideoWidgetInterfaceFunc_setHue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VideoWidgetInterfaceFunc_setHue_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VideoWidgetInterface.setHue", overloads);
        return 0;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_setSaturation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setSaturation(qreal)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setSaturation()' not implemented.");
            return 0;
        }
        Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
        cppSelf->setSaturation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VideoWidgetInterfaceFunc_setSaturation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VideoWidgetInterfaceFunc_setSaturation_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VideoWidgetInterface.setSaturation", overloads);
        return 0;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_setScaleMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::VideoWidget::ScaleMode >::isConvertible(arg)) {
        Phonon::VideoWidget::ScaleMode cpp_arg0 = Shiboken::Converter<Phonon::VideoWidget::ScaleMode >::toCpp(arg);
        // setScaleMode(Phonon::VideoWidget::ScaleMode)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.setScaleMode()' not implemented.");
            return 0;
        }
        Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
        cppSelf->setScaleMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VideoWidgetInterfaceFunc_setScaleMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VideoWidgetInterfaceFunc_setScaleMode_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::VideoWidget.ScaleMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VideoWidgetInterface.setScaleMode", overloads);
        return 0;
}

static PyObject* SbkPhonon_VideoWidgetInterfaceFunc_widget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widget()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'VideoWidgetInterface.widget()' not implemented.");
        return 0;
    }
    Phonon::VideoWidgetInterface* cppSelf = Shiboken::Converter<Phonon::VideoWidgetInterface* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->widget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_VideoWidgetInterface_methods[] = {
    {"aspectRatio", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_aspectRatio, METH_NOARGS},
    {"brightness", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_brightness, METH_NOARGS},
    {"contrast", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_contrast, METH_NOARGS},
    {"hue", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_hue, METH_NOARGS},
    {"saturation", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_saturation, METH_NOARGS},
    {"scaleMode", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_scaleMode, METH_NOARGS},
    {"setAspectRatio", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_setAspectRatio, METH_O},
    {"setBrightness", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_setBrightness, METH_O},
    {"setContrast", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_setContrast, METH_O},
    {"setHue", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_setHue, METH_O},
    {"setSaturation", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_setSaturation, METH_O},
    {"setScaleMode", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_setScaleMode, METH_O},
    {"widget", (PyCFunction)SbkPhonon_VideoWidgetInterfaceFunc_widget, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_VideoWidgetInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.VideoWidgetInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_VideoWidgetInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_VideoWidgetInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::VideoWidgetInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_VideoWidgetInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_VideoWidgetInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::VideoWidgetInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_Phonon_VideoWidgetInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGETINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_VideoWidgetInterface_Type);

    // Fill type discovery information
    SbkPhonon_VideoWidgetInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_VideoWidgetInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_VideoWidgetInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_VideoWidgetInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"VideoWidgetInterface", (PyObject*)&SbkPhonon_VideoWidgetInterface_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::VideoWidgetInterface >("Phonon::VideoWidgetInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::VideoWidgetInterface >(typeid(Phonon::VideoWidgetInterface).name());
}


} // extern "C"

