/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtwebkit_python.h"

#include "qwebframe_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qprinter.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qstring.h>
#include <qthread.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebelement.h>
#include <qwebframe.h>
#include <qwebpage.h>
#include <qwebsecurityorigin.h>

using namespace Shiboken;

static PyObject* SbkQWebFrameFunc_addToJavaScriptWindowObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addToJavaScriptWindowObject", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // addToJavaScriptWindowObject(QString,QObject*)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::addToJavaScriptWindowObject(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQWebFrameFunc_addToJavaScriptWindowObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_addToJavaScriptWindowObject_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.addToJavaScriptWindowObject", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_baseUrl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // baseUrl()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebFrame::baseUrl();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_childFrames(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childFrames()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QList<QWebFrame * > cpp_result = cppSelf->QWebFrame::childFrames();
    py_result = Shiboken::Converter<QList<QWebFrame * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_contentsSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentsSize()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWebFrame::contentsSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_documentElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentElement()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebFrame::documentElement();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_evaluateJavaScript(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // evaluateJavaScript(QString)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QWebFrame::evaluateJavaScript(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_evaluateJavaScript_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_evaluateJavaScript_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.evaluateJavaScript", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebFrame::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.event", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_findAllElements(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // findAllElements(QString)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        QWebElementCollection cpp_result = cppSelf->QWebFrame::findAllElements(*cpp_arg0);
        py_result = Shiboken::Converter<QWebElementCollection >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_findAllElements_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_findAllElements_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.findAllElements", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_findFirstElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // findFirstElement(QString)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        QWebElement cpp_result = cppSelf->QWebFrame::findFirstElement(*cpp_arg0);
        py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_findFirstElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_findFirstElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.findFirstElement", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_frameName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameName()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebFrame::frameName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWebFrame::geometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_hasFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFocus()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebFrame::hasFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_hitTestContent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // hitTestContent(QPoint)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        QWebHitTestResult cpp_result = cppSelf->QWebFrame::hitTestContent(*cpp_arg0);
        py_result = Shiboken::Converter<QWebHitTestResult >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_hitTestContent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_hitTestContent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.hitTestContent", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QWebFrame::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_load(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "load", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // load(QUrl)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::load(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QNetworkRequest & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // load(QNetworkRequest,QNetworkAccessManager::Operation,QByteArray)
            QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
            cppSelf->QWebFrame::load(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QNetworkAccessManager::Operation >::isConvertible(pyargs[1])) {
            QNetworkAccessManager::Operation cpp_arg1 = Shiboken::Converter<QNetworkAccessManager::Operation >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // load(QNetworkRequest,QNetworkAccessManager::Operation,QByteArray)
                QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
                cppSelf->QWebFrame::load(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QByteArray > cpp_arg2_auto_ptr;
                QByteArray* cpp_arg2 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[2]);
                if (!SbkQByteArray_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg2);
                // load(QNetworkRequest,QNetworkAccessManager::Operation,QByteArray)
                QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
                cppSelf->QWebFrame::load(*cpp_arg0, cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQWebFrameFunc_load_TypeError;
        } else goto SbkQWebFrameFunc_load_TypeError;
    } else goto SbkQWebFrameFunc_load_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest, PySide.QtNetwork.QNetworkAccessManager.Operation = QNetworkAccessManager.GetOperation, PySide.QtCore.QByteArray = QByteArray()", "PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.load", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_page(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // page()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QWebPage * cpp_result = cppSelf->QWebFrame::page();
    py_result = Shiboken::Converter<QWebPage * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_parentFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentFrame()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QWebFrame * cpp_result = cppSelf->QWebFrame::parentFrame();
    py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QWebFrame::pos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_print(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPrinter* cpp_arg0 = Shiboken::Converter<QPrinter* >::toCpp(arg);
        // print(QPrinter*)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::print(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_print_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_print_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.print", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_render(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "render", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainter * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // render(QPainter*)
            QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
            cppSelf->QWebFrame::render(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QRegion & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QRegion > cpp_arg1_auto_ptr;
            QRegion* cpp_arg1 = Shiboken::Converter<QRegion* >::toCpp(pyargs[1]);
            if (!SbkQRegion_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QRegion >(cpp_arg1);
            // render(QPainter*,QRegion)
            QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
            cppSelf->QWebFrame::render(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWebFrame::RenderLayer >::isConvertible(pyargs[1])) {
            QWebFrame::RenderLayer cpp_arg1 = Shiboken::Converter<QWebFrame::RenderLayer >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // render(QPainter*,QWebFrame::RenderLayer,QRegion)
                QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
                cppSelf->QWebFrame::render(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QRegion & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QRegion > cpp_arg2_auto_ptr;
                QRegion* cpp_arg2 = Shiboken::Converter<QRegion* >::toCpp(pyargs[2]);
                if (!SbkQRegion_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QRegion >(cpp_arg2);
                // render(QPainter*,QWebFrame::RenderLayer,QRegion)
                QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
                cppSelf->QWebFrame::render(cpp_arg0, cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQWebFrameFunc_render_TypeError;
        } else goto SbkQWebFrameFunc_render_TypeError;
    } else goto SbkQWebFrameFunc_render_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_render_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", "PySide.QtGui.QPainter, PySide.QtWebKit.QWebFrame.RenderLayer, PySide.QtGui.QRegion = QRegion()", "PySide.QtGui.QPainter, PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.render", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_renderTreeDump(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // renderTreeDump()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebFrame::renderTreeDump();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_requestedUrl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // requestedUrl()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebFrame::requestedUrl();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_scroll(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scroll", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scroll(int,int)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::scroll(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_scroll_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_scroll_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.scroll", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_scrollBarGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // scrollBarGeometry(Qt::Orientation)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QWebFrame::scrollBarGeometry(cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_scrollBarGeometry_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_scrollBarGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.scrollBarGeometry", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_scrollBarMaximum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // scrollBarMaximum(Qt::Orientation)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWebFrame::scrollBarMaximum(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_scrollBarMaximum_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_scrollBarMaximum_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.scrollBarMaximum", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_scrollBarMinimum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // scrollBarMinimum(Qt::Orientation)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWebFrame::scrollBarMinimum(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_scrollBarMinimum_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_scrollBarMinimum_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.scrollBarMinimum", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_scrollBarPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // scrollBarPolicy(Qt::Orientation)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        Qt::ScrollBarPolicy cpp_result = cppSelf->QWebFrame::scrollBarPolicy(cpp_arg0);
        py_result = Shiboken::Converter<Qt::ScrollBarPolicy >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_scrollBarPolicy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_scrollBarPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.scrollBarPolicy", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_scrollBarValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // scrollBarValue(Qt::Orientation)const
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWebFrame::scrollBarValue(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_scrollBarValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebFrameFunc_scrollBarValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.scrollBarValue", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_scrollPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scrollPosition()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QWebFrame::scrollPosition();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_securityOrigin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // securityOrigin()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QWebSecurityOrigin cpp_result = cppSelf->QWebFrame::securityOrigin();
    py_result = Shiboken::Converter<QWebSecurityOrigin >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_setContent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setContent", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // setContent(QByteArray,QString,QUrl)
            QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
            cppSelf->QWebFrame::setContent(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // setContent(QByteArray,QString,QUrl)
                QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
                cppSelf->QWebFrame::setContent(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QUrl > cpp_arg2_auto_ptr;
                QUrl* cpp_arg2 = Shiboken::Converter<QUrl* >::toCpp(pyargs[2]);
                if (!SbkQUrl_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QUrl >(cpp_arg2);
                // setContent(QByteArray,QString,QUrl)
                QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
                cppSelf->QWebFrame::setContent(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQWebFrameFunc_setContent_TypeError;
        } else goto SbkQWebFrameFunc_setContent_TypeError;
    } else goto SbkQWebFrameFunc_setContent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setContent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QString = QString(), PySide.QtCore.QUrl = QUrl()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.setContent", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setFocus()
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    cppSelf->QWebFrame::setFocus();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebFrameFunc_setHtml(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setHtml", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setHtml(QString,QUrl)
            QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
            cppSelf->QWebFrame::setHtml(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // setHtml(QString,QUrl)
            QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
            cppSelf->QWebFrame::setHtml(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWebFrameFunc_setHtml_TypeError;
    } else goto SbkQWebFrameFunc_setHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QUrl = QUrl()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.setHtml", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setScrollBarPolicy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setScrollBarPolicy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::ScrollBarPolicy >::isConvertible(pyargs[1])) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[0]);
        Qt::ScrollBarPolicy cpp_arg1 = Shiboken::Converter<Qt::ScrollBarPolicy >::toCpp(pyargs[1]);
        // setScrollBarPolicy(Qt::Orientation,Qt::ScrollBarPolicy)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::setScrollBarPolicy(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_setScrollBarPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setScrollBarPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation, PySide.QtCore.Qt.ScrollBarPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.setScrollBarPolicy", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setScrollBarValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setScrollBarValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setScrollBarValue(Qt::Orientation,int)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::setScrollBarValue(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_setScrollBarValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setScrollBarValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebFrame.setScrollBarValue", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setScrollPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setScrollPosition(QPoint)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::setScrollPosition(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_setScrollPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setScrollPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.setScrollPosition", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setTextSizeMultiplier(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTextSizeMultiplier(qreal)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::setTextSizeMultiplier(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_setTextSizeMultiplier_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setTextSizeMultiplier_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.setTextSizeMultiplier", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setUrl(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // setUrl(QUrl)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::setUrl(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_setUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.setUrl", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_setZoomFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setZoomFactor(qreal)
        QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
        cppSelf->QWebFrame::setZoomFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebFrameFunc_setZoomFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebFrameFunc_setZoomFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebFrame.setZoomFactor", overloads);
        return 0;
}

static PyObject* SbkQWebFrameFunc_textSizeMultiplier(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textSizeMultiplier()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QWebFrame::textSizeMultiplier();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_title(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // title()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebFrame::title();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_toHtml(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toHtml()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebFrame::toHtml();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_toPlainText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPlainText()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebFrame::toPlainText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_url(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // url()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebFrame::url();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebFrameFunc_zoomFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // zoomFactor()const
    QWebFrame* cppSelf = Shiboken::Converter<QWebFrame* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QWebFrame::zoomFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWebFrame_methods[] = {
    {"addToJavaScriptWindowObject", (PyCFunction)SbkQWebFrameFunc_addToJavaScriptWindowObject, METH_VARARGS},
    {"baseUrl", (PyCFunction)SbkQWebFrameFunc_baseUrl, METH_NOARGS},
    {"childFrames", (PyCFunction)SbkQWebFrameFunc_childFrames, METH_NOARGS},
    {"contentsSize", (PyCFunction)SbkQWebFrameFunc_contentsSize, METH_NOARGS},
    {"documentElement", (PyCFunction)SbkQWebFrameFunc_documentElement, METH_NOARGS},
    {"evaluateJavaScript", (PyCFunction)SbkQWebFrameFunc_evaluateJavaScript, METH_O},
    {"event", (PyCFunction)SbkQWebFrameFunc_event, METH_O},
    {"findAllElements", (PyCFunction)SbkQWebFrameFunc_findAllElements, METH_O},
    {"findFirstElement", (PyCFunction)SbkQWebFrameFunc_findFirstElement, METH_O},
    {"frameName", (PyCFunction)SbkQWebFrameFunc_frameName, METH_NOARGS},
    {"geometry", (PyCFunction)SbkQWebFrameFunc_geometry, METH_NOARGS},
    {"hasFocus", (PyCFunction)SbkQWebFrameFunc_hasFocus, METH_NOARGS},
    {"hitTestContent", (PyCFunction)SbkQWebFrameFunc_hitTestContent, METH_O},
    {"icon", (PyCFunction)SbkQWebFrameFunc_icon, METH_NOARGS},
    {"load", (PyCFunction)SbkQWebFrameFunc_load, METH_VARARGS},
    {"page", (PyCFunction)SbkQWebFrameFunc_page, METH_NOARGS},
    {"parentFrame", (PyCFunction)SbkQWebFrameFunc_parentFrame, METH_NOARGS},
    {"pos", (PyCFunction)SbkQWebFrameFunc_pos, METH_NOARGS},
    {"print", (PyCFunction)SbkQWebFrameFunc_print, METH_O},
    {"render", (PyCFunction)SbkQWebFrameFunc_render, METH_VARARGS},
    {"renderTreeDump", (PyCFunction)SbkQWebFrameFunc_renderTreeDump, METH_NOARGS},
    {"requestedUrl", (PyCFunction)SbkQWebFrameFunc_requestedUrl, METH_NOARGS},
    {"scroll", (PyCFunction)SbkQWebFrameFunc_scroll, METH_VARARGS},
    {"scrollBarGeometry", (PyCFunction)SbkQWebFrameFunc_scrollBarGeometry, METH_O},
    {"scrollBarMaximum", (PyCFunction)SbkQWebFrameFunc_scrollBarMaximum, METH_O},
    {"scrollBarMinimum", (PyCFunction)SbkQWebFrameFunc_scrollBarMinimum, METH_O},
    {"scrollBarPolicy", (PyCFunction)SbkQWebFrameFunc_scrollBarPolicy, METH_O},
    {"scrollBarValue", (PyCFunction)SbkQWebFrameFunc_scrollBarValue, METH_O},
    {"scrollPosition", (PyCFunction)SbkQWebFrameFunc_scrollPosition, METH_NOARGS},
    {"securityOrigin", (PyCFunction)SbkQWebFrameFunc_securityOrigin, METH_NOARGS},
    {"setContent", (PyCFunction)SbkQWebFrameFunc_setContent, METH_VARARGS},
    {"setFocus", (PyCFunction)SbkQWebFrameFunc_setFocus, METH_NOARGS},
    {"setHtml", (PyCFunction)SbkQWebFrameFunc_setHtml, METH_VARARGS},
    {"setScrollBarPolicy", (PyCFunction)SbkQWebFrameFunc_setScrollBarPolicy, METH_VARARGS},
    {"setScrollBarValue", (PyCFunction)SbkQWebFrameFunc_setScrollBarValue, METH_VARARGS},
    {"setScrollPosition", (PyCFunction)SbkQWebFrameFunc_setScrollPosition, METH_O},
    {"setTextSizeMultiplier", (PyCFunction)SbkQWebFrameFunc_setTextSizeMultiplier, METH_O},
    {"setUrl", (PyCFunction)SbkQWebFrameFunc_setUrl, METH_O},
    {"setZoomFactor", (PyCFunction)SbkQWebFrameFunc_setZoomFactor, METH_O},
    {"textSizeMultiplier", (PyCFunction)SbkQWebFrameFunc_textSizeMultiplier, METH_NOARGS},
    {"title", (PyCFunction)SbkQWebFrameFunc_title, METH_NOARGS},
    {"toHtml", (PyCFunction)SbkQWebFrameFunc_toHtml, METH_NOARGS},
    {"toPlainText", (PyCFunction)SbkQWebFrameFunc_toPlainText, METH_NOARGS},
    {"url", (PyCFunction)SbkQWebFrameFunc_url, METH_NOARGS},
    {"zoomFactor", (PyCFunction)SbkQWebFrameFunc_zoomFactor, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebFrame_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebFrame",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          Shiboken::deallocWrapperWithPrivateDtor,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebFrame_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtWebKit_QWebFrame_RenderLayer_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebFrame_RenderLayer_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderLayer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebFrame_RenderLayer_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebFrame_RenderLayer_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebFrame_RenderLayer_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QWebFrame(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebFrame_Type);

    SbkQWebFrame_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQWebFrame_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQWebFrame_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebFrame_Type));
    PyModule_AddObject(module, "QWebFrame",
        ((PyObject*)&SbkQWebFrame_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RenderLayer
    SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_RENDERLAYER_IDX] = &SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type);
    PyDict_SetItemString(SbkQWebFrame_Type.super.ht_type.tp_dict,
            "RenderLayer",((PyObject*)&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type,
        (long) QWebFrame::ContentsLayer, "ContentsLayer");
    PyDict_SetItemString(SbkQWebFrame_Type.super.ht_type.tp_dict,
        "ContentsLayer", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type.tp_dict,
        "ContentsLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type,
        (long) QWebFrame::ScrollBarLayer, "ScrollBarLayer");
    PyDict_SetItemString(SbkQWebFrame_Type.super.ht_type.tp_dict,
        "ScrollBarLayer", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type.tp_dict,
        "ScrollBarLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type,
        (long) QWebFrame::PanIconLayer, "PanIconLayer");
    PyDict_SetItemString(SbkQWebFrame_Type.super.ht_type.tp_dict,
        "PanIconLayer", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type.tp_dict,
        "PanIconLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type,
        (long) QWebFrame::AllLayers, "AllLayers");
    PyDict_SetItemString(SbkQWebFrame_Type.super.ht_type.tp_dict,
        "AllLayers", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebFrame_RenderLayer_Type.tp_dict,
        "AllLayers", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebFrame::RenderLayer");

    Shiboken::TypeResolver::createObjectTypeResolver<QWebFrame >("QWebFrame*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWebFrame >(typeid(QWebFrame).name());
}


} // extern "C"

