/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtsql_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtSql_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QSql(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlDriverCreatorBase(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlResult(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlRecord(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlRelation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlRelationalDelegate(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlField(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlError(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlDatabase(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlQueryModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlQuery(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlTableModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlRelationalTableModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlDriver(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSqlIndex(PyObject* module);

PyTypeObject** SbkPySide_QtSqlTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTSQL_API PyMODINIT_FUNC
initQtSql()
{
    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtSql", QtSql_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtSql_IDX_COUNT];
    SbkPySide_QtSqlTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QSql(module);
    init_QSqlDriverCreatorBase(module);
    init_QSqlResult(module);
    init_QSqlRecord(module);
    init_QSqlRelation(module);
    init_QSqlRelationalDelegate(module);
    init_QSqlField(module);
    init_QSqlError(module);
    init_QSqlDatabase(module);
    init_QSqlQueryModel(module);
    init_QSqlQuery(module);
    init_QSqlTableModel(module);
    init_QSqlRelationalTableModel(module);
    init_QSqlDriver(module);
    init_QSqlIndex(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtSql");
    }
}

} // extern "C"

