/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptcontextinfo_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qscriptcontext.h>
#include <qscriptcontextinfo.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQScriptContextInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptContextInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptContextInfo", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QScriptContextInfo()
        cptr = new QScriptContextInfo();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QScriptContext * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QScriptContext* cpp_arg0 = Shiboken::Converter<QScriptContext* >::toCpp(pyargs[0]);
        // QScriptContextInfo(const QScriptContext*)
        cptr = new QScriptContextInfo(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QScriptContextInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QScriptContextInfo > cpp_arg0_auto_ptr;
        QScriptContextInfo* cpp_arg0 = Shiboken::Converter<QScriptContextInfo* >::toCpp(pyargs[0]);
        if (!SbkQScriptContextInfo_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptContextInfo >(cpp_arg0);
        // QScriptContextInfo(QScriptContextInfo)
        cptr = new QScriptContextInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextInfo_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptContextInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptContextInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptContextInfo_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtScript.QScriptContext", "PySide.QtScript.QScriptContextInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptContextInfo", overloads);
        return -1;
}

static PyObject* SbkQScriptContextInfoFunc_columnNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnNumber()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptContextInfo::columnNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptContextInfo::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_functionEndLineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // functionEndLineNumber()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptContextInfo::functionEndLineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_functionMetaIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // functionMetaIndex()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptContextInfo::functionMetaIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_functionName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // functionName()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptContextInfo::functionName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_functionParameterNames(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // functionParameterNames()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QScriptContextInfo::functionParameterNames();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_functionStartLineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // functionStartLineNumber()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptContextInfo::functionStartLineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_functionType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // functionType()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    QScriptContextInfo::FunctionType cpp_result = cppSelf->QScriptContextInfo::functionType();
    py_result = Shiboken::Converter<QScriptContextInfo::FunctionType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptContextInfo::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_lineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineNumber()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptContextInfo::lineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextInfoFunc_scriptId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scriptId()const
    QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QScriptContextInfo::scriptId();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptContextInfo_methods[] = {
    {"columnNumber", (PyCFunction)SbkQScriptContextInfoFunc_columnNumber, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQScriptContextInfoFunc_fileName, METH_NOARGS},
    {"functionEndLineNumber", (PyCFunction)SbkQScriptContextInfoFunc_functionEndLineNumber, METH_NOARGS},
    {"functionMetaIndex", (PyCFunction)SbkQScriptContextInfoFunc_functionMetaIndex, METH_NOARGS},
    {"functionName", (PyCFunction)SbkQScriptContextInfoFunc_functionName, METH_NOARGS},
    {"functionParameterNames", (PyCFunction)SbkQScriptContextInfoFunc_functionParameterNames, METH_NOARGS},
    {"functionStartLineNumber", (PyCFunction)SbkQScriptContextInfoFunc_functionStartLineNumber, METH_NOARGS},
    {"functionType", (PyCFunction)SbkQScriptContextInfoFunc_functionType, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQScriptContextInfoFunc_isNull, METH_NOARGS},
    {"lineNumber", (PyCFunction)SbkQScriptContextInfoFunc_lineNumber, METH_NOARGS},
    {"scriptId", (PyCFunction)SbkQScriptContextInfoFunc_scriptId, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQScriptContextInfoFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQScriptContextInfo_Check(arg) && !SbkQScriptContextInfo_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QScriptContextInfo) [reverse operator]
        QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQScriptContextInfoFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptContextInfoFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContextInfo.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQScriptContextInfoFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQScriptContextInfo_Check(arg) && !SbkQScriptContextInfo_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QScriptContextInfo&) [reverse operator]
        QScriptContextInfo* cppSelf = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQScriptContextInfoFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptContextInfoFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContextInfo.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQScriptContextInfo_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQScriptContextInfoFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQScriptContextInfoFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQScriptContextInfo_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QScriptContextInfo& cpp_self = *Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QScriptContextInfo & >::isConvertible(other)) {
                // operator!=(const QScriptContextInfo & other) const
                QScriptContextInfo* cpp_other = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QScriptContextInfo  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QScriptContextInfo >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QScriptContextInfo > cpp_other_auto_ptr;
                QScriptContextInfo* cpp_other = Shiboken::Converter<QScriptContextInfo* >::toCpp(other);
                if (!SbkQScriptContextInfo_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QScriptContextInfo >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQScriptContextInfo_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QScriptContextInfo & >::isConvertible(other)) {
                // operator==(const QScriptContextInfo & other) const
                QScriptContextInfo* cpp_other = Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QScriptContextInfo  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QScriptContextInfo >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QScriptContextInfo > cpp_other_auto_ptr;
                QScriptContextInfo* cpp_other = Shiboken::Converter<QScriptContextInfo* >::toCpp(other);
                if (!SbkQScriptContextInfo_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QScriptContextInfo >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQScriptContextInfo_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQScriptContextInfo_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptContextInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptContextInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQScriptContextInfo_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQScriptContextInfo_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptContextInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptContextInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptContextInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtScript_QScriptContextInfo_FunctionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptContextInfo_FunctionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FunctionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptContextInfo_FunctionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptContextInfo_FunctionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptContextInfo_FunctionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QScriptContextInfo(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptContextInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptContextInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptContextInfo_Type));
    PyModule_AddObject(module, "QScriptContextInfo",
        ((PyObject*)&SbkQScriptContextInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FunctionType
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX] = &SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type);
    PyDict_SetItemString(SbkQScriptContextInfo_Type.super.ht_type.tp_dict,
            "FunctionType",((PyObject*)&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type,
        (long) QScriptContextInfo::ScriptFunction, "ScriptFunction");
    PyDict_SetItemString(SbkQScriptContextInfo_Type.super.ht_type.tp_dict,
        "ScriptFunction", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type.tp_dict,
        "ScriptFunction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type,
        (long) QScriptContextInfo::QtFunction, "QtFunction");
    PyDict_SetItemString(SbkQScriptContextInfo_Type.super.ht_type.tp_dict,
        "QtFunction", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type.tp_dict,
        "QtFunction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type,
        (long) QScriptContextInfo::QtPropertyFunction, "QtPropertyFunction");
    PyDict_SetItemString(SbkQScriptContextInfo_Type.super.ht_type.tp_dict,
        "QtPropertyFunction", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type.tp_dict,
        "QtPropertyFunction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type,
        (long) QScriptContextInfo::NativeFunction, "NativeFunction");
    PyDict_SetItemString(SbkQScriptContextInfo_Type.super.ht_type.tp_dict,
        "NativeFunction", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContextInfo_FunctionType_Type.tp_dict,
        "NativeFunction", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptContextInfo::FunctionType");

    Shiboken::TypeResolver::createValueTypeResolver<QScriptContextInfo >("QScriptContextInfo");
    Shiboken::TypeResolver::createValueTypeResolver<QScriptContextInfo >(typeid(QScriptContextInfo).name());
}


} // extern "C"

