/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptcontext_wrapper.h"

// Extra includes
#include <QList>
#include <qscriptcontext.h>
#include <qscriptengine.h>
#include <qscriptvalue.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static PyObject* SbkQScriptContextFunc_activationObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activationObject()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptContext::activationObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_argument(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // argument(int)const
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptContext::argument(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_argument_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptContextFunc_argument_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContext.argument", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_argumentCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // argumentCount()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptContext::argumentCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_argumentsObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // argumentsObject()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptContext::argumentsObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_backtrace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backtrace()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QScriptContext::backtrace();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_callee(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // callee()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptContext::callee();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_engine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // engine()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptEngine * cpp_result = cppSelf->QScriptContext::engine();
    py_result = Shiboken::Converter<QScriptEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_isCalledAsConstructor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCalledAsConstructor()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptContext::isCalledAsConstructor();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_parentContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentContext()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptContext * cpp_result = cppSelf->QScriptContext::parentContext();
    py_result = Shiboken::Converter<QScriptContext * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_popScope(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // popScope()
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptContext::popScope();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_pushScope(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // pushScope(QScriptValue)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        cppSelf->QScriptContext::pushScope(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_pushScope_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptContextFunc_pushScope_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContext.pushScope", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_returnValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // returnValue()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptContext::returnValue();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_scopeChain(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scopeChain()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QList<QScriptValue > cpp_result = cppSelf->QScriptContext::scopeChain();
    py_result = Shiboken::Converter<QList<QScriptValue > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_setActivationObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setActivationObject(QScriptValue)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        cppSelf->QScriptContext::setActivationObject(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_setActivationObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptContextFunc_setActivationObject_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContext.setActivationObject", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_setReturnValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setReturnValue(QScriptValue)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        cppSelf->QScriptContext::setReturnValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_setReturnValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptContextFunc_setReturnValue_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContext.setReturnValue", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_setThisObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setThisObject(QScriptValue)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        cppSelf->QScriptContext::setThisObject(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_setThisObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptContextFunc_setThisObject_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContext.setThisObject", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptContext::ExecutionState cpp_result = cppSelf->QScriptContext::state();
    py_result = Shiboken::Converter<QScriptContext::ExecutionState >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_thisObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // thisObject()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptContext::thisObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptContextFunc_throwError(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "throwError", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // throwError(QString)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptContext::throwError(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QScriptContext::Error >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        QScriptContext::Error cpp_arg0 = Shiboken::Converter<QScriptContext::Error >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // throwError(QScriptContext::Error,QString)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptContext::throwError(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_throwError_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptContextFunc_throwError_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptContext.Error, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptContext.throwError", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_throwValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // throwValue(QScriptValue)
        QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptContext::throwValue(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptContextFunc_throwValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptContextFunc_throwValue_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptContext.throwValue", overloads);
        return 0;
}

static PyObject* SbkQScriptContextFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QScriptContext* cppSelf = Shiboken::Converter<QScriptContext* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptContext::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptContext_methods[] = {
    {"activationObject", (PyCFunction)SbkQScriptContextFunc_activationObject, METH_NOARGS},
    {"argument", (PyCFunction)SbkQScriptContextFunc_argument, METH_O},
    {"argumentCount", (PyCFunction)SbkQScriptContextFunc_argumentCount, METH_NOARGS},
    {"argumentsObject", (PyCFunction)SbkQScriptContextFunc_argumentsObject, METH_NOARGS},
    {"backtrace", (PyCFunction)SbkQScriptContextFunc_backtrace, METH_NOARGS},
    {"callee", (PyCFunction)SbkQScriptContextFunc_callee, METH_NOARGS},
    {"engine", (PyCFunction)SbkQScriptContextFunc_engine, METH_NOARGS},
    {"isCalledAsConstructor", (PyCFunction)SbkQScriptContextFunc_isCalledAsConstructor, METH_NOARGS},
    {"parentContext", (PyCFunction)SbkQScriptContextFunc_parentContext, METH_NOARGS},
    {"popScope", (PyCFunction)SbkQScriptContextFunc_popScope, METH_NOARGS},
    {"pushScope", (PyCFunction)SbkQScriptContextFunc_pushScope, METH_O},
    {"returnValue", (PyCFunction)SbkQScriptContextFunc_returnValue, METH_NOARGS},
    {"scopeChain", (PyCFunction)SbkQScriptContextFunc_scopeChain, METH_NOARGS},
    {"setActivationObject", (PyCFunction)SbkQScriptContextFunc_setActivationObject, METH_O},
    {"setReturnValue", (PyCFunction)SbkQScriptContextFunc_setReturnValue, METH_O},
    {"setThisObject", (PyCFunction)SbkQScriptContextFunc_setThisObject, METH_O},
    {"state", (PyCFunction)SbkQScriptContextFunc_state, METH_NOARGS},
    {"thisObject", (PyCFunction)SbkQScriptContextFunc_thisObject, METH_NOARGS},
    {"throwError", (PyCFunction)SbkQScriptContextFunc_throwError, METH_VARARGS},
    {"throwValue", (PyCFunction)SbkQScriptContextFunc_throwValue, METH_O},
    {"toString", (PyCFunction)SbkQScriptContextFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptContext_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptContext",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptContext_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptContext >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtScript_QScriptContext_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptContext_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptContext_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptContext_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptContext_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptContext_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtScript_QScriptContext_ExecutionState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptContext_ExecutionState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptContext_ExecutionState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ExecutionState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptContext_ExecutionState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptContext_ExecutionState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptContext_ExecutionState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QScriptContext(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptContext_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptContext_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptContext_Type));
    PyModule_AddObject(module, "QScriptContext",
        ((PyObject*)&SbkQScriptContext_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX] = &SbkPySide_QtScript_QScriptContext_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptContext_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptContext_Error_Type);
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtScript_QScriptContext_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_Error_Type,
        (long) QScriptContext::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_Error_Type.tp_dict,
        "UnknownError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_Error_Type,
        (long) QScriptContext::ReferenceError, "ReferenceError");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "ReferenceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_Error_Type.tp_dict,
        "ReferenceError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_Error_Type,
        (long) QScriptContext::SyntaxError, "SyntaxError");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "SyntaxError", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_Error_Type.tp_dict,
        "SyntaxError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_Error_Type,
        (long) QScriptContext::TypeError, "TypeError");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "TypeError", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_Error_Type.tp_dict,
        "TypeError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_Error_Type,
        (long) QScriptContext::RangeError, "RangeError");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "RangeError", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_Error_Type.tp_dict,
        "RangeError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_Error_Type,
        (long) QScriptContext::URIError, "URIError");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "URIError", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_Error_Type.tp_dict,
        "URIError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptContext::Error");

    // init enum class: ExecutionState
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX] = &SbkPySide_QtScript_QScriptContext_ExecutionState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptContext_ExecutionState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptContext_ExecutionState_Type);
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
            "ExecutionState",((PyObject*)&SbkPySide_QtScript_QScriptContext_ExecutionState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_ExecutionState_Type,
        (long) QScriptContext::NormalState, "NormalState");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "NormalState", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_ExecutionState_Type.tp_dict,
        "NormalState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptContext_ExecutionState_Type,
        (long) QScriptContext::ExceptionState, "ExceptionState");
    PyDict_SetItemString(SbkQScriptContext_Type.super.ht_type.tp_dict,
        "ExceptionState", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptContext_ExecutionState_Type.tp_dict,
        "ExceptionState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptContext::ExecutionState");

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptContext >("QScriptContext*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptContext >(typeid(QScriptContext).name());
}


} // extern "C"

