/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qhttpheader_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QHttpHeaderWrapper::QHttpHeaderWrapper() : QHttpHeader() {
    // ... middle
}

QHttpHeaderWrapper::QHttpHeaderWrapper(const QString & str) : QHttpHeader(str) {
    // ... middle
}

int QHttpHeaderWrapper::majorVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "majorVersion"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QHttpHeader.majorVersion()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QHttpHeader.majorVersion", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QHttpHeaderWrapper::minorVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minorVersion"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QHttpHeader.minorVersion()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QHttpHeader.minorVersion", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QHttpHeaderWrapper::parseLine(const QString & line, int number)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parseLine"));
    if (py_override.isNull()) {
        return this->QHttpHeader::parseLine(line, number);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Si)",
        Shiboken::Converter<QString & >::toPython(line),
        number
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QHttpHeader.parseLine", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QHttpHeaderWrapper::toString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "toString"));
    if (py_override.isNull()) {
        return this->QHttpHeader::toString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QHttpHeader.toString", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QHttpHeaderWrapper::~QHttpHeaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQHttpHeader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHttpHeaderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QHttpHeader' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QHttpHeader", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QHttpHeader()
        cptr = new QHttpHeaderWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QHttpHeader(QString)
        cptr = new QHttpHeaderWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeader_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QHttpHeader >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHttpHeader_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQHttpHeader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpHeader", overloads);
        return -1;
}

static PyObject* SbkQHttpHeaderFunc_addValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // addValue(QString,QString)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::addValue(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_addValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_addValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpHeader.addValue", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_allValues(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // allValues(QString)const
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QHttpHeader::allValues(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_allValues_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHttpHeaderFunc_allValues_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.allValues", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_contentLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentLength()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QHttpHeader::contentLength();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_contentType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentType()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpHeader::contentType();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_hasContentLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasContentLength()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHttpHeader::hasContentLength();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_hasContentType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasContentType()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHttpHeader::hasContentType();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_hasKey(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasKey(QString)const
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHttpHeader::hasKey(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_hasKey_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHttpHeaderFunc_hasKey_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.hasKey", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHttpHeader::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_keys(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keys()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QHttpHeader::keys();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_majorVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // majorVersion()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QHttpHeader.majorVersion()' not implemented.");
        return 0;
    }
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->majorVersion();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_minorVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minorVersion()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QHttpHeader.minorVersion()' not implemented.");
        return 0;
    }
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->minorVersion();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_parse(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // parse(QString)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHttpHeader::parse(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_parse_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHttpHeaderFunc_parse_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.parse", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_parseLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "parseLine", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // parseLine(QString,int)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHttpHeader::parseLine(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_parseLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHttpHeaderFunc_parseLine_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpHeader.parseLine", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_removeAllValues(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeAllValues(QString)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::removeAllValues(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_removeAllValues_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_removeAllValues_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.removeAllValues", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_removeValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeValue(QString)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::removeValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_removeValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_removeValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.removeValue", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_setContentLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setContentLength(int)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::setContentLength(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_setContentLength_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_setContentLength_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.setContentLength", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_setContentType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setContentType(QString)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::setContentType(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_setContentType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_setContentType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.setContentType", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_setValid(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setValid(bool)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::setValid(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_setValid_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_setValid_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.setValid", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_setValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setValue(QString,QString)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::setValue(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpHeader.setValue", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_setValues(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QPair<QString, QString > >  >::isConvertible(arg)) {
        QList<QPair<QString, QString > >  cpp_arg0 = Shiboken::Converter<QList<QPair<QString, QString > >  >::toCpp(arg);
        // setValues(QList<QPair<QString,QString> >)
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        cppSelf->QHttpHeader::setValues(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_setValues_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpHeaderFunc_setValues_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.setValues", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpHeader::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHttpHeaderFunc_value(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // value(QString)const
        QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QHttpHeader::value(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHttpHeaderFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHttpHeaderFunc_value_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttpHeader.value", overloads);
        return 0;
}

static PyObject* SbkQHttpHeaderFunc_values(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // values()const
    QHttpHeader* cppSelf = Shiboken::Converter<QHttpHeader* >::toCpp((PyObject*)self);
    QList<QPair<QString, QString > > cpp_result = cppSelf->QHttpHeader::values();
    py_result = Shiboken::Converter<QList<QPair<QString, QString > > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQHttpHeader_methods[] = {
    {"addValue", (PyCFunction)SbkQHttpHeaderFunc_addValue, METH_VARARGS},
    {"allValues", (PyCFunction)SbkQHttpHeaderFunc_allValues, METH_O},
    {"contentLength", (PyCFunction)SbkQHttpHeaderFunc_contentLength, METH_NOARGS},
    {"contentType", (PyCFunction)SbkQHttpHeaderFunc_contentType, METH_NOARGS},
    {"hasContentLength", (PyCFunction)SbkQHttpHeaderFunc_hasContentLength, METH_NOARGS},
    {"hasContentType", (PyCFunction)SbkQHttpHeaderFunc_hasContentType, METH_NOARGS},
    {"hasKey", (PyCFunction)SbkQHttpHeaderFunc_hasKey, METH_O},
    {"isValid", (PyCFunction)SbkQHttpHeaderFunc_isValid, METH_NOARGS},
    {"keys", (PyCFunction)SbkQHttpHeaderFunc_keys, METH_NOARGS},
    {"majorVersion", (PyCFunction)SbkQHttpHeaderFunc_majorVersion, METH_NOARGS},
    {"minorVersion", (PyCFunction)SbkQHttpHeaderFunc_minorVersion, METH_NOARGS},
    {"parse", (PyCFunction)SbkQHttpHeaderFunc_parse, METH_O},
    {"parseLine", (PyCFunction)SbkQHttpHeaderFunc_parseLine, METH_VARARGS},
    {"removeAllValues", (PyCFunction)SbkQHttpHeaderFunc_removeAllValues, METH_O},
    {"removeValue", (PyCFunction)SbkQHttpHeaderFunc_removeValue, METH_O},
    {"setContentLength", (PyCFunction)SbkQHttpHeaderFunc_setContentLength, METH_O},
    {"setContentType", (PyCFunction)SbkQHttpHeaderFunc_setContentType, METH_O},
    {"setValid", (PyCFunction)SbkQHttpHeaderFunc_setValid, METH_O},
    {"setValue", (PyCFunction)SbkQHttpHeaderFunc_setValue, METH_VARARGS},
    {"setValues", (PyCFunction)SbkQHttpHeaderFunc_setValues, METH_O},
    {"toString", (PyCFunction)SbkQHttpHeaderFunc_toString, METH_NOARGS},
    {"value", (PyCFunction)SbkQHttpHeaderFunc_value, METH_O},
    {"values", (PyCFunction)SbkQHttpHeaderFunc_values, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHttpHeader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QHttpHeader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHttpHeader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHttpHeader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QHttpHeader >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQHttpHeader_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQHttpHeader_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QHttpHeader*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QHttpHeader(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHttpHeader_Type);

    // Fill type discovery information
    SbkQHttpHeader_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQHttpHeader_Type.type_discovery->addTypeDiscoveryFunction(&SbkQHttpHeader_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQHttpHeader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHttpHeader_Type));
    PyModule_AddObject(module, "QHttpHeader",
        ((PyObject*)&SbkQHttpHeader_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QHttpHeader >("QHttpHeader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QHttpHeader >(typeid(QHttpHeader).name());
}


} // extern "C"

