/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qundostack_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qundostack.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QUndoStackWrapper::QUndoStackWrapper(QObject * parent) : QUndoStack(parent), m_metaObject(0) {
    // ... middle
}

void QUndoStackWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QUndoStackWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUndoStackWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QUndoStackWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QUndoStackWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUndoStack.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QUndoStackWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUndoStack.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QUndoStackWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QUndoStackWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QUndoStack::staticMetaObject);
}
    return m_metaObject;
}

int QUndoStackWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QUndoStack::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QUndoStackWrapper::~QUndoStackWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQUndoStack_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QUndoStackWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QUndoStack", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QUndoStack(QObject*)
        cptr = new QUndoStackWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QUndoStack(QObject*)
        cptr = new QUndoStackWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQUndoStack_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QUndoStack >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQUndoStack_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQUndoStack_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QUndoStack", overloads);
        return -1;
}

static PyObject* SbkQUndoStackFunc_beginMacro(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // beginMacro(QString)
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        cppSelf->QUndoStack::beginMacro(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUndoStackFunc_beginMacro_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoStackFunc_beginMacro_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.beginMacro", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_canRedo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canRedo()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoStack::canRedo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_canUndo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canUndo()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoStack::canUndo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_cleanIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cleanIndex()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QUndoStack::cleanIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    cppSelf->QUndoStack::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUndoStackFunc_command(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // command(int)const
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        const QUndoCommand * cpp_result = cppSelf->QUndoStack::command(cpp_arg0);
        py_result = Shiboken::Converter<QUndoCommand * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQUndoStackFunc_command_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUndoStackFunc_command_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.command", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QUndoStack::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_createRedoAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createRedoAction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createRedoAction(QObject*,QString)const
            QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoStack::createRedoAction(cpp_arg0);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // createRedoAction(QObject*,QString)const
            QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoStack::createRedoAction(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else goto SbkQUndoStackFunc_createRedoAction_TypeError;
    } else goto SbkQUndoStackFunc_createRedoAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUndoStackFunc_createRedoAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QUndoStack.createRedoAction", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_createUndoAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createUndoAction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createUndoAction(QObject*,QString)const
            QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoStack::createUndoAction(cpp_arg0);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // createUndoAction(QObject*,QString)const
            QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoStack::createUndoAction(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else goto SbkQUndoStackFunc_createUndoAction_TypeError;
    } else goto SbkQUndoStackFunc_createUndoAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUndoStackFunc_createUndoAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QUndoStack.createUndoAction", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_endMacro(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endMacro()
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    cppSelf->QUndoStack::endMacro();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUndoStackFunc_index(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // index()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QUndoStack::index();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoStack::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_isClean(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isClean()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoStack::isClean();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_push(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUndoCommand * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QUndoCommand* cpp_arg0 = Shiboken::Converter<QUndoCommand* >::toCpp(arg);
        // push(QUndoCommand*)
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        cppSelf->QUndoStack::push(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQUndoStackFunc_push_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoStackFunc_push_TypeError:
        const char* overloads[] = {"PySide.QtGui.QUndoCommand", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.push", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_redo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // redo()
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    cppSelf->QUndoStack::redo();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUndoStackFunc_redoText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // redoText()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUndoStack::redoText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_setActive(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // setActive(bool)
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        cppSelf->QUndoStack::setActive();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setActive(bool)
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        cppSelf->QUndoStack::setActive(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUndoStackFunc_setActive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoStackFunc_setActive_TypeError:
        const char* overloads[] = {"bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.setActive", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_setClean(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setClean()
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    cppSelf->QUndoStack::setClean();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUndoStackFunc_setIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIndex(int)
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        cppSelf->QUndoStack::setIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUndoStackFunc_setIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoStackFunc_setIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.setIndex", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_setUndoLimit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setUndoLimit(int)
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        cppSelf->QUndoStack::setUndoLimit(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUndoStackFunc_setUndoLimit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoStackFunc_setUndoLimit_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.setUndoLimit", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_text(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // text(int)const
        QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QUndoStack::text(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUndoStackFunc_text_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUndoStackFunc_text_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoStack.text", overloads);
        return 0;
}

static PyObject* SbkQUndoStackFunc_undo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // undo()
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    cppSelf->QUndoStack::undo();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUndoStackFunc_undoLimit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // undoLimit()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QUndoStack::undoLimit();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUndoStackFunc_undoText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // undoText()const
    QUndoStack* cppSelf = Shiboken::Converter<QUndoStack* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUndoStack::undoText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQUndoStack_methods[] = {
    {"beginMacro", (PyCFunction)SbkQUndoStackFunc_beginMacro, METH_O},
    {"canRedo", (PyCFunction)SbkQUndoStackFunc_canRedo, METH_NOARGS},
    {"canUndo", (PyCFunction)SbkQUndoStackFunc_canUndo, METH_NOARGS},
    {"cleanIndex", (PyCFunction)SbkQUndoStackFunc_cleanIndex, METH_NOARGS},
    {"clear", (PyCFunction)SbkQUndoStackFunc_clear, METH_NOARGS},
    {"command", (PyCFunction)SbkQUndoStackFunc_command, METH_O},
    {"count", (PyCFunction)SbkQUndoStackFunc_count, METH_NOARGS},
    {"createRedoAction", (PyCFunction)SbkQUndoStackFunc_createRedoAction, METH_VARARGS},
    {"createUndoAction", (PyCFunction)SbkQUndoStackFunc_createUndoAction, METH_VARARGS},
    {"endMacro", (PyCFunction)SbkQUndoStackFunc_endMacro, METH_NOARGS},
    {"index", (PyCFunction)SbkQUndoStackFunc_index, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQUndoStackFunc_isActive, METH_NOARGS},
    {"isClean", (PyCFunction)SbkQUndoStackFunc_isClean, METH_NOARGS},
    {"push", (PyCFunction)SbkQUndoStackFunc_push, METH_O},
    {"redo", (PyCFunction)SbkQUndoStackFunc_redo, METH_NOARGS},
    {"redoText", (PyCFunction)SbkQUndoStackFunc_redoText, METH_NOARGS},
    {"setActive", (PyCFunction)SbkQUndoStackFunc_setActive, METH_NOARGS|METH_O},
    {"setClean", (PyCFunction)SbkQUndoStackFunc_setClean, METH_NOARGS},
    {"setIndex", (PyCFunction)SbkQUndoStackFunc_setIndex, METH_O},
    {"setUndoLimit", (PyCFunction)SbkQUndoStackFunc_setUndoLimit, METH_O},
    {"text", (PyCFunction)SbkQUndoStackFunc_text, METH_O},
    {"undo", (PyCFunction)SbkQUndoStackFunc_undo, METH_NOARGS},
    {"undoLimit", (PyCFunction)SbkQUndoStackFunc_undoLimit, METH_NOARGS},
    {"undoText", (PyCFunction)SbkQUndoStackFunc_undoText, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQUndoStack_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QUndoStack",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQUndoStack_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQUndoStack_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QUndoStack >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QUndoStack(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QUNDOSTACK_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQUndoStack_Type);

    SbkQUndoStack_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQUndoStack_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQUndoStack_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQUndoStack_Type));
    PyModule_AddObject(module, "QUndoStack",
        ((PyObject*)&SbkQUndoStack_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QUndoStack >("QUndoStack*");
    Shiboken::TypeResolver::createObjectTypeResolver<QUndoStack >(typeid(QUndoStack).name());
}


} // extern "C"

