/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qspaceritem_wrapper.h"

// Extra includes
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qrect.h>
#include <qsize.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSpacerItemWrapper::QSpacerItemWrapper(int w, int h, QSizePolicy::Policy hData, QSizePolicy::Policy vData) : QSpacerItem(w, h, hData, vData) {
    // ... middle
}

QFlags<Qt::Orientation> QSpacerItemWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        return this->QSpacerItem::expandingDirections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.expandingDirections", SbkType<QFlags<Qt::Orientation> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::Orientation>();
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QSpacerItemWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        return this->QSpacerItem::geometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.geometry", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QSpacerItemWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.hasHeightForWidth", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QSpacerItemWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QSpacerItemWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QLayoutItem::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSpacerItemWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        return this->QSpacerItem::isEmpty();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.isEmpty", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayout * QSpacerItemWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayoutItem::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.layout", SbkType<QLayout * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayout * cpp_result(Shiboken::Converter<QLayout * >::toCpp(py_result));
    return cpp_result;
}

QSize QSpacerItemWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        return this->QSpacerItem::maximumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.maximumSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QSpacerItemWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.minimumHeightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QSpacerItemWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        return this->QSpacerItem::minimumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.minimumSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QSpacerItemWrapper::setGeometry(const QRect & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QSpacerItem::setGeometry(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRect & >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QSpacerItemWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QSpacerItem::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QSpacerItemWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QSpacerItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.spacerItem", SbkType<QSpacerItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QSpacerItem * cpp_result(Shiboken::Converter<QSpacerItem * >::toCpp(py_result));
    return cpp_result;
}

QWidget * QSpacerItemWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSpacerItem.widget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

QSpacerItemWrapper::~QSpacerItemWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQSpacerItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSpacerItemWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QSpacerItem", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QSpacerItem(int,int,QSizePolicy::Policy,QSizePolicy::Policy)
            cptr = new QSpacerItemWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[2])) {
            QSizePolicy::Policy cpp_arg2 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QSpacerItem(int,int,QSizePolicy::Policy,QSizePolicy::Policy)
                cptr = new QSpacerItemWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[3])) {
                QSizePolicy::Policy cpp_arg3 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[3]);
                // QSpacerItem(int,int,QSizePolicy::Policy,QSizePolicy::Policy)
                cptr = new QSpacerItemWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQSpacerItem_Init_TypeError;
        } else goto SbkQSpacerItem_Init_TypeError;
    } else goto SbkQSpacerItem_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSpacerItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSpacerItem_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSpacerItem_Init_TypeError:
        const char* overloads[] = {"int, int, PySide.QtGui.QSizePolicy.Policy = QSizePolicy.Minimum, PySide.QtGui.QSizePolicy.Policy = QSizePolicy.Minimum", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSpacerItem", overloads);
        return -1;
}

static PyObject* SbkQSpacerItemFunc_changeSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "changeSize", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // changeSize(int,int,QSizePolicy::Policy,QSizePolicy::Policy)
            QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
            cppSelf->QSpacerItem::changeSize(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[2])) {
            QSizePolicy::Policy cpp_arg2 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // changeSize(int,int,QSizePolicy::Policy,QSizePolicy::Policy)
                QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
                cppSelf->QSpacerItem::changeSize(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[3])) {
                QSizePolicy::Policy cpp_arg3 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[3]);
                // changeSize(int,int,QSizePolicy::Policy,QSizePolicy::Policy)
                QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
                cppSelf->QSpacerItem::changeSize(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQSpacerItemFunc_changeSize_TypeError;
        } else goto SbkQSpacerItemFunc_changeSize_TypeError;
    } else goto SbkQSpacerItemFunc_changeSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSpacerItemFunc_changeSize_TypeError:
        const char* overloads[] = {"int, int, PySide.QtGui.QSizePolicy.Policy = QSizePolicy.Minimum, PySide.QtGui.QSizePolicy.Policy = QSizePolicy.Minimum", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSpacerItem.changeSize", overloads);
        return 0;
}

static PyObject* SbkQSpacerItemFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->QSpacerItem::expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSpacerItemFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QSpacerItem::geometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSpacerItemFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSpacerItem::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSpacerItemFunc_maximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumSize()const
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QSpacerItem::maximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSpacerItemFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QSpacerItem::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSpacerItemFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
        cppSelf->QSpacerItem::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSpacerItemFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSpacerItemFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSpacerItem.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQSpacerItemFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QSpacerItem::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSpacerItemFunc_spacerItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacerItem()
    QSpacerItem* cppSelf = Shiboken::Converter<QSpacerItem* >::toCpp((PyObject*)self);
    QSpacerItem * cpp_result = cppSelf->QSpacerItem::spacerItem();
    py_result = Shiboken::Converter<QSpacerItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQSpacerItem_methods[] = {
    {"changeSize", (PyCFunction)SbkQSpacerItemFunc_changeSize, METH_VARARGS},
    {"expandingDirections", (PyCFunction)SbkQSpacerItemFunc_expandingDirections, METH_NOARGS},
    {"geometry", (PyCFunction)SbkQSpacerItemFunc_geometry, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQSpacerItemFunc_isEmpty, METH_NOARGS},
    {"maximumSize", (PyCFunction)SbkQSpacerItemFunc_maximumSize, METH_NOARGS},
    {"minimumSize", (PyCFunction)SbkQSpacerItemFunc_minimumSize, METH_NOARGS},
    {"setGeometry", (PyCFunction)SbkQSpacerItemFunc_setGeometry, METH_O},
    {"sizeHint", (PyCFunction)SbkQSpacerItemFunc_sizeHint, METH_NOARGS},
    {"spacerItem", (PyCFunction)SbkQSpacerItemFunc_spacerItem, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSpacerItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSpacerItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSpacerItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSpacerItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSpacerItem >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QSpacerItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSPACERITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSpacerItem_Type);

    SbkQSpacerItem_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX];
    // Fill type discovery information
    SbkQSpacerItem_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSpacerItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSpacerItem_Type));
    PyModule_AddObject(module, "QSpacerItem",
        ((PyObject*)&SbkQSpacerItem_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSpacerItem >("QSpacerItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSpacerItem >(typeid(QSpacerItem).name());
}


} // extern "C"

