/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qpinchgesture_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPinchGestureWrapper::QPinchGestureWrapper(QObject * parent) : QPinchGesture(parent), m_metaObject(0) {
    // ... middle
}

void QPinchGestureWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPinchGestureWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPinchGestureWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPinchGestureWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QPinchGestureWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPinchGesture.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QPinchGestureWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPinchGesture.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QPinchGestureWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QPinchGestureWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QPinchGesture::staticMetaObject);
}
    return m_metaObject;
}

int QPinchGestureWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QPinchGesture::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QPinchGestureWrapper::~QPinchGestureWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQPinchGesture_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPinchGestureWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPinchGesture", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPinchGesture(QObject*)
        cptr = new QPinchGestureWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QPinchGesture(QObject*)
        cptr = new QPinchGestureWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQPinchGesture_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPinchGesture >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPinchGesture_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPinchGesture_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPinchGesture", overloads);
        return -1;
}

static PyObject* SbkQPinchGestureFunc_centerPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // centerPoint()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QPinchGesture::centerPoint();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_changeFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // changeFlags()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    QFlags<QPinchGesture::ChangeFlag> cpp_result = cppSelf->QPinchGesture::changeFlags();
    py_result = Shiboken::Converter<QFlags<QPinchGesture::ChangeFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_lastCenterPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastCenterPoint()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QPinchGesture::lastCenterPoint();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_lastRotationAngle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastRotationAngle()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPinchGesture::lastRotationAngle();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_lastScaleFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScaleFactor()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPinchGesture::lastScaleFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_rotationAngle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rotationAngle()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPinchGesture::rotationAngle();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_scaleFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scaleFactor()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPinchGesture::scaleFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_setCenterPoint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setCenterPoint(QPointF)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setCenterPoint(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setCenterPoint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setCenterPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setCenterPoint", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setChangeFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QPinchGesture_ChangeFlag_Check(arg)) {
        QFlags<QPinchGesture::ChangeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QPinchGesture::ChangeFlag> >::toCpp(arg);
        // setChangeFlags(QFlags<QPinchGesture::ChangeFlag>)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setChangeFlags(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setChangeFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setChangeFlags_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPinchGesture.ChangeFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setChangeFlags", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setLastCenterPoint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastCenterPoint(QPointF)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setLastCenterPoint(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setLastCenterPoint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setLastCenterPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setLastCenterPoint", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setLastRotationAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLastRotationAngle(qreal)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setLastRotationAngle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setLastRotationAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setLastRotationAngle_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setLastRotationAngle", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setLastScaleFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLastScaleFactor(qreal)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setLastScaleFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setLastScaleFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setLastScaleFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setLastScaleFactor", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setRotationAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRotationAngle(qreal)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setRotationAngle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setRotationAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setRotationAngle_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setRotationAngle", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setScaleFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setScaleFactor(qreal)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setScaleFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setScaleFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setScaleFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setScaleFactor", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setStartCenterPoint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setStartCenterPoint(QPointF)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setStartCenterPoint(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setStartCenterPoint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setStartCenterPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setStartCenterPoint", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setTotalChangeFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QPinchGesture_ChangeFlag_Check(arg)) {
        QFlags<QPinchGesture::ChangeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QPinchGesture::ChangeFlag> >::toCpp(arg);
        // setTotalChangeFlags(QFlags<QPinchGesture::ChangeFlag>)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setTotalChangeFlags(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setTotalChangeFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setTotalChangeFlags_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPinchGesture.ChangeFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setTotalChangeFlags", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setTotalRotationAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTotalRotationAngle(qreal)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setTotalRotationAngle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setTotalRotationAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setTotalRotationAngle_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setTotalRotationAngle", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_setTotalScaleFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTotalScaleFactor(qreal)
        QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
        cppSelf->QPinchGesture::setTotalScaleFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPinchGestureFunc_setTotalScaleFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPinchGestureFunc_setTotalScaleFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPinchGesture.setTotalScaleFactor", overloads);
        return 0;
}

static PyObject* SbkQPinchGestureFunc_startCenterPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startCenterPoint()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QPinchGesture::startCenterPoint();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_totalChangeFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalChangeFlags()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    QFlags<QPinchGesture::ChangeFlag> cpp_result = cppSelf->QPinchGesture::totalChangeFlags();
    py_result = Shiboken::Converter<QFlags<QPinchGesture::ChangeFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_totalRotationAngle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalRotationAngle()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPinchGesture::totalRotationAngle();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPinchGestureFunc_totalScaleFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalScaleFactor()const
    QPinchGesture* cppSelf = Shiboken::Converter<QPinchGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPinchGesture::totalScaleFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPinchGesture_methods[] = {
    {"centerPoint", (PyCFunction)SbkQPinchGestureFunc_centerPoint, METH_NOARGS},
    {"changeFlags", (PyCFunction)SbkQPinchGestureFunc_changeFlags, METH_NOARGS},
    {"lastCenterPoint", (PyCFunction)SbkQPinchGestureFunc_lastCenterPoint, METH_NOARGS},
    {"lastRotationAngle", (PyCFunction)SbkQPinchGestureFunc_lastRotationAngle, METH_NOARGS},
    {"lastScaleFactor", (PyCFunction)SbkQPinchGestureFunc_lastScaleFactor, METH_NOARGS},
    {"rotationAngle", (PyCFunction)SbkQPinchGestureFunc_rotationAngle, METH_NOARGS},
    {"scaleFactor", (PyCFunction)SbkQPinchGestureFunc_scaleFactor, METH_NOARGS},
    {"setCenterPoint", (PyCFunction)SbkQPinchGestureFunc_setCenterPoint, METH_O},
    {"setChangeFlags", (PyCFunction)SbkQPinchGestureFunc_setChangeFlags, METH_O},
    {"setLastCenterPoint", (PyCFunction)SbkQPinchGestureFunc_setLastCenterPoint, METH_O},
    {"setLastRotationAngle", (PyCFunction)SbkQPinchGestureFunc_setLastRotationAngle, METH_O},
    {"setLastScaleFactor", (PyCFunction)SbkQPinchGestureFunc_setLastScaleFactor, METH_O},
    {"setRotationAngle", (PyCFunction)SbkQPinchGestureFunc_setRotationAngle, METH_O},
    {"setScaleFactor", (PyCFunction)SbkQPinchGestureFunc_setScaleFactor, METH_O},
    {"setStartCenterPoint", (PyCFunction)SbkQPinchGestureFunc_setStartCenterPoint, METH_O},
    {"setTotalChangeFlags", (PyCFunction)SbkQPinchGestureFunc_setTotalChangeFlags, METH_O},
    {"setTotalRotationAngle", (PyCFunction)SbkQPinchGestureFunc_setTotalRotationAngle, METH_O},
    {"setTotalScaleFactor", (PyCFunction)SbkQPinchGestureFunc_setTotalScaleFactor, METH_O},
    {"startCenterPoint", (PyCFunction)SbkQPinchGestureFunc_startCenterPoint, METH_NOARGS},
    {"totalChangeFlags", (PyCFunction)SbkQPinchGestureFunc_totalChangeFlags, METH_NOARGS},
    {"totalRotationAngle", (PyCFunction)SbkQPinchGestureFunc_totalRotationAngle, METH_NOARGS},
    {"totalScaleFactor", (PyCFunction)SbkQPinchGestureFunc_totalScaleFactor, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPinchGesture_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPinchGesture",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPinchGesture_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPinchGesture_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPinchGesture >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QPinchGesture_ChangeFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPinchGesture::ChangeFlags >::toPython(
        ((QPinchGesture::ChangeFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QPinchGesture::ChangeFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QPinchGesture_ChangeFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPinchGesture::ChangeFlags >::toPython(
        ((QPinchGesture::ChangeFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QPinchGesture::ChangeFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QPinchGesture_ChangeFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPinchGesture::ChangeFlags >::toPython(
        ((QPinchGesture::ChangeFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QPinchGesture::ChangeFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QPinchGesture_ChangeFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPinchGesture::ChangeFlags >::toPython(
        ~ Shiboken::Converter< QPinchGesture::ChangeFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QPinchGesture_ChangeFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QPinchGesture_ChangeFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QPinchGesture_ChangeFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QPinchGesture_ChangeFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QPinchGesture_ChangeFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QPinchGesture_ChangeFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPinchGesture_ChangeFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChangeFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QPinchGesture_ChangeFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPinchGesture_ChangeFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPinchGesture_ChangeFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPinchGesture_ChangeFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPinchGesture_ChangeFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPinchGesture_ChangeFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChangeFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPinchGesture_ChangeFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPinchGesture_ChangeFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QPinchGesture_ChangeFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QPinchGesture(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPINCHGESTURE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPinchGesture_Type);

    SbkQPinchGesture_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGESTURE_IDX];
    // Fill type discovery information
    SbkQPinchGesture_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPinchGesture_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPinchGesture_Type));
    PyModule_AddObject(module, "QPinchGesture",
        ((PyObject*)&SbkQPinchGesture_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ChangeFlag
    SbkPySide_QtGuiTypes[SBK_QPINCHGESTURE_CHANGEFLAG_IDX] = &SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type);
    PyDict_SetItemString(SbkQPinchGesture_Type.super.ht_type.tp_dict,
            "ChangeFlag",((PyObject*)&SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type));

    // init flags class: QFlags<QPinchGesture::ChangeFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QPINCHGESTURE_CHANGEFLAG__IDX] = &SbkPySide_QtGui_QPinchGesture_ChangeFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPinchGesture_ChangeFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPinchGesture_ChangeFlags_Type);
    PyDict_SetItemString(SbkQPinchGesture_Type.super.ht_type.tp_dict,
            "ChangeFlags",((PyObject*)&SbkPySide_QtGui_QPinchGesture_ChangeFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type,
        (long) QPinchGesture::ScaleFactorChanged, "ScaleFactorChanged");
    PyDict_SetItemString(SbkQPinchGesture_Type.super.ht_type.tp_dict,
        "ScaleFactorChanged", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type.tp_dict,
        "ScaleFactorChanged", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type,
        (long) QPinchGesture::RotationAngleChanged, "RotationAngleChanged");
    PyDict_SetItemString(SbkQPinchGesture_Type.super.ht_type.tp_dict,
        "RotationAngleChanged", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type.tp_dict,
        "RotationAngleChanged", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type,
        (long) QPinchGesture::CenterPointChanged, "CenterPointChanged");
    PyDict_SetItemString(SbkQPinchGesture_Type.super.ht_type.tp_dict,
        "CenterPointChanged", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPinchGesture_ChangeFlag_Type.tp_dict,
        "CenterPointChanged", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPinchGesture::ChangeFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QPinchGesture >("QPinchGesture*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPinchGesture >(typeid(QPinchGesture).name());
}


} // extern "C"

