/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpaintevent_wrapper.h"

// Extra includes
#include <qrect.h>
#include <qregion.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPaintEventWrapper::QPaintEventWrapper(const QRect & paintRect) : QPaintEvent(paintRect) {
    // ... middle
}

QPaintEventWrapper::QPaintEventWrapper(const QRegion & paintRegion) : QPaintEvent(paintRegion) {
    // ... middle
}

QPaintEventWrapper::~QPaintEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPaintEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPaintEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPaintEvent", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // QPaintEvent(QRect)
        cptr = new QPaintEventWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRegion & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(pyargs[0]);
        if (!SbkQRegion_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // QPaintEvent(QRegion)
        cptr = new QPaintEventWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPaintEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPaintEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPaintEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPaintEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPaintEvent", overloads);
        return -1;
}

static PyObject* SbkQPaintEventFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QPaintEvent* cppSelf = Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self);
    const QRect & cpp_result = cppSelf->QPaintEvent::rect();
    py_result = Shiboken::Converter<QRect & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintEventFunc_region(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // region()const
    QPaintEvent* cppSelf = Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self);
    const QRegion & cpp_result = cppSelf->QPaintEvent::region();
    py_result = Shiboken::Converter<QRegion & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPaintEvent_methods[] = {
    {"rect", (PyCFunction)SbkQPaintEventFunc_rect, METH_NOARGS},
    {"region", (PyCFunction)SbkQPaintEventFunc_region, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQPaintEvent_get_m_rect(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRect >::toPython(Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self)->m_rect);
}
static int SbkQPaintEvent_set_m_rect(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'m_rect' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRect >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'm_rect', 'QRect' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self)->m_rect = Shiboken::Converter<QRect >::toCpp(value);

    return 0;
}

static PyObject* SbkQPaintEvent_get_m_erased(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self)->m_erased);
}
static int SbkQPaintEvent_set_m_erased(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'m_erased' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'm_erased', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self)->m_erased = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQPaintEvent_get_m_region(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRegion >::toPython(Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self)->m_region);
}
static int SbkQPaintEvent_set_m_region(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'m_region' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRegion >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'm_region', 'QRegion' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPaintEvent* >::toCpp((PyObject*)self)->m_region = Shiboken::Converter<QRegion >::toCpp(value);

    return 0;
}

// Getters and Setters for QPaintEvent
static PyGetSetDef SbkQPaintEvent_getsetlist[] = {
    {const_cast<char*>("m_rect"), (getter)SbkQPaintEvent_get_m_rect, (setter)SbkQPaintEvent_set_m_rect},
    {const_cast<char*>("m_erased"), (getter)SbkQPaintEvent_get_m_erased, (setter)SbkQPaintEvent_set_m_erased},
    {const_cast<char*>("m_region"), (getter)SbkQPaintEvent_get_m_region, (setter)SbkQPaintEvent_set_m_region},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPaintEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPaintEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPaintEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQPaintEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPaintEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPaintEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQPaintEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQPaintEvent_Type);
     if ( reinterpret_cast<QPaintEvent*>(cptr)->type() == QEvent::Paint)
        return &SbkQPaintEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QPaintEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPaintEvent_Type);

    SbkQPaintEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQPaintEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQPaintEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQPaintEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQPaintEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPaintEvent_Type));
    PyModule_AddObject(module, "QPaintEvent",
        ((PyObject*)&SbkQPaintEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QPaintEvent >("QPaintEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPaintEvent >(typeid(QPaintEvent).name());
}


} // extern "C"

