/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qlineargradient_wrapper.h"

// Extra includes
#include <QPair>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQLinearGradient_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLinearGradient* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQLinearGradient_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QLinearGradient", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QLinearGradient()
        cptr = new QLinearGradient();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // QLinearGradient(qreal,qreal,qreal,qreal)
        cptr = new QLinearGradient(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // QLinearGradient(QPointF,QPointF)
        cptr = new QLinearGradient(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLinearGradient & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QLinearGradient* cpp_arg0 = Shiboken::Converter<QLinearGradient* >::toCpp(pyargs[0]);
        // QLinearGradient(QLinearGradient)
        cptr = new QLinearGradient(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLinearGradient_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QLinearGradient >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLinearGradient_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQLinearGradient_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLinearGradient", "", "PySide.QtCore.QPointF, PySide.QtCore.QPointF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLinearGradient", overloads);
        return -1;
}

static PyObject* SbkQLinearGradientFunc_finalStop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // finalStop()const
    QLinearGradient* cppSelf = Shiboken::Converter<QLinearGradient* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QLinearGradient::finalStop();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLinearGradientFunc_setFinalStop(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFinalStop", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setFinalStop(qreal,qreal)
        QLinearGradient* cppSelf = Shiboken::Converter<QLinearGradient* >::toCpp((PyObject*)self);
        cppSelf->QLinearGradient::setFinalStop(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setFinalStop(QPointF)
        QLinearGradient* cppSelf = Shiboken::Converter<QLinearGradient* >::toCpp((PyObject*)self);
        cppSelf->QLinearGradient::setFinalStop(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLinearGradientFunc_setFinalStop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLinearGradientFunc_setFinalStop_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLinearGradient.setFinalStop", overloads);
        return 0;
}

static PyObject* SbkQLinearGradientFunc_setStart(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStart", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setStart(qreal,qreal)
        QLinearGradient* cppSelf = Shiboken::Converter<QLinearGradient* >::toCpp((PyObject*)self);
        cppSelf->QLinearGradient::setStart(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setStart(QPointF)
        QLinearGradient* cppSelf = Shiboken::Converter<QLinearGradient* >::toCpp((PyObject*)self);
        cppSelf->QLinearGradient::setStart(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLinearGradientFunc_setStart_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLinearGradientFunc_setStart_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLinearGradient.setStart", overloads);
        return 0;
}

static PyObject* SbkQLinearGradientFunc_start(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // start()const
    QLinearGradient* cppSelf = Shiboken::Converter<QLinearGradient* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QLinearGradient::start();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQLinearGradient_methods[] = {
    {"finalStop", (PyCFunction)SbkQLinearGradientFunc_finalStop, METH_NOARGS},
    {"setFinalStop", (PyCFunction)SbkQLinearGradientFunc_setFinalStop, METH_VARARGS},
    {"setStart", (PyCFunction)SbkQLinearGradientFunc_setStart, METH_VARARGS},
    {"start", (PyCFunction)SbkQLinearGradientFunc_start, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLinearGradient_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QLinearGradient",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLinearGradient_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLinearGradient_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QLinearGradient >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QLinearGradient(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLINEARGRADIENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLinearGradient_Type);

    SbkQLinearGradient_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRADIENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQLinearGradient_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLinearGradient_Type));
    PyModule_AddObject(module, "QLinearGradient",
        ((PyObject*)&SbkQLinearGradient_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QLinearGradient >("QLinearGradient");
    Shiboken::TypeResolver::createValueTypeResolver<QLinearGradient >(typeid(QLinearGradient).name());
}


} // extern "C"

