/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qgraphicswidget_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsitem.h>
#include <qgraphicslayout.h>
#include <qgraphicslayoutitem.h>
#include <qgraphicsscene.h>
#include <qgraphicssceneevent.h>
#include <qgraphicstransform.h>
#include <qgraphicswidget.h>
#include <qkeysequence.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsWidgetWrapper::QGraphicsWidgetWrapper(QGraphicsItem * parent, QFlags<Qt::WindowType> wFlags) : QGraphicsWidget(parent, wFlags), m_metaObject(0) {
    // ... middle
}

void QGraphicsWidgetWrapper::advance(int phase)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "advance"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::advance(phase);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        phase
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QRectF QGraphicsWidgetWrapper::boundingRect() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "boundingRect"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::boundingRect();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.boundingRect", SbkType<QRectF >()->tp_name, py_result->ob_type->tp_name);
        return QRectF();
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::closeEvent(QCloseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::closeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsWidgetWrapper::collidesWithItem(const QGraphicsItem * other, Qt::ItemSelectionMode mode) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "collidesWithItem"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::collidesWithItem(other, mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QGraphicsItem * >::toPython(other),
        Shiboken::Converter<Qt::ItemSelectionMode >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.collidesWithItem", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWidgetWrapper::collidesWithPath(const QPainterPath & path, Qt::ItemSelectionMode mode) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "collidesWithPath"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::collidesWithPath(path, mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QPainterPath & >::toPython(path),
        Shiboken::Converter<Qt::ItemSelectionMode >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.collidesWithPath", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWidgetWrapper::contains(const QPointF & point) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contains"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::contains(point);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPointF & >::toPython(point)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.contains", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::contextMenuEvent(QGraphicsSceneContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneContextMenuEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::dragEnterEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::dragLeaveEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::dragMoveEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::dropEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWidgetWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QGraphicsWidgetWrapper::extension(const QVariant & variant) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "extension"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::extension(variant);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(variant)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.extension", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::grabKeyboardEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "grabKeyboardEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::grabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::grabMouseEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "grabMouseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::grabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::hideEvent(QHideEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::hoverEnterEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::hoverEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneHoverEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::hoverLeaveEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::hoverLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneHoverEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::hoverMoveEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::hoverMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneHoverEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWidgetWrapper::isObscuredBy(const QGraphicsItem * item) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isObscuredBy"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::isObscuredBy(item);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsItem * >::toPython(item)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.isObscuredBy", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QGraphicsWidgetWrapper::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemChange"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::itemChange(change, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::toPython(change),
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.itemChange", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::keyReleaseEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::mouseDoubleClickEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::mouseMoveEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::mousePressEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::mouseReleaseEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::moveEvent(QGraphicsSceneMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMoveEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPainterPath QGraphicsWidgetWrapper::opaqueArea() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "opaqueArea"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::opaqueArea();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPainterPath();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPainterPath >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.opaqueArea", SbkType<QPainterPath >()->tp_name, py_result->ob_type->tp_name);
        return QPainterPath();
    }
    QPainterPath cpp_result(Shiboken::Converter<QPainterPath >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::paint(painter, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionGraphicsItem * >::toPython(option),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::paintWindowFrame(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintWindowFrame"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionGraphicsItem * >::toPython(option),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::polishEvent()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polishEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::polishEvent();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsWidgetWrapper::propertyChange(const QString & propertyName, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "propertyChange"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::propertyChange(propertyName, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QString & >::toPython(propertyName),
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.propertyChange", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::resizeEvent(QGraphicsSceneResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsWidgetWrapper::sceneEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sceneEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::sceneEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.sceneEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWidgetWrapper::sceneEventFilter(QGraphicsItem * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sceneEventFilter"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::sceneEventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QGraphicsItem * >::toPython(watched),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.sceneEventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::setGeometry(const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRectF & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QPainterPath QGraphicsWidgetWrapper::shape() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "shape"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::shape();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPainterPath();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPainterPath >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.shape", SbkType<QPainterPath >()->tp_name, py_result->ob_type->tp_name);
        return QPainterPath();
    }
    QPainterPath cpp_result(Shiboken::Converter<QPainterPath >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSizeF QGraphicsWidgetWrapper::sizeHint(Qt::SizeHint which, const QSizeF & constraint) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<Qt::SizeHint >::toPython(which),
        Shiboken::Converter<QSizeF & >::toPython(constraint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.sizeHint", SbkType<QSizeF >()->tp_name, py_result->ob_type->tp_name);
        return QSizeF();
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGraphicsWidgetWrapper::type() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "type"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::type();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.type", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWidgetWrapper::ungrabKeyboardEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ungrabKeyboardEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::ungrabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::ungrabMouseEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ungrabMouseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::ungrabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWidgetWrapper::updateGeometry()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::updateGeometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWidgetWrapper::wheelEvent(QGraphicsSceneWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneWheelEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWidgetWrapper::windowFrameEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "windowFrameEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::windowFrameEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.windowFrameEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

Qt::WindowFrameSection QGraphicsWidgetWrapper::windowFrameSectionAt(const QPointF & pos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "windowFrameSectionAt"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::windowFrameSectionAt(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPointF & >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Qt::WindowFrameSection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Qt::WindowFrameSection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsWidget.windowFrameSectionAt", SbkType<Qt::WindowFrameSection >()->tp_name, py_result->ob_type->tp_name);
        return Qt::WindowFrameSection();
    }
    Qt::WindowFrameSection cpp_result(Shiboken::Converter<Qt::WindowFrameSection >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QGraphicsWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsWidget::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsWidgetWrapper::~QGraphicsWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX]);
    if (type != myType) {
        type->mi_init = myType->mi_init;
        type->mi_offsets = myType->mi_offsets;
        type->mi_specialcast = myType->mi_specialcast;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGraphicsWidget", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsWidget(QGraphicsItem*,QFlags<Qt::WindowType>)
        cptr = new QGraphicsWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGraphicsItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGraphicsWidget(QGraphicsItem*,QFlags<Qt::WindowType>)
            cptr = new QGraphicsWidgetWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QGraphicsWidget(QGraphicsItem*,QFlags<Qt::WindowType>)
            cptr = new QGraphicsWidgetWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQGraphicsWidget_Init_TypeError;
    } else goto SbkQGraphicsWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget", overloads);
        return -1;
}

static PyObject* SbkQGraphicsWidgetFunc_actions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // actions()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QList<QAction * > cpp_result = cppSelf->QGraphicsWidget::actions();
    py_result = Shiboken::Converter<QList<QAction * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_addAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // addAction(QAction*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::addAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_addAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_addAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.addAction", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_addActions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QAction * > >::isConvertible(arg)) {
        QList<QAction * > cpp_arg0 = Shiboken::Converter<QList<QAction * > >::toCpp(arg);
        // addActions(QList<QAction*>)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::addActions(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_addActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_addActions_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.addActions", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_adjustSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // adjustSize()
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWidget::adjustSize();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsWidgetFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsWidget::boundingRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // close()
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsWidget::close();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_closeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCloseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCloseEvent* cpp_arg0 = Shiboken::Converter<QCloseEvent* >::toCpp(arg);
        // closeEvent(QCloseEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::closeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_closeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_closeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCloseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.closeEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.event", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::focusInEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.focusInEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWidget::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.focusNextPrevChild", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::focusOutEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.focusOutEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_focusPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusPolicy()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    Qt::FocusPolicy cpp_result = cppSelf->QGraphicsWidget::focusPolicy();
    py_result = Shiboken::Converter<Qt::FocusPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_focusWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusWidget()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QGraphicsWidget * cpp_result = cppSelf->QGraphicsWidget::focusWidget();
    py_result = Shiboken::Converter<QGraphicsWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QGraphicsWidget::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_grabKeyboardEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // grabKeyboardEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::grabKeyboardEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_grabKeyboardEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_grabKeyboardEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.grabKeyboardEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_grabMouseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // grabMouseEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::grabMouseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_grabMouseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_grabMouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.grabMouseEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_grabShortcut(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "grabShortcut", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QKeySequence & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[0]);
        if (!SbkQKeySequence_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        if (numArgs == 1) {
            // grabShortcut(QKeySequence,Qt::ShortcutContext)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QGraphicsWidget::grabShortcut(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ShortcutContext >::isConvertible(pyargs[1])) {
            Qt::ShortcutContext cpp_arg1 = Shiboken::Converter<Qt::ShortcutContext >::toCpp(pyargs[1]);
            // grabShortcut(QKeySequence,Qt::ShortcutContext)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QGraphicsWidget::grabShortcut(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_grabShortcut_TypeError;
    } else goto SbkQGraphicsWidgetFunc_grabShortcut_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_grabShortcut_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence, PySide.QtCore.Qt.ShortcutContext = Qt.WindowShortcut", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.grabShortcut", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::hideEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.hideEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_hoverLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverLeaveEvent(QGraphicsSceneHoverEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::hoverLeaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_hoverLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_hoverLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.hoverLeaveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_hoverMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverMoveEvent(QGraphicsSceneHoverEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::hoverMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_hoverMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_hoverMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.hoverMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_insertAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertAction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAction * >::isConvertible(pyargs[0]) && Shiboken::Converter<QAction * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAction* cpp_arg1 = Shiboken::Converter<QAction* >::toCpp(pyargs[1]);
        // insertAction(QAction*,QAction*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::insertAction(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_insertAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_insertAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction, PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.insertAction", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_insertActions(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertActions", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAction * >::isConvertible(pyargs[0]) && Shiboken::Converter<QList<QAction * > >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(pyargs[0]);
        QList<QAction * > cpp_arg1 = Shiboken::Converter<QList<QAction * > >::toCpp(pyargs[1]);
        // insertActions(QAction*,QList<QAction*>)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::insertActions(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_insertActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_insertActions_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.insertActions", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_isActiveWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActiveWindow()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsWidget::isActiveWindow();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_itemChange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemChange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        QGraphicsItem::GraphicsItemChange cpp_arg0 = Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // itemChange(QGraphicsItem::GraphicsItemChange,QVariant)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsWidget::itemChange(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_itemChange_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_itemChange_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem.GraphicsItemChange, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.itemChange", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_layout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layout()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QGraphicsLayout * cpp_result = cppSelf->QGraphicsWidget::layout();
    py_result = Shiboken::Converter<QGraphicsLayout * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_layoutDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layoutDirection()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    Qt::LayoutDirection cpp_result = cppSelf->QGraphicsWidget::layoutDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_moveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMoveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMoveEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMoveEvent* >::toCpp(arg);
        // moveEvent(QGraphicsSceneMoveEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::moveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_moveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_moveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.moveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionGraphicsItem * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionGraphicsItem* cpp_arg1 = Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // paint(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::paint(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // paint(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::paint(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_paint_TypeError;
    } else goto SbkQGraphicsWidgetFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionGraphicsItem, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.paint", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_paintWindowFrame(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paintWindowFrame", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionGraphicsItem * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionGraphicsItem* cpp_arg1 = Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // paintWindowFrame(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::paintWindowFrame(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // paintWindowFrame(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::paintWindowFrame(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_paintWindowFrame_TypeError;
    } else goto SbkQGraphicsWidgetFunc_paintWindowFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_paintWindowFrame_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionGraphicsItem, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.paintWindowFrame", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_palette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // palette()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QPalette cpp_result = cppSelf->QGraphicsWidget::palette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_polishEvent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // polishEvent()
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWidget::polishEvent();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsWidgetFunc_propertyChange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "propertyChange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // propertyChange(QString,QVariant)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsWidget::propertyChange(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_propertyChange_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_propertyChange_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.propertyChange", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsWidget::rect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_releaseShortcut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // releaseShortcut(int)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::releaseShortcut(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_releaseShortcut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_releaseShortcut_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.releaseShortcut", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_removeAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // removeAction(QAction*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::removeAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_removeAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_removeAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.removeAction", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_resize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // resize(qreal,qreal)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::resize(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QSizeF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[0]);
        if (!SbkQSizeF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // resize(QSizeF)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::resize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_resize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.resize", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneResizeEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneResizeEvent* >::toCpp(arg);
        // resizeEvent(QGraphicsSceneResizeEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_sceneEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // sceneEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWidget::sceneEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_sceneEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_sceneEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.sceneEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::WidgetAttribute >::isConvertible(pyargs[0])) {
        Qt::WidgetAttribute cpp_arg0 = Shiboken::Converter<Qt::WidgetAttribute >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setAttribute(Qt::WidgetAttribute,bool)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::setAttribute(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setAttribute(Qt::WidgetAttribute,bool)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::setAttribute(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_setAttribute_TypeError;
    } else goto SbkQGraphicsWidgetFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WidgetAttribute, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setContentsMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setContentsMargins", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setContentsMargins(qreal,qreal,qreal,qreal)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setContentsMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setContentsMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setContentsMargins_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setContentsMargins", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setFocusPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::FocusPolicy >::isConvertible(arg)) {
        Qt::FocusPolicy cpp_arg0 = Shiboken::Converter<Qt::FocusPolicy >::toCpp(arg);
        // setFocusPolicy(Qt::FocusPolicy)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setFocusPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setFocusPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setFocusPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.FocusPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setFocusPolicy", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setFont(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setFont", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setGeometry(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQGraphicsWidgetFunc_setGeometry_TypeError;

    if (!PyArg_UnpackTuple(args, "setGeometry", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setGeometry(qreal,qreal,qreal,qreal)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setGeometry(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setGeometry(QRectF)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setLayout(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsLayout * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsLayout* cpp_arg0 = Shiboken::Converter<QGraphicsLayout* >::toCpp(arg);
        // setLayout(QGraphicsLayout*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setLayout(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsWidgetFunc_setLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayout", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setLayout", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setLayoutDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::LayoutDirection >::isConvertible(arg)) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(arg);
        // setLayoutDirection(Qt::LayoutDirection)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setLayoutDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setLayoutDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setLayoutDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setLayoutDirection", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setPalette(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!SbkQPalette_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // setPalette(QPalette)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setPalette(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setPalette_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setPalette_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setPalette", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setShortcutAutoRepeat(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setShortcutAutoRepeat", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setShortcutAutoRepeat(int,bool)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::setShortcutAutoRepeat(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setShortcutAutoRepeat(int,bool)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::setShortcutAutoRepeat(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_setShortcutAutoRepeat_TypeError;
    } else goto SbkQGraphicsWidgetFunc_setShortcutAutoRepeat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setShortcutAutoRepeat_TypeError:
        const char* overloads[] = {"int, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setShortcutAutoRepeat", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setShortcutEnabled(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setShortcutEnabled", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setShortcutEnabled(int,bool)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::setShortcutEnabled(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setShortcutEnabled(int,bool)
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWidget::setShortcutEnabled(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_setShortcutEnabled_TypeError;
    } else goto SbkQGraphicsWidgetFunc_setShortcutEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setShortcutEnabled_TypeError:
        const char* overloads[] = {"int, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setShortcutEnabled", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStyle * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStyle* cpp_arg0 = Shiboken::Converter<QStyle* >::toCpp(arg);
        // setStyle(QStyle*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsWidgetFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setStyle", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setTabOrder(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabOrder", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QGraphicsWidget * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsWidget* cpp_arg0 = Shiboken::Converter<QGraphicsWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QGraphicsWidget* cpp_arg1 = Shiboken::Converter<QGraphicsWidget* >::toCpp(pyargs[1]);
        // setTabOrder(QGraphicsWidget*,QGraphicsWidget*)
        QGraphicsWidget::setTabOrder(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQGraphicsWidgetFunc_setTabOrder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setTabOrder_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsWidget, PySide.QtGui.QGraphicsWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setTabOrder", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setWindowFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_WindowType_Check(arg)) {
        QFlags<Qt::WindowType> cpp_arg0 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(arg);
        // setWindowFlags(QFlags<Qt::WindowType>)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setWindowFlags(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setWindowFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setWindowFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setWindowFlags", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setWindowFrameMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setWindowFrameMargins", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setWindowFrameMargins(qreal,qreal,qreal,qreal)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setWindowFrameMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setWindowFrameMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setWindowFrameMargins_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.setWindowFrameMargins", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_setWindowTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWindowTitle(QString)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::setWindowTitle(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_setWindowTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_setWindowTitle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.setWindowTitle", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_shape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shape()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QGraphicsWidget::shape();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::showEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.showEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QGraphicsWidget::size();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::SizeHint >::isConvertible(pyargs[0])) {
        Qt::SizeHint cpp_arg0 = Shiboken::Converter<Qt::SizeHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsWidget::sizeHint(cpp_arg0);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsWidget::sizeHint(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsWidgetFunc_sizeHint_TypeError;
    } else goto SbkQGraphicsWidgetFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SizeHint, PySide.QtCore.QSizeF = QSizeF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsWidget.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QStyle * cpp_result = cppSelf->QGraphicsWidget::style();
    py_result = Shiboken::Converter<QStyle * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_testAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::WidgetAttribute >::isConvertible(arg)) {
        Qt::WidgetAttribute cpp_arg0 = Shiboken::Converter<Qt::WidgetAttribute >::toCpp(arg);
        // testAttribute(Qt::WidgetAttribute)const
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWidget::testAttribute(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_testAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_testAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WidgetAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.testAttribute", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsWidget::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_ungrabKeyboardEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // ungrabKeyboardEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::ungrabKeyboardEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_ungrabKeyboardEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_ungrabKeyboardEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.ungrabKeyboardEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_ungrabMouseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // ungrabMouseEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWidget::ungrabMouseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_ungrabMouseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWidgetFunc_ungrabMouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.ungrabMouseEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_unsetLayoutDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetLayoutDirection()
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWidget::unsetLayoutDirection();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsWidgetFunc_unsetWindowFrameMargins(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetWindowFrameMargins()
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWidget::unsetWindowFrameMargins();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsWidgetFunc_updateGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometry()
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWidget::updateGeometry();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsWidgetFunc_windowFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowFlags()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::WindowType> cpp_result = cppSelf->QGraphicsWidget::windowFlags();
    py_result = Shiboken::Converter<QFlags<Qt::WindowType> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_windowFrameEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // windowFrameEvent(QEvent*)
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWidget::windowFrameEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_windowFrameEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_windowFrameEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.windowFrameEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_windowFrameGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowFrameGeometry()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsWidget::windowFrameGeometry();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_windowFrameRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowFrameRect()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsWidget::windowFrameRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_windowFrameSectionAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // windowFrameSectionAt(QPointF)const
        QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
        Qt::WindowFrameSection cpp_result = cppSelf->QGraphicsWidget::windowFrameSectionAt(*cpp_arg0);
        py_result = Shiboken::Converter<Qt::WindowFrameSection >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsWidgetFunc_windowFrameSectionAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsWidgetFunc_windowFrameSectionAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsWidget.windowFrameSectionAt", overloads);
        return 0;
}

static PyObject* SbkQGraphicsWidgetFunc_windowTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowTitle()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QGraphicsWidget::windowTitle();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsWidgetFunc_windowType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowType()const
    QGraphicsWidget* cppSelf = Shiboken::Converter<QGraphicsWidget* >::toCpp((PyObject*)self);
    Qt::WindowType cpp_result = cppSelf->QGraphicsWidget::windowType();
    py_result = Shiboken::Converter<Qt::WindowType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGraphicsWidget_methods[] = {
    {"actions", (PyCFunction)SbkQGraphicsWidgetFunc_actions, METH_NOARGS},
    {"addAction", (PyCFunction)SbkQGraphicsWidgetFunc_addAction, METH_O},
    {"addActions", (PyCFunction)SbkQGraphicsWidgetFunc_addActions, METH_O},
    {"adjustSize", (PyCFunction)SbkQGraphicsWidgetFunc_adjustSize, METH_NOARGS},
    {"boundingRect", (PyCFunction)SbkQGraphicsWidgetFunc_boundingRect, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQGraphicsWidgetFunc_changeEvent, METH_O},
    {"close", (PyCFunction)SbkQGraphicsWidgetFunc_close, METH_NOARGS},
    {"closeEvent", (PyCFunction)SbkQGraphicsWidgetFunc_closeEvent, METH_O},
    {"event", (PyCFunction)SbkQGraphicsWidgetFunc_event, METH_O},
    {"focusInEvent", (PyCFunction)SbkQGraphicsWidgetFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQGraphicsWidgetFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQGraphicsWidgetFunc_focusOutEvent, METH_O},
    {"focusPolicy", (PyCFunction)SbkQGraphicsWidgetFunc_focusPolicy, METH_NOARGS},
    {"focusWidget", (PyCFunction)SbkQGraphicsWidgetFunc_focusWidget, METH_NOARGS},
    {"font", (PyCFunction)SbkQGraphicsWidgetFunc_font, METH_NOARGS},
    {"grabKeyboardEvent", (PyCFunction)SbkQGraphicsWidgetFunc_grabKeyboardEvent, METH_O},
    {"grabMouseEvent", (PyCFunction)SbkQGraphicsWidgetFunc_grabMouseEvent, METH_O},
    {"grabShortcut", (PyCFunction)SbkQGraphicsWidgetFunc_grabShortcut, METH_VARARGS},
    {"hideEvent", (PyCFunction)SbkQGraphicsWidgetFunc_hideEvent, METH_O},
    {"hoverLeaveEvent", (PyCFunction)SbkQGraphicsWidgetFunc_hoverLeaveEvent, METH_O},
    {"hoverMoveEvent", (PyCFunction)SbkQGraphicsWidgetFunc_hoverMoveEvent, METH_O},
    {"insertAction", (PyCFunction)SbkQGraphicsWidgetFunc_insertAction, METH_VARARGS},
    {"insertActions", (PyCFunction)SbkQGraphicsWidgetFunc_insertActions, METH_VARARGS},
    {"isActiveWindow", (PyCFunction)SbkQGraphicsWidgetFunc_isActiveWindow, METH_NOARGS},
    {"itemChange", (PyCFunction)SbkQGraphicsWidgetFunc_itemChange, METH_VARARGS},
    {"layout", (PyCFunction)SbkQGraphicsWidgetFunc_layout, METH_NOARGS},
    {"layoutDirection", (PyCFunction)SbkQGraphicsWidgetFunc_layoutDirection, METH_NOARGS},
    {"moveEvent", (PyCFunction)SbkQGraphicsWidgetFunc_moveEvent, METH_O},
    {"paint", (PyCFunction)SbkQGraphicsWidgetFunc_paint, METH_VARARGS},
    {"paintWindowFrame", (PyCFunction)SbkQGraphicsWidgetFunc_paintWindowFrame, METH_VARARGS},
    {"palette", (PyCFunction)SbkQGraphicsWidgetFunc_palette, METH_NOARGS},
    {"polishEvent", (PyCFunction)SbkQGraphicsWidgetFunc_polishEvent, METH_NOARGS},
    {"propertyChange", (PyCFunction)SbkQGraphicsWidgetFunc_propertyChange, METH_VARARGS},
    {"rect", (PyCFunction)SbkQGraphicsWidgetFunc_rect, METH_NOARGS},
    {"releaseShortcut", (PyCFunction)SbkQGraphicsWidgetFunc_releaseShortcut, METH_O},
    {"removeAction", (PyCFunction)SbkQGraphicsWidgetFunc_removeAction, METH_O},
    {"resize", (PyCFunction)SbkQGraphicsWidgetFunc_resize, METH_VARARGS},
    {"resizeEvent", (PyCFunction)SbkQGraphicsWidgetFunc_resizeEvent, METH_O},
    {"sceneEvent", (PyCFunction)SbkQGraphicsWidgetFunc_sceneEvent, METH_O},
    {"setAttribute", (PyCFunction)SbkQGraphicsWidgetFunc_setAttribute, METH_VARARGS},
    {"setContentsMargins", (PyCFunction)SbkQGraphicsWidgetFunc_setContentsMargins, METH_VARARGS},
    {"setFocusPolicy", (PyCFunction)SbkQGraphicsWidgetFunc_setFocusPolicy, METH_O},
    {"setFont", (PyCFunction)SbkQGraphicsWidgetFunc_setFont, METH_O},
    {"setGeometry", (PyCFunction)SbkQGraphicsWidgetFunc_setGeometry, METH_VARARGS},
    {"setLayout", (PyCFunction)SbkQGraphicsWidgetFunc_setLayout, METH_O},
    {"setLayoutDirection", (PyCFunction)SbkQGraphicsWidgetFunc_setLayoutDirection, METH_O},
    {"setPalette", (PyCFunction)SbkQGraphicsWidgetFunc_setPalette, METH_O},
    {"setShortcutAutoRepeat", (PyCFunction)SbkQGraphicsWidgetFunc_setShortcutAutoRepeat, METH_VARARGS},
    {"setShortcutEnabled", (PyCFunction)SbkQGraphicsWidgetFunc_setShortcutEnabled, METH_VARARGS},
    {"setStyle", (PyCFunction)SbkQGraphicsWidgetFunc_setStyle, METH_O},
    {"setTabOrder", (PyCFunction)SbkQGraphicsWidgetFunc_setTabOrder, METH_VARARGS|METH_STATIC},
    {"setWindowFlags", (PyCFunction)SbkQGraphicsWidgetFunc_setWindowFlags, METH_O},
    {"setWindowFrameMargins", (PyCFunction)SbkQGraphicsWidgetFunc_setWindowFrameMargins, METH_VARARGS},
    {"setWindowTitle", (PyCFunction)SbkQGraphicsWidgetFunc_setWindowTitle, METH_O},
    {"shape", (PyCFunction)SbkQGraphicsWidgetFunc_shape, METH_NOARGS},
    {"showEvent", (PyCFunction)SbkQGraphicsWidgetFunc_showEvent, METH_O},
    {"size", (PyCFunction)SbkQGraphicsWidgetFunc_size, METH_NOARGS},
    {"sizeHint", (PyCFunction)SbkQGraphicsWidgetFunc_sizeHint, METH_VARARGS},
    {"style", (PyCFunction)SbkQGraphicsWidgetFunc_style, METH_NOARGS},
    {"testAttribute", (PyCFunction)SbkQGraphicsWidgetFunc_testAttribute, METH_O},
    {"type", (PyCFunction)SbkQGraphicsWidgetFunc_type, METH_NOARGS},
    {"ungrabKeyboardEvent", (PyCFunction)SbkQGraphicsWidgetFunc_ungrabKeyboardEvent, METH_O},
    {"ungrabMouseEvent", (PyCFunction)SbkQGraphicsWidgetFunc_ungrabMouseEvent, METH_O},
    {"unsetLayoutDirection", (PyCFunction)SbkQGraphicsWidgetFunc_unsetLayoutDirection, METH_NOARGS},
    {"unsetWindowFrameMargins", (PyCFunction)SbkQGraphicsWidgetFunc_unsetWindowFrameMargins, METH_NOARGS},
    {"updateGeometry", (PyCFunction)SbkQGraphicsWidgetFunc_updateGeometry, METH_NOARGS},
    {"windowFlags", (PyCFunction)SbkQGraphicsWidgetFunc_windowFlags, METH_NOARGS},
    {"windowFrameEvent", (PyCFunction)SbkQGraphicsWidgetFunc_windowFrameEvent, METH_O},
    {"windowFrameGeometry", (PyCFunction)SbkQGraphicsWidgetFunc_windowFrameGeometry, METH_NOARGS},
    {"windowFrameRect", (PyCFunction)SbkQGraphicsWidgetFunc_windowFrameRect, METH_NOARGS},
    {"windowFrameSectionAt", (PyCFunction)SbkQGraphicsWidgetFunc_windowFrameSectionAt, METH_O},
    {"windowTitle", (PyCFunction)SbkQGraphicsWidgetFunc_windowTitle, METH_NOARGS},
    {"windowType", (PyCFunction)SbkQGraphicsWidgetFunc_windowType, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static int mi_offsets[] = { -1, -1, -1, -1, -1, -1, -1, -1, -1 };
int*
SbkQGraphicsWidget_mi_init(const void* cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        std::set<int>::iterator it;
        const QGraphicsWidget* class_ptr = reinterpret_cast<const QGraphicsWidget*>(cptr);
        size_t base = (size_t) class_ptr;
        offsets.insert(((size_t) static_cast<const QGraphicsObject*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QGraphicsObject*>((QGraphicsWidget*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QGraphicsLayoutItem*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QGraphicsLayoutItem*>((QGraphicsWidget*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QObject*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QObject*>((QGraphicsObject*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QGraphicsItem*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QGraphicsItem*>((QGraphicsObject*)((void*)class_ptr))) - base);

        offsets.erase(0);

        int i = 0;
        for (it = offsets.begin(); it != offsets.end(); it++) {
            mi_offsets[i] = *it;
            i++;
        }
    }
    return mi_offsets;
}
static void* SbkQGraphicsWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QGraphicsWidget* me = reinterpret_cast<QGraphicsWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSOBJECT_IDX]))
        return static_cast<QGraphicsObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_IDX]))
        return static_cast<QGraphicsItem*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]))
        return static_cast<QGraphicsLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             SbkQGraphicsWidget_mi_init,
    /*mi_specialcast*/      &SbkQGraphicsWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGraphicsWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsWidget_Type);

    SbkQGraphicsWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX];
    SbkQGraphicsWidget_Type.super.ht_type.tp_bases = PyTuple_Pack(2,
        (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSOBJECT_IDX], (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]);

    // Fill type discovery information
    SbkQGraphicsWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsWidget_Type));
    PyModule_AddObject(module, "QGraphicsWidget",
        ((PyObject*)&SbkQGraphicsWidget_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsWidget >("QGraphicsWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsWidget >(typeid(QGraphicsWidget).name());
}


} // extern "C"

