/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsscenewheelevent_wrapper.h"

// Extra includes
#include <qpoint.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsSceneWheelEventWrapper::QGraphicsSceneWheelEventWrapper(QEvent::Type type) : QGraphicsSceneWheelEvent(type) {
    // ... middle
}

QGraphicsSceneWheelEventWrapper::~QGraphicsSceneWheelEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsSceneWheelEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneWheelEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsSceneWheelEvent", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsSceneWheelEvent(QEvent::Type)
        cptr = new QGraphicsSceneWheelEventWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        // QGraphicsSceneWheelEvent(QEvent::Type)
        cptr = new QGraphicsSceneWheelEventWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsSceneWheelEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsSceneWheelEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsSceneWheelEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneWheelEvent", overloads);
        return -1;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::MouseButton> cpp_result = cppSelf->QGraphicsSceneWheelEvent::buttons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_delta(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // delta()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsSceneWheelEvent::delta();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_modifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifiers()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QGraphicsSceneWheelEvent::modifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QGraphicsSceneWheelEvent::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneWheelEvent::pos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_scenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scenePos()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneWheelEvent::scenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_screenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenPos()const
    QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneWheelEvent::screenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_MouseButton_Check(arg)) {
        QFlags<Qt::MouseButton> cpp_arg0 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(arg);
        // setButtons(QFlags<Qt::MouseButton>)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setButtons_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButtons", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setButtons", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setDelta(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDelta(int)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setDelta(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setDelta_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setDelta_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setDelta", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setModifiers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(arg)) {
        QFlags<Qt::KeyboardModifier> cpp_arg0 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(arg);
        // setModifiers(QFlags<Qt::KeyboardModifier>)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setModifiers(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setModifiers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setModifiers_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setModifiers", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // setOrientation(Qt::Orientation)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setOrientation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setOrientation", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPos(QPointF)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScenePos(QPointF)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setScenePos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setScenePos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneWheelEventFunc_setScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setScreenPos(QPoint)
        QGraphicsSceneWheelEvent* cppSelf = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneWheelEvent::setScreenPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneWheelEventFunc_setScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneWheelEventFunc_setScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneWheelEvent.setScreenPos", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsSceneWheelEvent_methods[] = {
    {"buttons", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_buttons, METH_NOARGS},
    {"delta", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_delta, METH_NOARGS},
    {"modifiers", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_modifiers, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_orientation, METH_NOARGS},
    {"pos", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_pos, METH_NOARGS},
    {"scenePos", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_scenePos, METH_NOARGS},
    {"screenPos", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_screenPos, METH_NOARGS},
    {"setButtons", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setButtons, METH_O},
    {"setDelta", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setDelta, METH_O},
    {"setModifiers", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setModifiers, METH_O},
    {"setOrientation", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setOrientation, METH_O},
    {"setPos", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setPos, METH_O},
    {"setScenePos", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setScenePos, METH_O},
    {"setScreenPos", (PyCFunction)SbkQGraphicsSceneWheelEventFunc_setScreenPos, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsSceneWheelEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsSceneWheelEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsSceneWheelEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsSceneWheelEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsSceneWheelEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQGraphicsSceneWheelEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQGraphicsSceneWheelEvent_Type);
     if ( reinterpret_cast<QGraphicsSceneWheelEvent*>(cptr)->type() == QEvent::GraphicsSceneWheel)
        return &SbkQGraphicsSceneWheelEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QGraphicsSceneWheelEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEWHEELEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsSceneWheelEvent_Type);

    SbkQGraphicsSceneWheelEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX];
    // Fill type discovery information
    SbkQGraphicsSceneWheelEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQGraphicsSceneWheelEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQGraphicsSceneWheelEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsSceneWheelEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsSceneWheelEvent_Type));
    PyModule_AddObject(module, "QGraphicsSceneWheelEvent",
        ((PyObject*)&SbkQGraphicsSceneWheelEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneWheelEvent >("QGraphicsSceneWheelEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneWheelEvent >(typeid(QGraphicsSceneWheelEvent).name());
}


} // extern "C"

