/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsscenemouseevent_wrapper.h"

// Extra includes
#include <qpoint.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsSceneMouseEventWrapper::QGraphicsSceneMouseEventWrapper(QEvent::Type type) : QGraphicsSceneMouseEvent(type) {
    // ... middle
}

QGraphicsSceneMouseEventWrapper::~QGraphicsSceneMouseEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsSceneMouseEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneMouseEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsSceneMouseEvent", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsSceneMouseEvent(QEvent::Type)
        cptr = new QGraphicsSceneMouseEventWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        // QGraphicsSceneMouseEvent(QEvent::Type)
        cptr = new QGraphicsSceneMouseEventWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsSceneMouseEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsSceneMouseEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsSceneMouseEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneMouseEvent", overloads);
        return -1;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_button(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // button()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    Qt::MouseButton cpp_result = cppSelf->QGraphicsSceneMouseEvent::button();
    py_result = Shiboken::Converter<Qt::MouseButton >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_buttonDownPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::MouseButton >::isConvertible(arg)) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(arg);
        // buttonDownPos(Qt::MouseButton)const
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QGraphicsSceneMouseEvent::buttonDownPos(cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_buttonDownPos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsSceneMouseEventFunc_buttonDownPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.buttonDownPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_buttonDownScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::MouseButton >::isConvertible(arg)) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(arg);
        // buttonDownScenePos(Qt::MouseButton)const
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QGraphicsSceneMouseEvent::buttonDownScenePos(cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_buttonDownScenePos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsSceneMouseEventFunc_buttonDownScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.buttonDownScenePos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_buttonDownScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::MouseButton >::isConvertible(arg)) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(arg);
        // buttonDownScreenPos(Qt::MouseButton)const
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QGraphicsSceneMouseEvent::buttonDownScreenPos(cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_buttonDownScreenPos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsSceneMouseEventFunc_buttonDownScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.buttonDownScreenPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::MouseButton> cpp_result = cppSelf->QGraphicsSceneMouseEvent::buttons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_lastPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastPos()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneMouseEvent::lastPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_lastScenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScenePos()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneMouseEvent::lastScenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_lastScreenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScreenPos()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneMouseEvent::lastScreenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_modifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifiers()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QGraphicsSceneMouseEvent::modifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneMouseEvent::pos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_scenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scenePos()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneMouseEvent::scenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_screenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenPos()const
    QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneMouseEvent::screenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::MouseButton >::isConvertible(arg)) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(arg);
        // setButton(Qt::MouseButton)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setButton(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setButton_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setButton", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setButtonDownPos(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setButtonDownPos", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // setButtonDownPos(Qt::MouseButton,QPointF)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setButtonDownPos(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setButtonDownPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setButtonDownPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneMouseEvent.setButtonDownPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setButtonDownScenePos(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setButtonDownScenePos", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // setButtonDownScenePos(Qt::MouseButton,QPointF)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setButtonDownScenePos(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setButtonDownScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setButtonDownScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneMouseEvent.setButtonDownScenePos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setButtonDownScreenPos(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setButtonDownScreenPos", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // setButtonDownScreenPos(Qt::MouseButton,QPoint)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setButtonDownScreenPos(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setButtonDownScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setButtonDownScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneMouseEvent.setButtonDownScreenPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_MouseButton_Check(arg)) {
        QFlags<Qt::MouseButton> cpp_arg0 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(arg);
        // setButtons(QFlags<Qt::MouseButton>)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setButtons_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButtons", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setButtons", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setLastPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastPos(QPointF)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setLastPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setLastPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setLastPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setLastPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setLastScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastScenePos(QPointF)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setLastScenePos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setLastScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setLastScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setLastScenePos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setLastScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setLastScreenPos(QPoint)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setLastScreenPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setLastScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setLastScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setLastScreenPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setModifiers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(arg)) {
        QFlags<Qt::KeyboardModifier> cpp_arg0 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(arg);
        // setModifiers(QFlags<Qt::KeyboardModifier>)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setModifiers(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setModifiers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setModifiers_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setModifiers", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPos(QPointF)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScenePos(QPointF)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setScenePos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setScenePos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneMouseEventFunc_setScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setScreenPos(QPoint)
        QGraphicsSceneMouseEvent* cppSelf = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneMouseEvent::setScreenPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneMouseEventFunc_setScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneMouseEventFunc_setScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneMouseEvent.setScreenPos", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsSceneMouseEvent_methods[] = {
    {"button", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_button, METH_NOARGS},
    {"buttonDownPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_buttonDownPos, METH_O},
    {"buttonDownScenePos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_buttonDownScenePos, METH_O},
    {"buttonDownScreenPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_buttonDownScreenPos, METH_O},
    {"buttons", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_buttons, METH_NOARGS},
    {"lastPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_lastPos, METH_NOARGS},
    {"lastScenePos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_lastScenePos, METH_NOARGS},
    {"lastScreenPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_lastScreenPos, METH_NOARGS},
    {"modifiers", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_modifiers, METH_NOARGS},
    {"pos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_pos, METH_NOARGS},
    {"scenePos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_scenePos, METH_NOARGS},
    {"screenPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_screenPos, METH_NOARGS},
    {"setButton", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setButton, METH_O},
    {"setButtonDownPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setButtonDownPos, METH_VARARGS},
    {"setButtonDownScenePos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setButtonDownScenePos, METH_VARARGS},
    {"setButtonDownScreenPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setButtonDownScreenPos, METH_VARARGS},
    {"setButtons", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setButtons, METH_O},
    {"setLastPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setLastPos, METH_O},
    {"setLastScenePos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setLastScenePos, METH_O},
    {"setLastScreenPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setLastScreenPos, METH_O},
    {"setModifiers", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setModifiers, METH_O},
    {"setPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setPos, METH_O},
    {"setScenePos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setScenePos, METH_O},
    {"setScreenPos", (PyCFunction)SbkQGraphicsSceneMouseEventFunc_setScreenPos, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsSceneMouseEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsSceneMouseEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsSceneMouseEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsSceneMouseEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsSceneMouseEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQGraphicsSceneMouseEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQGraphicsSceneMouseEvent_Type);
     if ( reinterpret_cast<QGraphicsSceneMouseEvent*>(cptr)->type() == QEvent::GraphicsSceneMouseDoubleClick ||  reinterpret_cast<QGraphicsSceneMouseEvent*>(cptr)->type() == QEvent::GraphicsSceneMouseMove ||  reinterpret_cast<QGraphicsSceneMouseEvent*>(cptr)->type() == QEvent::GraphicsSceneMousePress ||  reinterpret_cast<QGraphicsSceneMouseEvent*>(cptr)->type() == QEvent::GraphicsSceneMouseRelease)
        return &SbkQGraphicsSceneMouseEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QGraphicsSceneMouseEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsSceneMouseEvent_Type);

    SbkQGraphicsSceneMouseEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX];
    // Fill type discovery information
    SbkQGraphicsSceneMouseEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQGraphicsSceneMouseEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQGraphicsSceneMouseEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsSceneMouseEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsSceneMouseEvent_Type));
    PyModule_AddObject(module, "QGraphicsSceneMouseEvent",
        ((PyObject*)&SbkQGraphicsSceneMouseEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneMouseEvent >("QGraphicsSceneMouseEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneMouseEvent >(typeid(QGraphicsSceneMouseEvent).name());
}


} // extern "C"

