/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicslinearlayout_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qgraphicsitem.h>
#include <qgraphicslayoutitem.h>
#include <qgraphicslinearlayout.h>
#include <qrect.h>
#include <qsize.h>
#include <qsizepolicy.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsLinearLayoutWrapper::QGraphicsLinearLayoutWrapper(QGraphicsLayoutItem * parent) : QGraphicsLinearLayout(parent) {
    // ... middle
}

QGraphicsLinearLayoutWrapper::QGraphicsLinearLayoutWrapper(Qt::Orientation orientation, QGraphicsLayoutItem * parent) : QGraphicsLinearLayout(orientation, parent) {
    // ... middle
}

int QGraphicsLinearLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QGraphicsLinearLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsLinearLayout.count", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsLinearLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QGraphicsLinearLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QGraphicsLayoutItem * QGraphicsLinearLayoutWrapper::itemAt(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QGraphicsLinearLayout::itemAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsLinearLayout.itemAt", SbkType<QGraphicsLayoutItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QGraphicsLayoutItem * cpp_result(Shiboken::Converter<QGraphicsLayoutItem * >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsLinearLayoutWrapper::removeAt(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeAt"));
    if (py_override.isNull()) {
        return this->QGraphicsLinearLayout::removeAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsLinearLayoutWrapper::setGeometry(const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsLinearLayout::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRectF & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSizeF QGraphicsLinearLayoutWrapper::sizeHint(Qt::SizeHint which, const QSizeF & constraint) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsLinearLayout::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<Qt::SizeHint >::toPython(which),
        Shiboken::Converter<QSizeF & >::toPython(constraint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsLinearLayout.sizeHint", SbkType<QSizeF >()->tp_name, py_result->ob_type->tp_name);
        return QSizeF();
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsLinearLayoutWrapper::updateGeometry()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsLayout::updateGeometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsLinearLayoutWrapper::widgetEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widgetEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsLayout::widgetEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QGraphicsLinearLayoutWrapper::~QGraphicsLinearLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsLinearLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsLinearLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGraphicsLinearLayout", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsLinearLayout(QGraphicsLayoutItem*)
        cptr = new QGraphicsLinearLayoutWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[0])) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGraphicsLinearLayout(Qt::Orientation,QGraphicsLayoutItem*)
            cptr = new QGraphicsLinearLayoutWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QGraphicsLayoutItem* cpp_arg1 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[1]);
            // QGraphicsLinearLayout(Qt::Orientation,QGraphicsLayoutItem*)
            cptr = new QGraphicsLinearLayoutWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQGraphicsLinearLayout_Init_TypeError;
    } else if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        // QGraphicsLinearLayout(QGraphicsLayoutItem*)
        cptr = new QGraphicsLinearLayoutWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsLinearLayout_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsLinearLayout >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsLinearLayout_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsLinearLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem = None", "PySide.QtCore.Qt.Orientation, PySide.QtGui.QGraphicsLayoutItem = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout", overloads);
        return -1;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(arg);
        // addItem(QGraphicsLayoutItem*)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::addItem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsLinearLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.addItem", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_addStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // addStretch(int)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::addStretch();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addStretch(int)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::addStretch(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_addStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_addStretch_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.addStretch", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_alignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(arg);
        // alignment(QGraphicsLayoutItem*)const
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QGraphicsLinearLayout::alignment(cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_alignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsLinearLayoutFunc_alignment_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.alignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsLinearLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_dump(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // dump(int)const
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::dump();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // dump(int)const
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::dump(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_dump_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_dump_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.dump", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_insertItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QGraphicsLayoutItem* cpp_arg1 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[1]);
        // insertItem(int,QGraphicsLayoutItem*)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::insertItem(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQGraphicsLinearLayoutFunc_insertItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_insertItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QGraphicsLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout.insertItem", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_insertStretch(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertStretch", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertStretch(int,int)
            QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsLinearLayout::insertStretch(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // insertStretch(int,int)
            QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsLinearLayout::insertStretch(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsLinearLayoutFunc_insertStretch_TypeError;
    } else goto SbkQGraphicsLinearLayoutFunc_insertStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_insertStretch_TypeError:
        const char* overloads[] = {"int, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout.insertStretch", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsLinearLayout::invalidate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        QGraphicsLayoutItem * cpp_result = cppSelf->QGraphicsLinearLayout::itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QGraphicsLayoutItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsLinearLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsLinearLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.itemAt", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_itemSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemSpacing(int)const
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsLinearLayout::itemSpacing(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_itemSpacing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsLinearLayoutFunc_itemSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.itemSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QGraphicsLinearLayout::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_removeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeAt(int)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::removeAt(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_removeAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_removeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.removeAt", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_removeItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(arg);
        // removeItem(QGraphicsLayoutItem*)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::removeItem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQGraphicsLinearLayoutFunc_removeItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_removeItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.removeItem", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_setAlignment(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAlignment", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // setAlignment(QGraphicsLayoutItem*,QFlags<Qt::AlignmentFlag>)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::setAlignment(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQGraphicsLinearLayoutFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout.setAlignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setGeometry(QRectF)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_setItemSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemSpacing", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setItemSpacing(int,qreal)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::setItemSpacing(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_setItemSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_setItemSpacing_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout.setItemSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // setOrientation(Qt::Orientation)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::setOrientation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.setOrientation", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setSpacing(qreal)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::setSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.setSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_setStretchFactor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStretchFactor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setStretchFactor(QGraphicsLayoutItem*,int)
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsLinearLayout::setStretchFactor(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQGraphicsLinearLayoutFunc_setStretchFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsLinearLayoutFunc_setStretchFactor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout.setStretchFactor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::SizeHint >::isConvertible(pyargs[0])) {
        Qt::SizeHint cpp_arg0 = Shiboken::Converter<Qt::SizeHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsLinearLayout::sizeHint(cpp_arg0);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsLinearLayout::sizeHint(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsLinearLayoutFunc_sizeHint_TypeError;
    } else goto SbkQGraphicsLinearLayoutFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsLinearLayoutFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SizeHint, PySide.QtCore.QSizeF = QSizeF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsLinearLayout.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_spacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacing()const
    QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsLinearLayout::spacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsLinearLayoutFunc_stretchFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(arg);
        // stretchFactor(QGraphicsLayoutItem*)const
        QGraphicsLinearLayout* cppSelf = Shiboken::Converter<QGraphicsLinearLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGraphicsLinearLayout::stretchFactor(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsLinearLayoutFunc_stretchFactor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsLinearLayoutFunc_stretchFactor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsLinearLayout.stretchFactor", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsLinearLayout_methods[] = {
    {"addItem", (PyCFunction)SbkQGraphicsLinearLayoutFunc_addItem, METH_O},
    {"addStretch", (PyCFunction)SbkQGraphicsLinearLayoutFunc_addStretch, METH_NOARGS|METH_O},
    {"alignment", (PyCFunction)SbkQGraphicsLinearLayoutFunc_alignment, METH_O},
    {"count", (PyCFunction)SbkQGraphicsLinearLayoutFunc_count, METH_NOARGS},
    {"dump", (PyCFunction)SbkQGraphicsLinearLayoutFunc_dump, METH_NOARGS|METH_O},
    {"insertItem", (PyCFunction)SbkQGraphicsLinearLayoutFunc_insertItem, METH_VARARGS},
    {"insertStretch", (PyCFunction)SbkQGraphicsLinearLayoutFunc_insertStretch, METH_VARARGS},
    {"invalidate", (PyCFunction)SbkQGraphicsLinearLayoutFunc_invalidate, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQGraphicsLinearLayoutFunc_itemAt, METH_O},
    {"itemSpacing", (PyCFunction)SbkQGraphicsLinearLayoutFunc_itemSpacing, METH_O},
    {"orientation", (PyCFunction)SbkQGraphicsLinearLayoutFunc_orientation, METH_NOARGS},
    {"removeAt", (PyCFunction)SbkQGraphicsLinearLayoutFunc_removeAt, METH_O},
    {"removeItem", (PyCFunction)SbkQGraphicsLinearLayoutFunc_removeItem, METH_O},
    {"setAlignment", (PyCFunction)SbkQGraphicsLinearLayoutFunc_setAlignment, METH_VARARGS},
    {"setGeometry", (PyCFunction)SbkQGraphicsLinearLayoutFunc_setGeometry, METH_O},
    {"setItemSpacing", (PyCFunction)SbkQGraphicsLinearLayoutFunc_setItemSpacing, METH_VARARGS},
    {"setOrientation", (PyCFunction)SbkQGraphicsLinearLayoutFunc_setOrientation, METH_O},
    {"setSpacing", (PyCFunction)SbkQGraphicsLinearLayoutFunc_setSpacing, METH_O},
    {"setStretchFactor", (PyCFunction)SbkQGraphicsLinearLayoutFunc_setStretchFactor, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQGraphicsLinearLayoutFunc_sizeHint, METH_VARARGS},
    {"spacing", (PyCFunction)SbkQGraphicsLinearLayoutFunc_spacing, METH_NOARGS},
    {"stretchFactor", (PyCFunction)SbkQGraphicsLinearLayoutFunc_stretchFactor, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsLinearLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsLinearLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsLinearLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsLinearLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsLinearLayout >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGraphicsLinearLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSLINEARLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsLinearLayout_Type);

    SbkQGraphicsLinearLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUT_IDX];
    // Fill type discovery information
    SbkQGraphicsLinearLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsLinearLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsLinearLayout_Type));
    PyModule_AddObject(module, "QGraphicsLinearLayout",
        ((PyObject*)&SbkQGraphicsLinearLayout_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsLinearLayout >("QGraphicsLinearLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsLinearLayout >(typeid(QGraphicsLinearLayout).name());
}


} // extern "C"

