/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfontmetrics_wrapper.h"

// Extra includes
#include <qchar.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qpaintdevice.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQFontMetrics_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFontMetrics* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QFontMetrics", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<QFont & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(pyargs[0]);
        if (!SbkQFont_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        if (numArgs == 1) {
            // QFontMetrics(QFont)
            cptr = new QFontMetrics(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QPaintDevice* cpp_arg1 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[1]);
            // QFontMetrics(QFont,QPaintDevice*)
            cptr = new QFontMetrics(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFontMetrics_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QFontMetrics & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFontMetrics > cpp_arg0_auto_ptr;
        QFontMetrics* cpp_arg0 = Shiboken::Converter<QFontMetrics* >::toCpp(pyargs[0]);
        if (!SbkQFontMetrics_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFontMetrics >(cpp_arg0);
        // QFontMetrics(QFontMetrics)
        cptr = new QFontMetrics(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetrics_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFontMetrics >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFontMetrics_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFontMetrics_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", "PySide.QtGui.QFont, PySide.QtGui.QPaintDevice", "PySide.QtGui.QFontMetrics", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetrics", overloads);
        return -1;
}

static PyObject* SbkQFontMetricsFunc_ascent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ascent()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::ascent();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_averageCharWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // averageCharWidth()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::averageCharWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_boundingRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQFontMetricsFunc_boundingRect_TypeError;

    if (!PyArg_UnpackTuple(args, "boundingRect", 1, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QString & >::isConvertible(pyargs[5])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return 0;
        std::auto_ptr<QString > cpp_arg5_auto_ptr;
        QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
        if (!SbkQString_Check(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
        if (numArgs == 6) {
            // boundingRect(int,int,int,int,int,QString,int,int*)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            // Begin code injection
            
            int* array = NULL;
            bool errorOccurred = false;
            
            if (numArgs == 8) {
                array = Shiboken::sequenceToIntArray(pyargs[8-1], true);
                if (PyErr_Occurred()) {
                    if (array)
                        delete []array;
                    errorOccurred = true;
                }
            }
            
            if (!errorOccurred) {
                QRect retval = cppSelf->boundingRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, (*cpp_arg5), 0, array);
            
                if (array)
                    delete []array;
            
                py_result = Shiboken::Converter<QRect >::toPython(retval);
            }
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[6])) {
            int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
            if (numArgs == 7) {
                // boundingRect(int,int,int,int,int,QString,int,int*)const
                QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 8) {
                    array = Shiboken::sequenceToIntArray(pyargs[8-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QRect retval = cppSelf->boundingRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, (*cpp_arg5), cpp_arg6, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QRect >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyObject_Check(pyargs[7])) {
                // boundingRect(int,int,int,int,int,QString,int,int*)const
                QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 8) {
                    array = Shiboken::sequenceToIntArray(pyargs[8-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QRect retval = cppSelf->boundingRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, (*cpp_arg5), cpp_arg6, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QRect >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQFontMetricsFunc_boundingRect_TypeError;
        } else goto SbkQFontMetricsFunc_boundingRect_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // boundingRect(QRect,int,QString,int,int*)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            // Begin code injection
            
            int* array = NULL;
            bool errorOccurred = false;
            
            if (numArgs == 5) {
                array = Shiboken::sequenceToIntArray(pyargs[5-1], true);
                if (PyErr_Occurred()) {
                    if (array)
                        delete []array;
                    errorOccurred = true;
                }
            }
            
            if (!errorOccurred) {
                QRect retval = cppSelf->boundingRect((*cpp_arg0), cpp_arg1, (*cpp_arg2), 0, array);
            
                if (array)
                    delete []array;
            
                py_result = Shiboken::Converter<QRect >::toPython(retval);
            }
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // boundingRect(QRect,int,QString,int,int*)const
                QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 5) {
                    array = Shiboken::sequenceToIntArray(pyargs[5-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QRect retval = cppSelf->boundingRect((*cpp_arg0), cpp_arg1, (*cpp_arg2), cpp_arg3, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QRect >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyObject_Check(pyargs[4])) {
                // boundingRect(QRect,int,QString,int,int*)const
                QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 5) {
                    array = Shiboken::sequenceToIntArray(pyargs[5-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QRect retval = cppSelf->boundingRect((*cpp_arg0), cpp_arg1, (*cpp_arg2), cpp_arg3, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QRect >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQFontMetricsFunc_boundingRect_TypeError;
        } else goto SbkQFontMetricsFunc_boundingRect_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QChar >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(pyargs[0]);
        if (!SbkQChar_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // boundingRect(QChar)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QFontMetrics::boundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // boundingRect(QString)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QFontMetrics::boundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFunc_boundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_boundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", "PySide.QtCore.QRect, int, PySide.QtCore.QString, int = 0, int = 0", "PySide.QtCore.QString", "int, int, int, int, int, PySide.QtCore.QString, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetrics.boundingRect", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_charWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "charWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // charWidth(QString,int)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFontMetrics::charWidth(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFunc_charWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_charWidth_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetrics.charWidth", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_descent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // descent()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::descent();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_elidedText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "elidedText", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::TextElideMode >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        Qt::TextElideMode cpp_arg1 = Shiboken::Converter<Qt::TextElideMode >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // elidedText(QString,Qt::TextElideMode,int,int)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QFontMetrics::elidedText(*cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // elidedText(QString,Qt::TextElideMode,int,int)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QFontMetrics::elidedText(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFontMetricsFunc_elidedText_TypeError;
    } else goto SbkQFontMetricsFunc_elidedText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_elidedText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.TextElideMode, int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetrics.elidedText", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_inFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // inFont(QChar)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFontMetrics::inFont(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFunc_inFont_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_inFont_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetrics.inFont", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_leading(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leading()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::leading();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_leftBearing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // leftBearing(QChar)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFontMetrics::leftBearing(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFunc_leftBearing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_leftBearing_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetrics.leftBearing", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_lineSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineSpacing()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::lineSpacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_lineWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineWidth()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::lineWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_maxWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxWidth()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::maxWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_minLeftBearing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minLeftBearing()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::minLeftBearing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_minRightBearing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minRightBearing()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::minRightBearing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_overlinePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overlinePos()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::overlinePos();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_rightBearing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // rightBearing(QChar)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFontMetrics::rightBearing(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFunc_rightBearing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_rightBearing_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetrics.rightBearing", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_size(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "size", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // size(int,QString,int,int*)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            // Begin code injection
            
            int* array = NULL;
            bool errorOccurred = false;
            
            if (numArgs == 4) {
                array = Shiboken::sequenceToIntArray(pyargs[4-1], true);
                if (PyErr_Occurred()) {
                    if (array)
                        delete []array;
                    errorOccurred = true;
                }
            }
            
            if (!errorOccurred) {
                QSize retval = cppSelf->size(cpp_arg0, (*cpp_arg1), 0, array);
            
                if (array)
                    delete []array;
            
                py_result = Shiboken::Converter<QSize >::toPython(retval);
            }
            
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // size(int,QString,int,int*)const
                QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 4) {
                    array = Shiboken::sequenceToIntArray(pyargs[4-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QSize retval = cppSelf->size(cpp_arg0, (*cpp_arg1), cpp_arg2, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QSize >::toPython(retval);
                }
                
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyObject_Check(pyargs[3])) {
                // size(int,QString,int,int*)const
                QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 4) {
                    array = Shiboken::sequenceToIntArray(pyargs[4-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QSize retval = cppSelf->size(cpp_arg0, (*cpp_arg1), cpp_arg2, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QSize >::toPython(retval);
                }
                
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQFontMetricsFunc_size_TypeError;
        } else goto SbkQFontMetricsFunc_size_TypeError;
    } else goto SbkQFontMetricsFunc_size_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_size_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetrics.size", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_strikeOutPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // strikeOutPos()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::strikeOutPos();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_tightBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // tightBoundingRect(QString)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QFontMetrics::tightBoundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFunc_tightBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_tightBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetrics.tightBoundingRect", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_underlinePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underlinePos()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::underlinePos();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFunc_width(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "width", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QChar >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(pyargs[0]);
        if (!SbkQChar_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // width(QChar)const
        QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFontMetrics::width(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // width(QString,int)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QFontMetrics::width(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // width(QString,int)const
            QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QFontMetrics::width(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFontMetricsFunc_width_TypeError;
    } else goto SbkQFontMetricsFunc_width_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFunc_width_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", "PySide.QtCore.QString, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetrics.width", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFunc_xHeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // xHeight()const
    QFontMetrics* cppSelf = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontMetrics::xHeight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFontMetrics_methods[] = {
    {"ascent", (PyCFunction)SbkQFontMetricsFunc_ascent, METH_NOARGS},
    {"averageCharWidth", (PyCFunction)SbkQFontMetricsFunc_averageCharWidth, METH_NOARGS},
    {"boundingRect", (PyCFunction)SbkQFontMetricsFunc_boundingRect, METH_VARARGS},
    {"charWidth", (PyCFunction)SbkQFontMetricsFunc_charWidth, METH_VARARGS},
    {"descent", (PyCFunction)SbkQFontMetricsFunc_descent, METH_NOARGS},
    {"elidedText", (PyCFunction)SbkQFontMetricsFunc_elidedText, METH_VARARGS},
    {"height", (PyCFunction)SbkQFontMetricsFunc_height, METH_NOARGS},
    {"inFont", (PyCFunction)SbkQFontMetricsFunc_inFont, METH_O},
    {"leading", (PyCFunction)SbkQFontMetricsFunc_leading, METH_NOARGS},
    {"leftBearing", (PyCFunction)SbkQFontMetricsFunc_leftBearing, METH_O},
    {"lineSpacing", (PyCFunction)SbkQFontMetricsFunc_lineSpacing, METH_NOARGS},
    {"lineWidth", (PyCFunction)SbkQFontMetricsFunc_lineWidth, METH_NOARGS},
    {"maxWidth", (PyCFunction)SbkQFontMetricsFunc_maxWidth, METH_NOARGS},
    {"minLeftBearing", (PyCFunction)SbkQFontMetricsFunc_minLeftBearing, METH_NOARGS},
    {"minRightBearing", (PyCFunction)SbkQFontMetricsFunc_minRightBearing, METH_NOARGS},
    {"overlinePos", (PyCFunction)SbkQFontMetricsFunc_overlinePos, METH_NOARGS},
    {"rightBearing", (PyCFunction)SbkQFontMetricsFunc_rightBearing, METH_O},
    {"size", (PyCFunction)SbkQFontMetricsFunc_size, METH_VARARGS},
    {"strikeOutPos", (PyCFunction)SbkQFontMetricsFunc_strikeOutPos, METH_NOARGS},
    {"tightBoundingRect", (PyCFunction)SbkQFontMetricsFunc_tightBoundingRect, METH_O},
    {"underlinePos", (PyCFunction)SbkQFontMetricsFunc_underlinePos, METH_NOARGS},
    {"width", (PyCFunction)SbkQFontMetricsFunc_width, METH_VARARGS},
    {"xHeight", (PyCFunction)SbkQFontMetricsFunc_xHeight, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQFontMetrics_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QFontMetrics& cpp_self = *Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QFontMetrics & >::isConvertible(other)) {
                // operator!=(const QFontMetrics & other)
                QFontMetrics* cpp_other = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetrics  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFontMetrics & >::isConvertible(other)) {
                // operator!=(const QFontMetrics & other) const
                QFontMetrics* cpp_other = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetrics  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFontMetrics >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFontMetrics > cpp_other_auto_ptr;
                QFontMetrics* cpp_other = Shiboken::Converter<QFontMetrics* >::toCpp(other);
                if (!SbkQFontMetrics_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFontMetrics >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQFontMetrics_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QFontMetrics & >::isConvertible(other)) {
                // operator==(const QFontMetrics & other)
                QFontMetrics* cpp_other = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetrics  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFontMetrics & >::isConvertible(other)) {
                // operator==(const QFontMetrics & other) const
                QFontMetrics* cpp_other = Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetrics  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFontMetrics >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFontMetrics > cpp_other_auto_ptr;
                QFontMetrics* cpp_other = Shiboken::Converter<QFontMetrics* >::toCpp(other);
                if (!SbkQFontMetrics_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFontMetrics >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQFontMetrics_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQFontMetrics_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFontMetrics_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFontMetrics",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQFontMetrics_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFontMetrics_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFontMetrics_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFontMetrics >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QFontMetrics(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFONTMETRICS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFontMetrics_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQFontMetrics_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFontMetrics_Type));
    PyModule_AddObject(module, "QFontMetrics",
        ((PyObject*)&SbkQFontMetrics_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QFontMetrics >("QFontMetrics");
    Shiboken::TypeResolver::createValueTypeResolver<QFontMetrics >(typeid(QFontMetrics).name());
}


} // extern "C"

