/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfontinfo_wrapper.h"

// Extra includes
#include <qfont.h>
#include <qfontinfo.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQFontInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFontInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QFontInfo", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QFont & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(pyargs[0]);
        if (!SbkQFont_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // QFontInfo(QFont)
        cptr = new QFontInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QFontInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFontInfo > cpp_arg0_auto_ptr;
        QFontInfo* cpp_arg0 = Shiboken::Converter<QFontInfo* >::toCpp(pyargs[0]);
        if (!SbkQFontInfo_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFontInfo >(cpp_arg0);
        // QFontInfo(QFontInfo)
        cptr = new QFontInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontInfo_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFontInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFontInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFontInfo_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", "PySide.QtGui.QFontInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontInfo", overloads);
        return -1;
}

static PyObject* SbkQFontInfoFunc_bold(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bold()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::bold();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_exactMatch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exactMatch()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::exactMatch();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_family(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // family()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFontInfo::family();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_fixedPitch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fixedPitch()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::fixedPitch();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_italic(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // italic()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::italic();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_overline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overline()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::overline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_pixelSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixelSize()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontInfo::pixelSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_pointSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pointSize()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontInfo::pointSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_pointSizeF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pointSizeF()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontInfo::pointSizeF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_rawMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rawMode()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::rawMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_strikeOut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // strikeOut()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::strikeOut();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    QFont::Style cpp_result = cppSelf->QFontInfo::style();
    py_result = Shiboken::Converter<QFont::Style >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_styleHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // styleHint()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    QFont::StyleHint cpp_result = cppSelf->QFontInfo::styleHint();
    py_result = Shiboken::Converter<QFont::StyleHint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_underline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underline()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFontInfo::underline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontInfoFunc_weight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // weight()const
    QFontInfo* cppSelf = Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFontInfo::weight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFontInfo_methods[] = {
    {"bold", (PyCFunction)SbkQFontInfoFunc_bold, METH_NOARGS},
    {"exactMatch", (PyCFunction)SbkQFontInfoFunc_exactMatch, METH_NOARGS},
    {"family", (PyCFunction)SbkQFontInfoFunc_family, METH_NOARGS},
    {"fixedPitch", (PyCFunction)SbkQFontInfoFunc_fixedPitch, METH_NOARGS},
    {"italic", (PyCFunction)SbkQFontInfoFunc_italic, METH_NOARGS},
    {"overline", (PyCFunction)SbkQFontInfoFunc_overline, METH_NOARGS},
    {"pixelSize", (PyCFunction)SbkQFontInfoFunc_pixelSize, METH_NOARGS},
    {"pointSize", (PyCFunction)SbkQFontInfoFunc_pointSize, METH_NOARGS},
    {"pointSizeF", (PyCFunction)SbkQFontInfoFunc_pointSizeF, METH_NOARGS},
    {"rawMode", (PyCFunction)SbkQFontInfoFunc_rawMode, METH_NOARGS},
    {"strikeOut", (PyCFunction)SbkQFontInfoFunc_strikeOut, METH_NOARGS},
    {"style", (PyCFunction)SbkQFontInfoFunc_style, METH_NOARGS},
    {"styleHint", (PyCFunction)SbkQFontInfoFunc_styleHint, METH_NOARGS},
    {"underline", (PyCFunction)SbkQFontInfoFunc_underline, METH_NOARGS},
    {"weight", (PyCFunction)SbkQFontInfoFunc_weight, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFontInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFontInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFontInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFontInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFontInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QFontInfo(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFONTINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFontInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQFontInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFontInfo_Type));
    PyModule_AddObject(module, "QFontInfo",
        ((PyObject*)&SbkQFontInfo_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QFontInfo >("QFontInfo");
    Shiboken::TypeResolver::createValueTypeResolver<QFontInfo >(typeid(QFontInfo).name());
}


} // extern "C"

