/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qxmlstreamattributes_wrapper.h"

// Extra includes
#include <QVector>
#include <qstring.h>
#include <qxmlstream.h>

using namespace Shiboken;

static int
SbkQXmlStreamAttributes_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlStreamAttributes* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlStreamAttributes", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlStreamAttributes()
        cptr = new QXmlStreamAttributes();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlStreamAttributes & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlStreamAttributes* cpp_arg0 = Shiboken::Converter<QXmlStreamAttributes* >::toCpp(pyargs[0]);
        // QXmlStreamAttributes(QXmlStreamAttributes)
        cptr = new QXmlStreamAttributes(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributes_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlStreamAttributes >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlStreamAttributes_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlStreamAttributes_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QXmlStreamAttributes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes", overloads);
        return -1;
}

static PyObject* SbkQXmlStreamAttributesFunc_append(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "append", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(pyargs[0]);
        // append(QXmlStreamAttribute)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamAttributes::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // append(QString,QString)
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamAttributes::append(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // append(QString,QString,QString)
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamAttributes::append(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamAttributesFunc_append_TypeError;
    } else goto SbkQXmlStreamAttributesFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.append", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_capacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capacity()const
    QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QXmlStreamAttributes::capacity();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamAttributesFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
    cppSelf->QXmlStreamAttributes::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlStreamAttributesFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QXmlStreamAttributes::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(arg);
        // count(QXmlStreamAttribute)const
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QXmlStreamAttributes::count(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_count_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.count", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_empty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // empty()const
    QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamAttributes::empty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamAttributesFunc_endsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(arg);
        // endsWith(QXmlStreamAttribute)const
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlStreamAttributes::endsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_endsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_endsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.endsWith", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_hasAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hasAttribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // hasAttribute(QString)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlStreamAttributes::hasAttribute(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // hasAttribute(QString,QString)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlStreamAttributes::hasAttribute(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamAttributesFunc_hasAttribute_TypeError;
    } else goto SbkQXmlStreamAttributesFunc_hasAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_hasAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.hasAttribute", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_indexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // indexOf(QXmlStreamAttribute,int)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QXmlStreamAttributes::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QXmlStreamAttribute,int)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QXmlStreamAttributes::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamAttributesFunc_indexOf_TypeError;
    } else goto SbkQXmlStreamAttributesFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamAttribute, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.indexOf", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamAttributes::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamAttributesFunc_lastIndexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // lastIndexOf(QXmlStreamAttribute,int)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QXmlStreamAttributes::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QXmlStreamAttribute,int)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QXmlStreamAttributes::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamAttributesFunc_lastIndexOf_TypeError;
    } else goto SbkQXmlStreamAttributesFunc_lastIndexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_lastIndexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamAttribute, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.lastIndexOf", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_prepend(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(arg);
        // prepend(QXmlStreamAttribute)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamAttributes::prepend(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_prepend_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_prepend_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.prepend", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_remove(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "remove", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // remove(int)
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamAttributes::remove(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // remove(int,int)
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamAttributes::remove(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamAttributesFunc_remove_TypeError;
    } else goto SbkQXmlStreamAttributesFunc_remove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_remove_TypeError:
        const char* overloads[] = {"int", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.remove", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QXmlStreamAttribute* cpp_arg1 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(pyargs[1]);
        // replace(int,QXmlStreamAttribute)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamAttributes::replace(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_replace_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.replace", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_reserve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // reserve(int)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamAttributes::reserve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_reserve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_reserve_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.reserve", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_resize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resize(int)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamAttributes::resize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_resize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.resize", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_setSharable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSharable(bool)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamAttributes::setSharable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_setSharable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamAttributesFunc_setSharable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.setSharable", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QXmlStreamAttributes::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamAttributesFunc_squeeze(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // squeeze()
    QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
    cppSelf->QXmlStreamAttributes::squeeze();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlStreamAttributesFunc_startsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(arg);
        // startsWith(QXmlStreamAttribute)const
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlStreamAttributes::startsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc_startsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_startsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.startsWith", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // value(QString)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            QStringRef cpp_result = cppSelf->QXmlStreamAttributes::value(*cpp_arg0);
            py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // value(QString,QString)const
            QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
            QStringRef cpp_result = cppSelf->QXmlStreamAttributes::value(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamAttributesFunc_value_TypeError;
    } else goto SbkQXmlStreamAttributesFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc_value_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamAttributes.value", overloads);
        return 0;
}

static PyMethodDef SbkQXmlStreamAttributes_methods[] = {
    {"append", (PyCFunction)SbkQXmlStreamAttributesFunc_append, METH_VARARGS},
    {"capacity", (PyCFunction)SbkQXmlStreamAttributesFunc_capacity, METH_NOARGS},
    {"clear", (PyCFunction)SbkQXmlStreamAttributesFunc_clear, METH_NOARGS},
    {"count", (PyCFunction)SbkQXmlStreamAttributesFunc_count, METH_NOARGS|METH_O},
    {"empty", (PyCFunction)SbkQXmlStreamAttributesFunc_empty, METH_NOARGS},
    {"endsWith", (PyCFunction)SbkQXmlStreamAttributesFunc_endsWith, METH_O},
    {"hasAttribute", (PyCFunction)SbkQXmlStreamAttributesFunc_hasAttribute, METH_VARARGS},
    {"indexOf", (PyCFunction)SbkQXmlStreamAttributesFunc_indexOf, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQXmlStreamAttributesFunc_isEmpty, METH_NOARGS},
    {"lastIndexOf", (PyCFunction)SbkQXmlStreamAttributesFunc_lastIndexOf, METH_VARARGS},
    {"prepend", (PyCFunction)SbkQXmlStreamAttributesFunc_prepend, METH_O},
    {"remove", (PyCFunction)SbkQXmlStreamAttributesFunc_remove, METH_VARARGS},
    {"replace", (PyCFunction)SbkQXmlStreamAttributesFunc_replace, METH_VARARGS},
    {"reserve", (PyCFunction)SbkQXmlStreamAttributesFunc_reserve, METH_O},
    {"resize", (PyCFunction)SbkQXmlStreamAttributesFunc_resize, METH_O},
    {"setSharable", (PyCFunction)SbkQXmlStreamAttributesFunc_setSharable, METH_O},
    {"size", (PyCFunction)SbkQXmlStreamAttributesFunc_size, METH_NOARGS},
    {"squeeze", (PyCFunction)SbkQXmlStreamAttributesFunc_squeeze, METH_NOARGS},
    {"startsWith", (PyCFunction)SbkQXmlStreamAttributesFunc_startsWith, METH_O},
    {"value", (PyCFunction)SbkQXmlStreamAttributesFunc_value, METH_VARARGS},
    {0} // Sentinel
};

static PyObject* SbkQXmlStreamAttributesFunc___add__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQXmlStreamAttributes_Check(arg) && !SbkQXmlStreamAttributes_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QVector<QXmlStreamAttribute >  >::isConvertible(arg)) {
        QVector<QXmlStreamAttribute >  cpp_arg0 = Shiboken::Converter<QVector<QXmlStreamAttribute >  >::toCpp(arg);
        // operator+(QVector<QXmlStreamAttribute>)const
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        QVector<QXmlStreamAttribute > cpp_result = (*cppSelf) + cpp_arg0;
        py_result = Shiboken::Converter<QVector<QXmlStreamAttribute > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc___add___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc___add___TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.__add__", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamAttributesFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQXmlStreamAttributes_Check(arg) && !SbkQXmlStreamAttributes_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(arg);
        // operator<<(QXmlStreamAttribute)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        QVector<QXmlStreamAttribute > & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QVector<QXmlStreamAttribute >  >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QVector<QXmlStreamAttribute >  >::isConvertible(arg)) {
        QVector<QXmlStreamAttribute >  cpp_arg0 = Shiboken::Converter<QVector<QXmlStreamAttribute >  >::toCpp(arg);
        // operator<<(QVector<QXmlStreamAttribute>)
        QXmlStreamAttributes* cppSelf = Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);
        QVector<QXmlStreamAttribute > & cpp_result = (*cppSelf) << cpp_arg0;
        py_result = Shiboken::Converter<QVector<QXmlStreamAttribute >  >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamAttributesFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlStreamAttributesFunc___lshift___TypeError:
        const char* overloads[] = {"list", "PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamAttributes.__lshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQXmlStreamAttributes_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQXmlStreamAttributesFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQXmlStreamAttributesFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQXmlStreamAttributes_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QXmlStreamAttributes& cpp_self = *Shiboken::Converter<QXmlStreamAttributes* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QVector<QXmlStreamAttribute >  >::isConvertible(other)) {
                // operator!=(const QVector<QXmlStreamAttribute > & v) const
                const QVector<QXmlStreamAttribute > & cpp_other = Shiboken::Converter<QVector<QXmlStreamAttribute >  >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQXmlStreamAttributes_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QVector<QXmlStreamAttribute >  >::isConvertible(other)) {
                // operator==(const QVector<QXmlStreamAttribute > & v) const
                const QVector<QXmlStreamAttribute > & cpp_other = Shiboken::Converter<QVector<QXmlStreamAttribute >  >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQXmlStreamAttributes_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQXmlStreamAttributes_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlStreamAttributes_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QXmlStreamAttributes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQXmlStreamAttributes_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQXmlStreamAttributes_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlStreamAttributes_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlStreamAttributes_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlStreamAttributes >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlStreamAttributes(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlStreamAttributes_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlStreamAttributes_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlStreamAttributes_Type));
    PyModule_AddObject(module, "QXmlStreamAttributes",
        ((PyObject*)&SbkQXmlStreamAttributes_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlStreamAttributes >("QXmlStreamAttributes");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlStreamAttributes >(typeid(QXmlStreamAttributes).name());
}


} // extern "C"

