/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qstringmatcher_wrapper.h"

// Extra includes
#include <qchar.h>
#include <qstring.h>
#include <qstringmatcher.h>

using namespace Shiboken;

static int
SbkQStringMatcher_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStringMatcher* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QStringMatcher", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QStringMatcher()
        cptr = new QStringMatcher();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QChar * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(pyargs[0]);
        if (!SbkQChar_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QStringMatcher(const QChar*,int,Qt::CaseSensitivity)
            cptr = new QStringMatcher(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[2])) {
            Qt::CaseSensitivity cpp_arg2 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[2]);
            // QStringMatcher(const QChar*,int,Qt::CaseSensitivity)
            cptr = new QStringMatcher(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringMatcher_Init_TypeError;
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QStringMatcher(QString,Qt::CaseSensitivity)
            cptr = new QStringMatcher(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            // QStringMatcher(QString,Qt::CaseSensitivity)
            cptr = new QStringMatcher(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringMatcher_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QStringMatcher & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStringMatcher > cpp_arg0_auto_ptr;
        QStringMatcher* cpp_arg0 = Shiboken::Converter<QStringMatcher* >::toCpp(pyargs[0]);
        if (!SbkQStringMatcher_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringMatcher >(cpp_arg0);
        // QStringMatcher(QStringMatcher)
        cptr = new QStringMatcher(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringMatcher_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStringMatcher >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStringMatcher_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStringMatcher_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QChar, int, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QStringMatcher", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringMatcher", overloads);
        return -1;
}

static PyObject* SbkQStringMatcherFunc_caseSensitivity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // caseSensitivity()const
    QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
    Qt::CaseSensitivity cpp_result = cppSelf->QStringMatcher::caseSensitivity();
    py_result = Shiboken::Converter<Qt::CaseSensitivity >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringMatcherFunc_indexIn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "indexIn", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QChar * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(pyargs[0]);
        if (!SbkQChar_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // indexIn(const QChar*,int,int)const
            QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringMatcher::indexIn(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // indexIn(const QChar*,int,int)const
            QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringMatcher::indexIn(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringMatcherFunc_indexIn_TypeError;
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // indexIn(QString,int)const
            QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringMatcher::indexIn(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexIn(QString,int)const
            QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringMatcher::indexIn(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringMatcherFunc_indexIn_TypeError;
    } else goto SbkQStringMatcherFunc_indexIn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringMatcherFunc_indexIn_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar, int, int = 0", "PySide.QtCore.QString, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringMatcher.indexIn", overloads);
        return 0;
}

static PyObject* SbkQStringMatcherFunc_pattern(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pattern()const
    QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStringMatcher::pattern();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringMatcherFunc_setCaseSensitivity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(arg)) {
        Qt::CaseSensitivity cpp_arg0 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(arg);
        // setCaseSensitivity(Qt::CaseSensitivity)
        QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
        cppSelf->QStringMatcher::setCaseSensitivity(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringMatcherFunc_setCaseSensitivity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringMatcherFunc_setCaseSensitivity_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringMatcher.setCaseSensitivity", overloads);
        return 0;
}

static PyObject* SbkQStringMatcherFunc_setPattern(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPattern(QString)
        QStringMatcher* cppSelf = Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)self);
        cppSelf->QStringMatcher::setPattern(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringMatcherFunc_setPattern_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringMatcherFunc_setPattern_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringMatcher.setPattern", overloads);
        return 0;
}

static PyMethodDef SbkQStringMatcher_methods[] = {
    {"caseSensitivity", (PyCFunction)SbkQStringMatcherFunc_caseSensitivity, METH_NOARGS},
    {"indexIn", (PyCFunction)SbkQStringMatcherFunc_indexIn, METH_VARARGS},
    {"pattern", (PyCFunction)SbkQStringMatcherFunc_pattern, METH_NOARGS},
    {"setCaseSensitivity", (PyCFunction)SbkQStringMatcherFunc_setCaseSensitivity, METH_O},
    {"setPattern", (PyCFunction)SbkQStringMatcherFunc_setPattern, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStringMatcher_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QStringMatcher",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStringMatcher_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStringMatcher_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStringMatcher >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStringMatcher(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTRINGMATCHER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStringMatcher_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQStringMatcher_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStringMatcher_Type));
    PyModule_AddObject(module, "QStringMatcher",
        ((PyObject*)&SbkQStringMatcher_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QStringMatcher >("QStringMatcher");
    Shiboken::TypeResolver::createValueTypeResolver<QStringMatcher >(typeid(QStringMatcher).name());
}


} // extern "C"

