/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qchildevent_wrapper.h"

// Extra includes
#include <qobject.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QChildEventWrapper::QChildEventWrapper(QEvent::Type type, QObject * child) : QChildEvent(type, child) {
    // ... middle
}

QChildEventWrapper::~QChildEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQChildEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QChildEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QChildEvent", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // QChildEvent(QEvent::Type,QObject*)
        cptr = new QChildEventWrapper(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQChildEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QChildEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQChildEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQChildEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QChildEvent", overloads);
        return -1;
}

static PyObject* SbkQChildEventFunc_added(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // added()const
    QChildEvent* cppSelf = Shiboken::Converter<QChildEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChildEvent::added();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQChildEventFunc_child(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // child()const
    QChildEvent* cppSelf = Shiboken::Converter<QChildEvent* >::toCpp((PyObject*)self);
    QObject * cpp_result = cppSelf->QChildEvent::child();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);

    // Ownership transferences.
    SbkBaseWrapper_setOwnership(py_result, true);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQChildEventFunc_polished(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // polished()const
    QChildEvent* cppSelf = Shiboken::Converter<QChildEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChildEvent::polished();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQChildEventFunc_removed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // removed()const
    QChildEvent* cppSelf = Shiboken::Converter<QChildEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChildEvent::removed();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQChildEvent_methods[] = {
    {"added", (PyCFunction)SbkQChildEventFunc_added, METH_NOARGS},
    {"child", (PyCFunction)SbkQChildEventFunc_child, METH_NOARGS},
    {"polished", (PyCFunction)SbkQChildEventFunc_polished, METH_NOARGS},
    {"removed", (PyCFunction)SbkQChildEventFunc_removed, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQChildEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QChildEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQChildEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQChildEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QChildEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQChildEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQChildEvent_Type);
     if ( reinterpret_cast<QChildEvent*>(cptr)->type() == QEvent::ChildAdded ||  reinterpret_cast<QChildEvent*>(cptr)->type() == QEvent::ChildPolished ||  reinterpret_cast<QChildEvent*>(cptr)->type() == QEvent::ChildRemoved)
        return &SbkQChildEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QChildEvent(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QCHILDEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQChildEvent_Type);

    SbkQChildEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQChildEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQChildEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQChildEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQChildEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQChildEvent_Type));
    PyModule_AddObject(module, "QChildEvent",
        ((PyObject*)&SbkQChildEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QChildEvent >("QChildEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QChildEvent >(typeid(QChildEvent).name());
}


} // extern "C"

