/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_phonon_python.h"

#include "phonon_audiooutput_wrapper.h"

// Extra includes
#include <QList>
#include <objectdescription.h>
#include <path.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

AudioOutputWrapper::AudioOutputWrapper(Phonon::Category category, QObject * parent) : Phonon::AudioOutput(category, parent), m_metaObject(0) {
    // ... middle
}

AudioOutputWrapper::AudioOutputWrapper(QObject * parent) : Phonon::AudioOutput(parent), m_metaObject(0) {
    // ... middle
}

void AudioOutputWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AudioOutputWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AudioOutputWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AudioOutputWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool AudioOutputWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "AudioOutput.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool AudioOutputWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "AudioOutput.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void AudioOutputWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* AudioOutputWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &Phonon::AudioOutput::staticMetaObject);
}
    return m_metaObject;
}

int AudioOutputWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = Phonon::AudioOutput::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

AudioOutputWrapper::~AudioOutputWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkPhonon_AudioOutput_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    AudioOutputWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "AudioOutput", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // AudioOutput(QObject*)
        cptr = new AudioOutputWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // AudioOutput(QObject*)
        cptr = new AudioOutputWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<Phonon::Category >::isConvertible(pyargs[0])) {
        Phonon::Category cpp_arg0 = Shiboken::Converter<Phonon::Category >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // AudioOutput(Phonon::Category,QObject*)
            cptr = new AudioOutputWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // AudioOutput(Phonon::Category,QObject*)
            cptr = new AudioOutputWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkPhonon_AudioOutput_Init_TypeError;
    } else goto SbkPhonon_AudioOutput_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::AudioOutput >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_AudioOutput_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_AudioOutput_Init_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon.Category, PySide.QtCore.QObject = None", "PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.AudioOutput", overloads);
        return -1;
}

static PyObject* SbkPhonon_AudioOutputFunc_category(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // category()const
    Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
    Phonon::Category cpp_result = cppSelf->Phonon::AudioOutput::category();
    py_result = Shiboken::Converter<Phonon::Category >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioOutputFunc_isMuted(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMuted()const
    Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::AudioOutput::isMuted();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioOutputFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->Phonon::AudioOutput::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioOutputFunc_outputDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // outputDevice()const
    Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
    Phonon::AudioOutputDevice cpp_result = cppSelf->Phonon::AudioOutput::outputDevice();
    py_result = Shiboken::Converter<Phonon::AudioOutputDevice >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioOutputFunc_setMuted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setMuted(bool)
        Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AudioOutput::setMuted(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioOutputFunc_setMuted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AudioOutputFunc_setMuted_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AudioOutput.setMuted", overloads);
        return 0;
}

static PyObject* SbkPhonon_AudioOutputFunc_setName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setName(QString)
        Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AudioOutput::setName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioOutputFunc_setName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AudioOutputFunc_setName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AudioOutput.setName", overloads);
        return 0;
}

static PyObject* SbkPhonon_AudioOutputFunc_setOutputDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::AudioOutputDevice & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        Phonon::AudioOutputDevice* cpp_arg0 = Shiboken::Converter<Phonon::AudioOutputDevice* >::toCpp(arg);
        // setOutputDevice(Phonon::AudioOutputDevice)
        Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->Phonon::AudioOutput::setOutputDevice(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioOutputFunc_setOutputDevice_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_AudioOutputFunc_setOutputDevice_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::AudioOutputDevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AudioOutput.setOutputDevice", overloads);
        return 0;
}

static PyObject* SbkPhonon_AudioOutputFunc_setVolume(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setVolume(qreal)
        Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AudioOutput::setVolume(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioOutputFunc_setVolume_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AudioOutputFunc_setVolume_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AudioOutput.setVolume", overloads);
        return 0;
}

static PyObject* SbkPhonon_AudioOutputFunc_setVolumeDecibel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setVolumeDecibel(qreal)
        Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AudioOutput::setVolumeDecibel(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioOutputFunc_setVolumeDecibel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AudioOutputFunc_setVolumeDecibel_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AudioOutput.setVolumeDecibel", overloads);
        return 0;
}

static PyObject* SbkPhonon_AudioOutputFunc_volume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // volume()const
    Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->Phonon::AudioOutput::volume();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioOutputFunc_volumeDecibel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // volumeDecibel()const
    Phonon::AudioOutput* cppSelf = Shiboken::Converter<Phonon::AudioOutput* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->Phonon::AudioOutput::volumeDecibel();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_AudioOutput_methods[] = {
    {"category", (PyCFunction)SbkPhonon_AudioOutputFunc_category, METH_NOARGS},
    {"isMuted", (PyCFunction)SbkPhonon_AudioOutputFunc_isMuted, METH_NOARGS},
    {"name", (PyCFunction)SbkPhonon_AudioOutputFunc_name, METH_NOARGS},
    {"outputDevice", (PyCFunction)SbkPhonon_AudioOutputFunc_outputDevice, METH_NOARGS},
    {"setMuted", (PyCFunction)SbkPhonon_AudioOutputFunc_setMuted, METH_O},
    {"setName", (PyCFunction)SbkPhonon_AudioOutputFunc_setName, METH_O},
    {"setOutputDevice", (PyCFunction)SbkPhonon_AudioOutputFunc_setOutputDevice, METH_O},
    {"setVolume", (PyCFunction)SbkPhonon_AudioOutputFunc_setVolume, METH_O},
    {"setVolumeDecibel", (PyCFunction)SbkPhonon_AudioOutputFunc_setVolumeDecibel, METH_O},
    {"volume", (PyCFunction)SbkPhonon_AudioOutputFunc_volume, METH_NOARGS},
    {"volumeDecibel", (PyCFunction)SbkPhonon_AudioOutputFunc_volumeDecibel, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkPhonon_AudioOutputSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    Phonon::AudioOutput* me = reinterpret_cast<Phonon::AudioOutput*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_ABSTRACTAUDIOOUTPUT_IDX]))
        return static_cast<Phonon::AbstractAudioOutput*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX]))
        return static_cast<Phonon::MediaNode*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_AudioOutput_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.AudioOutput",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_AudioOutput_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_AudioOutput_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkPhonon_AudioOutputSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::AudioOutput >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_Phonon_AudioOutput(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_AudioOutput_Type);

    SbkPhonon_AudioOutput_Type.super.ht_type.tp_base = SbkPySide_phononTypes[SBK_PHONON_ABSTRACTAUDIOOUTPUT_IDX];
    SbkPhonon_AudioOutput_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_ABSTRACTAUDIOOUTPUT_IDX])->mi_init;

    // Fill type discovery information
    SbkPhonon_AudioOutput_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_AudioOutput_Type) < 0)
        return;

    PyDict_SetItemString(module,"AudioOutput", (PyObject*)&SbkPhonon_AudioOutput_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::AudioOutput >("Phonon::AudioOutput*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::AudioOutput >(typeid(Phonon::AudioOutput).name());
}


} // extern "C"

