/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_audiocapturedevice_wrapper.h"

// Extra includes
#include <QList>
#include <pysideconversions.h>
#include <qbytearray.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkPhonon_AudioCaptureDevice_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    Phonon::AudioCaptureDevice* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "AudioCaptureDevice", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // ObjectDescription()
        cptr = new Phonon::AudioCaptureDevice();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QHash<QByteArray, QVariant >  >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QHash<QByteArray, QVariant >  cpp_arg1 = Shiboken::Converter<QHash<QByteArray, QVariant >  >::toCpp(pyargs[1]);
        // ObjectDescription(int,QHash<QByteArray,QVariant>)
        cptr = new Phonon::AudioCaptureDevice(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<Phonon::AudioCaptureDevice & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        Phonon::AudioCaptureDevice* cpp_arg0 = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp(pyargs[0]);
        // AudioCaptureDevice(Phonon::AudioCaptureDevice)
        cptr = new Phonon::AudioCaptureDevice(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioCaptureDevice_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::AudioCaptureDevice >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_AudioCaptureDevice_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_AudioCaptureDevice_Init_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::AudioCaptureDevice", "", "int, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.AudioCaptureDevice", overloads);
        return -1;
}

static PyObject* SbkPhonon_AudioCaptureDeviceFunc_description(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // description()const
    Phonon::AudioCaptureDevice* cppSelf = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->Phonon::AudioCaptureDevice::description();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioCaptureDeviceFunc_index(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // index()const
    Phonon::AudioCaptureDevice* cppSelf = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::AudioCaptureDevice::index();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioCaptureDeviceFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    Phonon::AudioCaptureDevice* cppSelf = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::AudioCaptureDevice::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioCaptureDeviceFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    Phonon::AudioCaptureDevice* cppSelf = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->Phonon::AudioCaptureDevice::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AudioCaptureDeviceFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // property(const char*)const
        Phonon::AudioCaptureDevice* cppSelf = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->Phonon::AudioCaptureDevice::property(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AudioCaptureDeviceFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_AudioCaptureDeviceFunc_property_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AudioCaptureDevice.property", overloads);
        return 0;
}

static PyObject* SbkPhonon_AudioCaptureDeviceFunc_propertyNames(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyNames()const
    Phonon::AudioCaptureDevice* cppSelf = Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);
    QList<QByteArray > cpp_result = cppSelf->Phonon::AudioCaptureDevice::propertyNames();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_AudioCaptureDevice_methods[] = {
    {"description", (PyCFunction)SbkPhonon_AudioCaptureDeviceFunc_description, METH_NOARGS},
    {"index", (PyCFunction)SbkPhonon_AudioCaptureDeviceFunc_index, METH_NOARGS},
    {"isValid", (PyCFunction)SbkPhonon_AudioCaptureDeviceFunc_isValid, METH_NOARGS},
    {"name", (PyCFunction)SbkPhonon_AudioCaptureDeviceFunc_name, METH_NOARGS},
    {"property", (PyCFunction)SbkPhonon_AudioCaptureDeviceFunc_property, METH_O},
    {"propertyNames", (PyCFunction)SbkPhonon_AudioCaptureDeviceFunc_propertyNames, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkPhonon_AudioCaptureDevice_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    Phonon::AudioCaptureDevice& cpp_self = *Shiboken::Converter<Phonon::AudioCaptureDevice* >::toCpp((PyObject*)self);

    switch (op) {
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkPhonon_AudioCaptureDevice_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_AudioCaptureDevice_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.AudioCaptureDevice",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkPhonon_AudioCaptureDevice_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_AudioCaptureDevice_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::AudioCaptureDevice >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_Phonon_AudioCaptureDevice(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_AUDIOCAPTUREDEVICE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_AudioCaptureDevice_Type);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_AudioCaptureDevice_Type) < 0)
        return;

    PyDict_SetItemString(module,"AudioCaptureDevice", (PyObject*)&SbkPhonon_AudioCaptureDevice_Type);
    Shiboken::TypeResolver::createValueTypeResolver<Phonon::AudioCaptureDevice >("Phonon::AudioCaptureDevice");
    Shiboken::TypeResolver::createValueTypeResolver<Phonon::AudioCaptureDevice >(typeid(Phonon::AudioCaptureDevice).name());
}


} // extern "C"

