/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptvalue_wrapper.h"

// Extra includes
#include <QList>
#include <qdatetime.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qregexp.h>
#include <qscriptclass.h>
#include <qscriptengine.h>
#include <qscriptvalue.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQScriptValue_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptValue* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QScriptValue", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QScriptValue()
        cptr = new QScriptValue();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLatin1String & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QLatin1String* cpp_arg0 = Shiboken::Converter<QLatin1String* >::toCpp(pyargs[0]);
        // QScriptValue(QLatin1String)
        cptr = new QScriptValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QScriptValue::SpecialValue >::isConvertible(pyargs[0])) {
        QScriptValue::SpecialValue cpp_arg0 = Shiboken::Converter<QScriptValue::SpecialValue >::toCpp(pyargs[0]);
        // QScriptValue(QScriptValue::SpecialValue)
        cptr = new QScriptValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(pyargs[0]);
        // QScriptValue(uint)
        cptr = new QScriptValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyFloat_Check(pyargs[0])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        // QScriptValue(double)
        cptr = new QScriptValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        // QScriptValue(const char*)
        cptr = new QScriptValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QScriptValue(QString)
        cptr = new QScriptValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyBool_Check(pyargs[0])) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(pyargs[0]);
        // QScriptValue(bool)
        cptr = new QScriptValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QScriptValue(int)
        cptr = new QScriptValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // QScriptValue(QScriptValue)
        cptr = new QScriptValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QScriptEngine * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QScriptEngine* cpp_arg0 = Shiboken::Converter<QScriptEngine* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QScriptValue::SpecialValue >::isConvertible(pyargs[1])) {
            QScriptValue::SpecialValue cpp_arg1 = Shiboken::Converter<QScriptValue::SpecialValue >::toCpp(pyargs[1]);
            // QScriptValue(QScriptEngine*,QScriptValue::SpecialValue)
            cptr = new QScriptValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            uint cpp_arg1 = Shiboken::Converter<uint >::toCpp(pyargs[1]);
            // QScriptValue(QScriptEngine*,uint)
            cptr = new QScriptValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyFloat_Check(pyargs[1])) {
            double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
            // QScriptValue(QScriptEngine*,double)
            cptr = new QScriptValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // QScriptValue(QScriptEngine*,const char*)
            cptr = new QScriptValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // QScriptValue(QScriptEngine*,QString)
            cptr = new QScriptValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyBool_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // QScriptValue(QScriptEngine*,bool)
            cptr = new QScriptValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QScriptValue(QScriptEngine*,int)
            cptr = new QScriptValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQScriptValue_Init_TypeError;
    } else goto SbkQScriptValue_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptValue >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptValue_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptValue_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtScript.QScriptEngine, PySide.QtScript.QScriptValue.SpecialValue", "PySide.QtScript.QScriptEngine, bool", "PySide.QtScript.QScriptEngine, PySide.QtCore.QString", "PySide.QtScript.QScriptEngine, str", "PySide.QtScript.QScriptEngine, float", "PySide.QtScript.QScriptEngine, int", "PySide.QtScript.QScriptEngine, unsigned int", "PySide.QtScript.QScriptValue.SpecialValue", "bool", "PySide.QtCore.QLatin1String", "PySide.QtScript.QScriptValue", "PySide.QtCore.QString", "str", "float", "int", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptValue", overloads);
        return -1;
}

static PyObject* SbkQScriptValueFunc_call(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "call", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // call(QScriptValue,QList<QScriptValue>)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptValue::call();
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        if (numArgs == 1) {
            // call(QScriptValue,QList<QScriptValue>)
            QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptValue::call(*cpp_arg0);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QScriptValue > cpp_arg1_auto_ptr;
            QScriptValue* cpp_arg1 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[1]);
            if (!SbkQScriptValue_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg1);
            // call(QScriptValue,QScriptValue)
            QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptValue::call(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QList<QScriptValue >  >::isConvertible(pyargs[1])) {
            QList<QScriptValue >  cpp_arg1 = Shiboken::Converter<QList<QScriptValue >  >::toCpp(pyargs[1]);
            // call(QScriptValue,QList<QScriptValue>)
            QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptValue::call(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQScriptValueFunc_call_TypeError;
    } else goto SbkQScriptValueFunc_call_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptValueFunc_call_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue = QScriptValue(), list = QScriptValueList()", "PySide.QtScript.QScriptValue, PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptValue.call", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_construct(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // construct(QList<QScriptValue>)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptValue::construct();
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // construct(QScriptValue)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptValue::construct(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QList<QScriptValue >  >::isConvertible(arg)) {
        QList<QScriptValue >  cpp_arg0 = Shiboken::Converter<QList<QScriptValue >  >::toCpp(arg);
        // construct(QList<QScriptValue>)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptValue::construct(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_construct_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptValueFunc_construct_TypeError:
        const char* overloads[] = {"list = QScriptValueList()", "PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.construct", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptValue::data();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_engine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // engine()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QScriptEngine * cpp_result = cppSelf->QScriptValue::engine();
    py_result = Shiboken::Converter<QScriptEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_equals(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // equals(QScriptValue)const
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QScriptValue::equals(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_equals_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptValueFunc_equals_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.equals", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_instanceOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // instanceOf(QScriptValue)const
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QScriptValue::instanceOf(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_instanceOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptValueFunc_instanceOf_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.instanceOf", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_isArray(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isArray()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isArray();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isBool(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isBool()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isBool();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isBoolean(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isBoolean()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isBoolean();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDate()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isDate();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isError()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isError();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isFunction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFunction()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isFunction();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNumber()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isNumber();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isObject()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isObject();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isQMetaObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isQMetaObject()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isQMetaObject();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isQObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isQObject()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isQObject();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isRegExp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRegExp()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isRegExp();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isString()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isString();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isUndefined(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUndefined()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isUndefined();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_isVariant(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isVariant()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::isVariant();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_lessThan(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // lessThan(QScriptValue)const
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QScriptValue::lessThan(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_lessThan_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptValueFunc_lessThan_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.lessThan", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_objectId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // objectId()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QScriptValue::objectId();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_prototype(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prototype()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptValue::prototype();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_scope(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scope()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptValue::scope();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_scriptClass(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scriptClass()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QScriptClass * cpp_result = cppSelf->QScriptValue::scriptClass();
    py_result = Shiboken::Converter<QScriptClass * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_setData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setData(QScriptValue)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        cppSelf->QScriptValue::setData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptValueFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.setData", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_setPrototype(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setPrototype(QScriptValue)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        cppSelf->QScriptValue::setPrototype(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_setPrototype_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptValueFunc_setPrototype_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.setPrototype", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_setScope(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setScope(QScriptValue)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        cppSelf->QScriptValue::setScope(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_setScope_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptValueFunc_setScope_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.setScope", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_setScriptClass(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptClass * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QScriptClass* cpp_arg0 = Shiboken::Converter<QScriptClass* >::toCpp(arg);
        // setScriptClass(QScriptClass*)
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        cppSelf->QScriptValue::setScriptClass(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_setScriptClass_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptValueFunc_setScriptClass_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptClass", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.setScriptClass", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_strictlyEquals(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // strictlyEquals(QScriptValue)const
        QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QScriptValue::strictlyEquals(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueFunc_strictlyEquals_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptValueFunc_strictlyEquals_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValue.strictlyEquals", overloads);
        return 0;
}

static PyObject* SbkQScriptValueFunc_toBool(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toBool()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::toBool();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toBoolean(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toBoolean()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValue::toBoolean();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toDateTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toDateTime()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QScriptValue::toDateTime();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toInt32(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toInt32()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    qint32 cpp_result = cppSelf->QScriptValue::toInt32();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toInteger(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toInteger()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QScriptValue::toInteger();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toNumber()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QScriptValue::toNumber();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toObject()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptValue::toObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toQMetaObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toQMetaObject()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    const QMetaObject * cpp_result = cppSelf->QScriptValue::toQMetaObject();
    py_result = Shiboken::Converter<QMetaObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toQObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toQObject()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QObject * cpp_result = cppSelf->QScriptValue::toQObject();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toRegExp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toRegExp()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QRegExp cpp_result = cppSelf->QScriptValue::toRegExp();
    py_result = Shiboken::Converter<QRegExp >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptValue::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toUInt16(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toUInt16()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    quint16 cpp_result = cppSelf->QScriptValue::toUInt16();
    py_result = Shiboken::Converter<unsigned short >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toUInt32(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toUInt32()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    quint32 cpp_result = cppSelf->QScriptValue::toUInt32();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueFunc_toVariant(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVariant()const
    QScriptValue* cppSelf = Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QScriptValue::toVariant();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptValue_methods[] = {
    {"call", (PyCFunction)SbkQScriptValueFunc_call, METH_VARARGS},
    {"construct", (PyCFunction)SbkQScriptValueFunc_construct, METH_NOARGS|METH_O},
    {"data", (PyCFunction)SbkQScriptValueFunc_data, METH_NOARGS},
    {"engine", (PyCFunction)SbkQScriptValueFunc_engine, METH_NOARGS},
    {"equals", (PyCFunction)SbkQScriptValueFunc_equals, METH_O},
    {"instanceOf", (PyCFunction)SbkQScriptValueFunc_instanceOf, METH_O},
    {"isArray", (PyCFunction)SbkQScriptValueFunc_isArray, METH_NOARGS},
    {"isBool", (PyCFunction)SbkQScriptValueFunc_isBool, METH_NOARGS},
    {"isBoolean", (PyCFunction)SbkQScriptValueFunc_isBoolean, METH_NOARGS},
    {"isDate", (PyCFunction)SbkQScriptValueFunc_isDate, METH_NOARGS},
    {"isError", (PyCFunction)SbkQScriptValueFunc_isError, METH_NOARGS},
    {"isFunction", (PyCFunction)SbkQScriptValueFunc_isFunction, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQScriptValueFunc_isNull, METH_NOARGS},
    {"isNumber", (PyCFunction)SbkQScriptValueFunc_isNumber, METH_NOARGS},
    {"isObject", (PyCFunction)SbkQScriptValueFunc_isObject, METH_NOARGS},
    {"isQMetaObject", (PyCFunction)SbkQScriptValueFunc_isQMetaObject, METH_NOARGS},
    {"isQObject", (PyCFunction)SbkQScriptValueFunc_isQObject, METH_NOARGS},
    {"isRegExp", (PyCFunction)SbkQScriptValueFunc_isRegExp, METH_NOARGS},
    {"isString", (PyCFunction)SbkQScriptValueFunc_isString, METH_NOARGS},
    {"isUndefined", (PyCFunction)SbkQScriptValueFunc_isUndefined, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQScriptValueFunc_isValid, METH_NOARGS},
    {"isVariant", (PyCFunction)SbkQScriptValueFunc_isVariant, METH_NOARGS},
    {"lessThan", (PyCFunction)SbkQScriptValueFunc_lessThan, METH_O},
    {"objectId", (PyCFunction)SbkQScriptValueFunc_objectId, METH_NOARGS},
    {"prototype", (PyCFunction)SbkQScriptValueFunc_prototype, METH_NOARGS},
    {"scope", (PyCFunction)SbkQScriptValueFunc_scope, METH_NOARGS},
    {"scriptClass", (PyCFunction)SbkQScriptValueFunc_scriptClass, METH_NOARGS},
    {"setData", (PyCFunction)SbkQScriptValueFunc_setData, METH_O},
    {"setPrototype", (PyCFunction)SbkQScriptValueFunc_setPrototype, METH_O},
    {"setScope", (PyCFunction)SbkQScriptValueFunc_setScope, METH_O},
    {"setScriptClass", (PyCFunction)SbkQScriptValueFunc_setScriptClass, METH_O},
    {"strictlyEquals", (PyCFunction)SbkQScriptValueFunc_strictlyEquals, METH_O},
    {"toBool", (PyCFunction)SbkQScriptValueFunc_toBool, METH_NOARGS},
    {"toBoolean", (PyCFunction)SbkQScriptValueFunc_toBoolean, METH_NOARGS},
    {"toDateTime", (PyCFunction)SbkQScriptValueFunc_toDateTime, METH_NOARGS},
    {"toInt32", (PyCFunction)SbkQScriptValueFunc_toInt32, METH_NOARGS},
    {"toInteger", (PyCFunction)SbkQScriptValueFunc_toInteger, METH_NOARGS},
    {"toNumber", (PyCFunction)SbkQScriptValueFunc_toNumber, METH_NOARGS},
    {"toObject", (PyCFunction)SbkQScriptValueFunc_toObject, METH_NOARGS},
    {"toQMetaObject", (PyCFunction)SbkQScriptValueFunc_toQMetaObject, METH_NOARGS},
    {"toQObject", (PyCFunction)SbkQScriptValueFunc_toQObject, METH_NOARGS},
    {"toRegExp", (PyCFunction)SbkQScriptValueFunc_toRegExp, METH_NOARGS},
    {"toString", (PyCFunction)SbkQScriptValueFunc_toString, METH_NOARGS},
    {"toUInt16", (PyCFunction)SbkQScriptValueFunc_toUInt16, METH_NOARGS},
    {"toUInt32", (PyCFunction)SbkQScriptValueFunc_toUInt32, METH_NOARGS},
    {"toVariant", (PyCFunction)SbkQScriptValueFunc_toVariant, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptValue_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptValue",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptValue_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptValue_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptValue >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtScript_QScriptValue_ResolveFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptValue_ResolveFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptValue_ResolveFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ResolveFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptValue_ResolveFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptValue_ResolveFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptValue_ResolveFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtScript_QScriptValue_PropertyFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptValue_PropertyFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptValue_PropertyFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PropertyFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptValue_PropertyFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptValue_PropertyFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptValue_PropertyFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtScript_QScriptValue_SpecialValue_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptValue_SpecialValue_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptValue_SpecialValue_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SpecialValue",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptValue_SpecialValue_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptValue_SpecialValue_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptValue_SpecialValue_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QScriptValue(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptValue_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptValue_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptValue_Type));
    PyModule_AddObject(module, "QScriptValue",
        ((PyObject*)&SbkQScriptValue_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ResolveFlag
    SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX] = &SbkPySide_QtScript_QScriptValue_ResolveFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type);
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
            "ResolveFlag",((PyObject*)&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type,
        (long) QScriptValue::ResolveLocal, "ResolveLocal");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "ResolveLocal", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_ResolveFlag_Type.tp_dict,
        "ResolveLocal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type,
        (long) QScriptValue::ResolvePrototype, "ResolvePrototype");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "ResolvePrototype", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_ResolveFlag_Type.tp_dict,
        "ResolvePrototype", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type,
        (long) QScriptValue::ResolveScope, "ResolveScope");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "ResolveScope", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_ResolveFlag_Type.tp_dict,
        "ResolveScope", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_ResolveFlag_Type,
        (long) QScriptValue::ResolveFull, "ResolveFull");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "ResolveFull", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_ResolveFlag_Type.tp_dict,
        "ResolveFull", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptValue::ResolveFlag");

    // init enum class: PropertyFlag
    SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX] = &SbkPySide_QtScript_QScriptValue_PropertyFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type);
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
            "PropertyFlag",((PyObject*)&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::ReadOnly, "ReadOnly");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "ReadOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "ReadOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::Undeletable, "Undeletable");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "Undeletable", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "Undeletable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::SkipInEnumeration, "SkipInEnumeration");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "SkipInEnumeration", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "SkipInEnumeration", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::PropertyGetter, "PropertyGetter");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "PropertyGetter", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "PropertyGetter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::PropertySetter, "PropertySetter");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "PropertySetter", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "PropertySetter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::QObjectMember, "QObjectMember");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "QObjectMember", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "QObjectMember", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::KeepExistingFlags, "KeepExistingFlags");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "KeepExistingFlags", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "KeepExistingFlags", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_PropertyFlag_Type,
        (long) QScriptValue::UserRange, "UserRange");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "UserRange", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_PropertyFlag_Type.tp_dict,
        "UserRange", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptValue::PropertyFlag");

    // init enum class: SpecialValue
    SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX] = &SbkPySide_QtScript_QScriptValue_SpecialValue_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptValue_SpecialValue_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptValue_SpecialValue_Type);
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
            "SpecialValue",((PyObject*)&SbkPySide_QtScript_QScriptValue_SpecialValue_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_SpecialValue_Type,
        (long) QScriptValue::NullValue, "NullValue");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "NullValue", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_SpecialValue_Type.tp_dict,
        "NullValue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptValue_SpecialValue_Type,
        (long) QScriptValue::UndefinedValue, "UndefinedValue");
    PyDict_SetItemString(SbkQScriptValue_Type.super.ht_type.tp_dict,
        "UndefinedValue", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptValue_SpecialValue_Type.tp_dict,
        "UndefinedValue", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptValue::SpecialValue");

    Shiboken::TypeResolver::createValueTypeResolver<QScriptValue >("QScriptValue");
    Shiboken::TypeResolver::createValueTypeResolver<QScriptValue >(typeid(QScriptValue).name());
}


} // extern "C"

