/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtopengl_python.h"

#include "qglwidget_wrapper.h"

// Extra includes
#include <QImage>
#include <QList>
#include <QPixmap>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgl.h>
#include <qglcolormap.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qimage.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGLWidgetWrapper::QGLWidgetWrapper(QGLContext * context, QWidget * parent, const QGLWidget * shareWidget, QFlags<Qt::WindowType> f) : QGLWidget(context, parent, shareWidget, f), m_metaObject(0) {
    // ... middle
}

QGLWidgetWrapper::QGLWidgetWrapper(QWidget * parent, const QGLWidget * shareWidget, QFlags<Qt::WindowType> f) : QGLWidget(parent, shareWidget, f), m_metaObject(0) {
    // ... middle
}

QGLWidgetWrapper::QGLWidgetWrapper(const QGLFormat & format, QWidget * parent, const QGLWidget * shareWidget, QFlags<Qt::WindowType> f) : QGLWidget(format, parent, shareWidget, f), m_metaObject(0) {
    // ... middle
}

void QGLWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGLWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGLWidgetWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QGLWidget::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGLWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGLWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::glDraw()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "glDraw"));
    if (py_override.isNull()) {
        return this->QGLWidget::glDraw();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::glInit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "glInit"));
    if (py_override.isNull()) {
        return this->QGLWidget::glInit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGLWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::initializeGL()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "initializeGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::initializeGL();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::initializeOverlayGL()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "initializeOverlayGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::initializeOverlayGL();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QGLWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QGLWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QGLWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QGLWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QGLWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QGLWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::paintGL()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::paintGL();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::paintOverlayGL()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintOverlayGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::paintOverlayGL();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QGLWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::resizeGL(int w, int h)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::resizeGL(w, h);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        w,
        h
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::resizeOverlayGL(int w, int h)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeOverlayGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::resizeOverlayGL(w, h);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        w,
        h
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QGLWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLWidget.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QGLWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::updateGL()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::updateGL();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::updateOverlayGL()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateOverlayGL"));
    if (py_override.isNull()) {
        return this->QGLWidget::updateOverlayGL();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGLWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGLWidget::staticMetaObject);
}
    return m_metaObject;
}

int QGLWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGLWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGLWidgetWrapper::~QGLWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGLWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QGLWidget", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QGLWidget(QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
        cptr = new QGLWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGLFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QGLFormat > cpp_arg0_auto_ptr;
        QGLFormat* cpp_arg0 = Shiboken::Converter<QGLFormat* >::toCpp(pyargs[0]);
        if (!SbkQGLFormat_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg0);
        if (numArgs == 1) {
            // QGLWidget(QGLFormat,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
            cptr = new QGLWidgetWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QGLWidget(QGLFormat,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                cptr = new QGLWidgetWrapper(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], self);
            } else if (Shiboken::Converter<QGLWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QGLWidget* cpp_arg2 = Shiboken::Converter<QGLWidget* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QGLWidget(QGLFormat,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                    cptr = new QGLWidgetWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(pyargs[1], self);
                } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[3])) {
                    QFlags<Qt::WindowType> cpp_arg3 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[3]);
                    // QGLWidget(QGLFormat,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                    cptr = new QGLWidgetWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(pyargs[1], self);
                } else goto SbkQGLWidget_Init_TypeError;
            } else goto SbkQGLWidget_Init_TypeError;
        } else goto SbkQGLWidget_Init_TypeError;
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGLWidget(QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
            cptr = new QGLWidgetWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (Shiboken::Converter<QGLWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QGLWidget* cpp_arg1 = Shiboken::Converter<QGLWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QGLWidget(QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                cptr = new QGLWidgetWrapper(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
            } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[2])) {
                QFlags<Qt::WindowType> cpp_arg2 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[2]);
                // QGLWidget(QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                cptr = new QGLWidgetWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
            } else goto SbkQGLWidget_Init_TypeError;
        } else goto SbkQGLWidget_Init_TypeError;
    } else if (Shiboken::Converter<QGLContext * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGLContext* cpp_arg0 = Shiboken::Converter<QGLContext* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGLWidget(QGLContext*,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
            cptr = new QGLWidgetWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
            Shiboken::setParent(self, pyargs[0]);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QGLWidget(QGLContext*,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                cptr = new QGLWidgetWrapper(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], self);
                Shiboken::setParent(self, pyargs[0]);
                Shiboken::setParent(pyargs[1], self);
            } else if (Shiboken::Converter<QGLWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QGLWidget* cpp_arg2 = Shiboken::Converter<QGLWidget* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QGLWidget(QGLContext*,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                    cptr = new QGLWidgetWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(pyargs[1], self);
                    Shiboken::setParent(self, pyargs[0]);
                    Shiboken::setParent(pyargs[1], self);
                } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[3])) {
                    QFlags<Qt::WindowType> cpp_arg3 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[3]);
                    // QGLWidget(QGLContext*,QWidget*,const QGLWidget*,QFlags<Qt::WindowType>)
                    cptr = new QGLWidgetWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(pyargs[1], self);
                    Shiboken::setParent(self, pyargs[0]);
                    Shiboken::setParent(pyargs[1], self);
                } else goto SbkQGLWidget_Init_TypeError;
            } else goto SbkQGLWidget_Init_TypeError;
        } else goto SbkQGLWidget_Init_TypeError;
    } else goto SbkQGLWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGLWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGLWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLContext, PySide.QtGui.QWidget = None, PySide.QtOpenGL.QGLWidget = None, PySide.QtCore.Qt.WindowFlags = 0", "PySide.QtGui.QWidget = None, PySide.QtOpenGL.QGLWidget = None, PySide.QtCore.Qt.WindowFlags = 0", "PySide.QtOpenGL.QGLFormat, PySide.QtGui.QWidget = None, PySide.QtOpenGL.QGLWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget", overloads);
        return -1;
}

static PyObject* SbkQGLWidgetFunc_autoBufferSwap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoBufferSwap()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLWidget::autoBufferSwap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_bindTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "bindTexture", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // bindTexture(QString)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPixmap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!SbkQPixmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (numArgs == 1) {
            // bindTexture(QPixmap,uint,int)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // bindTexture(QPixmap,uint,int)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // bindTexture(QPixmap,uint,int)
                    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                    unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (numArgs == 4 && SbkPySide_QtOpenGL_QGLContext_BindOption_Check(pyargs[3])) {
                    QFlags<QGLContext::BindOption> cpp_arg3 = Shiboken::Converter<QFlags<QGLContext::BindOption> >::toCpp(pyargs[3]);
                    // bindTexture(QPixmap,uint,int,QFlags<QGLContext::BindOption>)
                    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                    unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQGLWidgetFunc_bindTexture_TypeError;
            } else goto SbkQGLWidgetFunc_bindTexture_TypeError;
        } else goto SbkQGLWidgetFunc_bindTexture_TypeError;
    } else if (Shiboken::Converter<QImage & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // bindTexture(QImage,uint,int)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // bindTexture(QImage,uint,int)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // bindTexture(QImage,uint,int)
                    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                    unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (numArgs == 4 && SbkPySide_QtOpenGL_QGLContext_BindOption_Check(pyargs[3])) {
                    QFlags<QGLContext::BindOption> cpp_arg3 = Shiboken::Converter<QFlags<QGLContext::BindOption> >::toCpp(pyargs[3]);
                    // bindTexture(QImage,uint,int,QFlags<QGLContext::BindOption>)
                    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                    unsigned int cpp_result = cppSelf->QGLWidget::bindTexture(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQGLWidgetFunc_bindTexture_TypeError;
            } else goto SbkQGLWidgetFunc_bindTexture_TypeError;
        } else goto SbkQGLWidgetFunc_bindTexture_TypeError;
    } else goto SbkQGLWidgetFunc_bindTexture_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLWidgetFunc_bindTexture_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, unsigned int = 0x0DE1, int = 0x1908", "PySide.QtGui.QImage, unsigned int, int, PySide.QtOpenGL.QGLContext.BindOptions", "PySide.QtGui.QPixmap, unsigned int = 0x0DE1, int = 0x1908", "PySide.QtGui.QPixmap, unsigned int, int, PySide.QtOpenGL.QGLContext.BindOptions", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget.bindTexture", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_colormap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // colormap()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    const QGLColormap & cpp_result = cppSelf->QGLWidget::colormap();
    py_result = Shiboken::Converter<QGLColormap & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_context(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // context()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    const QGLContext * cpp_result = cppSelf->QGLWidget::context();
    py_result = Shiboken::Converter<QGLContext * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_convertToGLFormat(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QImage & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(arg);
        // convertToGLFormat(QImage)
        QImage cpp_result = QGLWidget::convertToGLFormat(*cpp_arg0);
        py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_convertToGLFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLWidgetFunc_convertToGLFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.convertToGLFormat", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_deleteTexture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // deleteTexture(uint)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::deleteTexture(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_deleteTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_deleteTexture_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.deleteTexture", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_doneCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doneCurrent()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::doneCurrent();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_doubleBuffer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleBuffer()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLWidget::doubleBuffer();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_drawTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawTexture", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QRectF,uint,uint)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            cppSelf->QGLWidget::drawTexture(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QRectF,uint,uint)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            cppSelf->QGLWidget::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLWidgetFunc_drawTexture_TypeError;
    } else if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QPointF,uint,uint)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            cppSelf->QGLWidget::drawTexture(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QPointF,uint,uint)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            cppSelf->QGLWidget::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLWidgetFunc_drawTexture_TypeError;
    } else goto SbkQGLWidgetFunc_drawTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_drawTexture_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, unsigned int, unsigned int = 0x0DE1", "PySide.QtCore.QRectF, unsigned int, unsigned int = 0x0DE1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget.drawTexture", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.event", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    QGLFormat cpp_result = cppSelf->QGLWidget::format();
    py_result = Shiboken::Converter<QGLFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_glDraw(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // glDraw()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::glDraw();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_glInit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // glInit()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::glInit();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_grabFrameBuffer(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // grabFrameBuffer(bool)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        QImage cpp_result = cppSelf->QGLWidget::grabFrameBuffer();
        py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // grabFrameBuffer(bool)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        QImage cpp_result = cppSelf->QGLWidget::grabFrameBuffer(cpp_arg0);
        py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_grabFrameBuffer_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLWidgetFunc_grabFrameBuffer_TypeError:
        const char* overloads[] = {"bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.grabFrameBuffer", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_initializeGL(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // initializeGL()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::initializeGL();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_initializeOverlayGL(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // initializeOverlayGL()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::initializeOverlayGL();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_isSharing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSharing()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLWidget::isSharing();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLWidget::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_makeCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // makeCurrent()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::makeCurrent();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_makeOverlayCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // makeOverlayCurrent()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::makeOverlayCurrent();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_overlayContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overlayContext()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    const QGLContext * cpp_result = cppSelf->QGLWidget::overlayContext();
    py_result = Shiboken::Converter<QGLContext * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QGLWidget::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLWidgetFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_paintGL(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // paintGL()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::paintGL();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_paintOverlayGL(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // paintOverlayGL()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::paintOverlayGL();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_qglClearColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // qglClearColor(QColor)const
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::qglClearColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_qglClearColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_qglClearColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.qglClearColor", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_qglColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // qglColor(QColor)const
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::qglColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_qglColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_qglColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.qglColor", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_renderPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "renderPixmap", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // renderPixmap(int,int,bool)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QGLWidget::renderPixmap();
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // renderPixmap(int,int,bool)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QGLWidget::renderPixmap(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // renderPixmap(int,int,bool)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QGLWidget::renderPixmap(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
                // renderPixmap(int,int,bool)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QGLWidget::renderPixmap(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLWidgetFunc_renderPixmap_TypeError;
        } else goto SbkQGLWidgetFunc_renderPixmap_TypeError;
    } else goto SbkQGLWidgetFunc_renderPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLWidgetFunc_renderPixmap_TypeError:
        const char* overloads[] = {"int = 0, int = 0, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget.renderPixmap", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_renderText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "renderText", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyFloat_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
        double cpp_arg2 = Shiboken::Converter<double >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!SbkQString_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        if (numArgs == 4) {
            // renderText(double,double,double,QString,QFont,int)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            cppSelf->QGLWidget::renderText(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QFont & >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QFont > cpp_arg4_auto_ptr;
            QFont* cpp_arg4 = Shiboken::Converter<QFont* >::toCpp(pyargs[4]);
            if (!SbkQFont_Check(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QFont >(cpp_arg4);
            if (numArgs == 5) {
                // renderText(double,double,double,QString,QFont,int)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                cppSelf->QGLWidget::renderText(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[5])) {
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                // renderText(double,double,double,QString,QFont,int)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                cppSelf->QGLWidget::renderText(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLWidgetFunc_renderText_TypeError;
        } else goto SbkQGLWidgetFunc_renderText_TypeError;
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // renderText(int,int,QString,QFont,int)
            QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
            cppSelf->QGLWidget::renderText(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QFont & >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            std::auto_ptr<QFont > cpp_arg3_auto_ptr;
            QFont* cpp_arg3 = Shiboken::Converter<QFont* >::toCpp(pyargs[3]);
            if (!SbkQFont_Check(pyargs[3]))
                cpp_arg3_auto_ptr = std::auto_ptr<QFont >(cpp_arg3);
            if (numArgs == 4) {
                // renderText(int,int,QString,QFont,int)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                cppSelf->QGLWidget::renderText(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[4])) {
                int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                // renderText(int,int,QString,QFont,int)
                QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
                cppSelf->QGLWidget::renderText(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLWidgetFunc_renderText_TypeError;
        } else goto SbkQGLWidgetFunc_renderText_TypeError;
    } else goto SbkQGLWidgetFunc_renderText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_renderText_TypeError:
        const char* overloads[] = {"float, float, float, PySide.QtCore.QString, PySide.QtGui.QFont = QFont(), int = 2000", "int, int, PySide.QtCore.QString, PySide.QtGui.QFont = QFont(), int = 2000", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget.renderText", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_resizeGL(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resizeGL", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // resizeGL(int,int)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::resizeGL(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_resizeGL_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_resizeGL_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget.resizeGL", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_resizeOverlayGL(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resizeOverlayGL", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // resizeOverlayGL(int,int)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::resizeOverlayGL(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_resizeOverlayGL_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_resizeOverlayGL_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLWidget.resizeOverlayGL", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_setAutoBufferSwap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoBufferSwap(bool)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::setAutoBufferSwap(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_setAutoBufferSwap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_setAutoBufferSwap_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.setAutoBufferSwap", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_setColormap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGLColormap & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGLColormap* cpp_arg0 = Shiboken::Converter<QGLColormap* >::toCpp(arg);
        // setColormap(QGLColormap)
        QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
        cppSelf->QGLWidget::setColormap(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLWidgetFunc_setColormap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLWidgetFunc_setColormap_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLColormap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLWidget.setColormap", overloads);
        return 0;
}

static PyObject* SbkQGLWidgetFunc_swapBuffers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // swapBuffers()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::swapBuffers();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_updateGL(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGL()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::updateGL();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLWidgetFunc_updateOverlayGL(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateOverlayGL()
    QGLWidget* cppSelf = Shiboken::Converter<QGLWidget* >::toCpp((PyObject*)self);
    cppSelf->QGLWidget::updateOverlayGL();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQGLWidget_methods[] = {
    {"autoBufferSwap", (PyCFunction)SbkQGLWidgetFunc_autoBufferSwap, METH_NOARGS},
    {"bindTexture", (PyCFunction)SbkQGLWidgetFunc_bindTexture, METH_VARARGS},
    {"colormap", (PyCFunction)SbkQGLWidgetFunc_colormap, METH_NOARGS},
    {"context", (PyCFunction)SbkQGLWidgetFunc_context, METH_NOARGS},
    {"convertToGLFormat", (PyCFunction)SbkQGLWidgetFunc_convertToGLFormat, METH_O|METH_STATIC},
    {"deleteTexture", (PyCFunction)SbkQGLWidgetFunc_deleteTexture, METH_O},
    {"doneCurrent", (PyCFunction)SbkQGLWidgetFunc_doneCurrent, METH_NOARGS},
    {"doubleBuffer", (PyCFunction)SbkQGLWidgetFunc_doubleBuffer, METH_NOARGS},
    {"drawTexture", (PyCFunction)SbkQGLWidgetFunc_drawTexture, METH_VARARGS},
    {"event", (PyCFunction)SbkQGLWidgetFunc_event, METH_O},
    {"format", (PyCFunction)SbkQGLWidgetFunc_format, METH_NOARGS},
    {"glDraw", (PyCFunction)SbkQGLWidgetFunc_glDraw, METH_NOARGS},
    {"glInit", (PyCFunction)SbkQGLWidgetFunc_glInit, METH_NOARGS},
    {"grabFrameBuffer", (PyCFunction)SbkQGLWidgetFunc_grabFrameBuffer, METH_NOARGS|METH_O},
    {"initializeGL", (PyCFunction)SbkQGLWidgetFunc_initializeGL, METH_NOARGS},
    {"initializeOverlayGL", (PyCFunction)SbkQGLWidgetFunc_initializeOverlayGL, METH_NOARGS},
    {"isSharing", (PyCFunction)SbkQGLWidgetFunc_isSharing, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQGLWidgetFunc_isValid, METH_NOARGS},
    {"makeCurrent", (PyCFunction)SbkQGLWidgetFunc_makeCurrent, METH_NOARGS},
    {"makeOverlayCurrent", (PyCFunction)SbkQGLWidgetFunc_makeOverlayCurrent, METH_NOARGS},
    {"overlayContext", (PyCFunction)SbkQGLWidgetFunc_overlayContext, METH_NOARGS},
    {"paintEngine", (PyCFunction)SbkQGLWidgetFunc_paintEngine, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQGLWidgetFunc_paintEvent, METH_O},
    {"paintGL", (PyCFunction)SbkQGLWidgetFunc_paintGL, METH_NOARGS},
    {"paintOverlayGL", (PyCFunction)SbkQGLWidgetFunc_paintOverlayGL, METH_NOARGS},
    {"qglClearColor", (PyCFunction)SbkQGLWidgetFunc_qglClearColor, METH_O},
    {"qglColor", (PyCFunction)SbkQGLWidgetFunc_qglColor, METH_O},
    {"renderPixmap", (PyCFunction)SbkQGLWidgetFunc_renderPixmap, METH_VARARGS},
    {"renderText", (PyCFunction)SbkQGLWidgetFunc_renderText, METH_VARARGS},
    {"resizeEvent", (PyCFunction)SbkQGLWidgetFunc_resizeEvent, METH_O},
    {"resizeGL", (PyCFunction)SbkQGLWidgetFunc_resizeGL, METH_VARARGS},
    {"resizeOverlayGL", (PyCFunction)SbkQGLWidgetFunc_resizeOverlayGL, METH_VARARGS},
    {"setAutoBufferSwap", (PyCFunction)SbkQGLWidgetFunc_setAutoBufferSwap, METH_O},
    {"setColormap", (PyCFunction)SbkQGLWidgetFunc_setColormap, METH_O},
    {"swapBuffers", (PyCFunction)SbkQGLWidgetFunc_swapBuffers, METH_NOARGS},
    {"updateGL", (PyCFunction)SbkQGLWidgetFunc_updateGL, METH_NOARGS},
    {"updateOverlayGL", (PyCFunction)SbkQGLWidgetFunc_updateOverlayGL, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQGLWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QGLWidget* me = reinterpret_cast<QGLWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQGLWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGLWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGLWidget(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLWidget_Type);

    SbkQGLWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQGLWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQGLWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGLWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLWidget_Type));
    PyModule_AddObject(module, "QGLWidget",
        ((PyObject*)&SbkQGLWidget_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGLWidget >("QGLWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGLWidget >(typeid(QGLWidget).name());
}


} // extern "C"

