/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTOPENGL_PYTHON_H
#define SBK_QTOPENGL_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTOPENGL_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTOPENGL_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTOPENGL_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qglshaderprogram.h>
#include <qgl.h>
#include <qglcolormap.h>
#include <qglframebufferobject.h>
#include <qglpixelbuffer.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QGL_IDX                                                  0
#define SBK_QGL_FORMATOPTION_IDX                                     1
#define SBK_QFLAGS_QGL_FORMATOPTION__IDX                             2
#define SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX                           3
#define SBK_QGLSHADER_IDX                                            4
#define SBK_QGLSHADER_SHADERTYPEBIT_IDX                              5
#define SBK_QFLAGS_QGLSHADER_SHADERTYPEBIT__IDX                      6
#define SBK_QGLCONTEXT_IDX                                           7
#define SBK_QGLCONTEXT_BINDOPTION_IDX                                8
#define SBK_QFLAGS_QGLCONTEXT_BINDOPTION__IDX                        9
#define SBK_QGLCOLORMAP_IDX                                          10
#define SBK_QGLFORMAT_IDX                                            11
#define SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX                          12
#define SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG__IDX                  13
#define SBK_QGLPIXELBUFFER_IDX                                       14
#define SBK_QGLFRAMEBUFFEROBJECT_IDX                                 15
#define SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX                      16
#define SBK_QGLSHADERPROGRAM_IDX                                     17
#define SBK_QGLWIDGET_IDX                                            18
#define SBK_QtOpenGL_IDX_COUNT                                       19

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtOpenGLTypes;

// Macros for type check
#define SbkPySide_QtOpenGL_QGL_FormatOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX])
#define SbkPySide_QtOpenGL_QGL_FormatOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION__IDX])
#define SbkQGLFramebufferObjectFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX])
#define SbkPySide_QtOpenGL_QGLShader_ShaderTypeBit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLSHADER_SHADERTYPEBIT_IDX])
#define SbkPySide_QtOpenGL_QGLShader_ShaderType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLSHADER_SHADERTYPEBIT__IDX])
#define SbkQGLShader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLSHADER_IDX])
#define SbkPySide_QtOpenGL_QGLContext_BindOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX])
#define SbkPySide_QtOpenGL_QGLContext_BindOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION__IDX])
#define SbkQGLContext_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLCONTEXT_IDX])
#define SbkQGLColormap_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX])
#define SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX])
#define SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG__IDX])
#define SbkQGLFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLFORMAT_IDX])
#define SbkQGLPixelBuffer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX])
#define SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])
#define SbkQGLFramebufferObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX])
#define SbkQGLShaderProgram_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX])
#define SbkQGLWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtOpenGLTypes[SBK_QGLWIDGET_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QGL::FormatOption >() { return SbkPySide_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGL::FormatOption> >() { return SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QGLFramebufferObjectFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QGLShader::ShaderTypeBit >() { return SbkPySide_QtOpenGLTypes[SBK_QGLSHADER_SHADERTYPEBIT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGLShader::ShaderTypeBit> >() { return SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLSHADER_SHADERTYPEBIT__IDX]; }
template<> inline PyTypeObject* SbkType<QGLShader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLSHADER_IDX]); }
template<> inline PyTypeObject* SbkType<QGLContext::BindOption >() { return SbkPySide_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGLContext::BindOption> >() { return SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QGLContext >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]); }
template<> inline PyTypeObject* SbkType<QGLColormap >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX]); }
template<> inline PyTypeObject* SbkType<QGLFormat::OpenGLVersionFlag >() { return SbkPySide_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGLFormat::OpenGLVersionFlag> >() { return SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QGLFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QGLPixelBuffer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX]); }
template<> inline PyTypeObject* SbkType<QGLFramebufferObject::Attachment >() { return SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QGLFramebufferObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<QGLShaderProgram >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX]); }
template<> inline PyTypeObject* SbkType<QGLWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtOpenGLTypes[SBK_QGLWIDGET_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QGL::FormatOption > : EnumConverter<QGL::FormatOption >
{
};
template<>
struct Converter<QFlags<QGL::FormatOption> > : EnumConverter<QFlags<QGL::FormatOption> >
{
};

template<>
struct Converter<QGLFramebufferObjectFormat > : ValueTypeConverter<QGLFramebufferObjectFormat >
{
};

template<>
struct Converter<QGLShader::ShaderTypeBit > : EnumConverter<QGLShader::ShaderTypeBit >
{
};
template<>
struct Converter<QFlags<QGLShader::ShaderTypeBit> > : EnumConverter<QFlags<QGLShader::ShaderTypeBit> >
{
};

template<>
struct Converter<QGLShader* > : ObjectTypeConverter<QGLShader >
{
};

template<>
struct Converter<QGLShader& > : ObjectTypeReferenceConverter<QGLShader >
{
};

template<>
struct Converter<QGLContext::BindOption > : EnumConverter<QGLContext::BindOption >
{
};
template<>
struct Converter<QFlags<QGLContext::BindOption> > : EnumConverter<QFlags<QGLContext::BindOption> >
{
};

template<>
struct Converter<QGLContext* > : ObjectTypeConverter<QGLContext >
{
};

template<>
struct Converter<QGLContext& > : ObjectTypeReferenceConverter<QGLContext >
{
};

template<>
struct Converter<QGLColormap > : ValueTypeConverter<QGLColormap >
{
};

template<>
struct Converter<QGLFormat::OpenGLVersionFlag > : EnumConverter<QGLFormat::OpenGLVersionFlag >
{
};
template<>
struct Converter<QFlags<QGLFormat::OpenGLVersionFlag> > : EnumConverter<QFlags<QGLFormat::OpenGLVersionFlag> >
{
};

template<>
struct Converter<QGLFormat > : ValueTypeConverter<QGLFormat >
{
    static QGLFormat toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGLPixelBuffer* > : ObjectTypeConverter<QGLPixelBuffer >
{
};

template<>
struct Converter<QGLPixelBuffer& > : ObjectTypeReferenceConverter<QGLPixelBuffer >
{
};

template<>
struct Converter<QGLFramebufferObject::Attachment > : EnumConverter<QGLFramebufferObject::Attachment >
{
};

template<>
struct Converter<QGLFramebufferObject* > : ObjectTypeConverter<QGLFramebufferObject >
{
};

template<>
struct Converter<QGLFramebufferObject& > : ObjectTypeReferenceConverter<QGLFramebufferObject >
{
};

template<>
struct Converter<QGLShaderProgram* > : ObjectTypeConverter<QGLShaderProgram >
{
};

template<>
struct Converter<QGLShaderProgram& > : ObjectTypeReferenceConverter<QGLShaderProgram >
{
};

template<>
struct Converter<QGLWidget* > : ObjectTypeConverter<QGLWidget >
{
};

template<>
struct Converter<QGLWidget& > : ObjectTypeReferenceConverter<QGLWidget >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QGLFormat >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QGLFormat >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QGLFormat >());
    return Shiboken::Converter<QFlags<QGL::FormatOption> >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QGLFormat Shiboken::Converter<QGLFormat >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QGLFormat)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QGLFormat >());
        if (Shiboken::Converter<QFlags<QGL::FormatOption> >::isConvertible(pyobj))
            return QGLFormat(Shiboken::Converter<QFlags<QGL::FormatOption> >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QGLFormat* cptr = reinterpret_cast<QGLFormat*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QGLFormat > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTOPENGL_PYTHON_H

