/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtmultimedia_python.h"

#include "qabstractvideobuffer_wrapper.h"

// Extra includes
#include <qabstractvideobuffer.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractVideoBufferWrapper::QAbstractVideoBufferWrapper(QAbstractVideoBuffer::HandleType type) : QAbstractVideoBuffer(type) {
    // ... middle
}

QVariant QAbstractVideoBufferWrapper::handle() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "handle"));
    if (py_override.isNull()) {
        return this->QAbstractVideoBuffer::handle();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoBuffer.handle", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

uchar * QAbstractVideoBufferWrapper::map(QAbstractVideoBuffer::MapMode mode, int * numBytes, int * bytesPerLine)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "map"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.map()' not implemented.");
        return uchar(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QAbstractVideoBuffer::MapMode >::toPython(mode)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return uchar(0);
    }
    // Check return type
    bool typeIsValid = PyObject_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoBuffer.map", "PyObject", py_result->ob_type->tp_name);
        return uchar(0);
    }
    uchar * cpp_result(Shiboken::Converter<uchar * >::toCpp(py_result));

    return cpp_result;
}

QAbstractVideoBuffer::MapMode QAbstractVideoBufferWrapper::mapMode() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapMode"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.mapMode()' not implemented.");
        return QAbstractVideoBuffer::MapMode();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QAbstractVideoBuffer::MapMode();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QAbstractVideoBuffer::MapMode >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoBuffer.mapMode", SbkType<QAbstractVideoBuffer::MapMode >()->tp_name, py_result->ob_type->tp_name);
        return QAbstractVideoBuffer::MapMode();
    }
    QAbstractVideoBuffer::MapMode cpp_result(Shiboken::Converter<QAbstractVideoBuffer::MapMode >::toCpp(py_result));
    return cpp_result;
}

void QAbstractVideoBufferWrapper::unmap()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unmap"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.unmap()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QAbstractVideoBufferWrapper::~QAbstractVideoBufferWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQAbstractVideoBuffer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractVideoBufferWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractVideoBuffer' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractVideoBuffer", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QAbstractVideoBuffer::HandleType >::isConvertible(pyargs[0])) {
        QAbstractVideoBuffer::HandleType cpp_arg0 = Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toCpp(pyargs[0]);
        // QAbstractVideoBuffer(QAbstractVideoBuffer::HandleType)
        cptr = new QAbstractVideoBufferWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoBuffer_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractVideoBuffer >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractVideoBuffer_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractVideoBuffer_Init_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAbstractVideoBuffer.HandleType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QAbstractVideoBuffer", overloads);
        return -1;
}

static PyObject* SbkQAbstractVideoBufferFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QAbstractVideoBuffer* cppSelf = Shiboken::Converter<QAbstractVideoBuffer* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QAbstractVideoBuffer::handle();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractVideoBufferFunc_handleType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handleType()const
    QAbstractVideoBuffer* cppSelf = Shiboken::Converter<QAbstractVideoBuffer* >::toCpp((PyObject*)self);
    QAbstractVideoBuffer::HandleType cpp_result = cppSelf->QAbstractVideoBuffer::handleType();
    py_result = Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractVideoBufferFunc_map(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractVideoBuffer::MapMode >::isConvertible(arg)) {
        QAbstractVideoBuffer::MapMode cpp_arg0 = Shiboken::Converter<QAbstractVideoBuffer::MapMode >::toCpp(arg);
        // map(QAbstractVideoBuffer::MapMode,int*,int*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.map()' not implemented.");
            return 0;
        }
        QAbstractVideoBuffer* cppSelf = Shiboken::Converter<QAbstractVideoBuffer* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_arg,int*,int* - START
        uchar * _ret;
        int a, b;
        _ret = cppSelf->map(cpp_arg0, &a, &b);
        py_result = Shiboken::makeTuple(_ret, a, b);
        // TEMPLATE - fix_arg,int*,int* - END
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoBufferFunc_map_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractVideoBufferFunc_map_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAbstractVideoBuffer.MapMode, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAbstractVideoBuffer.map", overloads);
        return 0;
}

static PyObject* SbkQAbstractVideoBufferFunc_mapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mapMode()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.mapMode()' not implemented.");
        return 0;
    }
    QAbstractVideoBuffer* cppSelf = Shiboken::Converter<QAbstractVideoBuffer* >::toCpp((PyObject*)self);
    QAbstractVideoBuffer::MapMode cpp_result = cppSelf->mapMode();
    py_result = Shiboken::Converter<QAbstractVideoBuffer::MapMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractVideoBufferFunc_unmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unmap()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.unmap()' not implemented.");
        return 0;
    }
    QAbstractVideoBuffer* cppSelf = Shiboken::Converter<QAbstractVideoBuffer* >::toCpp((PyObject*)self);
    cppSelf->unmap();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQAbstractVideoBuffer_methods[] = {
    {"handle", (PyCFunction)SbkQAbstractVideoBufferFunc_handle, METH_NOARGS},
    {"handleType", (PyCFunction)SbkQAbstractVideoBufferFunc_handleType, METH_NOARGS},
    {"map", (PyCFunction)SbkQAbstractVideoBufferFunc_map, METH_O},
    {"mapMode", (PyCFunction)SbkQAbstractVideoBufferFunc_mapMode, METH_NOARGS},
    {"unmap", (PyCFunction)SbkQAbstractVideoBufferFunc_unmap, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractVideoBuffer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAbstractVideoBuffer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractVideoBuffer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractVideoBuffer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractVideoBuffer >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQAbstractVideoBuffer_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQAbstractVideoBuffer_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QAbstractVideoBuffer*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MapMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "HandleType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QAbstractVideoBuffer(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractVideoBuffer_Type);

    // Fill type discovery information
    SbkQAbstractVideoBuffer_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQAbstractVideoBuffer_Type.type_discovery->addTypeDiscoveryFunction(&SbkQAbstractVideoBuffer_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractVideoBuffer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractVideoBuffer_Type));
    PyModule_AddObject(module, "QAbstractVideoBuffer",
        ((PyObject*)&SbkQAbstractVideoBuffer_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: MapMode
    SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX] = &SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type);
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
            "MapMode",((PyObject*)&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type,
        (long) QAbstractVideoBuffer::NotMapped, "NotMapped");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "NotMapped", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type.tp_dict,
        "NotMapped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type,
        (long) QAbstractVideoBuffer::ReadOnly, "ReadOnly");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "ReadOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type.tp_dict,
        "ReadOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type,
        (long) QAbstractVideoBuffer::WriteOnly, "WriteOnly");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "WriteOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type.tp_dict,
        "WriteOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type,
        (long) QAbstractVideoBuffer::ReadWrite, "ReadWrite");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "ReadWrite", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Type.tp_dict,
        "ReadWrite", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractVideoBuffer::MapMode");

    // init enum class: HandleType
    SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX] = &SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type);
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
            "HandleType",((PyObject*)&SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type,
        (long) QAbstractVideoBuffer::NoHandle, "NoHandle");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "NoHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type.tp_dict,
        "NoHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type,
        (long) QAbstractVideoBuffer::GLTextureHandle, "GLTextureHandle");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "GLTextureHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type.tp_dict,
        "GLTextureHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type,
        (long) QAbstractVideoBuffer::UserHandle, "UserHandle");
    PyDict_SetItemString(SbkQAbstractVideoBuffer_Type.super.ht_type.tp_dict,
        "UserHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Type.tp_dict,
        "UserHandle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractVideoBuffer::HandleType");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractVideoBuffer >("QAbstractVideoBuffer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractVideoBuffer >(typeid(QAbstractVideoBuffer).name());
}


} // extern "C"

