/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtouchevent_wrapper.h"
#include "qtouchevent_touchpoint_wrapper.h"

// Extra includes
#include <QList>
#include <qevent.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTouchEventWrapper::~QTouchEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static PyObject* SbkQTouchEventFunc_deviceType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // deviceType()const
    QTouchEvent* cppSelf = Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self);
    QTouchEvent::DeviceType cpp_result = cppSelf->QTouchEvent::deviceType();
    py_result = Shiboken::Converter<QTouchEvent::DeviceType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTouchEventFunc_setDeviceType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTouchEvent::DeviceType >::isConvertible(arg)) {
        QTouchEvent::DeviceType cpp_arg0 = Shiboken::Converter<QTouchEvent::DeviceType >::toCpp(arg);
        // setDeviceType(QTouchEvent::DeviceType)
        QTouchEvent* cppSelf = Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self);
        cppSelf->QTouchEvent::setDeviceType(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTouchEventFunc_setDeviceType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEventFunc_setDeviceType_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTouchEvent.DeviceType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTouchEvent.setDeviceType", overloads);
        return 0;
}

static PyObject* SbkQTouchEventFunc_setTouchPoints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTouchEvent::TouchPoint >  >::isConvertible(arg)) {
        QList<QTouchEvent::TouchPoint >  cpp_arg0 = Shiboken::Converter<QList<QTouchEvent::TouchPoint >  >::toCpp(arg);
        // setTouchPoints(QList<QTouchEvent::TouchPoint>)
        QTouchEvent* cppSelf = Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self);
        cppSelf->QTouchEvent::setTouchPoints(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTouchEventFunc_setTouchPoints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEventFunc_setTouchPoints_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTouchEvent.setTouchPoints", overloads);
        return 0;
}

static PyObject* SbkQTouchEventFunc_setWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setWidget(QWidget*)
        QTouchEvent* cppSelf = Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self);
        cppSelf->QTouchEvent::setWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTouchEventFunc_setWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEventFunc_setWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTouchEvent.setWidget", overloads);
        return 0;
}

static PyObject* SbkQTouchEventFunc_touchPoints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // touchPoints()const
    QTouchEvent* cppSelf = Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self);
    const QList<QTouchEvent::TouchPoint > & cpp_result = cppSelf->QTouchEvent::touchPoints();
    py_result = Shiboken::Converter<QList<QTouchEvent::TouchPoint >  >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTouchEventFunc_widget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widget()const
    QTouchEvent* cppSelf = Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QTouchEvent::widget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTouchEvent_methods[] = {
    {"deviceType", (PyCFunction)SbkQTouchEventFunc_deviceType, METH_NOARGS},
    {"setDeviceType", (PyCFunction)SbkQTouchEventFunc_setDeviceType, METH_O},
    {"setTouchPoints", (PyCFunction)SbkQTouchEventFunc_setTouchPoints, METH_O},
    {"setWidget", (PyCFunction)SbkQTouchEventFunc_setWidget, METH_O},
    {"touchPoints", (PyCFunction)SbkQTouchEventFunc_touchPoints, METH_NOARGS},
    {"widget", (PyCFunction)SbkQTouchEventFunc_widget, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQTouchEvent_get__touchPoints(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QList<QTouchEvent::TouchPoint > >::toPython(Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self)->_touchPoints);
}
static int SbkQTouchEvent_set__touchPoints(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'_touchPoints' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QList<QTouchEvent::TouchPoint > >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to '_touchPoints', 'QList' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self)->_touchPoints = Shiboken::Converter<QList<QTouchEvent::TouchPoint > >::toCpp(value);

    return 0;
}

static PyObject* SbkQTouchEvent_get__deviceType(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTouchEvent::DeviceType >::toPython(Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self)->_deviceType);
}
static int SbkQTouchEvent_set__deviceType(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'_deviceType' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTouchEvent::DeviceType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to '_deviceType', 'DeviceType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self)->_deviceType = Shiboken::Converter<QTouchEvent::DeviceType >::toCpp(value);

    return 0;
}

static PyObject* SbkQTouchEvent_get__widget(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QWidget * >::toPython(Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self)->_widget);
}
static int SbkQTouchEvent_set__widget(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'_widget' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QWidget * >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to '_widget', 'QWidget' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTouchEvent* >::toCpp((PyObject*)self)->_widget = Shiboken::Converter<QWidget * >::toCpp(value);

    Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "_widget", value);

    return 0;
}

// Getters and Setters for QTouchEvent
static PyGetSetDef SbkQTouchEvent_getsetlist[] = {
    {const_cast<char*>("_touchPoints"), (getter)SbkQTouchEvent_get__touchPoints, (setter)SbkQTouchEvent_set__touchPoints},
    {const_cast<char*>("_deviceType"), (getter)SbkQTouchEvent_get__deviceType, (setter)SbkQTouchEvent_set__deviceType},
    {const_cast<char*>("_widget"), (getter)SbkQTouchEvent_get__widget, (setter)SbkQTouchEvent_set__widget},
    {0}  // Sentinel
};

extern "C"
{

static void* SbkQTouchEvent_ObjCopierFunc(const void* ptr){
    return new QTouchEventWrapper(*reinterpret_cast<const QTouchEvent*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTouchEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTouchEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTouchEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTouchEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTouchEvent_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTouchEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTouchEvent_DeviceType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTouchEvent_DeviceType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTouchEvent_DeviceType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DeviceType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTouchEvent_DeviceType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTouchEvent_DeviceType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTouchEvent_DeviceType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTouchEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTouchEvent_Type);

    SbkQTouchEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX];
    // Fill type discovery information
    SbkQTouchEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTouchEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTouchEvent_Type));
    PyModule_AddObject(module, "QTouchEvent",
        ((PyObject*)&SbkQTouchEvent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: DeviceType
    SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_DEVICETYPE_IDX] = &SbkPySide_QtGui_QTouchEvent_DeviceType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTouchEvent_DeviceType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTouchEvent_DeviceType_Type);
    PyDict_SetItemString(SbkQTouchEvent_Type.super.ht_type.tp_dict,
            "DeviceType",((PyObject*)&SbkPySide_QtGui_QTouchEvent_DeviceType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTouchEvent_DeviceType_Type,
        (long) QTouchEvent::TouchScreen, "TouchScreen");
    PyDict_SetItemString(SbkQTouchEvent_Type.super.ht_type.tp_dict,
        "TouchScreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTouchEvent_DeviceType_Type.tp_dict,
        "TouchScreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTouchEvent_DeviceType_Type,
        (long) QTouchEvent::TouchPad, "TouchPad");
    PyDict_SetItemString(SbkQTouchEvent_Type.super.ht_type.tp_dict,
        "TouchPad", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTouchEvent_DeviceType_Type.tp_dict,
        "TouchPad", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTouchEvent::DeviceType");

    Shiboken::TypeResolver::createValueTypeResolver<QTouchEvent >("QTouchEvent");
    Shiboken::TypeResolver::createValueTypeResolver<QTouchEvent >(typeid(QTouchEvent).name());
}


} // extern "C"

