/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextoption_wrapper.h"
#include "qtextoption_tab_wrapper.h"

// Extra includes
#include <QList>
#include <qtextoption.h>

using namespace Shiboken;

static int
SbkQTextOption_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextOption* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextOption", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextOption()
        cptr = new QTextOption();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[0])) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[0]);
        // QTextOption(QFlags<Qt::AlignmentFlag>)
        cptr = new QTextOption(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextOption & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QTextOption > cpp_arg0_auto_ptr;
        QTextOption* cpp_arg0 = Shiboken::Converter<QTextOption* >::toCpp(pyargs[0]);
        if (!SbkQTextOption_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QTextOption >(cpp_arg0);
        // QTextOption(QTextOption)
        cptr = new QTextOption(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOption_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextOption >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextOption_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextOption_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.Alignment", "PySide.QtGui.QTextOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextOption", overloads);
        return -1;
}

static PyObject* SbkQTextOptionFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QTextOption::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    QFlags<QTextOption::Flag> cpp_result = cppSelf->QTextOption::flags();
    py_result = Shiboken::Converter<QFlags<QTextOption::Flag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setAlignment(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setAlignment", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QTextOption_Flag_Check(arg)) {
        QFlags<QTextOption::Flag> cpp_arg0 = Shiboken::Converter<QFlags<QTextOption::Flag> >::toCpp(arg);
        // setFlags(QFlags<QTextOption::Flag>)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setFlags(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setFlags_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextOption.Flags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setFlags", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setTabArray(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<qreal > >::isConvertible(arg)) {
        QList<qreal > cpp_arg0 = Shiboken::Converter<QList<qreal > >::toCpp(arg);
        // setTabArray(QList<qreal>)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setTabArray(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setTabArray_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setTabArray_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setTabArray", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setTabStop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTabStop(qreal)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setTabStop(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setTabStop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setTabStop_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setTabStop", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setTabs(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTextOption::Tab > >::isConvertible(arg)) {
        QList<QTextOption::Tab > cpp_arg0 = Shiboken::Converter<QList<QTextOption::Tab > >::toCpp(arg);
        // setTabs(QList<QTextOption::Tab>)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setTabs(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setTabs_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setTabs_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setTabs", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setTextDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::LayoutDirection >::isConvertible(arg)) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(arg);
        // setTextDirection(Qt::LayoutDirection)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setTextDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setTextDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setTextDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setTextDirection", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setUseDesignMetrics(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUseDesignMetrics(bool)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setUseDesignMetrics(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setUseDesignMetrics_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setUseDesignMetrics_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setUseDesignMetrics", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_setWrapMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextOption::WrapMode >::isConvertible(arg)) {
        QTextOption::WrapMode cpp_arg0 = Shiboken::Converter<QTextOption::WrapMode >::toCpp(arg);
        // setWrapMode(QTextOption::WrapMode)
        QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
        cppSelf->QTextOption::setWrapMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextOptionFunc_setWrapMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextOptionFunc_setWrapMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextOption.WrapMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextOption.setWrapMode", overloads);
        return 0;
}

static PyObject* SbkQTextOptionFunc_tabArray(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabArray()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    QList<qreal > cpp_result = cppSelf->QTextOption::tabArray();
    py_result = Shiboken::Converter<QList<qreal > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_tabStop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabStop()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextOption::tabStop();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_tabs(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabs()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    QList<QTextOption::Tab > cpp_result = cppSelf->QTextOption::tabs();
    py_result = Shiboken::Converter<QList<QTextOption::Tab > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_textDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textDirection()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    Qt::LayoutDirection cpp_result = cppSelf->QTextOption::textDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_useDesignMetrics(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // useDesignMetrics()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextOption::useDesignMetrics();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextOptionFunc_wrapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wrapMode()const
    QTextOption* cppSelf = Shiboken::Converter<QTextOption* >::toCpp((PyObject*)self);
    QTextOption::WrapMode cpp_result = cppSelf->QTextOption::wrapMode();
    py_result = Shiboken::Converter<QTextOption::WrapMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextOption_methods[] = {
    {"alignment", (PyCFunction)SbkQTextOptionFunc_alignment, METH_NOARGS},
    {"flags", (PyCFunction)SbkQTextOptionFunc_flags, METH_NOARGS},
    {"setAlignment", (PyCFunction)SbkQTextOptionFunc_setAlignment, METH_O},
    {"setFlags", (PyCFunction)SbkQTextOptionFunc_setFlags, METH_O},
    {"setTabArray", (PyCFunction)SbkQTextOptionFunc_setTabArray, METH_O},
    {"setTabStop", (PyCFunction)SbkQTextOptionFunc_setTabStop, METH_O},
    {"setTabs", (PyCFunction)SbkQTextOptionFunc_setTabs, METH_O},
    {"setTextDirection", (PyCFunction)SbkQTextOptionFunc_setTextDirection, METH_O},
    {"setUseDesignMetrics", (PyCFunction)SbkQTextOptionFunc_setUseDesignMetrics, METH_O},
    {"setWrapMode", (PyCFunction)SbkQTextOptionFunc_setWrapMode, METH_O},
    {"tabArray", (PyCFunction)SbkQTextOptionFunc_tabArray, METH_NOARGS},
    {"tabStop", (PyCFunction)SbkQTextOptionFunc_tabStop, METH_NOARGS},
    {"tabs", (PyCFunction)SbkQTextOptionFunc_tabs, METH_NOARGS},
    {"textDirection", (PyCFunction)SbkQTextOptionFunc_textDirection, METH_NOARGS},
    {"useDesignMetrics", (PyCFunction)SbkQTextOptionFunc_useDesignMetrics, METH_NOARGS},
    {"wrapMode", (PyCFunction)SbkQTextOptionFunc_wrapMode, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextOption_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextOption_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextOption_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextOption >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTextOption_TabType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextOption_TabType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextOption_TabType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TabType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextOption_TabType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextOption_TabType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextOption_TabType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QTextOption_Flag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextOption::Flags >::toPython(
        ((QTextOption::Flags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextOption::Flags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextOption_Flag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextOption::Flags >::toPython(
        ((QTextOption::Flags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextOption::Flags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextOption_Flag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextOption::Flags >::toPython(
        ((QTextOption::Flags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextOption::Flags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextOption_Flag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextOption::Flags >::toPython(
        ~ Shiboken::Converter< QTextOption::Flags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QTextOption_Flag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QTextOption_Flag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QTextOption_Flag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QTextOption_Flag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QTextOption_Flag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QTextOption_Flag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextOption_Flag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextOption_Flag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Flag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QTextOption_Flag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextOption_Flag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextOption_Flag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextOption_Flag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextOption_Flags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextOption_Flags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Flags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QTextOption_Flag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextOption_Flags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextOption_Flags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QTextOption_Flags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QTextOption_WrapMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextOption_WrapMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextOption_WrapMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WrapMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextOption_WrapMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextOption_WrapMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextOption_WrapMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTextOption(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextOption_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextOption_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextOption_Type));
    PyModule_AddObject(module, "QTextOption",
        ((PyObject*)&SbkQTextOption_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: TabType
    SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX] = &SbkPySide_QtGui_QTextOption_TabType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextOption_TabType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextOption_TabType_Type);
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
            "TabType",((PyObject*)&SbkPySide_QtGui_QTextOption_TabType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_TabType_Type,
        (long) QTextOption::LeftTab, "LeftTab");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "LeftTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_TabType_Type.tp_dict,
        "LeftTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_TabType_Type,
        (long) QTextOption::RightTab, "RightTab");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "RightTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_TabType_Type.tp_dict,
        "RightTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_TabType_Type,
        (long) QTextOption::CenterTab, "CenterTab");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "CenterTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_TabType_Type.tp_dict,
        "CenterTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_TabType_Type,
        (long) QTextOption::DelimiterTab, "DelimiterTab");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "DelimiterTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_TabType_Type.tp_dict,
        "DelimiterTab", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextOption::TabType");

    // init enum class: Flag
    SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX] = &SbkPySide_QtGui_QTextOption_Flag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextOption_Flag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextOption_Flag_Type);
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
            "Flag",((PyObject*)&SbkPySide_QtGui_QTextOption_Flag_Type));

    // init flags class: QFlags<QTextOption::Flag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG__IDX] = &SbkPySide_QtGui_QTextOption_Flags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextOption_Flags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextOption_Flags_Type);
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
            "Flags",((PyObject*)&SbkPySide_QtGui_QTextOption_Flags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_Flag_Type,
        (long) QTextOption::ShowTabsAndSpaces, "ShowTabsAndSpaces");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "ShowTabsAndSpaces", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_Flag_Type.tp_dict,
        "ShowTabsAndSpaces", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_Flag_Type,
        (long) QTextOption::ShowLineAndParagraphSeparators, "ShowLineAndParagraphSeparators");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "ShowLineAndParagraphSeparators", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_Flag_Type.tp_dict,
        "ShowLineAndParagraphSeparators", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_Flag_Type,
        (long) QTextOption::AddSpaceForLineAndParagraphSeparators, "AddSpaceForLineAndParagraphSeparators");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "AddSpaceForLineAndParagraphSeparators", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_Flag_Type.tp_dict,
        "AddSpaceForLineAndParagraphSeparators", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_Flag_Type,
        (long) QTextOption::SuppressColors, "SuppressColors");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "SuppressColors", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_Flag_Type.tp_dict,
        "SuppressColors", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_Flag_Type,
        (long) QTextOption::IncludeTrailingSpaces, "IncludeTrailingSpaces");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "IncludeTrailingSpaces", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_Flag_Type.tp_dict,
        "IncludeTrailingSpaces", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextOption::Flag");

    // init enum class: WrapMode
    SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX] = &SbkPySide_QtGui_QTextOption_WrapMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextOption_WrapMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextOption_WrapMode_Type);
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
            "WrapMode",((PyObject*)&SbkPySide_QtGui_QTextOption_WrapMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_WrapMode_Type,
        (long) QTextOption::NoWrap, "NoWrap");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "NoWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_WrapMode_Type.tp_dict,
        "NoWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_WrapMode_Type,
        (long) QTextOption::WordWrap, "WordWrap");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "WordWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_WrapMode_Type.tp_dict,
        "WordWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_WrapMode_Type,
        (long) QTextOption::ManualWrap, "ManualWrap");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "ManualWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_WrapMode_Type.tp_dict,
        "ManualWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_WrapMode_Type,
        (long) QTextOption::WrapAnywhere, "WrapAnywhere");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "WrapAnywhere", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_WrapMode_Type.tp_dict,
        "WrapAnywhere", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextOption_WrapMode_Type,
        (long) QTextOption::WrapAtWordBoundaryOrAnywhere, "WrapAtWordBoundaryOrAnywhere");
    PyDict_SetItemString(SbkQTextOption_Type.super.ht_type.tp_dict,
        "WrapAtWordBoundaryOrAnywhere", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextOption_WrapMode_Type.tp_dict,
        "WrapAtWordBoundaryOrAnywhere", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextOption::WrapMode");

    Shiboken::TypeResolver::createValueTypeResolver<QTextOption >("QTextOption");
    Shiboken::TypeResolver::createValueTypeResolver<QTextOption >(typeid(QTextOption).name());
}


} // extern "C"

