/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextlistformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpen.h>
#include <qstring.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextListFormatWrapper::QTextListFormatWrapper() : QTextListFormat() {
    // ... middle
}

QTextListFormatWrapper::QTextListFormatWrapper(const QTextFormat & fmt) : QTextListFormat(fmt) {
    // ... middle
}

QTextListFormatWrapper::~QTextListFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextListFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextListFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextListFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextListFormat()
        cptr = new QTextListFormatWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextListFormat(QTextFormat)
        cptr = new QTextListFormatWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextListFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextListFormat* cpp_arg0 = Shiboken::Converter<QTextListFormat* >::toCpp(pyargs[0]);
        // QTextListFormat(QTextListFormat)
        cptr = new QTextListFormatWrapper(*reinterpret_cast<QTextListFormatWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextListFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextListFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextListFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextListFormat_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextListFormat", "", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextListFormat", overloads);
        return -1;
}

static PyObject* SbkQTextListFormatFunc_indent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indent()const
    QTextListFormat* cppSelf = Shiboken::Converter<QTextListFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextListFormat::indent();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextListFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextListFormat* cppSelf = Shiboken::Converter<QTextListFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextListFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextListFormatFunc_setIndent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIndent(int)
        QTextListFormat* cppSelf = Shiboken::Converter<QTextListFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextListFormat::setIndent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextListFormatFunc_setIndent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextListFormatFunc_setIndent_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextListFormat.setIndent", overloads);
        return 0;
}

static PyObject* SbkQTextListFormatFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextListFormat::Style >::isConvertible(arg)) {
        QTextListFormat::Style cpp_arg0 = Shiboken::Converter<QTextListFormat::Style >::toCpp(arg);
        // setStyle(QTextListFormat::Style)
        QTextListFormat* cppSelf = Shiboken::Converter<QTextListFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextListFormat::setStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextListFormatFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextListFormatFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextListFormat.Style", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextListFormat.setStyle", overloads);
        return 0;
}

static PyObject* SbkQTextListFormatFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QTextListFormat* cppSelf = Shiboken::Converter<QTextListFormat* >::toCpp((PyObject*)self);
    QTextListFormat::Style cpp_result = cppSelf->QTextListFormat::style();
    py_result = Shiboken::Converter<QTextListFormat::Style >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextListFormat_methods[] = {
    {"indent", (PyCFunction)SbkQTextListFormatFunc_indent, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextListFormatFunc_isValid, METH_NOARGS},
    {"setIndent", (PyCFunction)SbkQTextListFormatFunc_setIndent, METH_O},
    {"setStyle", (PyCFunction)SbkQTextListFormatFunc_setStyle, METH_O},
    {"style", (PyCFunction)SbkQTextListFormatFunc_style, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextListFormat_ObjCopierFunc(const void* ptr){
    return new QTextListFormatWrapper(*reinterpret_cast<const QTextListFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextListFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextListFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextListFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextListFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextListFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextListFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTextListFormat_Style_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextListFormat_Style_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextListFormat_Style_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Style",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextListFormat_Style_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextListFormat_Style_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextListFormat_Style_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTextListFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextListFormat_Type);

    SbkQTextListFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX];
    // Fill type discovery information
    SbkQTextListFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextListFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextListFormat_Type));
    PyModule_AddObject(module, "QTextListFormat",
        ((PyObject*)&SbkQTextListFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Style
    SbkPySide_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX] = &SbkPySide_QtGui_QTextListFormat_Style_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextListFormat_Style_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextListFormat_Style_Type);
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
            "Style",((PyObject*)&SbkPySide_QtGui_QTextListFormat_Style_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListDisc, "ListDisc");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListDisc", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListDisc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListCircle, "ListCircle");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListCircle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListCircle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListSquare, "ListSquare");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListSquare", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListSquare", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListDecimal, "ListDecimal");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListDecimal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListDecimal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListLowerAlpha, "ListLowerAlpha");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListLowerAlpha", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListLowerAlpha", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListUpperAlpha, "ListUpperAlpha");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListUpperAlpha", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListUpperAlpha", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListLowerRoman, "ListLowerRoman");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListLowerRoman", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListLowerRoman", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListUpperRoman, "ListUpperRoman");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListUpperRoman", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListUpperRoman", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextListFormat_Style_Type,
        (long) QTextListFormat::ListStyleUndefined, "ListStyleUndefined");
    PyDict_SetItemString(SbkQTextListFormat_Type.super.ht_type.tp_dict,
        "ListStyleUndefined", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextListFormat_Style_Type.tp_dict,
        "ListStyleUndefined", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextListFormat::Style");

    Shiboken::TypeResolver::createValueTypeResolver<QTextListFormat >("QTextListFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextListFormat >(typeid(QTextListFormat).name());
}


} // extern "C"

