/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qquaternion_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qquaternion.h>
#include <qvariant.h>
#include <qvector3d.h>
#include <qvector4d.h>

using namespace Shiboken;

static int
SbkQQuaternion_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QQuaternion* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQQuaternion_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QQuaternion", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QQuaternion()
        cptr = new QQuaternion();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (numArgs == 4 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // QQuaternion(qreal,qreal,qreal,qreal)
            cptr = new QQuaternion(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            // QQuaternion(qreal,QVector3D)
            cptr = new QQuaternion(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQQuaternion_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QVector4D & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[0]);
        if (!SbkQVector4D_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // QQuaternion(QVector4D)
        cptr = new QQuaternion(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QQuaternion & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[0]);
        // QQuaternion(QQuaternion)
        cptr = new QQuaternion(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternion_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QQuaternion >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQQuaternion_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQQuaternion_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", "", "PySide.QtGui.QVector4D", "float, PySide.QtGui.QVector3D", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QQuaternion", overloads);
        return -1;
}

static PyObject* SbkQQuaternionFunc_conjugate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // conjugate()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    QQuaternion cpp_result = cppSelf->QQuaternion::conjugate();
    py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_fromAxisAndAngle(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQQuaternionFunc_fromAxisAndAngle_TypeError;

    if (!PyArg_UnpackTuple(args, "fromAxisAndAngle", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // fromAxisAndAngle(qreal,qreal,qreal,qreal)
        QQuaternion cpp_result = QQuaternion::fromAxisAndAngle(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!SbkQVector3D_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // fromAxisAndAngle(QVector3D,qreal)
        QQuaternion cpp_result = QQuaternion::fromAxisAndAngle(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_fromAxisAndAngle_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc_fromAxisAndAngle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D, float", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QQuaternion.fromAxisAndAngle", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_isIdentity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isIdentity()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QQuaternion::isIdentity();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QQuaternion::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QQuaternion::length();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_lengthSquared(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lengthSquared()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QQuaternion::lengthSquared();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_nlerp(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "nlerp", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QQuaternion & >::isConvertible(pyargs[0]) && Shiboken::Converter<QQuaternion & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QQuaternion* cpp_arg1 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // nlerp(QQuaternion,QQuaternion,qreal)
        QQuaternion cpp_result = QQuaternion::nlerp(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_nlerp_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc_nlerp_TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion, PySide.QtGui.QQuaternion, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QQuaternion.nlerp", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_normalize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // normalize()
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    cppSelf->QQuaternion::normalize();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQQuaternionFunc_normalized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalized()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    QQuaternion cpp_result = cppSelf->QQuaternion::normalized();
    py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_rotatedVector(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVector3D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(arg);
        if (!SbkQVector3D_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // rotatedVector(QVector3D)const
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        QVector3D cpp_result = cppSelf->QQuaternion::rotatedVector(*cpp_arg0);
        py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_rotatedVector_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc_rotatedVector_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.rotatedVector", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_scalar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scalar()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QQuaternion::scalar();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_setScalar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setScalar(qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        cppSelf->QQuaternion::setScalar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_setScalar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQQuaternionFunc_setScalar_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.setScalar", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_setVector(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQQuaternionFunc_setVector_TypeError;

    if (!PyArg_UnpackTuple(args, "setVector", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // setVector(qreal,qreal,qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        cppSelf->QQuaternion::setVector(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!SbkQVector3D_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // setVector(QVector3D)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        cppSelf->QQuaternion::setVector(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_setVector_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQQuaternionFunc_setVector_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D", "float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QQuaternion.setVector", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setX(qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        cppSelf->QQuaternion::setX(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQQuaternionFunc_setX_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.setX", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setY(qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        cppSelf->QQuaternion::setY(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQQuaternionFunc_setY_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.setY", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_setZ(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setZ(qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        cppSelf->QQuaternion::setZ(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_setZ_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQQuaternionFunc_setZ_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.setZ", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_slerp(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "slerp", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QQuaternion & >::isConvertible(pyargs[0]) && Shiboken::Converter<QQuaternion & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QQuaternion* cpp_arg1 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // slerp(QQuaternion,QQuaternion,qreal)
        QQuaternion cpp_result = QQuaternion::slerp(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc_slerp_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc_slerp_TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion, PySide.QtGui.QQuaternion, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QQuaternion.slerp", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc_toVector4D(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector4D()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    QVector4D cpp_result = cppSelf->QQuaternion::toVector4D();
    py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_vector(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // vector()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    QVector3D cpp_result = cppSelf->QQuaternion::vector();
    py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QQuaternion::x();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QQuaternion::y();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc_z(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // z()const
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QQuaternion::z();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQQuaternion_methods[] = {
    {"conjugate", (PyCFunction)SbkQQuaternionFunc_conjugate, METH_NOARGS},
    {"fromAxisAndAngle", (PyCFunction)SbkQQuaternionFunc_fromAxisAndAngle, METH_VARARGS|METH_STATIC},
    {"isIdentity", (PyCFunction)SbkQQuaternionFunc_isIdentity, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQQuaternionFunc_isNull, METH_NOARGS},
    {"length", (PyCFunction)SbkQQuaternionFunc_length, METH_NOARGS},
    {"lengthSquared", (PyCFunction)SbkQQuaternionFunc_lengthSquared, METH_NOARGS},
    {"nlerp", (PyCFunction)SbkQQuaternionFunc_nlerp, METH_VARARGS|METH_STATIC},
    {"normalize", (PyCFunction)SbkQQuaternionFunc_normalize, METH_NOARGS},
    {"normalized", (PyCFunction)SbkQQuaternionFunc_normalized, METH_NOARGS},
    {"rotatedVector", (PyCFunction)SbkQQuaternionFunc_rotatedVector, METH_O},
    {"scalar", (PyCFunction)SbkQQuaternionFunc_scalar, METH_NOARGS},
    {"setScalar", (PyCFunction)SbkQQuaternionFunc_setScalar, METH_O},
    {"setVector", (PyCFunction)SbkQQuaternionFunc_setVector, METH_VARARGS},
    {"setX", (PyCFunction)SbkQQuaternionFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQQuaternionFunc_setY, METH_O},
    {"setZ", (PyCFunction)SbkQQuaternionFunc_setZ, METH_O},
    {"slerp", (PyCFunction)SbkQQuaternionFunc_slerp, METH_VARARGS|METH_STATIC},
    {"toVector4D", (PyCFunction)SbkQQuaternionFunc_toVector4D, METH_NOARGS},
    {"vector", (PyCFunction)SbkQQuaternionFunc_vector, METH_NOARGS},
    {"x", (PyCFunction)SbkQQuaternionFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQQuaternionFunc_y, METH_NOARGS},
    {"z", (PyCFunction)SbkQQuaternionFunc_z, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQQuaternionFunc___mul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rmul__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rmul__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QQuaternion) [reverse operator]
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        const QQuaternion cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QQuaternion,qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        const QQuaternion cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QQuaternion & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(arg);
        // operator*(QQuaternion,QQuaternion)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        const QQuaternion cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___mul___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", "float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__mul__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___imul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QQuaternion & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(arg);
        // operator*=(QQuaternion)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        (*cppSelf) *= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQQuaternionFunc___imul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__imul__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___add__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QQuaternion & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(arg);
        // operator+(QQuaternion,QQuaternion)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        const QQuaternion cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___add___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__add__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___iadd__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QQuaternion & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(arg);
        // operator+=(QQuaternion)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQQuaternionFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__iadd__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___neg__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    // operator-(QQuaternion)
    QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
    const QQuaternion cpp_result = - (*cppSelf);
    py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQQuaternionFunc___sub__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rsub__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rsub__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QQuaternion & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(arg);
        // operator-(QQuaternion,QQuaternion)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        const QQuaternion cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___sub___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__sub__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___isub__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QQuaternion & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(arg);
        // operator-=(QQuaternion)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQQuaternionFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__isub__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___div__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rdiv__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rdiv__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QQuaternion,qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        const QQuaternion cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QQuaternion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___div___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__div__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___idiv__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else goto SbkQQuaternionFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQQuaternionFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__idiv__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QQuaternion) [reverse operator]
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQQuaternionFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQQuaternionFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQQuaternion_Check(arg) && !SbkQQuaternion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QQuaternion&) [reverse operator]
        QQuaternion* cppSelf = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQQuaternionFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQQuaternionFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QQuaternion.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQQuaternion_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQQuaternionFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQQuaternionFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQQuaternionFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQQuaternionFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)SbkQQuaternionFunc___neg__,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQQuaternionFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQQuaternionFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQQuaternionFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQQuaternionFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQQuaternionFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQQuaternionFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQQuaternion_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QQuaternion& cpp_self = *Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QQuaternion & >::isConvertible(other)) {
                // operator!=(const QQuaternion & q2)
                QQuaternion* cpp_other = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QQuaternion  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQQuaternion_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QQuaternion & >::isConvertible(other)) {
                // operator==(const QQuaternion & q2)
                QQuaternion* cpp_other = Shiboken::Converter<QQuaternion* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QQuaternion  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQQuaternion_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQQuaternion_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQQuaternion_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QQuaternion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQQuaternion_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQQuaternion_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQQuaternion_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQQuaternion_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QQuaternion >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QQuaternion(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QQUATERNION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQQuaternion_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQQuaternion_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQQuaternion_Type));
    PyModule_AddObject(module, "QQuaternion",
        ((PyObject*)&SbkQQuaternion_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QQuaternion >("QQuaternion");
    Shiboken::TypeResolver::createValueTypeResolver<QQuaternion >(typeid(QQuaternion).name());
}


} // extern "C"

