/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qmatrix2x4_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQMatrix2x4_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMatrix2x4* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QMatrix2x4", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QMatrix2x4()
        cptr = new QMatrix2x4();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QMatrix2x4 & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QMatrix2x4* cpp_arg0 = Shiboken::Converter<QMatrix2x4* >::toCpp(pyargs[0]);
        // QMatrix2x4(QMatrix2x4)
        cptr = new QMatrix2x4(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMatrix2x4_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMatrix2x4 >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMatrix2x4_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMatrix2x4_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QMatrix2x4", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix2x4", overloads);
        return -1;
}

static PyMethodDef SbkQMatrix2x4_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMatrix2x4_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMatrix2x4",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMatrix2x4_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMatrix2x4_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMatrix2x4 >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QMatrix2x4(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMATRIX2X4_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMatrix2x4_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQMatrix2x4_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMatrix2x4_Type));
    PyModule_AddObject(module, "QMatrix2x4",
        ((PyObject*)&SbkQMatrix2x4_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QMatrix2x4 >("QMatrix2x4");
    Shiboken::TypeResolver::createValueTypeResolver<QMatrix2x4 >(typeid(QMatrix2x4).name());
}


} // extern "C"

