/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsscenedragdropevent_wrapper.h"

// Extra includes
#include <qmimedata.h>
#include <qpoint.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsSceneDragDropEventWrapper::QGraphicsSceneDragDropEventWrapper(QEvent::Type type) : QGraphicsSceneDragDropEvent(type) {
    // ... middle
}

QGraphicsSceneDragDropEventWrapper::~QGraphicsSceneDragDropEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsSceneDragDropEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneDragDropEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsSceneDragDropEvent", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsSceneDragDropEvent(QEvent::Type)
        cptr = new QGraphicsSceneDragDropEventWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        // QGraphicsSceneDragDropEvent(QEvent::Type)
        cptr = new QGraphicsSceneDragDropEventWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsSceneDragDropEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsSceneDragDropEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsSceneDragDropEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneDragDropEvent", overloads);
        return -1;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_acceptProposedAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // acceptProposedAction()
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsSceneDragDropEvent::acceptProposedAction();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::MouseButton> cpp_result = cppSelf->QGraphicsSceneDragDropEvent::buttons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_dropAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dropAction()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    Qt::DropAction cpp_result = cppSelf->QGraphicsSceneDragDropEvent::dropAction();
    py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_mimeData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeData()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    const QMimeData * cpp_result = cppSelf->QGraphicsSceneDragDropEvent::mimeData();
    py_result = Shiboken::Converter<QMimeData * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_modifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifiers()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QGraphicsSceneDragDropEvent::modifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneDragDropEvent::pos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_possibleActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // possibleActions()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QGraphicsSceneDragDropEvent::possibleActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_proposedAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proposedAction()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    Qt::DropAction cpp_result = cppSelf->QGraphicsSceneDragDropEvent::proposedAction();
    py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_scenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scenePos()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneDragDropEvent::scenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_screenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenPos()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneDragDropEvent::screenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_MouseButton_Check(arg)) {
        QFlags<Qt::MouseButton> cpp_arg0 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(arg);
        // setButtons(QFlags<Qt::MouseButton>)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setButtons_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButtons", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setButtons", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setDropAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::DropAction >::isConvertible(arg)) {
        Qt::DropAction cpp_arg0 = Shiboken::Converter<Qt::DropAction >::toCpp(arg);
        // setDropAction(Qt::DropAction)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setDropAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setDropAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setDropAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setDropAction", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setModifiers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(arg)) {
        QFlags<Qt::KeyboardModifier> cpp_arg0 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(arg);
        // setModifiers(QFlags<Qt::KeyboardModifier>)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setModifiers(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setModifiers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setModifiers_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setModifiers", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPos(QPointF)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setPossibleActions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_DropAction_Check(arg)) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(arg);
        // setPossibleActions(QFlags<Qt::DropAction>)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setPossibleActions(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setPossibleActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setPossibleActions_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setPossibleActions", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setProposedAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::DropAction >::isConvertible(arg)) {
        Qt::DropAction cpp_arg0 = Shiboken::Converter<Qt::DropAction >::toCpp(arg);
        // setProposedAction(Qt::DropAction)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setProposedAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setProposedAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setProposedAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setProposedAction", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScenePos(QPointF)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setScenePos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setScenePos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_setScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setScreenPos(QPoint)
        QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneDragDropEvent::setScreenPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneDragDropEventFunc_setScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneDragDropEventFunc_setScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneDragDropEvent.setScreenPos", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneDragDropEventFunc_source(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // source()const
    QGraphicsSceneDragDropEvent* cppSelf = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QGraphicsSceneDragDropEvent::source();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGraphicsSceneDragDropEvent_methods[] = {
    {"acceptProposedAction", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_acceptProposedAction, METH_NOARGS},
    {"buttons", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_buttons, METH_NOARGS},
    {"dropAction", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_dropAction, METH_NOARGS},
    {"mimeData", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_mimeData, METH_NOARGS},
    {"modifiers", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_modifiers, METH_NOARGS},
    {"pos", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_pos, METH_NOARGS},
    {"possibleActions", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_possibleActions, METH_NOARGS},
    {"proposedAction", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_proposedAction, METH_NOARGS},
    {"scenePos", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_scenePos, METH_NOARGS},
    {"screenPos", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_screenPos, METH_NOARGS},
    {"setButtons", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setButtons, METH_O},
    {"setDropAction", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setDropAction, METH_O},
    {"setModifiers", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setModifiers, METH_O},
    {"setPos", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setPos, METH_O},
    {"setPossibleActions", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setPossibleActions, METH_O},
    {"setProposedAction", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setProposedAction, METH_O},
    {"setScenePos", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setScenePos, METH_O},
    {"setScreenPos", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_setScreenPos, METH_O},
    {"source", (PyCFunction)SbkQGraphicsSceneDragDropEventFunc_source, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsSceneDragDropEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsSceneDragDropEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsSceneDragDropEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsSceneDragDropEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsSceneDragDropEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQGraphicsSceneDragDropEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQGraphicsSceneDragDropEvent_Type);
     if ( reinterpret_cast<QGraphicsSceneDragDropEvent*>(cptr)->type() == QEvent::GraphicsSceneDragEnter ||  reinterpret_cast<QGraphicsSceneDragDropEvent*>(cptr)->type() == QEvent::GraphicsSceneDragLeave ||  reinterpret_cast<QGraphicsSceneDragDropEvent*>(cptr)->type() == QEvent::GraphicsSceneDragMove ||  reinterpret_cast<QGraphicsSceneDragDropEvent*>(cptr)->type() == QEvent::GraphicsSceneDrop)
        return &SbkQGraphicsSceneDragDropEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QGraphicsSceneDragDropEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsSceneDragDropEvent_Type);

    SbkQGraphicsSceneDragDropEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX];
    // Fill type discovery information
    SbkQGraphicsSceneDragDropEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQGraphicsSceneDragDropEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQGraphicsSceneDragDropEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsSceneDragDropEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsSceneDragDropEvent_Type));
    PyModule_AddObject(module, "QGraphicsSceneDragDropEvent",
        ((PyObject*)&SbkQGraphicsSceneDragDropEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneDragDropEvent >("QGraphicsSceneDragDropEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneDragDropEvent >(typeid(QGraphicsSceneDragDropEvent).name());
}


} // extern "C"

