/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qfontcombobox_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcompleter.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qfontcombobox.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qvalidator.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFontComboBoxWrapper::QFontComboBoxWrapper(QWidget * parent) : QFontComboBox(parent), m_metaObject(0) {
    // ... middle
}

void QFontComboBoxWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::changeEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::changeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::contextMenuEvent(QContextMenuEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::contextMenuEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QFontComboBoxWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QFontComboBoxWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QFontComboBox::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFontComboBoxWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::focusInEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::focusInEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFontComboBoxWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::focusOutEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::focusOutEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QFontComboBoxWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::hideEvent(QHideEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::hideEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::hidePopup()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hidePopup"));
    if (py_override.isNull()) {
        return this->QComboBox::hidePopup();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QFontComboBoxWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QComboBox::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::keyPressEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::keyPressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::keyReleaseEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::keyReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QFontComboBoxWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QFontComboBoxWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QComboBox::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::mousePressEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::mousePressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QFontComboBoxWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::resizeEvent(QResizeEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::resizeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::showEvent(QShowEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::showEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::showPopup()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showPopup"));
    if (py_override.isNull()) {
        return this->QComboBox::showPopup();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QFontComboBoxWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QFontComboBox::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFontComboBox.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QFontComboBoxWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFontComboBoxWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFontComboBoxWrapper::wheelEvent(QWheelEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::wheelEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QFontComboBoxWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QFontComboBox::staticMetaObject);
}
    return m_metaObject;
}

int QFontComboBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QFontComboBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QFontComboBoxWrapper::~QFontComboBoxWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQFontComboBox_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFontComboBoxWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QFontComboBox", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QFontComboBox(QWidget*)
        cptr = new QFontComboBoxWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QFontComboBox(QWidget*)
        cptr = new QFontComboBoxWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQFontComboBox_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFontComboBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFontComboBox_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFontComboBox_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontComboBox", overloads);
        return -1;
}

static PyObject* SbkQFontComboBoxFunc_currentFont(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFont()const
    QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QFontComboBox::currentFont();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontComboBoxFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFontComboBox::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontComboBoxFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontComboBoxFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontComboBox.event", overloads);
        return 0;
}

static PyObject* SbkQFontComboBoxFunc_fontFilters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontFilters()const
    QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
    QFlags<QFontComboBox::FontFilter> cpp_result = cppSelf->QFontComboBox::fontFilters();
    py_result = Shiboken::Converter<QFlags<QFontComboBox::FontFilter> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontComboBoxFunc_setCurrentFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setCurrentFont(QFont)
        QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
        cppSelf->QFontComboBox::setCurrentFont(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontComboBoxFunc_setCurrentFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontComboBoxFunc_setCurrentFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontComboBox.setCurrentFont", overloads);
        return 0;
}

static PyObject* SbkQFontComboBoxFunc_setFontFilters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QFontComboBox_FontFilter_Check(arg)) {
        QFlags<QFontComboBox::FontFilter> cpp_arg0 = Shiboken::Converter<QFlags<QFontComboBox::FontFilter> >::toCpp(arg);
        // setFontFilters(QFlags<QFontComboBox::FontFilter>)
        QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
        cppSelf->QFontComboBox::setFontFilters(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontComboBoxFunc_setFontFilters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontComboBoxFunc_setFontFilters_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFontComboBox.FontFilters", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontComboBox.setFontFilters", overloads);
        return 0;
}

static PyObject* SbkQFontComboBoxFunc_setWritingSystem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFontDatabase::WritingSystem >::isConvertible(arg)) {
        QFontDatabase::WritingSystem cpp_arg0 = Shiboken::Converter<QFontDatabase::WritingSystem >::toCpp(arg);
        // setWritingSystem(QFontDatabase::WritingSystem)
        QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
        cppSelf->QFontComboBox::setWritingSystem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontComboBoxFunc_setWritingSystem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontComboBoxFunc_setWritingSystem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFontDatabase.WritingSystem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontComboBox.setWritingSystem", overloads);
        return 0;
}

static PyObject* SbkQFontComboBoxFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QFontComboBox::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontComboBoxFunc_writingSystem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // writingSystem()const
    QFontComboBox* cppSelf = Shiboken::Converter<QFontComboBox* >::toCpp((PyObject*)self);
    QFontDatabase::WritingSystem cpp_result = cppSelf->QFontComboBox::writingSystem();
    py_result = Shiboken::Converter<QFontDatabase::WritingSystem >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFontComboBox_methods[] = {
    {"currentFont", (PyCFunction)SbkQFontComboBoxFunc_currentFont, METH_NOARGS},
    {"event", (PyCFunction)SbkQFontComboBoxFunc_event, METH_O},
    {"fontFilters", (PyCFunction)SbkQFontComboBoxFunc_fontFilters, METH_NOARGS},
    {"setCurrentFont", (PyCFunction)SbkQFontComboBoxFunc_setCurrentFont, METH_O},
    {"setFontFilters", (PyCFunction)SbkQFontComboBoxFunc_setFontFilters, METH_O},
    {"setWritingSystem", (PyCFunction)SbkQFontComboBoxFunc_setWritingSystem, METH_O},
    {"sizeHint", (PyCFunction)SbkQFontComboBoxFunc_sizeHint, METH_NOARGS},
    {"writingSystem", (PyCFunction)SbkQFontComboBoxFunc_writingSystem, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQFontComboBoxSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QFontComboBox* me = reinterpret_cast<QFontComboBox*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_IDX]))
        return static_cast<QComboBox*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFontComboBox_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFontComboBox",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFontComboBox_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFontComboBox_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQFontComboBoxSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFontComboBox >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QFontComboBox_FontFilter___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFontComboBox::FontFilters >::toPython(
        ((QFontComboBox::FontFilters) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QFontComboBox::FontFilters >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QFontComboBox_FontFilter___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFontComboBox::FontFilters >::toPython(
        ((QFontComboBox::FontFilters) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QFontComboBox::FontFilters >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QFontComboBox_FontFilter___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFontComboBox::FontFilters >::toPython(
        ((QFontComboBox::FontFilters) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QFontComboBox::FontFilters >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QFontComboBox_FontFilter___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFontComboBox::FontFilters >::toPython(
        ~ Shiboken::Converter< QFontComboBox::FontFilters >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QFontComboBox_FontFilter_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QFontComboBox_FontFilter___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QFontComboBox_FontFilter___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QFontComboBox_FontFilter___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QFontComboBox_FontFilter___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QFontComboBox_FontFilter_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFontComboBox_FontFilter_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFontComboBox_FontFilter_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FontFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QFontComboBox_FontFilter_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFontComboBox_FontFilter_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFontComboBox_FontFilter_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFontComboBox_FontFilter_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFontComboBox_FontFilters_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFontComboBox_FontFilters_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FontFilters",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QFontComboBox_FontFilter_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFontComboBox_FontFilters_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFontComboBox_FontFilters_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QFontComboBox_FontFilters_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QFontComboBox(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFONTCOMBOBOX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFontComboBox_Type);

    SbkQFontComboBox_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_IDX];
    SbkQFontComboBox_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQFontComboBox_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFontComboBox_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFontComboBox_Type));
    PyModule_AddObject(module, "QFontComboBox",
        ((PyObject*)&SbkQFontComboBox_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FontFilter
    SbkPySide_QtGuiTypes[SBK_QFONTCOMBOBOX_FONTFILTER_IDX] = &SbkPySide_QtGui_QFontComboBox_FontFilter_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFontComboBox_FontFilter_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFontComboBox_FontFilter_Type);
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
            "FontFilter",((PyObject*)&SbkPySide_QtGui_QFontComboBox_FontFilter_Type));

    // init flags class: QFlags<QFontComboBox::FontFilter>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QFONTCOMBOBOX_FONTFILTER__IDX] = &SbkPySide_QtGui_QFontComboBox_FontFilters_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFontComboBox_FontFilters_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFontComboBox_FontFilters_Type);
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
            "FontFilters",((PyObject*)&SbkPySide_QtGui_QFontComboBox_FontFilters_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontComboBox_FontFilter_Type,
        (long) QFontComboBox::AllFonts, "AllFonts");
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
        "AllFonts", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontComboBox_FontFilter_Type.tp_dict,
        "AllFonts", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontComboBox_FontFilter_Type,
        (long) QFontComboBox::ScalableFonts, "ScalableFonts");
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
        "ScalableFonts", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontComboBox_FontFilter_Type.tp_dict,
        "ScalableFonts", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontComboBox_FontFilter_Type,
        (long) QFontComboBox::NonScalableFonts, "NonScalableFonts");
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
        "NonScalableFonts", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontComboBox_FontFilter_Type.tp_dict,
        "NonScalableFonts", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontComboBox_FontFilter_Type,
        (long) QFontComboBox::MonospacedFonts, "MonospacedFonts");
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
        "MonospacedFonts", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontComboBox_FontFilter_Type.tp_dict,
        "MonospacedFonts", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontComboBox_FontFilter_Type,
        (long) QFontComboBox::ProportionalFonts, "ProportionalFonts");
    PyDict_SetItemString(SbkQFontComboBox_Type.super.ht_type.tp_dict,
        "ProportionalFonts", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontComboBox_FontFilter_Type.tp_dict,
        "ProportionalFonts", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFontComboBox::FontFilter");

    Shiboken::TypeResolver::createObjectTypeResolver<QFontComboBox >("QFontComboBox*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFontComboBox >(typeid(QFontComboBox).name());
}


} // extern "C"

