/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTGUI_PYTHON_H
#define SBK_QTGUI_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTGUI_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTGUI_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTGUI_API
#endif
#endif

// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qwhatsthis.h>
#include <qtextobject.h>
#include <qtransform.h>
#include <qpen.h>
#include <qquaternion.h>
#include <qcleanlooksstyle.h>
#include <qpolygon.h>
#include <qabstractprintdialog.h>
#include <qcolordialog.h>
#include <qsortfilterproxymodel.h>
#include <qcursor.h>
#include <qtextcursor.h>
#include <qlabel.h>
#include <qevent.h>
#include <qprintpreviewdialog.h>
#include <qinputdialog.h>
#include <qsizegrip.h>
#include <qabstractbutton.h>
#include <qtabbar.h>
#include <qradiobutton.h>
#include <qtoolbar.h>
#include <qtreewidget.h>
#include <qwizard.h>
#include <qiconengine.h>
#include <QTextEdit>
#include <qboxlayout.h>
#include <qplastiquestyle.h>
#include <qundoview.h>
#include <qfont.h>
#include <qundogroup.h>
#include <qgraphicsitemanimation.h>
#include <qgraphicsanchorlayout.h>
#include <qpushbutton.h>
#include <qsplashscreen.h>
#include <qgesturerecognizer.h>
#include <qpixmap.h>
#include <qprinterinfo.h>
#include <qpainterpath.h>
#include <qlcdnumber.h>
#include <qprogressbar.h>
#include <qtoolbox.h>
#include <qabstractscrollarea.h>
#include <qabstractspinbox.h>
#include <qgraphicsscene.h>
#include <qprogressdialog.h>
#include <qtextbrowser.h>
#include <qlistwidget.h>
#include <qfileiconprovider.h>
#include <qundostack.h>
#include <qworkspace.h>
#include <qicon.h>
#include <qdirmodel.h>
#include <qformlayout.h>
#include <QAbstractTextDocumentLayout>
#include <qitemselectionmodel.h>
#include <qclipboard.h>
#include <qtextdocumentfragment.h>
#include <qgroupbox.h>
#include <qinputcontextfactory.h>
#include <qregion.h>
#include <qcolumnview.h>
#include <qwidget.h>
#include <qgraphicsproxywidget.h>
#include <qabstractslider.h>
#include <qitemdelegate.h>
#include <qtextformat.h>
#include <qkeyeventtransition.h>
#include <qgenericmatrix.h>
#include <qabstractkineticscroller.h>
#include <qpalette.h>
#include <qpixmapcache.h>
#include <qfontdatabase.h>
#include <qtextlist.h>
#include <qgtkstyle.h>
#include <qmdisubwindow.h>
#include <qgraphicstransform.h>
#include <qvector4d.h>
#include <qgraphicswidget.h>
#include <qsound.h>
#include <qwidgetaction.h>
#include <qbuttongroup.h>
#include <qfocusframe.h>
#include <qstyleditemdelegate.h>
#include <qx11info_x11.h>
#include <qstringlistmodel.h>
#include <qerrormessage.h>
#include <qplaintextedit.h>
#include <qproxymodel.h>
#include <qdockwidget.h>
#include <qtabwidget.h>
#include <qabstractitemview.h>
#include <qspinbox.h>
#include <qcalendarwidget.h>
#include <qmatrix4x4.h>
#include <qprintdialog.h>
#include <qitemeditorfactory.h>
#include <qdatawidgetmapper.h>
#include <qrubberband.h>
#include <qabstracttextdocumentlayout.h>
#include <qaction.h>
#include <qvector2d.h>
#include <qimagewriter.h>
#include <qmenu.h>
#include <qtextoption.h>
#include <qmouseeventtransition.h>
#include <qinputcontext.h>
#include <qtextedit.h>
#include <qfontinfo.h>
#include <qfontmetrics.h>
#include <qtextlayout.h>
#include <qwindowsstyle.h>
#include <qvector3d.h>
#include <qlistview.h>
#include <qtextdocument.h>
#include <qsyntaxhighlighter.h>
#include <qcolor.h>
#include <qgraphicsview.h>
#include <qpaintdevice.h>
#include <qfiledialog.h>
#include <qtablewidget.h>
#include <qfilesystemmodel.h>
#include <qgraphicseffect.h>
#include <qapplication.h>
#include <qtreeview.h>
#include <qlineedit.h>
#include <qtooltip.h>
#include <qtableview.h>
#include <qimage.h>
#include <qbrush.h>
#include <qstyleoption.h>
#include <qgraphicslayoutitem.h>
#include <qaccessible.h>
#include <QPainterPath>
#include <qtoolbutton.h>
#include <qcombobox.h>
#include <qbitmap.h>
#include <QTextBlock>
#include <qpaintengine.h>
#include <qcommonstyle.h>
#include <qkeysequence.h>
#include <qstylepainter.h>
#include <qstylefactory.h>
#include <qtreewidgetitemiterator.h>
#include <qmovie.h>
#include <qdialogbuttonbox.h>
#include <qimageiohandler.h>
#include <qmotifstyle.h>
#include <qcheckbox.h>
#include <qstackedwidget.h>
#include <qstandarditemmodel.h>
#include <qabstractitemdelegate.h>
#include <qdesktopwidget.h>
#include <qgraphicssceneevent.h>
#include <qstackedlayout.h>
#include <qlayoutitem.h>
#include <QTextLayout>
#include <qmessagebox.h>
#include <qpicture.h>
#include <qdialog.h>
#include <qcommandlinkbutton.h>
#include <qfontdialog.h>
#include <qmdiarea.h>
#include <qslider.h>
#include <qcompleter.h>
#include <qprintengine.h>
#include <qlayout.h>
#include <qdial.h>
#include <qdrawutil.h>
#include <qstyle.h>
#include <qvalidator.h>
#include <qtexttable.h>
#include <qpainter.h>
#include <QTextFrame>
#include <qgraphicslayout.h>
#include <qheaderview.h>
#include <qstatusbar.h>
#include <qdrag.h>
#include <qmatrix.h>
#include <qfontcombobox.h>
#include <qgraphicslinearlayout.h>
#include <qdatetimeedit.h>
#include <qscrollarea.h>
#include <qscrollbar.h>
#include <qsystemtrayicon.h>
#include <qshortcut.h>
#include <qgraphicsitem.h>
#include <qsessionmanager.h>
#include <qabstractproxymodel.h>
#include <qprintpreviewwidget.h>
#include <qdesktopservices.h>
#include <qgridlayout.h>
#include <qsplitter.h>
#include <qframe.h>
#include <qactiongroup.h>
#include <QInputMethodEvent>
#include <qpagesetupdialog.h>
#include <qgesture.h>
#include <qimagereader.h>
#include <qprinter.h>
#include <qmenubar.h>
#include <qsizepolicy.h>
#include <qcdestyle.h>
#include <qabstractpagesetupdialog.h>
#include <qgraphicsgridlayout.h>
#include <qmainwindow.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QMATRIX2X4_IDX                                           0
#define SBK_QMATRIX2X3_IDX                                           1
#define SBK_QMATRIX2X2_IDX                                           2
#define SBK_QMATRIX3X4_IDX                                           3
#define SBK_QMATRIX3X3_IDX                                           4
#define SBK_QMATRIX3X2_IDX                                           5
#define SBK_QMATRIX4X3_IDX                                           6
#define SBK_QMATRIX4X2_IDX                                           7
#define SBK_QITEMEDITORFACTORY_IDX                                   8
#define SBK_QICONENGINE_IDX                                          9
#define SBK_QTREEWIDGETITEMITERATOR_IDX                              10
#define SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX                 11
#define SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG__IDX         12
#define SBK_QTILERULES_IDX                                           13
#define SBK_QFONTMETRICSF_IDX                                        14
#define SBK_QITEMSELECTION_IDX                                       15
#define SBK_QKEYSEQUENCE_IDX                                         16
#define SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX                          17
#define SBK_QKEYSEQUENCE_STANDARDKEY_IDX                             18
#define SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX                           19
#define SBK_QSTRINGLISTMODEL_IDX                                     20
#define SBK_QTEXTOPTION_IDX                                          21
#define SBK_QTEXTOPTION_TABTYPE_IDX                                  22
#define SBK_QTEXTOPTION_FLAG_IDX                                     23
#define SBK_QFLAGS_QTEXTOPTION_FLAG__IDX                             24
#define SBK_QTEXTOPTION_WRAPMODE_IDX                                 25
#define SBK_QTEXTOPTION_TAB_IDX                                      26
#define SBK_QBRUSH_IDX                                               27
#define SBK_QX11INFO_IDX                                             28
#define SBK_QTEXTINLINEOBJECT_IDX                                    29
#define SBK_QINPUTCONTEXTFACTORY_IDX                                 30
#define SBK_QPICTUREIO_IDX                                           31
#define SBK_QTOOLTIP_IDX                                             32
#define SBK_QPRINTERINFO_IDX                                         33
#define SBK_QTEXTLINE_IDX                                            34
#define SBK_QTEXTLINE_EDGE_IDX                                       35
#define SBK_QTEXTLINE_CURSORPOSITION_IDX                             36
#define SBK_QUNDOCOMMAND_IDX                                         37
#define SBK_QGESTURERECOGNIZER_IDX                                   38
#define SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX                        39
#define SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG__IDX                40
#define SBK_QTEXTFRAGMENT_IDX                                        41
#define SBK_QACTION_IDX                                              42
#define SBK_QACTION_PRIORITY_IDX                                     43
#define SBK_QACTION_ACTIONEVENT_IDX                                  44
#define SBK_QACTION_SOFTKEYROLE_IDX                                  45
#define SBK_QACTION_MENUROLE_IDX                                     46
#define SBK_QACTIONGROUP_IDX                                         47
#define SBK_QBUTTONGROUP_IDX                                         48
#define SBK_QGRAPHICSEFFECT_IDX                                      49
#define SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX                        50
#define SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX                           51
#define SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG__IDX                   52
#define SBK_QGRAPHICSBLUREFFECT_IDX                                  53
#define SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX                         54
#define SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT__IDX                 55
#define SBK_QGRAPHICSCOLORIZEEFFECT_IDX                              56
#define SBK_QGRAPHICSOPACITYEFFECT_IDX                               57
#define SBK_QDATAWIDGETMAPPER_IDX                                    58
#define SBK_QDATAWIDGETMAPPER_SUBMITPOLICY_IDX                       59
#define SBK_QCLIPBOARD_IDX                                           60
#define SBK_QCLIPBOARD_MODE_IDX                                      61
#define SBK_QSYSTEMTRAYICON_IDX                                      62
#define SBK_QSYSTEMTRAYICON_MESSAGEICON_IDX                          63
#define SBK_QSYSTEMTRAYICON_ACTIVATIONREASON_IDX                     64
#define SBK_QSTYLEFACTORY_IDX                                        65
#define SBK_QPOLYGONF_IDX                                            66
#define SBK_QKEYEVENTTRANSITION_IDX                                  67
#define SBK_QMOUSEEVENTTRANSITION_IDX                                68
#define SBK_QTEXTOBJECT_IDX                                          69
#define SBK_QTEXTFRAME_IDX                                           70
#define SBK_QTREEWIDGETITEM_IDX                                      71
#define SBK_QTREEWIDGETITEM_ITEMTYPE_IDX                             72
#define SBK_QTREEWIDGETITEM_CHILDINDICATORPOLICY_IDX                 73
#define SBK_QVALIDATOR_IDX                                           74
#define SBK_QVALIDATOR_STATE_IDX                                     75
#define SBK_QTEXTLENGTH_IDX                                          76
#define SBK_QTEXTLENGTH_TYPE_IDX                                     77
#define SBK_QIMAGEREADER_IDX                                         78
#define SBK_QIMAGEREADER_IMAGEREADERERROR_IDX                        79
#define SBK_QPAINTENGINESTATE_IDX                                    80
#define SBK_QWIDGETACTION_IDX                                        81
#define SBK_QPOLYGON_IDX                                             82
#define SBK_QGRAPHICSANCHOR_IDX                                      83
#define SBK_QCOLOR_IDX                                               84
#define SBK_QCOLOR_SPEC_IDX                                          85
#define SBK_QGESTURE_IDX                                             86
#define SBK_QGESTURE_GESTURECANCELPOLICY_IDX                         87
#define SBK_QABSTRACTKINETICSCROLLER_IDX                             88
#define SBK_QTABLEWIDGETITEM_IDX                                     89
#define SBK_QTABLEWIDGETITEM_ITEMTYPE_IDX                            90
#define SBK_QCOMPLETER_IDX                                           91
#define SBK_QCOMPLETER_MODELSORTING_IDX                              92
#define SBK_QCOMPLETER_COMPLETIONMODE_IDX                            93
#define SBK_QCLIPBOARDEVENT_IDX                                      94
#define SBK_QWINDOWSTATECHANGEEVENT_IDX                              95
#define SBK_QCLOSEEVENT_IDX                                          96
#define SBK_QICONDRAGEVENT_IDX                                       97
#define SBK_QFILEOPENEVENT_IDX                                       98
#define SBK_QSHORTCUTEVENT_IDX                                       99
#define SBK_QSHOWEVENT_IDX                                           100
#define SBK_QSTATUSTIPEVENT_IDX                                      101
#define SBK_QHIDEEVENT_IDX                                           102
#define SBK_QHELPEVENT_IDX                                           103
#define SBK_QDROPEVENT_IDX                                           104
#define SBK_QACTIONEVENT_IDX                                         105
#define SBK_QPINCHGESTURE_IDX                                        106
#define SBK_QPINCHGESTURE_CHANGEFLAG_IDX                             107
#define SBK_QFLAGS_QPINCHGESTURE_CHANGEFLAG__IDX                     108
#define SBK_QPAINTERPATHSTROKER_IDX                                  109
#define SBK_QSHORTCUT_IDX                                            110
#define SBK_QREGEXPVALIDATOR_IDX                                     111
#define SBK_QREGION_IDX                                              112
#define SBK_QREGION_REGIONTYPE_IDX                                   113
#define SBK_QGRAPHICSITEMANIMATION_IDX                               114
#define SBK_QRESIZEEVENT_IDX                                         115
#define SBK_QABSTRACTITEMDELEGATE_IDX                                116
#define SBK_QABSTRACTITEMDELEGATE_ENDEDITHINT_IDX                    117
#define SBK_QSTYLEDITEMDELEGATE_IDX                                  118
#define SBK_QITEMDELEGATE_IDX                                        119
#define SBK_QLAYOUTITEM_IDX                                          120
#define SBK_QLAYOUT_IDX                                              121
#define SBK_QLAYOUT_SIZECONSTRAINT_IDX                               122
#define SBK_QSTACKEDLAYOUT_IDX                                       123
#define SBK_QSTACKEDLAYOUT_STACKINGMODE_IDX                          124
#define SBK_QWIDGETITEM_IDX                                          125
#define SBK_QPIXMAPCACHE_IDX                                         126
#define SBK_QSOUND_IDX                                               127
#define SBK_QTEXTBLOCK_IDX                                           128
#define SBK_QTEXTFRAME_ITERATOR_IDX                                  129
#define SBK_QTEXTBLOCK_ITERATOR_IDX                                  130
#define SBK_QMOVEEVENT_IDX                                           131
#define SBK_QPAINTENGINE_IDX                                         132
#define SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX                         133
#define SBK_QPAINTENGINE_TYPE_IDX                                    134
#define SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX                      135
#define SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE__IDX              136
#define SBK_QPAINTENGINE_DIRTYFLAG_IDX                               137
#define SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG__IDX                       138
#define SBK_QBOXLAYOUT_IDX                                           139
#define SBK_QBOXLAYOUT_DIRECTION_IDX                                 140
#define SBK_QHBOXLAYOUT_IDX                                          141
#define SBK_QVBOXLAYOUT_IDX                                          142
#define SBK_QACCESSIBLEEVENT_IDX                                     143
#define SBK_QIMAGEWRITER_IDX                                         144
#define SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX                        145
#define SBK_QSTANDARDITEM_IDX                                        146
#define SBK_QSTANDARDITEM_ITEMTYPE_IDX                               147
#define SBK_QTEXTDOCUMENTFRAGMENT_IDX                                148
#define SBK_QPEN_IDX                                                 149
#define SBK_QTEXTDOCUMENT_IDX                                        150
#define SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX                           151
#define SBK_QTEXTDOCUMENT_FINDFLAG_IDX                               152
#define SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG__IDX                       153
#define SBK_QTEXTDOCUMENT_METAINFORMATION_IDX                        154
#define SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX                          155
#define SBK_QABSTRACTTEXTDOCUMENTLAYOUT_SELECTION_IDX                156
#define SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX             157
#define SBK_QTEXTLAYOUT_IDX                                          158
#define SBK_QTEXTLAYOUT_CURSORMODE_IDX                               159
#define SBK_QTEXTLAYOUT_FORMATRANGE_IDX                              160
#define SBK_QDRAG_IDX                                                161
#define SBK_QGRAPHICSITEM_IDX                                        162
#define SBK_QGRAPHICSITEM_CACHEMODE_IDX                              163
#define SBK_QGRAPHICSITEM_PANELMODALITY_IDX                          164
#define SBK_QGRAPHICSITEM_GRAPHICSITEMFLAG_IDX                       165
#define SBK_QFLAGS_QGRAPHICSITEM_GRAPHICSITEMFLAG__IDX               166
#define SBK_QGRAPHICSITEM_GRAPHICSITEMCHANGE_IDX                     167
#define SBK_QGRAPHICSITEM_EXTENSION_IDX                              168
#define SBK_QGRAPHICSPIXMAPITEM_IDX                                  169
#define SBK_QGRAPHICSPIXMAPITEM_SHAPEMODE_IDX                        170
#define SBK_QABSTRACTGRAPHICSSHAPEITEM_IDX                           171
#define SBK_QGRAPHICSPOLYGONITEM_IDX                                 172
#define SBK_QGRAPHICSRECTITEM_IDX                                    173
#define SBK_QICON_IDX                                                174
#define SBK_QICON_MODE_IDX                                           175
#define SBK_QICON_STATE_IDX                                          176
#define SBK_QGRAPHICSITEMGROUP_IDX                                   177
#define SBK_QGRAPHICSELLIPSEITEM_IDX                                 178
#define SBK_QGRAPHICSSIMPLETEXTITEM_IDX                              179
#define SBK_QPAINTDEVICE_IDX                                         180
#define SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX                       181
#define SBK_QPIXMAP_IDX                                              182
#define SBK_QPIXMAP_SHAREMODE_IDX                                    183
#define SBK_QPICTURE_IDX                                             184
#define SBK_QINPUTEVENT_IDX                                          185
#define SBK_QTOUCHEVENT_IDX                                          186
#define SBK_QTOUCHEVENT_DEVICETYPE_IDX                               187
#define SBK_QTOUCHEVENT_TOUCHPOINT_IDX                               188
#define SBK_QTABLETEVENT_IDX                                         189
#define SBK_QTABLETEVENT_TABLETDEVICE_IDX                            190
#define SBK_QTABLETEVENT_POINTERTYPE_IDX                             191
#define SBK_QMOUSEEVENT_IDX                                          192
#define SBK_QSWIPEGESTURE_IDX                                        193
#define SBK_QSWIPEGESTURE_SWIPEDIRECTION_IDX                         194
#define SBK_QDRAGLEAVEEVENT_IDX                                      195
#define SBK_QSTANDARDITEMMODEL_IDX                                   196
#define SBK_QPROXYMODEL_IDX                                          197
#define SBK_QFILESYSTEMMODEL_IDX                                     198
#define SBK_QFILESYSTEMMODEL_ROLES_IDX                               199
#define SBK_QIMAGEIOHANDLER_IDX                                      200
#define SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX                          201
#define SBK_QFORMLAYOUT_IDX                                          202
#define SBK_QFORMLAYOUT_FIELDGROWTHPOLICY_IDX                        203
#define SBK_QFORMLAYOUT_ROWWRAPPOLICY_IDX                            204
#define SBK_QFORMLAYOUT_ITEMROLE_IDX                                 205
#define SBK_QSYNTAXHIGHLIGHTER_IDX                                   206
#define SBK_QFONTINFO_IDX                                            207
#define SBK_QSTYLEOPTION_IDX                                         208
#define SBK_QSTYLEOPTION_STYLEOPTIONVERSION_IDX                      209
#define SBK_QSTYLEOPTION_STYLEOPTIONTYPE_IDX                         210
#define SBK_QSTYLEOPTION_OPTIONTYPE_IDX                              211
#define SBK_QSTYLEHINTRETURN_IDX                                     212
#define SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX                      213
#define SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX                  214
#define SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX                     215
#define SBK_QSTYLEHINTRETURNMASK_IDX                                 216
#define SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX              217
#define SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX                 218
#define SBK_QSTYLEHINTRETURNVARIANT_IDX                              219
#define SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX           220
#define SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX              221
#define SBK_QSTYLEOPTIONRUBBERBAND_IDX                               222
#define SBK_QSTYLEOPTIONRUBBERBAND_STYLEOPTIONVERSION_IDX            223
#define SBK_QSTYLEOPTIONRUBBERBAND_STYLEOPTIONTYPE_IDX               224
#define SBK_QSTYLEOPTIONTABWIDGETFRAME_IDX                           225
#define SBK_QSTYLEOPTIONTABWIDGETFRAME_STYLEOPTIONVERSION_IDX        226
#define SBK_QSTYLEOPTIONTABWIDGETFRAME_STYLEOPTIONTYPE_IDX           227
#define SBK_QSTYLEOPTIONHEADER_IDX                                   228
#define SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX                229
#define SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX                   230
#define SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX                  231
#define SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX                   232
#define SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX                     233
#define SBK_QSTYLEOPTIONBUTTON_IDX                                   234
#define SBK_QSTYLEOPTIONBUTTON_STYLEOPTIONVERSION_IDX                235
#define SBK_QSTYLEOPTIONBUTTON_BUTTONFEATURE_IDX                     236
#define SBK_QFLAGS_QSTYLEOPTIONBUTTON_BUTTONFEATURE__IDX             237
#define SBK_QSTYLEOPTIONBUTTON_STYLEOPTIONTYPE_IDX                   238
#define SBK_QSTYLEOPTIONDOCKWIDGET_IDX                               239
#define SBK_QSTYLEOPTIONDOCKWIDGET_STYLEOPTIONVERSION_IDX            240
#define SBK_QSTYLEOPTIONDOCKWIDGET_STYLEOPTIONTYPE_IDX               241
#define SBK_QSTYLEOPTIONDOCKWIDGETV2_IDX                             242
#define SBK_QSTYLEOPTIONDOCKWIDGETV2_STYLEOPTIONVERSION_IDX          243
#define SBK_QSTYLEOPTIONTOOLBAR_IDX                                  244
#define SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX               245
#define SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX                  246
#define SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX                  247
#define SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX                   248
#define SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE__IDX           249
#define SBK_QSTYLEOPTIONTABBARBASE_IDX                               250
#define SBK_QSTYLEOPTIONTABBARBASE_STYLEOPTIONVERSION_IDX            251
#define SBK_QSTYLEOPTIONTABBARBASE_STYLEOPTIONTYPE_IDX               252
#define SBK_QSTYLEOPTIONTABBARBASEV2_IDX                             253
#define SBK_QSTYLEOPTIONTABBARBASEV2_STYLEOPTIONVERSION_IDX          254
#define SBK_QSTYLEOPTIONTOOLBOX_IDX                                  255
#define SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX               256
#define SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX                  257
#define SBK_QSTYLEOPTIONTAB_IDX                                      258
#define SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX                   259
#define SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX                         260
#define SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET__IDX                 261
#define SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX                          262
#define SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX                     263
#define SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX                      264
#define SBK_QSTYLEOPTIONTABV2_IDX                                    265
#define SBK_QSTYLEOPTIONTABV2_STYLEOPTIONVERSION_IDX                 266
#define SBK_QSTYLEOPTIONTABV3_IDX                                    267
#define SBK_QSTYLEOPTIONTABV3_STYLEOPTIONVERSION_IDX                 268
#define SBK_QSTYLEOPTIONPROGRESSBAR_IDX                              269
#define SBK_QSTYLEOPTIONPROGRESSBAR_STYLEOPTIONVERSION_IDX           270
#define SBK_QSTYLEOPTIONPROGRESSBAR_STYLEOPTIONTYPE_IDX              271
#define SBK_QSTYLEOPTIONPROGRESSBARV2_IDX                            272
#define SBK_QSTYLEOPTIONPROGRESSBARV2_STYLEOPTIONVERSION_IDX         273
#define SBK_QSTYLEOPTIONPROGRESSBARV2_STYLEOPTIONTYPE_IDX            274
#define SBK_QSTYLEOPTIONFRAME_IDX                                    275
#define SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX                 276
#define SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX                    277
#define SBK_QSTYLEOPTIONFRAMEV2_IDX                                  278
#define SBK_QSTYLEOPTIONFRAMEV2_STYLEOPTIONVERSION_IDX               279
#define SBK_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE_IDX                     280
#define SBK_QFLAGS_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE__IDX             281
#define SBK_QSTYLEOPTIONFRAMEV3_IDX                                  282
#define SBK_QSTYLEOPTIONFRAMEV3_STYLEOPTIONVERSION_IDX               283
#define SBK_QTABLEWIDGETSELECTIONRANGE_IDX                           284
#define SBK_QGRAPHICSDROPSHADOWEFFECT_IDX                            285
#define SBK_QGRADIENT_IDX                                            286
#define SBK_QGRADIENT_COORDINATEMODE_IDX                             287
#define SBK_QGRADIENT_SPREAD_IDX                                     288
#define SBK_QGRADIENT_TYPE_IDX                                       289
#define SBK_QGRADIENT_INTERPOLATIONMODE_IDX                          290
#define SBK_QCONICALGRADIENT_IDX                                     291
#define SBK_QRADIALGRADIENT_IDX                                      292
#define SBK_QPRINTENGINE_IDX                                         293
#define SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX                  294
#define SBK_QGRAPHICSPATHITEM_IDX                                    295
#define SBK_QDRAGMOVEEVENT_IDX                                       296
#define SBK_QDRAGENTEREVENT_IDX                                      297
#define SBK_QHOVEREVENT_IDX                                          298
#define SBK_QDOUBLEVALIDATOR_IDX                                     299
#define SBK_QDOUBLEVALIDATOR_NOTATION_IDX                            300
#define SBK_QPAINTEVENT_IDX                                          301
#define SBK_QPALETTE_IDX                                             302
#define SBK_QPALETTE_COLORGROUP_IDX                                  303
#define SBK_QPALETTE_COLORROLE_IDX                                   304
#define SBK_QSTYLE_IDX                                               305
#define SBK_QSTYLE_PIXELMETRIC_IDX                                   306
#define SBK_QSTYLE_SUBCONTROL_IDX                                    307
#define SBK_QFLAGS_QSTYLE_SUBCONTROL__IDX                            308
#define SBK_QSTYLE_STANDARDPIXMAP_IDX                                309
#define SBK_QSTYLE_STYLEHINT_IDX                                     310
#define SBK_QSTYLE_PRIMITIVEELEMENT_IDX                              311
#define SBK_QSTYLE_CONTROLELEMENT_IDX                                312
#define SBK_QSTYLE_CONTENTSTYPE_IDX                                  313
#define SBK_QSTYLE_STATEFLAG_IDX                                     314
#define SBK_QFLAGS_QSTYLE_STATEFLAG__IDX                             315
#define SBK_QSTYLE_COMPLEXCONTROL_IDX                                316
#define SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX                     317
#define SBK_QSTYLE_SUBELEMENT_IDX                                    318
#define SBK_QCOMMONSTYLE_IDX                                         319
#define SBK_QMOTIFSTYLE_IDX                                          320
#define SBK_QWINDOWSSTYLE_IDX                                        321
#define SBK_QCDESTYLE_IDX                                            322
#define SBK_QPLASTIQUESTYLE_IDX                                      323
#define SBK_QGRAPHICSTRANSFORM_IDX                                   324
#define SBK_QGRAPHICSROTATION_IDX                                    325
#define SBK_QGRAPHICSSCALE_IDX                                       326
#define SBK_QSTYLEOPTIONGRAPHICSITEM_IDX                             327
#define SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX          328
#define SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX             329
#define SBK_QVECTOR3D_IDX                                            330
#define SBK_QSTYLEOPTIONMENUITEM_IDX                                 331
#define SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX              332
#define SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX                 333
#define SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX                       334
#define SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX                    335
#define SBK_QVECTOR2D_IDX                                            336
#define SBK_QPANGESTURE_IDX                                          337
#define SBK_QWIDGET_IDX                                              338
#define SBK_QWIDGET_RENDERFLAG_IDX                                   339
#define SBK_QFLAGS_QWIDGET_RENDERFLAG__IDX                           340
#define SBK_QSIZEGRIP_IDX                                            341
#define SBK_QWIZARDPAGE_IDX                                          342
#define SBK_QTABBAR_IDX                                              343
#define SBK_QTABBAR_SELECTIONBEHAVIOR_IDX                            344
#define SBK_QTABBAR_BUTTONPOSITION_IDX                               345
#define SBK_QTABBAR_SHAPE_IDX                                        346
#define SBK_QTABWIDGET_IDX                                           347
#define SBK_QTABWIDGET_TABSHAPE_IDX                                  348
#define SBK_QTABWIDGET_TABPOSITION_IDX                               349
#define SBK_QFOCUSFRAME_IDX                                          350
#define SBK_QMAINWINDOW_IDX                                          351
#define SBK_QMAINWINDOW_DOCKOPTION_IDX                               352
#define SBK_QFLAGS_QMAINWINDOW_DOCKOPTION__IDX                       353
#define SBK_QMENU_IDX                                                354
#define SBK_QABSTRACTSLIDER_IDX                                      355
#define SBK_QABSTRACTSLIDER_SLIDERACTION_IDX                         356
#define SBK_QABSTRACTSLIDER_SLIDERCHANGE_IDX                         357
#define SBK_QDIAL_IDX                                                358
#define SBK_QDIALOGBUTTONBOX_IDX                                     359
#define SBK_QDIALOGBUTTONBOX_BUTTONLAYOUT_IDX                        360
#define SBK_QDIALOGBUTTONBOX_BUTTONROLE_IDX                          361
#define SBK_QDIALOGBUTTONBOX_STANDARDBUTTON_IDX                      362
#define SBK_QFLAGS_QDIALOGBUTTONBOX_STANDARDBUTTON__IDX              363
#define SBK_QRUBBERBAND_IDX                                          364
#define SBK_QRUBBERBAND_SHAPE_IDX                                    365
#define SBK_QFRAME_IDX                                               366
#define SBK_QFRAME_STYLEMASK_IDX                                     367
#define SBK_QFRAME_SHAPE_IDX                                         368
#define SBK_QFRAME_SHADOW_IDX                                        369
#define SBK_QSPLITTER_IDX                                            370
#define SBK_QLCDNUMBER_IDX                                           371
#define SBK_QLCDNUMBER_MODE_IDX                                      372
#define SBK_QLCDNUMBER_SEGMENTSTYLE_IDX                              373
#define SBK_QABSTRACTSCROLLAREA_IDX                                  374
#define SBK_QDOCKWIDGET_IDX                                          375
#define SBK_QDOCKWIDGET_DOCKWIDGETFEATURE_IDX                        376
#define SBK_QFLAGS_QDOCKWIDGET_DOCKWIDGETFEATURE__IDX                377
#define SBK_QABSTRACTBUTTON_IDX                                      378
#define SBK_QCHECKBOX_IDX                                            379
#define SBK_QSCROLLAREA_IDX                                          380
#define SBK_QCALENDARWIDGET_IDX                                      381
#define SBK_QCALENDARWIDGET_HORIZONTALHEADERFORMAT_IDX               382
#define SBK_QCALENDARWIDGET_VERTICALHEADERFORMAT_IDX                 383
#define SBK_QCALENDARWIDGET_SELECTIONMODE_IDX                        384
#define SBK_QABSTRACTSPINBOX_IDX                                     385
#define SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX                     386
#define SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG__IDX             387
#define SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX                      388
#define SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX                       389
#define SBK_QMDIAREA_IDX                                             390
#define SBK_QMDIAREA_WINDOWORDER_IDX                                 391
#define SBK_QMDIAREA_VIEWMODE_IDX                                    392
#define SBK_QMDIAREA_AREAOPTION_IDX                                  393
#define SBK_QFLAGS_QMDIAREA_AREAOPTION__IDX                          394
#define SBK_QSTACKEDWIDGET_IDX                                       395
#define SBK_QMDISUBWINDOW_IDX                                        396
#define SBK_QMDISUBWINDOW_SUBWINDOWOPTION_IDX                        397
#define SBK_QFLAGS_QMDISUBWINDOW_SUBWINDOWOPTION__IDX                398
#define SBK_QLABEL_IDX                                               399
#define SBK_QSCROLLBAR_IDX                                           400
#define SBK_QPRINTPREVIEWWIDGET_IDX                                  401
#define SBK_QPRINTPREVIEWWIDGET_ZOOMMODE_IDX                         402
#define SBK_QPRINTPREVIEWWIDGET_VIEWMODE_IDX                         403
#define SBK_QSPLASHSCREEN_IDX                                        404
#define SBK_QWORKSPACE_IDX                                           405
#define SBK_QWORKSPACE_WINDOWORDER_IDX                               406
#define SBK_QSLIDER_IDX                                              407
#define SBK_QSLIDER_TICKPOSITION_IDX                                 408
#define SBK_QDESKTOPWIDGET_IDX                                       409
#define SBK_QPAINTER_IDX                                             410
#define SBK_QPAINTER_COMPOSITIONMODE_IDX                             411
#define SBK_QPAINTER_RENDERHINT_IDX                                  412
#define SBK_QFLAGS_QPAINTER_RENDERHINT__IDX                          413
#define SBK_QSTYLEPAINTER_IDX                                        414
#define SBK_QGROUPBOX_IDX                                            415
#define SBK_QSTATUSBAR_IDX                                           416
#define SBK_QSPLITTERHANDLE_IDX                                      417
#define SBK_QTOOLBAR_IDX                                             418
#define SBK_QLINEEDIT_IDX                                            419
#define SBK_QLINEEDIT_ECHOMODE_IDX                                   420
#define SBK_QSTYLEOPTIONCOMPLEX_IDX                                  421
#define SBK_QSTYLEOPTIONCOMPLEX_STYLEOPTIONVERSION_IDX               422
#define SBK_QSTYLEOPTIONCOMPLEX_STYLEOPTIONTYPE_IDX                  423
#define SBK_QSTYLEOPTIONGROUPBOX_IDX                                 424
#define SBK_QSTYLEOPTIONGROUPBOX_STYLEOPTIONVERSION_IDX              425
#define SBK_QSTYLEOPTIONGROUPBOX_STYLEOPTIONTYPE_IDX                 426
#define SBK_QSTYLEOPTIONTITLEBAR_IDX                                 427
#define SBK_QSTYLEOPTIONTITLEBAR_STYLEOPTIONVERSION_IDX              428
#define SBK_QSTYLEOPTIONTITLEBAR_STYLEOPTIONTYPE_IDX                 429
#define SBK_QSTYLEOPTIONSLIDER_IDX                                   430
#define SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONVERSION_IDX                431
#define SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONTYPE_IDX                   432
#define SBK_QSTYLEOPTIONSIZEGRIP_IDX                                 433
#define SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX              434
#define SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX                 435
#define SBK_QSTYLEOPTIONSPINBOX_IDX                                  436
#define SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX               437
#define SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX                  438
#define SBK_QSTYLEOPTIONTOOLBUTTON_IDX                               439
#define SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX            440
#define SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX             441
#define SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE__IDX     442
#define SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX               443
#define SBK_QSTYLEOPTIONCOMBOBOX_IDX                                 444
#define SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONVERSION_IDX              445
#define SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONTYPE_IDX                 446
#define SBK_QSTYLEOPTIONFOCUSRECT_IDX                                447
#define SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX             448
#define SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX                449
#define SBK_QSTYLEOPTIONTOOLBOXV2_IDX                                450
#define SBK_QSTYLEOPTIONTOOLBOXV2_STYLEOPTIONVERSION_IDX             451
#define SBK_QSTYLEOPTIONTOOLBOXV2_TABPOSITION_IDX                    452
#define SBK_QSTYLEOPTIONTOOLBOXV2_SELECTEDPOSITION_IDX               453
#define SBK_QGRAPHICSSCENEEVENT_IDX                                  454
#define SBK_QGRAPHICSSCENERESIZEEVENT_IDX                            455
#define SBK_QGRAPHICSSCENEWHEELEVENT_IDX                             456
#define SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX                          457
#define SBK_QGRAPHICSSCENEHELPEVENT_IDX                              458
#define SBK_QGRAPHICSSCENEMOUSEEVENT_IDX                             459
#define SBK_QGRAPHICSSCENEHOVEREVENT_IDX                             460
#define SBK_QGRAPHICSSCENEMOVEEVENT_IDX                              461
#define SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX                       462
#define SBK_QGRAPHICSSCENECONTEXTMENUEVENT_REASON_IDX                463
#define SBK_QINPUTMETHODEVENT_IDX                                    464
#define SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX                      465
#define SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX                          466
#define SBK_QSPINBOX_IDX                                             467
#define SBK_QINPUTCONTEXT_IDX                                        468
#define SBK_QINPUTCONTEXT_STANDARDFORMAT_IDX                         469
#define SBK_QDESKTOPSERVICES_IDX                                     470
#define SBK_QDESKTOPSERVICES_STANDARDLOCATION_IDX                    471
#define SBK_QSESSIONMANAGER_IDX                                      472
#define SBK_QSESSIONMANAGER_RESTARTHINT_IDX                          473
#define SBK_QFOCUSEVENT_IDX                                          474
#define SBK_QGRAPHICSOBJECT_IDX                                      475
#define SBK_QGRAPHICSTEXTITEM_IDX                                    476
#define SBK_QPLAINTEXTDOCUMENTLAYOUT_IDX                             477
#define SBK_QTEXTBLOCKGROUP_IDX                                      478
#define SBK_QTEXTLIST_IDX                                            479
#define SBK_QITEMSELECTIONRANGE_IDX                                  480
#define SBK_QFONTMETRICS_IDX                                         481
#define SBK_QINTVALIDATOR_IDX                                        482
#define SBK_QITEMEDITORCREATORBASE_IDX                               483
#define SBK_QCONTEXTMENUEVENT_IDX                                    484
#define SBK_QCONTEXTMENUEVENT_REASON_IDX                             485
#define SBK_QDOUBLESPINBOX_IDX                                       486
#define SBK_QRADIOBUTTON_IDX                                         487
#define SBK_QWHEELEVENT_IDX                                          488
#define SBK_QABSTRACTITEMVIEW_IDX                                    489
#define SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX                       490
#define SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX                  491
#define SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX                        492
#define SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER__IDX                493
#define SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX                         494
#define SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX                       495
#define SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX              496
#define SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX                         497
#define SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX                      498
#define SBK_QABSTRACTITEMVIEW_STATE_IDX                              499
#define SBK_QTABLEVIEW_IDX                                           500
#define SBK_QTREEVIEW_IDX                                            501
#define SBK_QCOLUMNVIEW_IDX                                          502
#define SBK_QLISTVIEW_IDX                                            503
#define SBK_QLISTVIEW_RESIZEMODE_IDX                                 504
#define SBK_QLISTVIEW_LAYOUTMODE_IDX                                 505
#define SBK_QLISTVIEW_VIEWMODE_IDX                                   506
#define SBK_QLISTVIEW_FLOW_IDX                                       507
#define SBK_QLISTVIEW_MOVEMENT_IDX                                   508
#define SBK_QLISTWIDGET_IDX                                          509
#define SBK_QUNDOVIEW_IDX                                            510
#define SBK_QHEADERVIEW_IDX                                          511
#define SBK_QHEADERVIEW_RESIZEMODE_IDX                               512
#define SBK_QVECTOR4D_IDX                                            513
#define SBK_QTOOLBARCHANGEEVENT_IDX                                  514
#define SBK_QCURSOR_IDX                                              515
#define SBK_QPUSHBUTTON_IDX                                          516
#define SBK_QCOMMANDLINKBUTTON_IDX                                   517
#define SBK_QTEXTITEM_IDX                                            518
#define SBK_QTEXTITEM_RENDERFLAG_IDX                                 519
#define SBK_QFLAGS_QTEXTITEM_RENDERFLAG__IDX                         520
#define SBK_QGRAPHICSLINEITEM_IDX                                    521
#define SBK_QDIRMODEL_IDX                                            522
#define SBK_QDIRMODEL_ROLES_IDX                                      523
#define SBK_QTREEWIDGET_IDX                                          524
#define SBK_QTRANSFORM_IDX                                           525
#define SBK_QTRANSFORM_TRANSFORMATIONTYPE_IDX                        526
#define SBK_QICONENGINEV2_IDX                                        527
#define SBK_QICONENGINEV2_ICONENGINEHOOK_IDX                         528
#define SBK_QLINEARGRADIENT_IDX                                      529
#define SBK_QCLEANLOOKSSTYLE_IDX                                     530
#define SBK_QFONT_IDX                                                531
#define SBK_QFONT_STYLESTRATEGY_IDX                                  532
#define SBK_QFONT_SPACINGTYPE_IDX                                    533
#define SBK_QFONT_STYLEHINT_IDX                                      534
#define SBK_QFONT_WEIGHT_IDX                                         535
#define SBK_QFONT_CAPITALIZATION_IDX                                 536
#define SBK_QFONT_STRETCH_IDX                                        537
#define SBK_QFONT_STYLE_IDX                                          538
#define SBK_QGRAPHICSSCENE_IDX                                       539
#define SBK_QGRAPHICSSCENE_SCENELAYER_IDX                            540
#define SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER__IDX                    541
#define SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX                       542
#define SBK_QGRAPHICSVIEW_IDX                                        543
#define SBK_QGRAPHICSVIEW_OPTIMIZATIONFLAG_IDX                       544
#define SBK_QFLAGS_QGRAPHICSVIEW_OPTIMIZATIONFLAG__IDX               545
#define SBK_QGRAPHICSVIEW_VIEWPORTANCHOR_IDX                         546
#define SBK_QGRAPHICSVIEW_VIEWPORTUPDATEMODE_IDX                     547
#define SBK_QGRAPHICSVIEW_CACHEMODEFLAG_IDX                          548
#define SBK_QFLAGS_QGRAPHICSVIEW_CACHEMODEFLAG__IDX                  549
#define SBK_QGRAPHICSVIEW_DRAGMODE_IDX                               550
#define SBK_QSTYLEOPTIONVIEWITEM_IDX                                 551
#define SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX              552
#define SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX                 553
#define SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX                        554
#define SBK_QSTYLEOPTIONVIEWITEMV2_IDX                               555
#define SBK_QSTYLEOPTIONVIEWITEMV2_STYLEOPTIONVERSION_IDX            556
#define SBK_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE_IDX               557
#define SBK_QFLAGS_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE__IDX       558
#define SBK_QSTYLEOPTIONVIEWITEMV3_IDX                               559
#define SBK_QSTYLEOPTIONVIEWITEMV3_STYLEOPTIONVERSION_IDX            560
#define SBK_QSTYLEOPTIONVIEWITEMV4_IDX                               561
#define SBK_QSTYLEOPTIONVIEWITEMV4_VIEWITEMPOSITION_IDX              562
#define SBK_QSTYLEOPTIONVIEWITEMV4_STYLEOPTIONVERSION_IDX            563
#define SBK_QWHATSTHISCLICKEDEVENT_IDX                               564
#define SBK_QPRINTER_IDX                                             565
#define SBK_QPRINTER_OUTPUTFORMAT_IDX                                566
#define SBK_QPRINTER_DUPLEXMODE_IDX                                  567
#define SBK_QPRINTER_PRINTRANGE_IDX                                  568
#define SBK_QPRINTER_UNIT_IDX                                        569
#define SBK_QPRINTER_PRINTERMODE_IDX                                 570
#define SBK_QPRINTER_ORIENTATION_IDX                                 571
#define SBK_QPRINTER_PRINTERSTATE_IDX                                572
#define SBK_QPRINTER_COLORMODE_IDX                                   573
#define SBK_QPRINTER_PAPERSOURCE_IDX                                 574
#define SBK_QPRINTER_PAGEORDER_IDX                                   575
#define SBK_QPRINTER_PAGESIZE_IDX                                    576
#define SBK_QGRIDLAYOUT_IDX                                          577
#define SBK_QSIZEPOLICY_IDX                                          578
#define SBK_QSIZEPOLICY_CONTROLTYPE_IDX                              579
#define SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE__IDX                      580
#define SBK_QSIZEPOLICY_POLICYFLAG_IDX                               581
#define SBK_QSIZEPOLICY_POLICY_IDX                                   582
#define SBK_QSPACERITEM_IDX                                          583
#define SBK_QPROGRESSBAR_IDX                                         584
#define SBK_QPROGRESSBAR_DIRECTION_IDX                               585
#define SBK_QLISTWIDGETITEM_IDX                                      586
#define SBK_QLISTWIDGETITEM_ITEMTYPE_IDX                             587
#define SBK_QQUATERNION_IDX                                          588
#define SBK_QMATRIX4X4_IDX                                           589
#define SBK_QMATRIX_IDX                                              590
#define SBK_QPAINTERPATH_IDX                                         591
#define SBK_QPAINTERPATH_ELEMENTTYPE_IDX                             592
#define SBK_QPAINTERPATH_ELEMENT_IDX                                 593
#define SBK_QWHATSTHIS_IDX                                           594
#define SBK_QCOMBOBOX_IDX                                            595
#define SBK_QCOMBOBOX_INSERTPOLICY_IDX                               596
#define SBK_QCOMBOBOX_SIZEADJUSTPOLICY_IDX                           597
#define SBK_QFONTCOMBOBOX_IDX                                        598
#define SBK_QFONTCOMBOBOX_FONTFILTER_IDX                             599
#define SBK_QFLAGS_QFONTCOMBOBOX_FONTFILTER__IDX                     600
#define SBK_QTOOLBUTTON_IDX                                          601
#define SBK_QTOOLBUTTON_TOOLBUTTONPOPUPMODE_IDX                      602
#define SBK_QDIALOG_IDX                                              603
#define SBK_QDIALOG_DIALOGCODE_IDX                                   604
#define SBK_QPROGRESSDIALOG_IDX                                      605
#define SBK_QWIZARD_IDX                                              606
#define SBK_QWIZARD_WIZARDBUTTON_IDX                                 607
#define SBK_QWIZARD_WIZARDSTYLE_IDX                                  608
#define SBK_QWIZARD_WIZARDPIXMAP_IDX                                 609
#define SBK_QWIZARD_WIZARDOPTION_IDX                                 610
#define SBK_QFLAGS_QWIZARD_WIZARDOPTION__IDX                         611
#define SBK_QABSTRACTPRINTDIALOG_IDX                                 612
#define SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX                      613
#define SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX               614
#define SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION__IDX       615
#define SBK_QPRINTDIALOG_IDX                                         616
#define SBK_QCOLORDIALOG_IDX                                         617
#define SBK_QCOLORDIALOG_COLORDIALOGOPTION_IDX                       618
#define SBK_QFLAGS_QCOLORDIALOG_COLORDIALOGOPTION__IDX               619
#define SBK_QPRINTPREVIEWDIALOG_IDX                                  620
#define SBK_QABSTRACTPAGESETUPDIALOG_IDX                             621
#define SBK_QPAGESETUPDIALOG_IDX                                     622
#define SBK_QPAGESETUPDIALOG_PAGESETUPDIALOGOPTION_IDX               623
#define SBK_QFLAGS_QPAGESETUPDIALOG_PAGESETUPDIALOGOPTION__IDX       624
#define SBK_QERRORMESSAGE_IDX                                        625
#define SBK_QFILEICONPROVIDER_IDX                                    626
#define SBK_QFILEICONPROVIDER_ICONTYPE_IDX                           627
#define SBK_QAPPLICATION_IDX                                         628
#define SBK_QAPPLICATION_TYPE_IDX                                    629
#define SBK_QAPPLICATION_COLORSPEC_IDX                               630
#define SBK_QTABLEWIDGET_IDX                                         631
#define SBK_QGRAPHICSLAYOUTITEM_IDX                                  632
#define SBK_QGRAPHICSWIDGET_IDX                                      633
#define SBK_QGRAPHICSPROXYWIDGET_IDX                                 634
#define SBK_QGRAPHICSLAYOUT_IDX                                      635
#define SBK_QGRAPHICSANCHORLAYOUT_IDX                                636
#define SBK_QGRAPHICSGRIDLAYOUT_IDX                                  637
#define SBK_QGRAPHICSLINEARLAYOUT_IDX                                638
#define SBK_QTOOLBOX_IDX                                             639
#define SBK_QTEXTFORMAT_IDX                                          640
#define SBK_QTEXTFORMAT_PROPERTY_IDX                                 641
#define SBK_QTEXTFORMAT_FORMATTYPE_IDX                               642
#define SBK_QTEXTFORMAT_OBJECTTYPES_IDX                              643
#define SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX                            644
#define SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG__IDX                    645
#define SBK_QTEXTBLOCKFORMAT_IDX                                     646
#define SBK_QTEXTLISTFORMAT_IDX                                      647
#define SBK_QTEXTLISTFORMAT_STYLE_IDX                                648
#define SBK_QTEXTFRAMEFORMAT_IDX                                     649
#define SBK_QTEXTFRAMEFORMAT_POSITION_IDX                            650
#define SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX                         651
#define SBK_QTEXTTABLEFORMAT_IDX                                     652
#define SBK_QTEXTCHARFORMAT_IDX                                      653
#define SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX                    654
#define SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX                       655
#define SBK_QTEXTIMAGEFORMAT_IDX                                     656
#define SBK_QTEXTTABLECELLFORMAT_IDX                                 657
#define SBK_QDATETIMEEDIT_IDX                                        658
#define SBK_QDATETIMEEDIT_SECTION_IDX                                659
#define SBK_QFLAGS_QDATETIMEEDIT_SECTION__IDX                        660
#define SBK_QTIMEEDIT_IDX                                            661
#define SBK_QDATEEDIT_IDX                                            662
#define SBK_QTEXTBLOCKUSERDATA_IDX                                   663
#define SBK_QITEMSELECTIONMODEL_IDX                                  664
#define SBK_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX                    665
#define SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG__IDX            666
#define SBK_QMOVIE_IDX                                               667
#define SBK_QMOVIE_CACHEMODE_IDX                                     668
#define SBK_QMOVIE_MOVIESTATE_IDX                                    669
#define SBK_QTEXTTABLE_IDX                                           670
#define SBK_QINPUTDIALOG_IDX                                         671
#define SBK_QINPUTDIALOG_INPUTMODE_IDX                               672
#define SBK_QINPUTDIALOG_INPUTDIALOGOPTION_IDX                       673
#define SBK_QGTKSTYLE_IDX                                            674
#define SBK_QUNDOGROUP_IDX                                           675
#define SBK_QFILEDIALOG_IDX                                          676
#define SBK_QFILEDIALOG_FILEMODE_IDX                                 677
#define SBK_QFILEDIALOG_OPTION_IDX                                   678
#define SBK_QFLAGS_QFILEDIALOG_OPTION__IDX                           679
#define SBK_QFILEDIALOG_DIALOGLABEL_IDX                              680
#define SBK_QFILEDIALOG_VIEWMODE_IDX                                 681
#define SBK_QFILEDIALOG_ACCEPTMODE_IDX                               682
#define SBK_QUNDOSTACK_IDX                                           683
#define SBK_QTEXTCURSOR_IDX                                          684
#define SBK_QTEXTCURSOR_MOVEMODE_IDX                                 685
#define SBK_QTEXTCURSOR_MOVEOPERATION_IDX                            686
#define SBK_QTEXTCURSOR_SELECTIONTYPE_IDX                            687
#define SBK_QPLAINTEXTEDIT_IDX                                       688
#define SBK_QPLAINTEXTEDIT_LINEWRAPMODE_IDX                          689
#define SBK_QIMAGE_IDX                                               690
#define SBK_QIMAGE_INVERTMODE_IDX                                    691
#define SBK_QIMAGE_FORMAT_IDX                                        692
#define SBK_QBITMAP_IDX                                              693
#define SBK_QFONTDATABASE_IDX                                        694
#define SBK_QFONTDATABASE_WRITINGSYSTEM_IDX                          695
#define SBK_QKEYEVENT_IDX                                            696
#define SBK_QMESSAGEBOX_IDX                                          697
#define SBK_QMESSAGEBOX_BUTTONROLE_IDX                               698
#define SBK_QMESSAGEBOX_STANDARDBUTTON_IDX                           699
#define SBK_QFLAGS_QMESSAGEBOX_STANDARDBUTTON__IDX                   700
#define SBK_QMESSAGEBOX_ICON_IDX                                     701
#define SBK_QTEXTEDIT_IDX                                            702
#define SBK_QTEXTEDIT_AUTOFORMATTINGFLAG_IDX                         703
#define SBK_QFLAGS_QTEXTEDIT_AUTOFORMATTINGFLAG__IDX                 704
#define SBK_QTEXTEDIT_LINEWRAPMODE_IDX                               705
#define SBK_QTEXTBROWSER_IDX                                         706
#define SBK_QTEXTEDIT_EXTRASELECTION_IDX                             707
#define SBK_QMENUBAR_IDX                                             708
#define SBK_QTEXTTABLECELL_IDX                                       709
#define SBK_QTEXTOBJECTINTERFACE_IDX                                 710
#define SBK_QABSTRACTPROXYMODEL_IDX                                  711
#define SBK_QSORTFILTERPROXYMODEL_IDX                                712
#define SBK_QFONTDIALOG_IDX                                          713
#define SBK_QFONTDIALOG_FONTDIALOGOPTION_IDX                         714
#define SBK_QFLAGS_QFONTDIALOG_FONTDIALOGOPTION__IDX                 715
#define SBK_QtGui_IDX_COUNT                                          716

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtGuiTypes;

// Macros for type check
#define SbkQMatrix2x4_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX2X4_IDX])
#define SbkQMatrix2x3_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX2X3_IDX])
#define SbkQMatrix2x2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX2X2_IDX])
#define SbkQMatrix3x4_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX3X4_IDX])
#define SbkQMatrix3x3_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX3X3_IDX])
#define SbkQMatrix3x2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX3X2_IDX])
#define SbkQMatrix4x3_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX4X3_IDX])
#define SbkQMatrix4x2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX4X2_IDX])
#define SbkQItemEditorFactory_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMEDITORFACTORY_IDX])
#define SbkQIconEngine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICONENGINE_IDX])
#define SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])
#define SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG__IDX])
#define SbkQTreeWidgetItemIterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEMITERATOR_IDX])
#define SbkQTileRules_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTILERULES_IDX])
#define SbkQFontMetricsF_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTMETRICSF_IDX])
#define SbkQItemSelection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMSELECTION_IDX])
#define SbkPySide_QtGui_QKeySequence_SequenceFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])
#define SbkPySide_QtGui_QKeySequence_StandardKey_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])
#define SbkPySide_QtGui_QKeySequence_SequenceMatch_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX])
#define SbkQKeySequence_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_IDX])
#define SbkQStringListModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTRINGLISTMODEL_IDX])
#define SbkPySide_QtGui_QTextOption_TabType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX])
#define SbkPySide_QtGui_QTextOption_Flag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX])
#define SbkPySide_QtGui_QTextOption_Flags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG__IDX])
#define SbkPySide_QtGui_QTextOption_WrapMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX])
#define SbkQTextOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_IDX])
#define SbkQTextOption_Tab_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX])
#define SbkQBrush_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QBRUSH_IDX])
#define SbkQX11Info_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QX11INFO_IDX])
#define SbkQTextInlineObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTINLINEOBJECT_IDX])
#define SbkQInputContextFactory_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTCONTEXTFACTORY_IDX])
#define SbkQPictureIO_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPICTUREIO_IDX])
#define SbkQToolTip_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOOLTIP_IDX])
#define SbkQPrinterInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTERINFO_IDX])
#define SbkPySide_QtGui_QTextLine_Edge_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLINE_EDGE_IDX])
#define SbkPySide_QtGui_QTextLine_CursorPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLINE_CURSORPOSITION_IDX])
#define SbkQTextLine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLINE_IDX])
#define SbkQUndoCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QUNDOCOMMAND_IDX])
#define SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX])
#define SbkPySide_QtGui_QGestureRecognizer_Result_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG__IDX])
#define SbkQGestureRecognizer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_IDX])
#define SbkQTextFragment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFRAGMENT_IDX])
#define SbkPySide_QtGui_QAction_Priority_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTION_PRIORITY_IDX])
#define SbkPySide_QtGui_QAction_ActionEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTION_ACTIONEVENT_IDX])
#define SbkPySide_QtGui_QAction_SoftKeyRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTION_SOFTKEYROLE_IDX])
#define SbkPySide_QtGui_QAction_MenuRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTION_MENUROLE_IDX])
#define SbkQAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTION_IDX])
#define SbkQActionGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTIONGROUP_IDX])
#define SbkQButtonGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QBUTTONGROUP_IDX])
#define SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX])
#define SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX])
#define SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG__IDX])
#define SbkQGraphicsEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_IDX])
#define SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX])
#define SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT__IDX])
#define SbkQGraphicsBlurEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSBLUREFFECT_IDX])
#define SbkQGraphicsColorizeEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSCOLORIZEEFFECT_IDX])
#define SbkQGraphicsOpacityEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSOPACITYEFFECT_IDX])
#define SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDATAWIDGETMAPPER_SUBMITPOLICY_IDX])
#define SbkQDataWidgetMapper_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDATAWIDGETMAPPER_IDX])
#define SbkPySide_QtGui_QClipboard_Mode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])
#define SbkQClipboard_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCLIPBOARD_IDX])
#define SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_MESSAGEICON_IDX])
#define SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_ACTIVATIONREASON_IDX])
#define SbkQSystemTrayIcon_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_IDX])
#define SbkQStyleFactory_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEFACTORY_IDX])
#define SbkQPolygonF_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPOLYGONF_IDX])
#define SbkQKeyEventTransition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QKEYEVENTTRANSITION_IDX])
#define SbkQMouseEventTransition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOUSEEVENTTRANSITION_IDX])
#define SbkQTextObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOBJECT_IDX])
#define SbkQTextFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFRAME_IDX])
#define SbkPySide_QtGui_QTreeWidgetItem_ItemType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_ITEMTYPE_IDX])
#define SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_CHILDINDICATORPOLICY_IDX])
#define SbkQTreeWidgetItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_IDX])
#define SbkPySide_QtGui_QValidator_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QVALIDATOR_STATE_IDX])
#define SbkQValidator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QVALIDATOR_IDX])
#define SbkPySide_QtGui_QTextLength_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLENGTH_TYPE_IDX])
#define SbkQTextLength_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLENGTH_IDX])
#define SbkPySide_QtGui_QImageReader_ImageReaderError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX])
#define SbkQImageReader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGEREADER_IDX])
#define SbkQPaintEngineState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX])
#define SbkQWidgetAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIDGETACTION_IDX])
#define SbkQPolygon_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPOLYGON_IDX])
#define SbkQGraphicsAnchor_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSANCHOR_IDX])
#define SbkPySide_QtGui_QColor_Spec_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOLOR_SPEC_IDX])
#define SbkQColor_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOLOR_IDX])
#define SbkPySide_QtGui_QGesture_GestureCancelPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGESTURE_GESTURECANCELPOLICY_IDX])
#define SbkQGesture_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGESTURE_IDX])
#define SbkQAbstractKineticScroller_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTKINETICSCROLLER_IDX])
#define SbkPySide_QtGui_QTableWidgetItem_ItemType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETITEM_ITEMTYPE_IDX])
#define SbkQTableWidgetItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETITEM_IDX])
#define SbkPySide_QtGui_QCompleter_ModelSorting_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMPLETER_MODELSORTING_IDX])
#define SbkPySide_QtGui_QCompleter_CompletionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX])
#define SbkQCompleter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMPLETER_IDX])
#define SbkQClipboardEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCLIPBOARDEVENT_IDX])
#define SbkQWindowStateChangeEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWINDOWSTATECHANGEEVENT_IDX])
#define SbkQCloseEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCLOSEEVENT_IDX])
#define SbkQIconDragEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICONDRAGEVENT_IDX])
#define SbkQFileOpenEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEOPENEVENT_IDX])
#define SbkQShortcutEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSHORTCUTEVENT_IDX])
#define SbkQShowEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSHOWEVENT_IDX])
#define SbkQStatusTipEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTATUSTIPEVENT_IDX])
#define SbkQHideEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QHIDEEVENT_IDX])
#define SbkQHelpEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QHELPEVENT_IDX])
#define SbkQDropEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX])
#define SbkQActionEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACTIONEVENT_IDX])
#define SbkPySide_QtGui_QPinchGesture_ChangeFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPINCHGESTURE_CHANGEFLAG_IDX])
#define SbkPySide_QtGui_QPinchGesture_ChangeFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QPINCHGESTURE_CHANGEFLAG__IDX])
#define SbkQPinchGesture_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPINCHGESTURE_IDX])
#define SbkQPainterPathStroker_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX])
#define SbkQShortcut_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSHORTCUT_IDX])
#define SbkQRegExpValidator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QREGEXPVALIDATOR_IDX])
#define SbkPySide_QtGui_QRegion_RegionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QREGION_REGIONTYPE_IDX])
#define SbkQRegion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QREGION_IDX])
#define SbkQGraphicsItemAnimation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEMANIMATION_IDX])
#define SbkQResizeEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QRESIZEEVENT_IDX])
#define SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_ENDEDITHINT_IDX])
#define SbkQAbstractItemDelegate_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_IDX])
#define SbkQStyledItemDelegate_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEDITEMDELEGATE_IDX])
#define SbkQItemDelegate_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMDELEGATE_IDX])
#define SbkQLayoutItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])
#define SbkPySide_QtGui_QLayout_SizeConstraint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX])
#define SbkQLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX])
#define SbkPySide_QtGui_QStackedLayout_StackingMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTACKEDLAYOUT_STACKINGMODE_IDX])
#define SbkQStackedLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTACKEDLAYOUT_IDX])
#define SbkQWidgetItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIDGETITEM_IDX])
#define SbkQPixmapCache_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPIXMAPCACHE_IDX])
#define SbkQSound_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSOUND_IDX])
#define SbkQTextBlock_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTBLOCK_IDX])
#define SbkQTextFrame_iterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFRAME_ITERATOR_IDX])
#define SbkQTextBlock_iterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTBLOCK_ITERATOR_IDX])
#define SbkQMoveEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOVEEVENT_IDX])
#define SbkPySide_QtGui_QPaintEngine_PolygonDrawMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX])
#define SbkPySide_QtGui_QPaintEngine_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX])
#define SbkPySide_QtGui_QPaintEngine_PaintEngineFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX])
#define SbkPySide_QtGui_QPaintEngine_PaintEngineFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE__IDX])
#define SbkPySide_QtGui_QPaintEngine_DirtyFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX])
#define SbkPySide_QtGui_QPaintEngine_DirtyFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG__IDX])
#define SbkQPaintEngine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_IDX])
#define SbkPySide_QtGui_QBoxLayout_Direction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QBOXLAYOUT_DIRECTION_IDX])
#define SbkQBoxLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QBOXLAYOUT_IDX])
#define SbkQHBoxLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QHBOXLAYOUT_IDX])
#define SbkQVBoxLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QVBOXLAYOUT_IDX])
#define SbkQAccessibleEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QACCESSIBLEEVENT_IDX])
#define SbkPySide_QtGui_QImageWriter_ImageWriterError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX])
#define SbkQImageWriter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGEWRITER_IDX])
#define SbkPySide_QtGui_QStandardItem_ItemType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTANDARDITEM_ITEMTYPE_IDX])
#define SbkQStandardItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTANDARDITEM_IDX])
#define SbkQTextDocumentFragment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX])
#define SbkQPen_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPEN_IDX])
#define SbkPySide_QtGui_QTextDocument_ResourceType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX])
#define SbkPySide_QtGui_QTextDocument_FindFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX])
#define SbkPySide_QtGui_QTextDocument_FindFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG__IDX])
#define SbkPySide_QtGui_QTextDocument_MetaInformation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX])
#define SbkQTextDocument_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX])
#define SbkQAbstractTextDocumentLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX])
#define SbkQAbstractTextDocumentLayout_Selection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_SELECTION_IDX])
#define SbkQAbstractTextDocumentLayout_PaintContext_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX])
#define SbkPySide_QtGui_QTextLayout_CursorMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_CURSORMODE_IDX])
#define SbkQTextLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_IDX])
#define SbkQTextLayout_FormatRange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX])
#define SbkQDrag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDRAG_IDX])
#define SbkPySide_QtGui_QGraphicsItem_CacheMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_CACHEMODE_IDX])
#define SbkPySide_QtGui_QGraphicsItem_PanelModality_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_PANELMODALITY_IDX])
#define SbkPySide_QtGui_QGraphicsItem_GraphicsItemFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_GRAPHICSITEMFLAG_IDX])
#define SbkPySide_QtGui_QGraphicsItem_GraphicsItemFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSITEM_GRAPHICSITEMFLAG__IDX])
#define SbkPySide_QtGui_QGraphicsItem_GraphicsItemChange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_GRAPHICSITEMCHANGE_IDX])
#define SbkPySide_QtGui_QGraphicsItem_Extension_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_EXTENSION_IDX])
#define SbkQGraphicsItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_IDX])
#define SbkPySide_QtGui_QGraphicsPixmapItem_ShapeMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSPIXMAPITEM_SHAPEMODE_IDX])
#define SbkQGraphicsPixmapItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSPIXMAPITEM_IDX])
#define SbkQAbstractGraphicsShapeItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTGRAPHICSSHAPEITEM_IDX])
#define SbkQGraphicsPolygonItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSPOLYGONITEM_IDX])
#define SbkQGraphicsRectItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSRECTITEM_IDX])
#define SbkPySide_QtGui_QIcon_Mode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICON_MODE_IDX])
#define SbkPySide_QtGui_QIcon_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICON_STATE_IDX])
#define SbkQIcon_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICON_IDX])
#define SbkQGraphicsItemGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEMGROUP_IDX])
#define SbkQGraphicsEllipseItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSELLIPSEITEM_IDX])
#define SbkQGraphicsSimpleTextItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSIMPLETEXTITEM_IDX])
#define SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])
#define SbkQPaintDevice_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])
#define SbkPySide_QtGui_QPixmap_ShareMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPIXMAP_SHAREMODE_IDX])
#define SbkQPixmap_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPIXMAP_IDX])
#define SbkQPicture_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPICTURE_IDX])
#define SbkQInputEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX])
#define SbkPySide_QtGui_QTouchEvent_DeviceType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_DEVICETYPE_IDX])
#define SbkQTouchEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_IDX])
#define SbkQTouchEvent_TouchPoint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX])
#define SbkPySide_QtGui_QTabletEvent_TabletDevice_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX])
#define SbkPySide_QtGui_QTabletEvent_PointerType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX])
#define SbkQTabletEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_IDX])
#define SbkQMouseEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOUSEEVENT_IDX])
#define SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSWIPEGESTURE_SWIPEDIRECTION_IDX])
#define SbkQSwipeGesture_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSWIPEGESTURE_IDX])
#define SbkQDragLeaveEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX])
#define SbkQStandardItemModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTANDARDITEMMODEL_IDX])
#define SbkQProxyModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPROXYMODEL_IDX])
#define SbkPySide_QtGui_QFileSystemModel_Roles_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILESYSTEMMODEL_ROLES_IDX])
#define SbkQFileSystemModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILESYSTEMMODEL_IDX])
#define SbkPySide_QtGui_QImageIOHandler_ImageOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])
#define SbkQImageIOHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX])
#define SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_FIELDGROWTHPOLICY_IDX])
#define SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_ROWWRAPPOLICY_IDX])
#define SbkPySide_QtGui_QFormLayout_ItemRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_ITEMROLE_IDX])
#define SbkQFormLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_IDX])
#define SbkQSyntaxHighlighter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX])
#define SbkQFontInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTINFO_IDX])
#define SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOption_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_STYLEOPTIONTYPE_IDX])
#define SbkPySide_QtGui_QStyleOption_OptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_OPTIONTYPE_IDX])
#define SbkQStyleOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX])
#define SbkPySide_QtGui_QStyleHintReturn_HintReturnType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX])
#define SbkPySide_QtGui_QStyleHintReturn_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleHintReturn_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX])
#define SbkQStyleHintReturn_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_IDX])
#define SbkPySide_QtGui_QStyleHintReturnMask_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleHintReturnMask_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX])
#define SbkQStyleHintReturnMask_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNMASK_IDX])
#define SbkPySide_QtGui_QStyleHintReturnVariant_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleHintReturnVariant_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX])
#define SbkQStyleHintReturnVariant_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNVARIANT_IDX])
#define SbkPySide_QtGui_QStyleOptionRubberBand_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONRUBBERBAND_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionRubberBand_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONRUBBERBAND_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionRubberBand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONRUBBERBAND_IDX])
#define SbkPySide_QtGui_QStyleOptionTabWidgetFrame_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABWIDGETFRAME_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionTabWidgetFrame_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABWIDGETFRAME_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionTabWidgetFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABWIDGETFRAME_IDX])
#define SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX])
#define SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX])
#define SbkQStyleOptionHeader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_IDX])
#define SbkPySide_QtGui_QStyleOptionButton_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionButton_ButtonFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_BUTTONFEATURE_IDX])
#define SbkPySide_QtGui_QStyleOptionButton_ButtonFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONBUTTON_BUTTONFEATURE__IDX])
#define SbkPySide_QtGui_QStyleOptionButton_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_IDX])
#define SbkPySide_QtGui_QStyleOptionDockWidget_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGET_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionDockWidget_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGET_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionDockWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGET_IDX])
#define SbkPySide_QtGui_QStyleOptionDockWidgetV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGETV2_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionDockWidgetV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGETV2_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE__IDX])
#define SbkQStyleOptionToolBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX])
#define SbkPySide_QtGui_QStyleOptionTabBarBase_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASE_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionTabBarBase_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASE_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionTabBarBase_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASE_IDX])
#define SbkPySide_QtGui_QStyleOptionTabBarBaseV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASEV2_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionTabBarBaseV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASEV2_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBox_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBox_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionToolBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX])
#define SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])
#define SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET__IDX])
#define SbkPySide_QtGui_QStyleOptionTab_TabPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionTab_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_IDX])
#define SbkPySide_QtGui_QStyleOptionTabV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV2_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionTabV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV2_IDX])
#define SbkPySide_QtGui_QStyleOptionTabV3_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV3_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionTabV3_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV3_IDX])
#define SbkPySide_QtGui_QStyleOptionProgressBar_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBAR_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionProgressBar_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBAR_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionProgressBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBAR_IDX])
#define SbkPySide_QtGui_QStyleOptionProgressBarV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBARV2_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionProgressBarV2_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBARV2_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionProgressBarV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBARV2_IDX])
#define SbkPySide_QtGui_QStyleOptionFrame_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionFrame_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_IDX])
#define SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE_IDX])
#define SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE__IDX])
#define SbkQStyleOptionFrameV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_IDX])
#define SbkPySide_QtGui_QStyleOptionFrameV3_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV3_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionFrameV3_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV3_IDX])
#define SbkQTableWidgetSelectionRange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX])
#define SbkQGraphicsDropShadowEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSDROPSHADOWEFFECT_IDX])
#define SbkPySide_QtGui_QGradient_CoordinateMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX])
#define SbkPySide_QtGui_QGradient_Spread_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX])
#define SbkPySide_QtGui_QGradient_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX])
#define SbkPySide_QtGui_QGradient_InterpolationMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX])
#define SbkQGradient_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRADIENT_IDX])
#define SbkQConicalGradient_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCONICALGRADIENT_IDX])
#define SbkQRadialGradient_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QRADIALGRADIENT_IDX])
#define SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX])
#define SbkQPrintEngine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_IDX])
#define SbkQGraphicsPathItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSPATHITEM_IDX])
#define SbkQDragMoveEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX])
#define SbkQDragEnterEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX])
#define SbkQHoverEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QHOVEREVENT_IDX])
#define SbkPySide_QtGui_QDoubleValidator_Notation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDOUBLEVALIDATOR_NOTATION_IDX])
#define SbkQDoubleValidator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDOUBLEVALIDATOR_IDX])
#define SbkQPaintEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTEVENT_IDX])
#define SbkPySide_QtGui_QPalette_ColorGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])
#define SbkPySide_QtGui_QPalette_ColorRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])
#define SbkQPalette_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPALETTE_IDX])
#define SbkPySide_QtGui_QStyle_PixelMetric_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_PIXELMETRIC_IDX])
#define SbkPySide_QtGui_QStyle_SubControl_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_SUBCONTROL_IDX])
#define SbkPySide_QtGui_QStyle_SubControls_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL__IDX])
#define SbkPySide_QtGui_QStyle_StandardPixmap_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX])
#define SbkPySide_QtGui_QStyle_StyleHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_STYLEHINT_IDX])
#define SbkPySide_QtGui_QStyle_PrimitiveElement_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX])
#define SbkPySide_QtGui_QStyle_ControlElement_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_CONTROLELEMENT_IDX])
#define SbkPySide_QtGui_QStyle_ContentsType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_CONTENTSTYPE_IDX])
#define SbkPySide_QtGui_QStyle_StateFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_STATEFLAG_IDX])
#define SbkPySide_QtGui_QStyle_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLE_STATEFLAG__IDX])
#define SbkPySide_QtGui_QStyle_ComplexControl_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])
#define SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX])
#define SbkPySide_QtGui_QStyle_SubElement_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_SUBELEMENT_IDX])
#define SbkQStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLE_IDX])
#define SbkQCommonStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMMONSTYLE_IDX])
#define SbkQMotifStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOTIFSTYLE_IDX])
#define SbkQWindowsStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWINDOWSSTYLE_IDX])
#define SbkQCDEStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCDESTYLE_IDX])
#define SbkQPlastiqueStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPLASTIQUESTYLE_IDX])
#define SbkQGraphicsTransform_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSTRANSFORM_IDX])
#define SbkQGraphicsRotation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSROTATION_IDX])
#define SbkQGraphicsScale_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCALE_IDX])
#define SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionGraphicsItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX])
#define SbkQVector3D_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QVECTOR3D_IDX])
#define SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX])
#define SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX])
#define SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX])
#define SbkQStyleOptionMenuItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_IDX])
#define SbkQVector2D_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QVECTOR2D_IDX])
#define SbkQPanGesture_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPANGESTURE_IDX])
#define SbkPySide_QtGui_QWidget_RenderFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIDGET_RENDERFLAG_IDX])
#define SbkPySide_QtGui_QWidget_RenderFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QWIDGET_RENDERFLAG__IDX])
#define SbkQWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])
#define SbkQSizeGrip_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSIZEGRIP_IDX])
#define SbkQWizardPage_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIZARDPAGE_IDX])
#define SbkPySide_QtGui_QTabBar_SelectionBehavior_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABBAR_SELECTIONBEHAVIOR_IDX])
#define SbkPySide_QtGui_QTabBar_ButtonPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABBAR_BUTTONPOSITION_IDX])
#define SbkPySide_QtGui_QTabBar_Shape_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABBAR_SHAPE_IDX])
#define SbkQTabBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABBAR_IDX])
#define SbkPySide_QtGui_QTabWidget_TabShape_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABWIDGET_TABSHAPE_IDX])
#define SbkPySide_QtGui_QTabWidget_TabPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABWIDGET_TABPOSITION_IDX])
#define SbkQTabWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABWIDGET_IDX])
#define SbkQFocusFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFOCUSFRAME_IDX])
#define SbkPySide_QtGui_QMainWindow_DockOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMAINWINDOW_DOCKOPTION_IDX])
#define SbkPySide_QtGui_QMainWindow_DockOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QMAINWINDOW_DOCKOPTION__IDX])
#define SbkQMainWindow_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMAINWINDOW_IDX])
#define SbkQMenu_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMENU_IDX])
#define SbkPySide_QtGui_QAbstractSlider_SliderAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_SLIDERACTION_IDX])
#define SbkPySide_QtGui_QAbstractSlider_SliderChange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_SLIDERCHANGE_IDX])
#define SbkQAbstractSlider_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_IDX])
#define SbkQDial_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIAL_IDX])
#define SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_BUTTONLAYOUT_IDX])
#define SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_BUTTONROLE_IDX])
#define SbkPySide_QtGui_QDialogButtonBox_StandardButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_STANDARDBUTTON_IDX])
#define SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QDIALOGBUTTONBOX_STANDARDBUTTON__IDX])
#define SbkQDialogButtonBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_IDX])
#define SbkPySide_QtGui_QRubberBand_Shape_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QRUBBERBAND_SHAPE_IDX])
#define SbkQRubberBand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QRUBBERBAND_IDX])
#define SbkPySide_QtGui_QFrame_StyleMask_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFRAME_STYLEMASK_IDX])
#define SbkPySide_QtGui_QFrame_Shape_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFRAME_SHAPE_IDX])
#define SbkPySide_QtGui_QFrame_Shadow_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFRAME_SHADOW_IDX])
#define SbkQFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFRAME_IDX])
#define SbkQSplitter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSPLITTER_IDX])
#define SbkPySide_QtGui_QLCDNumber_Mode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLCDNUMBER_MODE_IDX])
#define SbkPySide_QtGui_QLCDNumber_SegmentStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLCDNUMBER_SEGMENTSTYLE_IDX])
#define SbkQLCDNumber_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLCDNUMBER_IDX])
#define SbkQAbstractScrollArea_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX])
#define SbkPySide_QtGui_QDockWidget_DockWidgetFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDOCKWIDGET_DOCKWIDGETFEATURE_IDX])
#define SbkPySide_QtGui_QDockWidget_DockWidgetFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QDOCKWIDGET_DOCKWIDGETFEATURE__IDX])
#define SbkQDockWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDOCKWIDGET_IDX])
#define SbkQAbstractButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTBUTTON_IDX])
#define SbkQCheckBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCHECKBOX_IDX])
#define SbkQScrollArea_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSCROLLAREA_IDX])
#define SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_HORIZONTALHEADERFORMAT_IDX])
#define SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_VERTICALHEADERFORMAT_IDX])
#define SbkPySide_QtGui_QCalendarWidget_SelectionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_SELECTIONMODE_IDX])
#define SbkQCalendarWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_IDX])
#define SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])
#define SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG__IDX])
#define SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX])
#define SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX])
#define SbkQAbstractSpinBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_IDX])
#define SbkPySide_QtGui_QMdiArea_WindowOrder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMDIAREA_WINDOWORDER_IDX])
#define SbkPySide_QtGui_QMdiArea_ViewMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMDIAREA_VIEWMODE_IDX])
#define SbkPySide_QtGui_QMdiArea_AreaOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMDIAREA_AREAOPTION_IDX])
#define SbkPySide_QtGui_QMdiArea_AreaOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QMDIAREA_AREAOPTION__IDX])
#define SbkQMdiArea_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMDIAREA_IDX])
#define SbkQStackedWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTACKEDWIDGET_IDX])
#define SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMDISUBWINDOW_SUBWINDOWOPTION_IDX])
#define SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QMDISUBWINDOW_SUBWINDOWOPTION__IDX])
#define SbkQMdiSubWindow_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMDISUBWINDOW_IDX])
#define SbkQLabel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLABEL_IDX])
#define SbkQScrollBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSCROLLBAR_IDX])
#define SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_ZOOMMODE_IDX])
#define SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_VIEWMODE_IDX])
#define SbkQPrintPreviewWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_IDX])
#define SbkQSplashScreen_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSPLASHSCREEN_IDX])
#define SbkPySide_QtGui_QWorkspace_WindowOrder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWORKSPACE_WINDOWORDER_IDX])
#define SbkQWorkspace_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWORKSPACE_IDX])
#define SbkPySide_QtGui_QSlider_TickPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSLIDER_TICKPOSITION_IDX])
#define SbkQSlider_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSLIDER_IDX])
#define SbkQDesktopWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDESKTOPWIDGET_IDX])
#define SbkPySide_QtGui_QPainter_CompositionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX])
#define SbkPySide_QtGui_QPainter_RenderHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX])
#define SbkPySide_QtGui_QPainter_RenderHints_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT__IDX])
#define SbkQPainter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTER_IDX])
#define SbkQStylePainter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEPAINTER_IDX])
#define SbkQGroupBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGROUPBOX_IDX])
#define SbkQStatusBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTATUSBAR_IDX])
#define SbkQSplitterHandle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSPLITTERHANDLE_IDX])
#define SbkQToolBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOOLBAR_IDX])
#define SbkPySide_QtGui_QLineEdit_EchoMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLINEEDIT_ECHOMODE_IDX])
#define SbkQLineEdit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLINEEDIT_IDX])
#define SbkPySide_QtGui_QStyleOptionComplex_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionComplex_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionComplex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX])
#define SbkPySide_QtGui_QStyleOptionGroupBox_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGROUPBOX_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionGroupBox_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGROUPBOX_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionGroupBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGROUPBOX_IDX])
#define SbkPySide_QtGui_QStyleOptionTitleBar_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTITLEBAR_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionTitleBar_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTITLEBAR_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionTitleBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTITLEBAR_IDX])
#define SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionSlider_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_IDX])
#define SbkPySide_QtGui_QStyleOptionSizeGrip_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionSizeGrip_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionSizeGrip_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSIZEGRIP_IDX])
#define SbkPySide_QtGui_QStyleOptionSpinBox_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionSpinBox_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionSpinBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSPINBOX_IDX])
#define SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])
#define SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE__IDX])
#define SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionToolButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX])
#define SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionComboBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_IDX])
#define SbkPySide_QtGui_QStyleOptionFocusRect_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionFocusRect_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX])
#define SbkQStyleOptionFocusRect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFOCUSRECT_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_TABPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_SELECTEDPOSITION_IDX])
#define SbkQStyleOptionToolBoxV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_IDX])
#define SbkQGraphicsSceneEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX])
#define SbkQGraphicsSceneResizeEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENERESIZEEVENT_IDX])
#define SbkQGraphicsSceneWheelEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEWHEELEVENT_IDX])
#define SbkQGraphicsSceneDragDropEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX])
#define SbkQGraphicsSceneHelpEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEHELPEVENT_IDX])
#define SbkQGraphicsSceneMouseEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX])
#define SbkQGraphicsSceneHoverEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEHOVEREVENT_IDX])
#define SbkQGraphicsSceneMoveEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEMOVEEVENT_IDX])
#define SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_REASON_IDX])
#define SbkQGraphicsSceneContextMenuEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX])
#define SbkPySide_QtGui_QInputMethodEvent_AttributeType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX])
#define SbkQInputMethodEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX])
#define SbkQInputMethodEvent_Attribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX])
#define SbkQSpinBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSPINBOX_IDX])
#define SbkPySide_QtGui_QInputContext_StandardFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTCONTEXT_STANDARDFORMAT_IDX])
#define SbkQInputContext_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTCONTEXT_IDX])
#define SbkPySide_QtGui_QDesktopServices_StandardLocation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDESKTOPSERVICES_STANDARDLOCATION_IDX])
#define SbkQDesktopServices_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDESKTOPSERVICES_IDX])
#define SbkPySide_QtGui_QSessionManager_RestartHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX])
#define SbkQSessionManager_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSESSIONMANAGER_IDX])
#define SbkQFocusEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFOCUSEVENT_IDX])
#define SbkQGraphicsObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSOBJECT_IDX])
#define SbkQGraphicsTextItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSTEXTITEM_IDX])
#define SbkQPlainTextDocumentLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPLAINTEXTDOCUMENTLAYOUT_IDX])
#define SbkQTextBlockGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKGROUP_IDX])
#define SbkQTextList_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLIST_IDX])
#define SbkQItemSelectionRange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONRANGE_IDX])
#define SbkQFontMetrics_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTMETRICS_IDX])
#define SbkQIntValidator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINTVALIDATOR_IDX])
#define SbkQItemEditorCreatorBase_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMEDITORCREATORBASE_IDX])
#define SbkPySide_QtGui_QContextMenuEvent_Reason_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX])
#define SbkQContextMenuEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX])
#define SbkQDoubleSpinBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDOUBLESPINBOX_IDX])
#define SbkQRadioButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QRADIOBUTTON_IDX])
#define SbkQWheelEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWHEELEVENT_IDX])
#define SbkPySide_QtGui_QAbstractItemView_DragDropMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX])
#define SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX])
#define SbkPySide_QtGui_QAbstractItemView_EditTrigger_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])
#define SbkPySide_QtGui_QAbstractItemView_EditTriggers_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER__IDX])
#define SbkPySide_QtGui_QAbstractItemView_ScrollMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX])
#define SbkPySide_QtGui_QAbstractItemView_CursorAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX])
#define SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX])
#define SbkPySide_QtGui_QAbstractItemView_ScrollHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX])
#define SbkPySide_QtGui_QAbstractItemView_SelectionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX])
#define SbkPySide_QtGui_QAbstractItemView_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX])
#define SbkQAbstractItemView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX])
#define SbkQTableView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLEVIEW_IDX])
#define SbkQTreeView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEVIEW_IDX])
#define SbkQColumnView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOLUMNVIEW_IDX])
#define SbkPySide_QtGui_QListView_ResizeMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTVIEW_RESIZEMODE_IDX])
#define SbkPySide_QtGui_QListView_LayoutMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTVIEW_LAYOUTMODE_IDX])
#define SbkPySide_QtGui_QListView_ViewMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTVIEW_VIEWMODE_IDX])
#define SbkPySide_QtGui_QListView_Flow_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTVIEW_FLOW_IDX])
#define SbkPySide_QtGui_QListView_Movement_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTVIEW_MOVEMENT_IDX])
#define SbkQListView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTVIEW_IDX])
#define SbkQListWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTWIDGET_IDX])
#define SbkQUndoView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QUNDOVIEW_IDX])
#define SbkPySide_QtGui_QHeaderView_ResizeMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QHEADERVIEW_RESIZEMODE_IDX])
#define SbkQHeaderView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QHEADERVIEW_IDX])
#define SbkQVector4D_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QVECTOR4D_IDX])
#define SbkQToolBarChangeEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOOLBARCHANGEEVENT_IDX])
#define SbkQCursor_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCURSOR_IDX])
#define SbkQPushButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPUSHBUTTON_IDX])
#define SbkQCommandLinkButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMMANDLINKBUTTON_IDX])
#define SbkPySide_QtGui_QTextItem_RenderFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX])
#define SbkPySide_QtGui_QTextItem_RenderFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG__IDX])
#define SbkQTextItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTITEM_IDX])
#define SbkQGraphicsLineItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSLINEITEM_IDX])
#define SbkPySide_QtGui_QDirModel_Roles_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIRMODEL_ROLES_IDX])
#define SbkQDirModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIRMODEL_IDX])
#define SbkQTreeWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTREEWIDGET_IDX])
#define SbkPySide_QtGui_QTransform_TransformationType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTRANSFORM_TRANSFORMATIONTYPE_IDX])
#define SbkQTransform_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTRANSFORM_IDX])
#define SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_ICONENGINEHOOK_IDX])
#define SbkQIconEngineV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_IDX])
#define SbkQLinearGradient_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLINEARGRADIENT_IDX])
#define SbkQCleanlooksStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCLEANLOOKSSTYLE_IDX])
#define SbkPySide_QtGui_QFont_StyleStrategy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])
#define SbkPySide_QtGui_QFont_SpacingType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX])
#define SbkPySide_QtGui_QFont_StyleHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])
#define SbkPySide_QtGui_QFont_Weight_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_WEIGHT_IDX])
#define SbkPySide_QtGui_QFont_Capitalization_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX])
#define SbkPySide_QtGui_QFont_Stretch_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_STRETCH_IDX])
#define SbkPySide_QtGui_QFont_Style_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_STYLE_IDX])
#define SbkQFont_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONT_IDX])
#define SbkPySide_QtGui_QGraphicsScene_SceneLayer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX])
#define SbkPySide_QtGui_QGraphicsScene_SceneLayers_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER__IDX])
#define SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX])
#define SbkQGraphicsScene_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_IDX])
#define SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_OPTIMIZATIONFLAG_IDX])
#define SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSVIEW_OPTIMIZATIONFLAG__IDX])
#define SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_VIEWPORTANCHOR_IDX])
#define SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_VIEWPORTUPDATEMODE_IDX])
#define SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_CACHEMODEFLAG_IDX])
#define SbkPySide_QtGui_QGraphicsView_CacheMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSVIEW_CACHEMODEFLAG__IDX])
#define SbkPySide_QtGui_QGraphicsView_DragMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_DRAGMODE_IDX])
#define SbkQGraphicsView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItem_Position_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX])
#define SbkQStyleOptionViewItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_STYLEOPTIONVERSION_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE__IDX])
#define SbkQStyleOptionViewItemV2_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItemV3_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV3_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionViewItemV3_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV3_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_VIEWITEMPOSITION_IDX])
#define SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_STYLEOPTIONVERSION_IDX])
#define SbkQStyleOptionViewItemV4_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_IDX])
#define SbkQWhatsThisClickedEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWHATSTHISCLICKEDEVENT_IDX])
#define SbkPySide_QtGui_QPrinter_OutputFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX])
#define SbkPySide_QtGui_QPrinter_DuplexMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_DUPLEXMODE_IDX])
#define SbkPySide_QtGui_QPrinter_PrintRange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTRANGE_IDX])
#define SbkPySide_QtGui_QPrinter_Unit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_UNIT_IDX])
#define SbkPySide_QtGui_QPrinter_PrinterMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTERMODE_IDX])
#define SbkPySide_QtGui_QPrinter_Orientation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_ORIENTATION_IDX])
#define SbkPySide_QtGui_QPrinter_PrinterState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTERSTATE_IDX])
#define SbkPySide_QtGui_QPrinter_ColorMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_COLORMODE_IDX])
#define SbkPySide_QtGui_QPrinter_PaperSource_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_PAPERSOURCE_IDX])
#define SbkPySide_QtGui_QPrinter_PageOrder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_PAGEORDER_IDX])
#define SbkPySide_QtGui_QPrinter_PageSize_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_PAGESIZE_IDX])
#define SbkQPrinter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTER_IDX])
#define SbkQGridLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRIDLAYOUT_IDX])
#define SbkPySide_QtGui_QSizePolicy_ControlType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])
#define SbkPySide_QtGui_QSizePolicy_ControlTypes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE__IDX])
#define SbkPySide_QtGui_QSizePolicy_PolicyFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX])
#define SbkPySide_QtGui_QSizePolicy_Policy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_POLICY_IDX])
#define SbkQSizePolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_IDX])
#define SbkQSpacerItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSPACERITEM_IDX])
#define SbkPySide_QtGui_QProgressBar_Direction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPROGRESSBAR_DIRECTION_IDX])
#define SbkQProgressBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPROGRESSBAR_IDX])
#define SbkPySide_QtGui_QListWidgetItem_ItemType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTWIDGETITEM_ITEMTYPE_IDX])
#define SbkQListWidgetItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLISTWIDGETITEM_IDX])
#define SbkQQuaternion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QQUATERNION_IDX])
#define SbkQMatrix4x4_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX4X4_IDX])
#define SbkQMatrix_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMATRIX_IDX])
#define SbkPySide_QtGui_QPainterPath_ElementType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_ELEMENTTYPE_IDX])
#define SbkQPainterPath_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_IDX])
#define SbkQPainterPath_Element_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_ELEMENT_IDX])
#define SbkQWhatsThis_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWHATSTHIS_IDX])
#define SbkPySide_QtGui_QComboBox_InsertPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_INSERTPOLICY_IDX])
#define SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_SIZEADJUSTPOLICY_IDX])
#define SbkQComboBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_IDX])
#define SbkPySide_QtGui_QFontComboBox_FontFilter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTCOMBOBOX_FONTFILTER_IDX])
#define SbkPySide_QtGui_QFontComboBox_FontFilters_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QFONTCOMBOBOX_FONTFILTER__IDX])
#define SbkQFontComboBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTCOMBOBOX_IDX])
#define SbkPySide_QtGui_QToolButton_ToolButtonPopupMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOOLBUTTON_TOOLBUTTONPOPUPMODE_IDX])
#define SbkQToolButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOOLBUTTON_IDX])
#define SbkPySide_QtGui_QDialog_DialogCode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIALOG_DIALOGCODE_IDX])
#define SbkQDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX])
#define SbkQProgressDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPROGRESSDIALOG_IDX])
#define SbkPySide_QtGui_QWizard_WizardButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDBUTTON_IDX])
#define SbkPySide_QtGui_QWizard_WizardStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDSTYLE_IDX])
#define SbkPySide_QtGui_QWizard_WizardPixmap_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDPIXMAP_IDX])
#define SbkPySide_QtGui_QWizard_WizardOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDOPTION_IDX])
#define SbkPySide_QtGui_QWizard_WizardOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QWIZARD_WIZARDOPTION__IDX])
#define SbkQWizard_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QWIZARD_IDX])
#define SbkPySide_QtGui_QAbstractPrintDialog_PrintRange_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX])
#define SbkPySide_QtGui_QAbstractPrintDialog_PrintDialogOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])
#define SbkPySide_QtGui_QAbstractPrintDialog_PrintDialogOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION__IDX])
#define SbkQAbstractPrintDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTPRINTDIALOG_IDX])
#define SbkQPrintDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTDIALOG_IDX])
#define SbkPySide_QtGui_QColorDialog_ColorDialogOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOLORDIALOG_COLORDIALOGOPTION_IDX])
#define SbkPySide_QtGui_QColorDialog_ColorDialogOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QCOLORDIALOG_COLORDIALOGOPTION__IDX])
#define SbkQColorDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QCOLORDIALOG_IDX])
#define SbkQPrintPreviewDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWDIALOG_IDX])
#define SbkQAbstractPageSetupDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTPAGESETUPDIALOG_IDX])
#define SbkPySide_QtGui_QPageSetupDialog_PageSetupDialogOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAGESETUPDIALOG_PAGESETUPDIALOGOPTION_IDX])
#define SbkPySide_QtGui_QPageSetupDialog_PageSetupDialogOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAGESETUPDIALOG_PAGESETUPDIALOGOPTION__IDX])
#define SbkQPageSetupDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAGESETUPDIALOG_IDX])
#define SbkQErrorMessage_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QERRORMESSAGE_IDX])
#define SbkPySide_QtGui_QFileIconProvider_IconType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX])
#define SbkQFileIconProvider_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEICONPROVIDER_IDX])
#define SbkPySide_QtGui_QApplication_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QAPPLICATION_TYPE_IDX])
#define SbkPySide_QtGui_QApplication_ColorSpec_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QAPPLICATION_COLORSPEC_IDX])
#define SbkQApplication_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QAPPLICATION_IDX])
#define SbkQTableWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTABLEWIDGET_IDX])
#define SbkQGraphicsLayoutItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])
#define SbkQGraphicsWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX])
#define SbkQGraphicsProxyWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSPROXYWIDGET_IDX])
#define SbkQGraphicsLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUT_IDX])
#define SbkQGraphicsAnchorLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSANCHORLAYOUT_IDX])
#define SbkQGraphicsGridLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSGRIDLAYOUT_IDX])
#define SbkQGraphicsLinearLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGRAPHICSLINEARLAYOUT_IDX])
#define SbkQToolBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTOOLBOX_IDX])
#define SbkPySide_QtGui_QTextFormat_Property_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX])
#define SbkPySide_QtGui_QTextFormat_FormatType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX])
#define SbkPySide_QtGui_QTextFormat_ObjectTypes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX])
#define SbkPySide_QtGui_QTextFormat_PageBreakFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX])
#define SbkPySide_QtGui_QTextFormat_PageBreakFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG__IDX])
#define SbkQTextFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])
#define SbkQTextBlockFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX])
#define SbkPySide_QtGui_QTextListFormat_Style_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX])
#define SbkQTextListFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX])
#define SbkPySide_QtGui_QTextFrameFormat_Position_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX])
#define SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])
#define SbkQTextFrameFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX])
#define SbkQTextTableFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTTABLEFORMAT_IDX])
#define SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX])
#define SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX])
#define SbkQTextCharFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX])
#define SbkQTextImageFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX])
#define SbkQTextTableCellFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX])
#define SbkPySide_QtGui_QDateTimeEdit_Section_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDATETIMEEDIT_SECTION_IDX])
#define SbkPySide_QtGui_QDateTimeEdit_Sections_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QDATETIMEEDIT_SECTION__IDX])
#define SbkQDateTimeEdit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDATETIMEEDIT_IDX])
#define SbkQTimeEdit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTIMEEDIT_IDX])
#define SbkQDateEdit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QDATEEDIT_IDX])
#define SbkQTextBlockUserData_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKUSERDATA_IDX])
#define SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX])
#define SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG__IDX])
#define SbkQItemSelectionModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONMODEL_IDX])
#define SbkPySide_QtGui_QMovie_CacheMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOVIE_CACHEMODE_IDX])
#define SbkPySide_QtGui_QMovie_MovieState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOVIE_MOVIESTATE_IDX])
#define SbkQMovie_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMOVIE_IDX])
#define SbkQTextTable_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTTABLE_IDX])
#define SbkPySide_QtGui_QInputDialog_InputMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_INPUTMODE_IDX])
#define SbkPySide_QtGui_QInputDialog_InputDialogOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_INPUTDIALOGOPTION_IDX])
#define SbkQInputDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_IDX])
#define SbkQGtkStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QGTKSTYLE_IDX])
#define SbkQUndoGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QUNDOGROUP_IDX])
#define SbkPySide_QtGui_QFileDialog_FileMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_FILEMODE_IDX])
#define SbkPySide_QtGui_QFileDialog_Option_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_OPTION_IDX])
#define SbkPySide_QtGui_QFileDialog_Options_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QFILEDIALOG_OPTION__IDX])
#define SbkPySide_QtGui_QFileDialog_DialogLabel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX])
#define SbkPySide_QtGui_QFileDialog_ViewMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_VIEWMODE_IDX])
#define SbkPySide_QtGui_QFileDialog_AcceptMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX])
#define SbkQFileDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_IDX])
#define SbkQUndoStack_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QUNDOSTACK_IDX])
#define SbkPySide_QtGui_QTextCursor_MoveMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX])
#define SbkPySide_QtGui_QTextCursor_MoveOperation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX])
#define SbkPySide_QtGui_QTextCursor_SelectionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX])
#define SbkQTextCursor_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_IDX])
#define SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPLAINTEXTEDIT_LINEWRAPMODE_IDX])
#define SbkQPlainTextEdit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPLAINTEXTEDIT_IDX])
#define SbkPySide_QtGui_QImage_InvertMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX])
#define SbkPySide_QtGui_QImage_Format_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])
#define SbkQImage_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QIMAGE_IDX])
#define SbkQBitmap_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QBITMAP_IDX])
#define SbkPySide_QtGui_QFontDatabase_WritingSystem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])
#define SbkQFontDatabase_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTDATABASE_IDX])
#define SbkQKeyEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QKEYEVENT_IDX])
#define SbkPySide_QtGui_QMessageBox_ButtonRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_BUTTONROLE_IDX])
#define SbkPySide_QtGui_QMessageBox_StandardButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_STANDARDBUTTON_IDX])
#define SbkPySide_QtGui_QMessageBox_StandardButtons_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QMESSAGEBOX_STANDARDBUTTON__IDX])
#define SbkPySide_QtGui_QMessageBox_Icon_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_ICON_IDX])
#define SbkQMessageBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_IDX])
#define SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_AUTOFORMATTINGFLAG_IDX])
#define SbkPySide_QtGui_QTextEdit_AutoFormatting_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTEDIT_AUTOFORMATTINGFLAG__IDX])
#define SbkPySide_QtGui_QTextEdit_LineWrapMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_LINEWRAPMODE_IDX])
#define SbkQTextEdit_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_IDX])
#define SbkQTextBrowser_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTBROWSER_IDX])
#define SbkQTextEdit_ExtraSelection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX])
#define SbkQMenuBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QMENUBAR_IDX])
#define SbkQTextTableCell_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTTABLECELL_IDX])
#define SbkQTextObjectInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX])
#define SbkQAbstractProxyModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QABSTRACTPROXYMODEL_IDX])
#define SbkQSortFilterProxyModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QSORTFILTERPROXYMODEL_IDX])
#define SbkPySide_QtGui_QFontDialog_FontDialogOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTDIALOG_FONTDIALOGOPTION_IDX])
#define SbkPySide_QtGui_QFontDialog_FontDialogOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFLAGS_QFONTDIALOG_FONTDIALOGOPTION__IDX])
#define SbkQFontDialog_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QFONTDIALOG_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QMatrix2x4 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX2X4_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix2x3 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX2X3_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix2x2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX2X2_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix3x4 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX3X4_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix3x3 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX3X3_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix3x2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX3X2_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix4x3 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX4X3_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix4x2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX4X2_IDX]); }
template<> inline PyTypeObject* SbkType<QItemEditorFactory >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QITEMEDITORFACTORY_IDX]); }
template<> inline PyTypeObject* SbkType<QIconEngine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QICONENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QTreeWidgetItemIterator::IteratorFlag >() { return SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTreeWidgetItemIterator::IteratorFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTreeWidgetItemIterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEMITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QTileRules >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTILERULES_IDX]); }
template<> inline PyTypeObject* SbkType<QFontMetricsF >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONTMETRICSF_IDX]); }
template<> inline PyTypeObject* SbkType<QItemSelection >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QITEMSELECTION_IDX]); }
template<> inline PyTypeObject* SbkType<QKeySequence::SequenceFormat >() { return SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QKeySequence::StandardKey >() { return SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX]; }
template<> inline PyTypeObject* SbkType<QKeySequence::SequenceMatch >() { return SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX]; }
template<> inline PyTypeObject* SbkType<QKeySequence >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]); }
template<> inline PyTypeObject* SbkType<QStringListModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTRINGLISTMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QTextOption::TabType >() { return SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextOption::Flag >() { return SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextOption::Flag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextOption::WrapMode >() { return SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextOption >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_IDX]); }
template<> inline PyTypeObject* SbkType<QTextOption::Tab >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]); }
template<> inline PyTypeObject* SbkType<QBrush >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QBRUSH_IDX]); }
template<> inline PyTypeObject* SbkType<QX11Info >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QX11INFO_IDX]); }
template<> inline PyTypeObject* SbkType<QTextInlineObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTINLINEOBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<QInputContextFactory >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINPUTCONTEXTFACTORY_IDX]); }
template<> inline PyTypeObject* SbkType<QPictureIO >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPICTUREIO_IDX]); }
template<> inline PyTypeObject* SbkType<QToolTip >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOOLTIP_IDX]); }
template<> inline PyTypeObject* SbkType<QPrinterInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPRINTERINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QTextLine::Edge >() { return SbkPySide_QtGuiTypes[SBK_QTEXTLINE_EDGE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextLine::CursorPosition >() { return SbkPySide_QtGuiTypes[SBK_QTEXTLINE_CURSORPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QTextLine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTLINE_IDX]); }
template<> inline PyTypeObject* SbkType<QUndoCommand >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QUNDOCOMMAND_IDX]); }
template<> inline PyTypeObject* SbkType<QGestureRecognizer::ResultFlag >() { return SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGestureRecognizer::ResultFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QGestureRecognizer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_IDX]); }
template<> inline PyTypeObject* SbkType<QTextFragment >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTFRAGMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QAction::Priority >() { return SbkPySide_QtGuiTypes[SBK_QACTION_PRIORITY_IDX]; }
template<> inline PyTypeObject* SbkType<QAction::ActionEvent >() { return SbkPySide_QtGuiTypes[SBK_QACTION_ACTIONEVENT_IDX]; }
template<> inline PyTypeObject* SbkType<QAction::SoftKeyRole >() { return SbkPySide_QtGuiTypes[SBK_QACTION_SOFTKEYROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QAction::MenuRole >() { return SbkPySide_QtGuiTypes[SBK_QACTION_MENUROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QAction >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QACTION_IDX]); }
template<> inline PyTypeObject* SbkType<QActionGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QACTIONGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QButtonGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QBUTTONGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsEffect::PixmapPadMode >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsEffect::ChangeFlag >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGraphicsEffect::ChangeFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsEffect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsBlurEffect::BlurHint >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGraphicsBlurEffect::BlurHint> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT__IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsBlurEffect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSBLUREFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsColorizeEffect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSCOLORIZEEFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsOpacityEffect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSOPACITYEFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<QDataWidgetMapper::SubmitPolicy >() { return SbkPySide_QtGuiTypes[SBK_QDATAWIDGETMAPPER_SUBMITPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QDataWidgetMapper >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDATAWIDGETMAPPER_IDX]); }
template<> inline PyTypeObject* SbkType<QClipboard::Mode >() { return SbkPySide_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX]; }
template<> inline PyTypeObject* SbkType<QClipboard >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCLIPBOARD_IDX]); }
template<> inline PyTypeObject* SbkType<QSystemTrayIcon::MessageIcon >() { return SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_MESSAGEICON_IDX]; }
template<> inline PyTypeObject* SbkType<QSystemTrayIcon::ActivationReason >() { return SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_ACTIVATIONREASON_IDX]; }
template<> inline PyTypeObject* SbkType<QSystemTrayIcon >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleFactory >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEFACTORY_IDX]); }
template<> inline PyTypeObject* SbkType<QPolygonF >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPOLYGONF_IDX]); }
template<> inline PyTypeObject* SbkType<QKeyEventTransition >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QKEYEVENTTRANSITION_IDX]); }
template<> inline PyTypeObject* SbkType<QMouseEventTransition >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMOUSEEVENTTRANSITION_IDX]); }
template<> inline PyTypeObject* SbkType<QTextObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTOBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTFRAME_IDX]); }
template<> inline PyTypeObject* SbkType<QTreeWidgetItem::ItemType >() { return SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_ITEMTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTreeWidgetItem::ChildIndicatorPolicy >() { return SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_CHILDINDICATORPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QTreeWidgetItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QValidator::State >() { return SbkPySide_QtGuiTypes[SBK_QVALIDATOR_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QValidator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QVALIDATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QTextLength::Type >() { return SbkPySide_QtGuiTypes[SBK_QTEXTLENGTH_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextLength >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTLENGTH_IDX]); }
template<> inline PyTypeObject* SbkType<QImageReader::ImageReaderError >() { return SbkPySide_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QImageReader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QIMAGEREADER_IDX]); }
template<> inline PyTypeObject* SbkType<QPaintEngineState >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX]); }
template<> inline PyTypeObject* SbkType<QWidgetAction >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWIDGETACTION_IDX]); }
template<> inline PyTypeObject* SbkType<QPolygon >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPOLYGON_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsAnchor >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSANCHOR_IDX]); }
template<> inline PyTypeObject* SbkType<QColor::Spec >() { return SbkPySide_QtGuiTypes[SBK_QCOLOR_SPEC_IDX]; }
template<> inline PyTypeObject* SbkType<QColor >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOLOR_IDX]); }
template<> inline PyTypeObject* SbkType<QGesture::GestureCancelPolicy >() { return SbkPySide_QtGuiTypes[SBK_QGESTURE_GESTURECANCELPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QGesture >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGESTURE_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractKineticScroller >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTKINETICSCROLLER_IDX]); }
template<> inline PyTypeObject* SbkType<QTableWidgetItem::ItemType >() { return SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETITEM_ITEMTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTableWidgetItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QCompleter::ModelSorting >() { return SbkPySide_QtGuiTypes[SBK_QCOMPLETER_MODELSORTING_IDX]; }
template<> inline PyTypeObject* SbkType<QCompleter::CompletionMode >() { return SbkPySide_QtGuiTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QCompleter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOMPLETER_IDX]); }
template<> inline PyTypeObject* SbkType<QClipboardEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCLIPBOARDEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QWindowStateChangeEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWINDOWSTATECHANGEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QCloseEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCLOSEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QIconDragEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QICONDRAGEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QFileOpenEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFILEOPENEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QShortcutEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSHORTCUTEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QShowEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSHOWEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QStatusTipEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTATUSTIPEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QHideEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QHIDEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QHelpEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QHELPEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDropEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QActionEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QACTIONEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QPinchGesture::ChangeFlag >() { return SbkPySide_QtGuiTypes[SBK_QPINCHGESTURE_CHANGEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QPinchGesture::ChangeFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QPINCHGESTURE_CHANGEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QPinchGesture >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPINCHGESTURE_IDX]); }
template<> inline PyTypeObject* SbkType<QPainterPathStroker >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX]); }
template<> inline PyTypeObject* SbkType<QShortcut >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSHORTCUT_IDX]); }
template<> inline PyTypeObject* SbkType<QRegExpValidator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QREGEXPVALIDATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QRegion::RegionType >() { return SbkPySide_QtGuiTypes[SBK_QREGION_REGIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QRegion >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QREGION_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsItemAnimation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEMANIMATION_IDX]); }
template<> inline PyTypeObject* SbkType<QResizeEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QRESIZEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractItemDelegate::EndEditHint >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_ENDEDITHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemDelegate >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_IDX]); }
template<> inline PyTypeObject* SbkType<QStyledItemDelegate >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEDITEMDELEGATE_IDX]); }
template<> inline PyTypeObject* SbkType<QItemDelegate >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QITEMDELEGATE_IDX]); }
template<> inline PyTypeObject* SbkType<QLayoutItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QLayout::SizeConstraint >() { return SbkPySide_QtGuiTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX]; }
template<> inline PyTypeObject* SbkType<QLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QStackedLayout::StackingMode >() { return SbkPySide_QtGuiTypes[SBK_QSTACKEDLAYOUT_STACKINGMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QStackedLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTACKEDLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QWidgetItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWIDGETITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QPixmapCache >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPIXMAPCACHE_IDX]); }
template<> inline PyTypeObject* SbkType<QSound >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSOUND_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBlock >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTBLOCK_IDX]); }
template<> inline PyTypeObject* SbkType<QTextFrame::iterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTFRAME_ITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBlock::iterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTBLOCK_ITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QMoveEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMOVEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QPaintEngine::PolygonDrawMode >() { return SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPaintEngine::Type >() { return SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QPaintEngine::PaintEngineFeature >() { return SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QPaintEngine::PaintEngineFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QPaintEngine::DirtyFlag >() { return SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QPaintEngine::DirtyFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QPaintEngine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QBoxLayout::Direction >() { return SbkPySide_QtGuiTypes[SBK_QBOXLAYOUT_DIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QBoxLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QBOXLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QHBoxLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QHBOXLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QVBoxLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QVBOXLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QAccessibleEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QACCESSIBLEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QImageWriter::ImageWriterError >() { return SbkPySide_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QImageWriter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QIMAGEWRITER_IDX]); }
template<> inline PyTypeObject* SbkType<QStandardItem::ItemType >() { return SbkPySide_QtGuiTypes[SBK_QSTANDARDITEM_ITEMTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStandardItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTANDARDITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QTextDocumentFragment >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QPen >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPEN_IDX]); }
template<> inline PyTypeObject* SbkType<QTextDocument::ResourceType >() { return SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextDocument::FindFlag >() { return SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextDocument::FindFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextDocument::MetaInformation >() { return SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX]; }
template<> inline PyTypeObject* SbkType<QTextDocument >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractTextDocumentLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractTextDocumentLayout::Selection >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_SELECTION_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractTextDocumentLayout::PaintContext >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextLayout::CursorMode >() { return SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_CURSORMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextLayout::FormatRange >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]); }
template<> inline PyTypeObject* SbkType<QDrag >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDRAG_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsItem::CacheMode >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_CACHEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsItem::PanelModality >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_PANELMODALITY_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsItem::GraphicsItemFlag >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_GRAPHICSITEMFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGraphicsItem::GraphicsItemFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSITEM_GRAPHICSITEMFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsItem::GraphicsItemChange >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_GRAPHICSITEMCHANGE_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsItem::Extension >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_EXTENSION_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsPixmapItem::ShapeMode >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSPIXMAPITEM_SHAPEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsPixmapItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSPIXMAPITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractGraphicsShapeItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTGRAPHICSSHAPEITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsPolygonItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSPOLYGONITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsRectItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSRECTITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QIcon::Mode >() { return SbkPySide_QtGuiTypes[SBK_QICON_MODE_IDX]; }
template<> inline PyTypeObject* SbkType<QIcon::State >() { return SbkPySide_QtGuiTypes[SBK_QICON_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QIcon >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QICON_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsItemGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEMGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsEllipseItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSELLIPSEITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSimpleTextItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSIMPLETEXTITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QPaintDevice::PaintDeviceMetric >() { return SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX]; }
template<> inline PyTypeObject* SbkType<QPaintDevice >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]); }
template<> inline PyTypeObject* SbkType<QPixmap::ShareMode >() { return SbkPySide_QtGuiTypes[SBK_QPIXMAP_SHAREMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPixmap >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPIXMAP_IDX]); }
template<> inline PyTypeObject* SbkType<QPicture >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPICTURE_IDX]); }
template<> inline PyTypeObject* SbkType<QInputEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QTouchEvent::DeviceType >() { return SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_DEVICETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTouchEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QTouchEvent::TouchPoint >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]); }
template<> inline PyTypeObject* SbkType<QTabletEvent::TabletDevice >() { return SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX]; }
template<> inline PyTypeObject* SbkType<QTabletEvent::PointerType >() { return SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTabletEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QMouseEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMOUSEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QSwipeGesture::SwipeDirection >() { return SbkPySide_QtGuiTypes[SBK_QSWIPEGESTURE_SWIPEDIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QSwipeGesture >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSWIPEGESTURE_IDX]); }
template<> inline PyTypeObject* SbkType<QDragLeaveEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QStandardItemModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTANDARDITEMMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QProxyModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPROXYMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QFileSystemModel::Roles >() { return SbkPySide_QtGuiTypes[SBK_QFILESYSTEMMODEL_ROLES_IDX]; }
template<> inline PyTypeObject* SbkType<QFileSystemModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFILESYSTEMMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QImageIOHandler::ImageOption >() { return SbkPySide_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QImageIOHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QFormLayout::FieldGrowthPolicy >() { return SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_FIELDGROWTHPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QFormLayout::RowWrapPolicy >() { return SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_ROWWRAPPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QFormLayout::ItemRole >() { return SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_ITEMROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QFormLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QSyntaxHighlighter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX]); }
template<> inline PyTypeObject* SbkType<QFontInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONTINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOption::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOption::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOption::OptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_OPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOption >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleHintReturn::HintReturnType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturn::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturn::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturn >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURN_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleHintReturnMask::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturnMask::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturnMask >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNMASK_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleHintReturnVariant::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturnVariant::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleHintReturnVariant >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEHINTRETURNVARIANT_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionRubberBand::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONRUBBERBAND_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionRubberBand::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONRUBBERBAND_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionRubberBand >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONRUBBERBAND_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTabWidgetFrame::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABWIDGETFRAME_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabWidgetFrame::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABWIDGETFRAME_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabWidgetFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABWIDGETFRAME_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionHeader::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionHeader::SectionPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionHeader::SelectedPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionHeader::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionHeader::SortIndicator >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionHeader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionButton::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionButton::ButtonFeature >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_BUTTONFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyleOptionButton::ButtonFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONBUTTON_BUTTONFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionButton::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionDockWidget::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGET_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionDockWidget::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGET_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionDockWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionDockWidgetV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGETV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionDockWidgetV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONDOCKWIDGETV2_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBar::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBar::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBar::ToolBarPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBar::ToolBarFeature >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyleOptionToolBar::ToolBarFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTabBarBase::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASE_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabBarBase::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASE_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabBarBase >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASE_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTabBarBaseV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASEV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabBarBaseV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABBARBASEV2_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBox::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBox::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTab::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTab::CornerWidget >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyleOptionTab::CornerWidget> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET__IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTab::TabPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTab::SelectedPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTab::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTab >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTabV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV2_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTabV3::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV3_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTabV3 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTABV3_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionProgressBar::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBAR_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionProgressBar::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBAR_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionProgressBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionProgressBarV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBARV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionProgressBarV2::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBARV2_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionProgressBarV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONPROGRESSBARV2_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionFrame::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFrame::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionFrameV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFrameV2::FrameFeature >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyleOptionFrameV2::FrameFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFrameV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionFrameV3::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV3_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFrameV3 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV3_IDX]); }
template<> inline PyTypeObject* SbkType<QTableWidgetSelectionRange >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsDropShadowEffect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSDROPSHADOWEFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<QGradient::CoordinateMode >() { return SbkPySide_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGradient::Spread >() { return SbkPySide_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX]; }
template<> inline PyTypeObject* SbkType<QGradient::Type >() { return SbkPySide_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QGradient::InterpolationMode >() { return SbkPySide_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGradient >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRADIENT_IDX]); }
template<> inline PyTypeObject* SbkType<QConicalGradient >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCONICALGRADIENT_IDX]); }
template<> inline PyTypeObject* SbkType<QRadialGradient >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QRADIALGRADIENT_IDX]); }
template<> inline PyTypeObject* SbkType<QPrintEngine::PrintEnginePropertyKey >() { return SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX]; }
template<> inline PyTypeObject* SbkType<QPrintEngine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsPathItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSPATHITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QDragMoveEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDragEnterEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QHoverEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QHOVEREVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDoubleValidator::Notation >() { return SbkPySide_QtGuiTypes[SBK_QDOUBLEVALIDATOR_NOTATION_IDX]; }
template<> inline PyTypeObject* SbkType<QDoubleValidator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDOUBLEVALIDATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QPaintEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QPalette::ColorGroup >() { return SbkPySide_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX]; }
template<> inline PyTypeObject* SbkType<QPalette::ColorRole >() { return SbkPySide_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QPalette >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPALETTE_IDX]); }
template<> inline PyTypeObject* SbkType<QStyle::PixelMetric >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_PIXELMETRIC_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::SubControl >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_SUBCONTROL_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyle::SubControl> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL__IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::StandardPixmap >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::StyleHint >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_STYLEHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::PrimitiveElement >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::ControlElement >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_CONTROLELEMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::ContentsType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_CONTENTSTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::StateFlag >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_STATEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyle::StateFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLE_STATEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::ComplexControl >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::RequestSoftwareInputPanel >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle::SubElement >() { return SbkPySide_QtGuiTypes[SBK_QSTYLE_SUBELEMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QCommonStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOMMONSTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QMotifStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMOTIFSTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QWindowsStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWINDOWSSTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QCDEStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCDESTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QPlastiqueStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPLASTIQUESTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsTransform >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSTRANSFORM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsRotation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSROTATION_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsScale >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCALE_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionGraphicsItem::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionGraphicsItem::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionGraphicsItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QVector3D >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QVECTOR3D_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionMenuItem::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionMenuItem::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionMenuItem::CheckType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionMenuItem::MenuItemType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionMenuItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QVector2D >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QVECTOR2D_IDX]); }
template<> inline PyTypeObject* SbkType<QPanGesture >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPANGESTURE_IDX]); }
template<> inline PyTypeObject* SbkType<QWidget::RenderFlag >() { return SbkPySide_QtGuiTypes[SBK_QWIDGET_RENDERFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QWidget::RenderFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QWIDGET_RENDERFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QSizeGrip >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSIZEGRIP_IDX]); }
template<> inline PyTypeObject* SbkType<QWizardPage >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWIZARDPAGE_IDX]); }
template<> inline PyTypeObject* SbkType<QTabBar::SelectionBehavior >() { return SbkPySide_QtGuiTypes[SBK_QTABBAR_SELECTIONBEHAVIOR_IDX]; }
template<> inline PyTypeObject* SbkType<QTabBar::ButtonPosition >() { return SbkPySide_QtGuiTypes[SBK_QTABBAR_BUTTONPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QTabBar::Shape >() { return SbkPySide_QtGuiTypes[SBK_QTABBAR_SHAPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTabBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QTabWidget::TabShape >() { return SbkPySide_QtGuiTypes[SBK_QTABWIDGET_TABSHAPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTabWidget::TabPosition >() { return SbkPySide_QtGuiTypes[SBK_QTABWIDGET_TABPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QTabWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QFocusFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFOCUSFRAME_IDX]); }
template<> inline PyTypeObject* SbkType<QMainWindow::DockOption >() { return SbkPySide_QtGuiTypes[SBK_QMAINWINDOW_DOCKOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QMainWindow::DockOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QMAINWINDOW_DOCKOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QMainWindow >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMAINWINDOW_IDX]); }
template<> inline PyTypeObject* SbkType<QMenu >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMENU_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractSlider::SliderAction >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_SLIDERACTION_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractSlider::SliderChange >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_SLIDERCHANGE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractSlider >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_IDX]); }
template<> inline PyTypeObject* SbkType<QDial >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDIAL_IDX]); }
template<> inline PyTypeObject* SbkType<QDialogButtonBox::ButtonLayout >() { return SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_BUTTONLAYOUT_IDX]; }
template<> inline PyTypeObject* SbkType<QDialogButtonBox::ButtonRole >() { return SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_BUTTONROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QDialogButtonBox::StandardButton >() { return SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_STANDARDBUTTON_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QDialogButtonBox::StandardButton> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QDIALOGBUTTONBOX_STANDARDBUTTON__IDX]; }
template<> inline PyTypeObject* SbkType<QDialogButtonBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QRubberBand::Shape >() { return SbkPySide_QtGuiTypes[SBK_QRUBBERBAND_SHAPE_IDX]; }
template<> inline PyTypeObject* SbkType<QRubberBand >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QRUBBERBAND_IDX]); }
template<> inline PyTypeObject* SbkType<QFrame::StyleMask >() { return SbkPySide_QtGuiTypes[SBK_QFRAME_STYLEMASK_IDX]; }
template<> inline PyTypeObject* SbkType<QFrame::Shape >() { return SbkPySide_QtGuiTypes[SBK_QFRAME_SHAPE_IDX]; }
template<> inline PyTypeObject* SbkType<QFrame::Shadow >() { return SbkPySide_QtGuiTypes[SBK_QFRAME_SHADOW_IDX]; }
template<> inline PyTypeObject* SbkType<QFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]); }
template<> inline PyTypeObject* SbkType<QSplitter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSPLITTER_IDX]); }
template<> inline PyTypeObject* SbkType<QLCDNumber::Mode >() { return SbkPySide_QtGuiTypes[SBK_QLCDNUMBER_MODE_IDX]; }
template<> inline PyTypeObject* SbkType<QLCDNumber::SegmentStyle >() { return SbkPySide_QtGuiTypes[SBK_QLCDNUMBER_SEGMENTSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<QLCDNumber >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLCDNUMBER_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractScrollArea >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]); }
template<> inline PyTypeObject* SbkType<QDockWidget::DockWidgetFeature >() { return SbkPySide_QtGuiTypes[SBK_QDOCKWIDGET_DOCKWIDGETFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QDockWidget::DockWidgetFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QDOCKWIDGET_DOCKWIDGETFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QDockWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDOCKWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QCheckBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCHECKBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QScrollArea >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSCROLLAREA_IDX]); }
template<> inline PyTypeObject* SbkType<QCalendarWidget::HorizontalHeaderFormat >() { return SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_HORIZONTALHEADERFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QCalendarWidget::VerticalHeaderFormat >() { return SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_VERTICALHEADERFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QCalendarWidget::SelectionMode >() { return SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_SELECTIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QCalendarWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractSpinBox::StepEnabledFlag >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QAbstractSpinBox::StepEnabledFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractSpinBox::CorrectionMode >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractSpinBox::ButtonSymbols >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractSpinBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QMdiArea::WindowOrder >() { return SbkPySide_QtGuiTypes[SBK_QMDIAREA_WINDOWORDER_IDX]; }
template<> inline PyTypeObject* SbkType<QMdiArea::ViewMode >() { return SbkPySide_QtGuiTypes[SBK_QMDIAREA_VIEWMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QMdiArea::AreaOption >() { return SbkPySide_QtGuiTypes[SBK_QMDIAREA_AREAOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QMdiArea::AreaOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QMDIAREA_AREAOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QMdiArea >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMDIAREA_IDX]); }
template<> inline PyTypeObject* SbkType<QStackedWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTACKEDWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QMdiSubWindow::SubWindowOption >() { return SbkPySide_QtGuiTypes[SBK_QMDISUBWINDOW_SUBWINDOWOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QMdiSubWindow::SubWindowOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QMDISUBWINDOW_SUBWINDOWOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QMdiSubWindow >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMDISUBWINDOW_IDX]); }
template<> inline PyTypeObject* SbkType<QLabel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLABEL_IDX]); }
template<> inline PyTypeObject* SbkType<QScrollBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSCROLLBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QPrintPreviewWidget::ZoomMode >() { return SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_ZOOMMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrintPreviewWidget::ViewMode >() { return SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_VIEWMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrintPreviewWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QSplashScreen >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSPLASHSCREEN_IDX]); }
template<> inline PyTypeObject* SbkType<QWorkspace::WindowOrder >() { return SbkPySide_QtGuiTypes[SBK_QWORKSPACE_WINDOWORDER_IDX]; }
template<> inline PyTypeObject* SbkType<QWorkspace >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWORKSPACE_IDX]); }
template<> inline PyTypeObject* SbkType<QSlider::TickPosition >() { return SbkPySide_QtGuiTypes[SBK_QSLIDER_TICKPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QSlider >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSLIDER_IDX]); }
template<> inline PyTypeObject* SbkType<QDesktopWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDESKTOPWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QPainter::CompositionMode >() { return SbkPySide_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPainter::RenderHint >() { return SbkPySide_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QPainter::RenderHint> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT__IDX]; }
template<> inline PyTypeObject* SbkType<QPainter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTER_IDX]); }
template<> inline PyTypeObject* SbkType<QStylePainter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEPAINTER_IDX]); }
template<> inline PyTypeObject* SbkType<QGroupBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGROUPBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QStatusBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTATUSBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QSplitterHandle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSPLITTERHANDLE_IDX]); }
template<> inline PyTypeObject* SbkType<QToolBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOOLBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QLineEdit::EchoMode >() { return SbkPySide_QtGuiTypes[SBK_QLINEEDIT_ECHOMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QLineEdit >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLINEEDIT_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionComplex::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionComplex::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionComplex >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionGroupBox::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGROUPBOX_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionGroupBox::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGROUPBOX_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionGroupBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGROUPBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionTitleBar::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTITLEBAR_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTitleBar::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTITLEBAR_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionTitleBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTITLEBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionSlider::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionSlider::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionSlider >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionSizeGrip::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionSizeGrip::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionSizeGrip >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSIZEGRIP_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionSpinBox::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionSpinBox::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionSpinBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSPINBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionToolButton::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolButton::ToolButtonFeature >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyleOptionToolButton::ToolButtonFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolButton::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionComboBox::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionComboBox::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionComboBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionFocusRect::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFocusRect::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionFocusRect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFOCUSRECT_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBoxV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBoxV2::TabPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_TABPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBoxV2::SelectedPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_SELECTEDPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionToolBoxV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneResizeEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENERESIZEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneWheelEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEWHEELEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneDragDropEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneHelpEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEHELPEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneMouseEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneHoverEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEHOVEREVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneMoveEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEMOVEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsSceneContextMenuEvent::Reason >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_REASON_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsSceneContextMenuEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QInputMethodEvent::AttributeType >() { return SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QInputMethodEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QInputMethodEvent::Attribute >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]); }
template<> inline PyTypeObject* SbkType<QSpinBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSPINBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QInputContext::StandardFormat >() { return SbkPySide_QtGuiTypes[SBK_QINPUTCONTEXT_STANDARDFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QInputContext >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINPUTCONTEXT_IDX]); }
template<> inline PyTypeObject* SbkType<QDesktopServices::StandardLocation >() { return SbkPySide_QtGuiTypes[SBK_QDESKTOPSERVICES_STANDARDLOCATION_IDX]; }
template<> inline PyTypeObject* SbkType<QDesktopServices >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDESKTOPSERVICES_IDX]); }
template<> inline PyTypeObject* SbkType<QSessionManager::RestartHint >() { return SbkPySide_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QSessionManager >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSESSIONMANAGER_IDX]); }
template<> inline PyTypeObject* SbkType<QFocusEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFOCUSEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSOBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsTextItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSTEXTITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QPlainTextDocumentLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPLAINTEXTDOCUMENTLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBlockGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QTextList >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTLIST_IDX]); }
template<> inline PyTypeObject* SbkType<QItemSelectionRange >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONRANGE_IDX]); }
template<> inline PyTypeObject* SbkType<QFontMetrics >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONTMETRICS_IDX]); }
template<> inline PyTypeObject* SbkType<QIntValidator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINTVALIDATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QItemEditorCreatorBase >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QITEMEDITORCREATORBASE_IDX]); }
template<> inline PyTypeObject* SbkType<QContextMenuEvent::Reason >() { return SbkPySide_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX]; }
template<> inline PyTypeObject* SbkType<QContextMenuEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDoubleSpinBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDOUBLESPINBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QRadioButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QRADIOBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QWheelEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWHEELEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractItemView::DragDropMode >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::SelectionBehavior >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::EditTrigger >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QAbstractItemView::EditTrigger> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER__IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::ScrollMode >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::CursorAction >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::DropIndicatorPosition >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::ScrollHint >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::SelectionMode >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView::State >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractItemView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QTableView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABLEVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QTreeView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTREEVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QColumnView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOLUMNVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QListView::ResizeMode >() { return SbkPySide_QtGuiTypes[SBK_QLISTVIEW_RESIZEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QListView::LayoutMode >() { return SbkPySide_QtGuiTypes[SBK_QLISTVIEW_LAYOUTMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QListView::ViewMode >() { return SbkPySide_QtGuiTypes[SBK_QLISTVIEW_VIEWMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QListView::Flow >() { return SbkPySide_QtGuiTypes[SBK_QLISTVIEW_FLOW_IDX]; }
template<> inline PyTypeObject* SbkType<QListView::Movement >() { return SbkPySide_QtGuiTypes[SBK_QLISTVIEW_MOVEMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QListView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLISTVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QListWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLISTWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QUndoView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QUNDOVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QHeaderView::ResizeMode >() { return SbkPySide_QtGuiTypes[SBK_QHEADERVIEW_RESIZEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QHeaderView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QHEADERVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QVector4D >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QVECTOR4D_IDX]); }
template<> inline PyTypeObject* SbkType<QToolBarChangeEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOOLBARCHANGEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QCursor >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCURSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QPushButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPUSHBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QCommandLinkButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOMMANDLINKBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QTextItem::RenderFlag >() { return SbkPySide_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextItem::RenderFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsLineItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLINEITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QDirModel::Roles >() { return SbkPySide_QtGuiTypes[SBK_QDIRMODEL_ROLES_IDX]; }
template<> inline PyTypeObject* SbkType<QDirModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDIRMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QTreeWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTREEWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QTransform::TransformationType >() { return SbkPySide_QtGuiTypes[SBK_QTRANSFORM_TRANSFORMATIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTransform >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTRANSFORM_IDX]); }
template<> inline PyTypeObject* SbkType<QIconEngineV2::IconEngineHook >() { return SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_ICONENGINEHOOK_IDX]; }
template<> inline PyTypeObject* SbkType<QIconEngineV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_IDX]); }
template<> inline PyTypeObject* SbkType<QLinearGradient >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]); }
template<> inline PyTypeObject* SbkType<QCleanlooksStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCLEANLOOKSSTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QFont::StyleStrategy >() { return SbkPySide_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX]; }
template<> inline PyTypeObject* SbkType<QFont::SpacingType >() { return SbkPySide_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QFont::StyleHint >() { return SbkPySide_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFont::Weight >() { return SbkPySide_QtGuiTypes[SBK_QFONT_WEIGHT_IDX]; }
template<> inline PyTypeObject* SbkType<QFont::Capitalization >() { return SbkPySide_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX]; }
template<> inline PyTypeObject* SbkType<QFont::Stretch >() { return SbkPySide_QtGuiTypes[SBK_QFONT_STRETCH_IDX]; }
template<> inline PyTypeObject* SbkType<QFont::Style >() { return SbkPySide_QtGuiTypes[SBK_QFONT_STYLE_IDX]; }
template<> inline PyTypeObject* SbkType<QFont >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsScene::SceneLayer >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGraphicsScene::SceneLayer> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER__IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsScene::ItemIndexMethod >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsScene >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsView::OptimizationFlag >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_OPTIMIZATIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGraphicsView::OptimizationFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSVIEW_OPTIMIZATIONFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsView::ViewportAnchor >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_VIEWPORTANCHOR_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsView::ViewportUpdateMode >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_VIEWPORTUPDATEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsView::CacheModeFlag >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_CACHEMODEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QGraphicsView::CacheModeFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSVIEW_CACHEMODEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsView::DragMode >() { return SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_DRAGMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QGraphicsView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItem::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItem::StyleOptionType >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItem::Position >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV2::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV2::ViewItemFeature >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QStyleOptionViewItemV2::ViewItemFeature> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV2 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV3::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV3_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV3 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV3_IDX]); }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV4::ViewItemPosition >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_VIEWITEMPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV4::StyleOptionVersion >() { return SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_STYLEOPTIONVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QStyleOptionViewItemV4 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_IDX]); }
template<> inline PyTypeObject* SbkType<QWhatsThisClickedEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWHATSTHISCLICKEDEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QPrinter::OutputFormat >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::DuplexMode >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_DUPLEXMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::PrintRange >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTRANGE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::Unit >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_UNIT_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::PrinterMode >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTERMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::Orientation >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_ORIENTATION_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::PrinterState >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTERSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::ColorMode >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_COLORMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::PaperSource >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_PAPERSOURCE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::PageOrder >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_PAGEORDER_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter::PageSize >() { return SbkPySide_QtGuiTypes[SBK_QPRINTER_PAGESIZE_IDX]; }
template<> inline PyTypeObject* SbkType<QPrinter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPRINTER_IDX]); }
template<> inline PyTypeObject* SbkType<QGridLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRIDLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QSizePolicy::ControlType >() { return SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QSizePolicy::ControlType> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE__IDX]; }
template<> inline PyTypeObject* SbkType<QSizePolicy::PolicyFlag >() { return SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QSizePolicy::Policy >() { return SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_POLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QSizePolicy >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_IDX]); }
template<> inline PyTypeObject* SbkType<QSpacerItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSPACERITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QProgressBar::Direction >() { return SbkPySide_QtGuiTypes[SBK_QPROGRESSBAR_DIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QProgressBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPROGRESSBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QListWidgetItem::ItemType >() { return SbkPySide_QtGuiTypes[SBK_QLISTWIDGETITEM_ITEMTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QListWidgetItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QLISTWIDGETITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QQuaternion >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QQUATERNION_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix4x4 >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX4X4_IDX]); }
template<> inline PyTypeObject* SbkType<QMatrix >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMATRIX_IDX]); }
template<> inline PyTypeObject* SbkType<QPainterPath::ElementType >() { return SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_ELEMENTTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QPainterPath >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_IDX]); }
template<> inline PyTypeObject* SbkType<QPainterPath::Element >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_ELEMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QWhatsThis >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWHATSTHIS_IDX]); }
template<> inline PyTypeObject* SbkType<QComboBox::InsertPolicy >() { return SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_INSERTPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QComboBox::SizeAdjustPolicy >() { return SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_SIZEADJUSTPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QComboBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QFontComboBox::FontFilter >() { return SbkPySide_QtGuiTypes[SBK_QFONTCOMBOBOX_FONTFILTER_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QFontComboBox::FontFilter> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QFONTCOMBOBOX_FONTFILTER__IDX]; }
template<> inline PyTypeObject* SbkType<QFontComboBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONTCOMBOBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QToolButton::ToolButtonPopupMode >() { return SbkPySide_QtGuiTypes[SBK_QTOOLBUTTON_TOOLBUTTONPOPUPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QToolButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOOLBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QDialog::DialogCode >() { return SbkPySide_QtGuiTypes[SBK_QDIALOG_DIALOGCODE_IDX]; }
template<> inline PyTypeObject* SbkType<QDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QProgressDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPROGRESSDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QWizard::WizardButton >() { return SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDBUTTON_IDX]; }
template<> inline PyTypeObject* SbkType<QWizard::WizardStyle >() { return SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<QWizard::WizardPixmap >() { return SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDPIXMAP_IDX]; }
template<> inline PyTypeObject* SbkType<QWizard::WizardOption >() { return SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QWizard::WizardOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QWIZARD_WIZARDOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QWizard >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QWIZARD_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractPrintDialog::PrintRange >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractPrintDialog::PrintDialogOption >() { return SbkPySide_QtGuiTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QAbstractPrintDialog::PrintDialogOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractPrintDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTPRINTDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QPrintDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPRINTDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QColorDialog::ColorDialogOption >() { return SbkPySide_QtGuiTypes[SBK_QCOLORDIALOG_COLORDIALOGOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QColorDialog::ColorDialogOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QCOLORDIALOG_COLORDIALOGOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QColorDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QCOLORDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QPrintPreviewDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractPageSetupDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTPAGESETUPDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QPageSetupDialog::PageSetupDialogOption >() { return SbkPySide_QtGuiTypes[SBK_QPAGESETUPDIALOG_PAGESETUPDIALOGOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QPageSetupDialog::PageSetupDialogOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAGESETUPDIALOG_PAGESETUPDIALOGOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QPageSetupDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPAGESETUPDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QErrorMessage >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QERRORMESSAGE_IDX]); }
template<> inline PyTypeObject* SbkType<QFileIconProvider::IconType >() { return SbkPySide_QtGuiTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QFileIconProvider >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFILEICONPROVIDER_IDX]); }
template<> inline PyTypeObject* SbkType<QApplication::Type >() { return SbkPySide_QtGuiTypes[SBK_QAPPLICATION_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QApplication::ColorSpec >() { return SbkPySide_QtGuiTypes[SBK_QAPPLICATION_COLORSPEC_IDX]; }
template<> inline PyTypeObject* SbkType<QApplication >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QAPPLICATION_IDX]); }
template<> inline PyTypeObject* SbkType<QTableWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTABLEWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsLayoutItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsProxyWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSPROXYWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsAnchorLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSANCHORLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsGridLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSGRIDLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QGraphicsLinearLayout >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLINEARLAYOUT_IDX]); }
template<> inline PyTypeObject* SbkType<QToolBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTOOLBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QTextFormat::Property >() { return SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX]; }
template<> inline PyTypeObject* SbkType<QTextFormat::FormatType >() { return SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextFormat::ObjectTypes >() { return SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX]; }
template<> inline PyTypeObject* SbkType<QTextFormat::PageBreakFlag >() { return SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextFormat::PageBreakFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBlockFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextListFormat::Style >() { return SbkPySide_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextListFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextFrameFormat::Position >() { return SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QTextFrameFormat::BorderStyle >() { return SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextFrameFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextTableFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTTABLEFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextCharFormat::VerticalAlignment >() { return SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QTextCharFormat::UnderlineStyle >() { return SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextCharFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextImageFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextTableCellFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QDateTimeEdit::Section >() { return SbkPySide_QtGuiTypes[SBK_QDATETIMEEDIT_SECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QDateTimeEdit::Section> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QDATETIMEEDIT_SECTION__IDX]; }
template<> inline PyTypeObject* SbkType<QDateTimeEdit >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDATETIMEEDIT_IDX]); }
template<> inline PyTypeObject* SbkType<QTimeEdit >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTIMEEDIT_IDX]); }
template<> inline PyTypeObject* SbkType<QDateEdit >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QDATEEDIT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBlockUserData >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKUSERDATA_IDX]); }
template<> inline PyTypeObject* SbkType<QItemSelectionModel::SelectionFlag >() { return SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QItemSelectionModel::SelectionFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QItemSelectionModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QMovie::CacheMode >() { return SbkPySide_QtGuiTypes[SBK_QMOVIE_CACHEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QMovie::MovieState >() { return SbkPySide_QtGuiTypes[SBK_QMOVIE_MOVIESTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QMovie >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMOVIE_IDX]); }
template<> inline PyTypeObject* SbkType<QTextTable >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTTABLE_IDX]); }
template<> inline PyTypeObject* SbkType<QInputDialog::InputMode >() { return SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_INPUTMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QInputDialog::InputDialogOption >() { return SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_INPUTDIALOGOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QInputDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QGtkStyle >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QGTKSTYLE_IDX]); }
template<> inline PyTypeObject* SbkType<QUndoGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QUNDOGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QFileDialog::FileMode >() { return SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_FILEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QFileDialog::Option >() { return SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_OPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QFileDialog::Option> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QFILEDIALOG_OPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QFileDialog::DialogLabel >() { return SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX]; }
template<> inline PyTypeObject* SbkType<QFileDialog::ViewMode >() { return SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_VIEWMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QFileDialog::AcceptMode >() { return SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QFileDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_IDX]); }
template<> inline PyTypeObject* SbkType<QUndoStack >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QUNDOSTACK_IDX]); }
template<> inline PyTypeObject* SbkType<QTextCursor::MoveMode >() { return SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextCursor::MoveOperation >() { return SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX]; }
template<> inline PyTypeObject* SbkType<QTextCursor::SelectionType >() { return SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextCursor >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QPlainTextEdit::LineWrapMode >() { return SbkPySide_QtGuiTypes[SBK_QPLAINTEXTEDIT_LINEWRAPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QPlainTextEdit >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QPLAINTEXTEDIT_IDX]); }
template<> inline PyTypeObject* SbkType<QImage::InvertMode >() { return SbkPySide_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QImage::Format >() { return SbkPySide_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QImage >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QIMAGE_IDX]); }
template<> inline PyTypeObject* SbkType<QBitmap >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QBITMAP_IDX]); }
template<> inline PyTypeObject* SbkType<QFontDatabase::WritingSystem >() { return SbkPySide_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX]; }
template<> inline PyTypeObject* SbkType<QFontDatabase >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONTDATABASE_IDX]); }
template<> inline PyTypeObject* SbkType<QKeyEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QKEYEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QMessageBox::ButtonRole >() { return SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_BUTTONROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QMessageBox::StandardButton >() { return SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_STANDARDBUTTON_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QMessageBox::StandardButton> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QMESSAGEBOX_STANDARDBUTTON__IDX]; }
template<> inline PyTypeObject* SbkType<QMessageBox::Icon >() { return SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_ICON_IDX]; }
template<> inline PyTypeObject* SbkType<QMessageBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QTextEdit::AutoFormattingFlag >() { return SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_AUTOFORMATTINGFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextEdit::AutoFormattingFlag> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTEDIT_AUTOFORMATTINGFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextEdit::LineWrapMode >() { return SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_LINEWRAPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextEdit >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBrowser >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTBROWSER_IDX]); }
template<> inline PyTypeObject* SbkType<QTextEdit::ExtraSelection >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]); }
template<> inline PyTypeObject* SbkType<QMenuBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QMENUBAR_IDX]); }
template<> inline PyTypeObject* SbkType<QTextTableCell >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTTABLECELL_IDX]); }
template<> inline PyTypeObject* SbkType<QTextObjectInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractProxyModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTPROXYMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QSortFilterProxyModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QSORTFILTERPROXYMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QFontDialog::FontDialogOption >() { return SbkPySide_QtGuiTypes[SBK_QFONTDIALOG_FONTDIALOGOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QFontDialog::FontDialogOption> >() { return SbkPySide_QtGuiTypes[SBK_QFLAGS_QFONTDIALOG_FONTDIALOGOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QFontDialog >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtGuiTypes[SBK_QFONTDIALOG_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QMatrix2x4 > : ValueTypeConverter<QMatrix2x4 >
{
};

template<>
struct Converter<QMatrix2x3 > : ValueTypeConverter<QMatrix2x3 >
{
};

template<>
struct Converter<QMatrix2x2 > : ValueTypeConverter<QMatrix2x2 >
{
};

template<>
struct Converter<QMatrix3x4 > : ValueTypeConverter<QMatrix3x4 >
{
};

template<>
struct Converter<QMatrix3x3 > : ValueTypeConverter<QMatrix3x3 >
{
};

template<>
struct Converter<QMatrix3x2 > : ValueTypeConverter<QMatrix3x2 >
{
};

template<>
struct Converter<QMatrix4x3 > : ValueTypeConverter<QMatrix4x3 >
{
};

template<>
struct Converter<QMatrix4x2 > : ValueTypeConverter<QMatrix4x2 >
{
};

template<>
struct Converter<QItemEditorFactory* > : ObjectTypeConverter<QItemEditorFactory >
{
};

template<>
struct Converter<QItemEditorFactory& > : ObjectTypeReferenceConverter<QItemEditorFactory >
{
};

template<>
struct Converter<QIconEngine* > : ObjectTypeConverter<QIconEngine >
{
};

template<>
struct Converter<QIconEngine& > : ObjectTypeReferenceConverter<QIconEngine >
{
};

template<>
struct Converter<QTreeWidgetItemIterator::IteratorFlag > : EnumConverter<QTreeWidgetItemIterator::IteratorFlag >
{
};
template<>
struct Converter<QFlags<QTreeWidgetItemIterator::IteratorFlag> > : EnumConverter<QFlags<QTreeWidgetItemIterator::IteratorFlag> >
{
};

template<>
struct Converter<QTreeWidgetItemIterator > : ValueTypeConverter<QTreeWidgetItemIterator >
{
};

template<>
struct Converter<QTileRules > : ValueTypeConverter<QTileRules >
{
    static QTileRules toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QFontMetricsF > : ValueTypeConverter<QFontMetricsF >
{
    static QFontMetricsF toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QItemSelection > : ValueTypeConverter<QItemSelection >
{
};

template<>
struct Converter<QKeySequence::SequenceFormat > : EnumConverter<QKeySequence::SequenceFormat >
{
};

template<>
struct Converter<QKeySequence::StandardKey > : EnumConverter<QKeySequence::StandardKey >
{
};

template<>
struct Converter<QKeySequence::SequenceMatch > : EnumConverter<QKeySequence::SequenceMatch >
{
};

template<>
struct Converter<QKeySequence > : ValueTypeConverter<QKeySequence >
{
    static QKeySequence toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStringListModel* > : ObjectTypeConverter<QStringListModel >
{
};

template<>
struct Converter<QStringListModel& > : ObjectTypeReferenceConverter<QStringListModel >
{
};

template<>
struct Converter<QTextOption::TabType > : EnumConverter<QTextOption::TabType >
{
};

template<>
struct Converter<QTextOption::Flag > : EnumConverter<QTextOption::Flag >
{
};
template<>
struct Converter<QFlags<QTextOption::Flag> > : EnumConverter<QFlags<QTextOption::Flag> >
{
};

template<>
struct Converter<QTextOption::WrapMode > : EnumConverter<QTextOption::WrapMode >
{
};

template<>
struct Converter<QTextOption > : ValueTypeConverter<QTextOption >
{
    static QTextOption toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTextOption::Tab > : ValueTypeConverter<QTextOption::Tab >
{
};

template<>
struct Converter<QBrush > : ValueTypeConverter<QBrush >
{
    static QBrush toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QX11Info > : ValueTypeConverter<QX11Info >
{
};

template<>
struct Converter<QTextInlineObject > : ValueTypeConverter<QTextInlineObject >
{
};

template<>
struct Converter<QInputContextFactory* > : ObjectTypeConverter<QInputContextFactory >
{
};

template<>
struct Converter<QInputContextFactory& > : ObjectTypeReferenceConverter<QInputContextFactory >
{
};

template<>
struct Converter<QPictureIO* > : ObjectTypeConverter<QPictureIO >
{
};

template<>
struct Converter<QPictureIO& > : ObjectTypeReferenceConverter<QPictureIO >
{
};

template<>
struct Converter<QToolTip* > : ObjectTypeConverter<QToolTip >
{
};

template<>
struct Converter<QToolTip& > : ObjectTypeReferenceConverter<QToolTip >
{
};

template<>
struct Converter<QPrinterInfo > : ValueTypeConverter<QPrinterInfo >
{
    static QPrinterInfo toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTextLine::Edge > : EnumConverter<QTextLine::Edge >
{
};

template<>
struct Converter<QTextLine::CursorPosition > : EnumConverter<QTextLine::CursorPosition >
{
};

template<>
struct Converter<QTextLine > : ValueTypeConverter<QTextLine >
{
};

template<>
struct Converter<QUndoCommand* > : ObjectTypeConverter<QUndoCommand >
{
};

template<>
struct Converter<QUndoCommand& > : ObjectTypeReferenceConverter<QUndoCommand >
{
};

template<>
struct Converter<QGestureRecognizer::ResultFlag > : EnumConverter<QGestureRecognizer::ResultFlag >
{
};
template<>
struct Converter<QFlags<QGestureRecognizer::ResultFlag> > : EnumConverter<QFlags<QGestureRecognizer::ResultFlag> >
{
};

template<>
struct Converter<QGestureRecognizer* > : ObjectTypeConverter<QGestureRecognizer >
{
};

template<>
struct Converter<QGestureRecognizer& > : ObjectTypeReferenceConverter<QGestureRecognizer >
{
};

template<>
struct Converter<QTextFragment > : ValueTypeConverter<QTextFragment >
{
};

template<>
struct Converter<QAction::Priority > : EnumConverter<QAction::Priority >
{
};

template<>
struct Converter<QAction::ActionEvent > : EnumConverter<QAction::ActionEvent >
{
};

template<>
struct Converter<QAction::SoftKeyRole > : EnumConverter<QAction::SoftKeyRole >
{
};

template<>
struct Converter<QAction::MenuRole > : EnumConverter<QAction::MenuRole >
{
};

template<>
struct Converter<QAction* > : ObjectTypeConverter<QAction >
{
};

template<>
struct Converter<QAction& > : ObjectTypeReferenceConverter<QAction >
{
};

template<>
struct Converter<QActionGroup* > : ObjectTypeConverter<QActionGroup >
{
};

template<>
struct Converter<QActionGroup& > : ObjectTypeReferenceConverter<QActionGroup >
{
};

template<>
struct Converter<QButtonGroup* > : ObjectTypeConverter<QButtonGroup >
{
};

template<>
struct Converter<QButtonGroup& > : ObjectTypeReferenceConverter<QButtonGroup >
{
};

template<>
struct Converter<QGraphicsEffect::PixmapPadMode > : EnumConverter<QGraphicsEffect::PixmapPadMode >
{
};

template<>
struct Converter<QGraphicsEffect::ChangeFlag > : EnumConverter<QGraphicsEffect::ChangeFlag >
{
};
template<>
struct Converter<QFlags<QGraphicsEffect::ChangeFlag> > : EnumConverter<QFlags<QGraphicsEffect::ChangeFlag> >
{
};

template<>
struct Converter<QGraphicsEffect* > : ObjectTypeConverter<QGraphicsEffect >
{
};

template<>
struct Converter<QGraphicsEffect& > : ObjectTypeReferenceConverter<QGraphicsEffect >
{
};

template<>
struct Converter<QGraphicsBlurEffect::BlurHint > : EnumConverter<QGraphicsBlurEffect::BlurHint >
{
};
template<>
struct Converter<QFlags<QGraphicsBlurEffect::BlurHint> > : EnumConverter<QFlags<QGraphicsBlurEffect::BlurHint> >
{
};

template<>
struct Converter<QGraphicsBlurEffect* > : ObjectTypeConverter<QGraphicsBlurEffect >
{
};

template<>
struct Converter<QGraphicsBlurEffect& > : ObjectTypeReferenceConverter<QGraphicsBlurEffect >
{
};

template<>
struct Converter<QGraphicsColorizeEffect* > : ObjectTypeConverter<QGraphicsColorizeEffect >
{
};

template<>
struct Converter<QGraphicsColorizeEffect& > : ObjectTypeReferenceConverter<QGraphicsColorizeEffect >
{
};

template<>
struct Converter<QGraphicsOpacityEffect* > : ObjectTypeConverter<QGraphicsOpacityEffect >
{
};

template<>
struct Converter<QGraphicsOpacityEffect& > : ObjectTypeReferenceConverter<QGraphicsOpacityEffect >
{
};

template<>
struct Converter<QDataWidgetMapper::SubmitPolicy > : EnumConverter<QDataWidgetMapper::SubmitPolicy >
{
};

template<>
struct Converter<QDataWidgetMapper* > : ObjectTypeConverter<QDataWidgetMapper >
{
};

template<>
struct Converter<QDataWidgetMapper& > : ObjectTypeReferenceConverter<QDataWidgetMapper >
{
};

template<>
struct Converter<QClipboard::Mode > : EnumConverter<QClipboard::Mode >
{
};

template<>
struct Converter<QClipboard* > : ObjectTypeConverter<QClipboard >
{
};

template<>
struct Converter<QClipboard& > : ObjectTypeReferenceConverter<QClipboard >
{
};

template<>
struct Converter<QSystemTrayIcon::MessageIcon > : EnumConverter<QSystemTrayIcon::MessageIcon >
{
};

template<>
struct Converter<QSystemTrayIcon::ActivationReason > : EnumConverter<QSystemTrayIcon::ActivationReason >
{
};

template<>
struct Converter<QSystemTrayIcon* > : ObjectTypeConverter<QSystemTrayIcon >
{
};

template<>
struct Converter<QSystemTrayIcon& > : ObjectTypeReferenceConverter<QSystemTrayIcon >
{
};

template<>
struct Converter<QStyleFactory* > : ObjectTypeConverter<QStyleFactory >
{
};

template<>
struct Converter<QStyleFactory& > : ObjectTypeReferenceConverter<QStyleFactory >
{
};

template<>
struct Converter<QPolygonF > : ValueTypeConverter<QPolygonF >
{
    static QPolygonF toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QKeyEventTransition* > : ObjectTypeConverter<QKeyEventTransition >
{
};

template<>
struct Converter<QKeyEventTransition& > : ObjectTypeReferenceConverter<QKeyEventTransition >
{
};

template<>
struct Converter<QMouseEventTransition* > : ObjectTypeConverter<QMouseEventTransition >
{
};

template<>
struct Converter<QMouseEventTransition& > : ObjectTypeReferenceConverter<QMouseEventTransition >
{
};

template<>
struct Converter<QTextObject* > : ObjectTypeConverter<QTextObject >
{
};

template<>
struct Converter<QTextObject& > : ObjectTypeReferenceConverter<QTextObject >
{
};

template<>
struct Converter<QTextFrame* > : ObjectTypeConverter<QTextFrame >
{
};

template<>
struct Converter<QTextFrame& > : ObjectTypeReferenceConverter<QTextFrame >
{
};

template<>
struct Converter<QTreeWidgetItem::ItemType > : EnumConverter<QTreeWidgetItem::ItemType >
{
};

template<>
struct Converter<QTreeWidgetItem::ChildIndicatorPolicy > : EnumConverter<QTreeWidgetItem::ChildIndicatorPolicy >
{
};

template<>
struct Converter<QTreeWidgetItem* > : ObjectTypeConverter<QTreeWidgetItem >
{
};

template<>
struct Converter<QTreeWidgetItem& > : ObjectTypeReferenceConverter<QTreeWidgetItem >
{
};

template<>
struct Converter<QValidator::State > : EnumConverter<QValidator::State >
{
};

template<>
struct Converter<QValidator* > : ObjectTypeConverter<QValidator >
{
};

template<>
struct Converter<QValidator& > : ObjectTypeReferenceConverter<QValidator >
{
};

template<>
struct Converter<QTextLength::Type > : EnumConverter<QTextLength::Type >
{
};

template<>
struct Converter<QTextLength > : ValueTypeConverter<QTextLength >
{
};

template<>
struct Converter<QImageReader::ImageReaderError > : EnumConverter<QImageReader::ImageReaderError >
{
};

template<>
struct Converter<QImageReader* > : ObjectTypeConverter<QImageReader >
{
};

template<>
struct Converter<QImageReader& > : ObjectTypeReferenceConverter<QImageReader >
{
};

template<>
struct Converter<QPaintEngineState* > : ObjectTypeConverter<QPaintEngineState >
{
};

template<>
struct Converter<QPaintEngineState& > : ObjectTypeReferenceConverter<QPaintEngineState >
{
};

template<>
struct Converter<QWidgetAction* > : ObjectTypeConverter<QWidgetAction >
{
};

template<>
struct Converter<QWidgetAction& > : ObjectTypeReferenceConverter<QWidgetAction >
{
};

template<>
struct Converter<QPolygon > : ValueTypeConverter<QPolygon >
{
    static QPolygon toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGraphicsAnchor* > : ObjectTypeConverter<QGraphicsAnchor >
{
};

template<>
struct Converter<QGraphicsAnchor& > : ObjectTypeReferenceConverter<QGraphicsAnchor >
{
};

template<>
struct Converter<QColor::Spec > : EnumConverter<QColor::Spec >
{
};

template<>
struct Converter<QColor > : ValueTypeConverter<QColor >
{
    static QColor toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGesture::GestureCancelPolicy > : EnumConverter<QGesture::GestureCancelPolicy >
{
};

template<>
struct Converter<QGesture* > : ObjectTypeConverter<QGesture >
{
};

template<>
struct Converter<QGesture& > : ObjectTypeReferenceConverter<QGesture >
{
};

template<>
struct Converter<QAbstractKineticScroller* > : ObjectTypeConverter<QAbstractKineticScroller >
{
};

template<>
struct Converter<QAbstractKineticScroller& > : ObjectTypeReferenceConverter<QAbstractKineticScroller >
{
};

template<>
struct Converter<QTableWidgetItem::ItemType > : EnumConverter<QTableWidgetItem::ItemType >
{
};

template<>
struct Converter<QTableWidgetItem* > : ObjectTypeConverter<QTableWidgetItem >
{
};

template<>
struct Converter<QTableWidgetItem& > : ObjectTypeReferenceConverter<QTableWidgetItem >
{
};

template<>
struct Converter<QCompleter::ModelSorting > : EnumConverter<QCompleter::ModelSorting >
{
};

template<>
struct Converter<QCompleter::CompletionMode > : EnumConverter<QCompleter::CompletionMode >
{
};

template<>
struct Converter<QCompleter* > : ObjectTypeConverter<QCompleter >
{
};

template<>
struct Converter<QCompleter& > : ObjectTypeReferenceConverter<QCompleter >
{
};

template<>
struct Converter<QClipboardEvent* > : ObjectTypeConverter<QClipboardEvent >
{
};

template<>
struct Converter<QClipboardEvent& > : ObjectTypeReferenceConverter<QClipboardEvent >
{
};

template<>
struct Converter<QWindowStateChangeEvent* > : ObjectTypeConverter<QWindowStateChangeEvent >
{
};

template<>
struct Converter<QWindowStateChangeEvent& > : ObjectTypeReferenceConverter<QWindowStateChangeEvent >
{
};

template<>
struct Converter<QCloseEvent* > : ObjectTypeConverter<QCloseEvent >
{
};

template<>
struct Converter<QCloseEvent& > : ObjectTypeReferenceConverter<QCloseEvent >
{
};

template<>
struct Converter<QIconDragEvent* > : ObjectTypeConverter<QIconDragEvent >
{
};

template<>
struct Converter<QIconDragEvent& > : ObjectTypeReferenceConverter<QIconDragEvent >
{
};

template<>
struct Converter<QFileOpenEvent* > : ObjectTypeConverter<QFileOpenEvent >
{
};

template<>
struct Converter<QFileOpenEvent& > : ObjectTypeReferenceConverter<QFileOpenEvent >
{
};

template<>
struct Converter<QShortcutEvent* > : ObjectTypeConverter<QShortcutEvent >
{
};

template<>
struct Converter<QShortcutEvent& > : ObjectTypeReferenceConverter<QShortcutEvent >
{
};

template<>
struct Converter<QShowEvent* > : ObjectTypeConverter<QShowEvent >
{
};

template<>
struct Converter<QShowEvent& > : ObjectTypeReferenceConverter<QShowEvent >
{
};

template<>
struct Converter<QStatusTipEvent* > : ObjectTypeConverter<QStatusTipEvent >
{
};

template<>
struct Converter<QStatusTipEvent& > : ObjectTypeReferenceConverter<QStatusTipEvent >
{
};

template<>
struct Converter<QHideEvent* > : ObjectTypeConverter<QHideEvent >
{
};

template<>
struct Converter<QHideEvent& > : ObjectTypeReferenceConverter<QHideEvent >
{
};

template<>
struct Converter<QHelpEvent* > : ObjectTypeConverter<QHelpEvent >
{
};

template<>
struct Converter<QHelpEvent& > : ObjectTypeReferenceConverter<QHelpEvent >
{
};

template<>
struct Converter<QDropEvent* > : ObjectTypeConverter<QDropEvent >
{
};

template<>
struct Converter<QDropEvent& > : ObjectTypeReferenceConverter<QDropEvent >
{
};

template<>
struct Converter<QActionEvent* > : ObjectTypeConverter<QActionEvent >
{
};

template<>
struct Converter<QActionEvent& > : ObjectTypeReferenceConverter<QActionEvent >
{
};

template<>
struct Converter<QPinchGesture::ChangeFlag > : EnumConverter<QPinchGesture::ChangeFlag >
{
};
template<>
struct Converter<QFlags<QPinchGesture::ChangeFlag> > : EnumConverter<QFlags<QPinchGesture::ChangeFlag> >
{
};

template<>
struct Converter<QPinchGesture* > : ObjectTypeConverter<QPinchGesture >
{
};

template<>
struct Converter<QPinchGesture& > : ObjectTypeReferenceConverter<QPinchGesture >
{
};

template<>
struct Converter<QPainterPathStroker* > : ObjectTypeConverter<QPainterPathStroker >
{
};

template<>
struct Converter<QPainterPathStroker& > : ObjectTypeReferenceConverter<QPainterPathStroker >
{
};

template<>
struct Converter<QShortcut* > : ObjectTypeConverter<QShortcut >
{
};

template<>
struct Converter<QShortcut& > : ObjectTypeReferenceConverter<QShortcut >
{
};

template<>
struct Converter<QRegExpValidator* > : ObjectTypeConverter<QRegExpValidator >
{
};

template<>
struct Converter<QRegExpValidator& > : ObjectTypeReferenceConverter<QRegExpValidator >
{
};

template<>
struct Converter<QRegion::RegionType > : EnumConverter<QRegion::RegionType >
{
};

template<>
struct Converter<QRegion > : ValueTypeConverter<QRegion >
{
    static QRegion toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGraphicsItemAnimation* > : ObjectTypeConverter<QGraphicsItemAnimation >
{
};

template<>
struct Converter<QGraphicsItemAnimation& > : ObjectTypeReferenceConverter<QGraphicsItemAnimation >
{
};

template<>
struct Converter<QResizeEvent* > : ObjectTypeConverter<QResizeEvent >
{
};

template<>
struct Converter<QResizeEvent& > : ObjectTypeReferenceConverter<QResizeEvent >
{
};

template<>
struct Converter<QAbstractItemDelegate::EndEditHint > : EnumConverter<QAbstractItemDelegate::EndEditHint >
{
};

template<>
struct Converter<QAbstractItemDelegate* > : ObjectTypeConverter<QAbstractItemDelegate >
{
};

template<>
struct Converter<QAbstractItemDelegate& > : ObjectTypeReferenceConverter<QAbstractItemDelegate >
{
};

template<>
struct Converter<QStyledItemDelegate* > : ObjectTypeConverter<QStyledItemDelegate >
{
};

template<>
struct Converter<QStyledItemDelegate& > : ObjectTypeReferenceConverter<QStyledItemDelegate >
{
};

template<>
struct Converter<QItemDelegate* > : ObjectTypeConverter<QItemDelegate >
{
};

template<>
struct Converter<QItemDelegate& > : ObjectTypeReferenceConverter<QItemDelegate >
{
};

template<>
struct Converter<QLayoutItem* > : ObjectTypeConverter<QLayoutItem >
{
};

template<>
struct Converter<QLayoutItem& > : ObjectTypeReferenceConverter<QLayoutItem >
{
};

template<>
struct Converter<QLayout::SizeConstraint > : EnumConverter<QLayout::SizeConstraint >
{
};

template<>
struct Converter<QLayout* > : ObjectTypeConverter<QLayout >
{
};

template<>
struct Converter<QLayout& > : ObjectTypeReferenceConverter<QLayout >
{
};

template<>
struct Converter<QStackedLayout::StackingMode > : EnumConverter<QStackedLayout::StackingMode >
{
};

template<>
struct Converter<QStackedLayout* > : ObjectTypeConverter<QStackedLayout >
{
};

template<>
struct Converter<QStackedLayout& > : ObjectTypeReferenceConverter<QStackedLayout >
{
};

template<>
struct Converter<QWidgetItem* > : ObjectTypeConverter<QWidgetItem >
{
};

template<>
struct Converter<QWidgetItem& > : ObjectTypeReferenceConverter<QWidgetItem >
{
};

template<>
struct Converter<QPixmapCache* > : ObjectTypeConverter<QPixmapCache >
{
};

template<>
struct Converter<QPixmapCache& > : ObjectTypeReferenceConverter<QPixmapCache >
{
};

template<>
struct Converter<QSound* > : ObjectTypeConverter<QSound >
{
};

template<>
struct Converter<QSound& > : ObjectTypeReferenceConverter<QSound >
{
};

template<>
struct Converter<QTextBlock > : ValueTypeConverter<QTextBlock >
{
};

template<>
struct Converter<QTextFrame::iterator > : ValueTypeConverter<QTextFrame::iterator >
{
};

template<>
struct Converter<QTextBlock::iterator > : ValueTypeConverter<QTextBlock::iterator >
{
};

template<>
struct Converter<QMoveEvent* > : ObjectTypeConverter<QMoveEvent >
{
};

template<>
struct Converter<QMoveEvent& > : ObjectTypeReferenceConverter<QMoveEvent >
{
};

template<>
struct Converter<QPaintEngine::PolygonDrawMode > : EnumConverter<QPaintEngine::PolygonDrawMode >
{
};

template<>
struct Converter<QPaintEngine::Type > : EnumConverter<QPaintEngine::Type >
{
};

template<>
struct Converter<QPaintEngine::PaintEngineFeature > : EnumConverter<QPaintEngine::PaintEngineFeature >
{
};
template<>
struct Converter<QFlags<QPaintEngine::PaintEngineFeature> > : EnumConverter<QFlags<QPaintEngine::PaintEngineFeature> >
{
};

template<>
struct Converter<QPaintEngine::DirtyFlag > : EnumConverter<QPaintEngine::DirtyFlag >
{
};
template<>
struct Converter<QFlags<QPaintEngine::DirtyFlag> > : EnumConverter<QFlags<QPaintEngine::DirtyFlag> >
{
};

template<>
struct Converter<QPaintEngine* > : ObjectTypeConverter<QPaintEngine >
{
};

template<>
struct Converter<QPaintEngine& > : ObjectTypeReferenceConverter<QPaintEngine >
{
};

template<>
struct Converter<QBoxLayout::Direction > : EnumConverter<QBoxLayout::Direction >
{
};

template<>
struct Converter<QBoxLayout* > : ObjectTypeConverter<QBoxLayout >
{
};

template<>
struct Converter<QBoxLayout& > : ObjectTypeReferenceConverter<QBoxLayout >
{
};

template<>
struct Converter<QHBoxLayout* > : ObjectTypeConverter<QHBoxLayout >
{
};

template<>
struct Converter<QHBoxLayout& > : ObjectTypeReferenceConverter<QHBoxLayout >
{
};

template<>
struct Converter<QVBoxLayout* > : ObjectTypeConverter<QVBoxLayout >
{
};

template<>
struct Converter<QVBoxLayout& > : ObjectTypeReferenceConverter<QVBoxLayout >
{
};

template<>
struct Converter<QAccessibleEvent* > : ObjectTypeConverter<QAccessibleEvent >
{
};

template<>
struct Converter<QAccessibleEvent& > : ObjectTypeReferenceConverter<QAccessibleEvent >
{
};

template<>
struct Converter<QImageWriter::ImageWriterError > : EnumConverter<QImageWriter::ImageWriterError >
{
};

template<>
struct Converter<QImageWriter* > : ObjectTypeConverter<QImageWriter >
{
};

template<>
struct Converter<QImageWriter& > : ObjectTypeReferenceConverter<QImageWriter >
{
};

template<>
struct Converter<QStandardItem::ItemType > : EnumConverter<QStandardItem::ItemType >
{
};

template<>
struct Converter<QStandardItem* > : ObjectTypeConverter<QStandardItem >
{
};

template<>
struct Converter<QStandardItem& > : ObjectTypeReferenceConverter<QStandardItem >
{
};

template<>
struct Converter<QTextDocumentFragment > : ValueTypeConverter<QTextDocumentFragment >
{
};

template<>
struct Converter<QPen > : ValueTypeConverter<QPen >
{
    static QPen toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTextDocument::ResourceType > : EnumConverter<QTextDocument::ResourceType >
{
};

template<>
struct Converter<QTextDocument::FindFlag > : EnumConverter<QTextDocument::FindFlag >
{
};
template<>
struct Converter<QFlags<QTextDocument::FindFlag> > : EnumConverter<QFlags<QTextDocument::FindFlag> >
{
};

template<>
struct Converter<QTextDocument::MetaInformation > : EnumConverter<QTextDocument::MetaInformation >
{
};

template<>
struct Converter<QTextDocument* > : ObjectTypeConverter<QTextDocument >
{
};

template<>
struct Converter<QTextDocument& > : ObjectTypeReferenceConverter<QTextDocument >
{
};

template<>
struct Converter<QAbstractTextDocumentLayout* > : ObjectTypeConverter<QAbstractTextDocumentLayout >
{
};

template<>
struct Converter<QAbstractTextDocumentLayout& > : ObjectTypeReferenceConverter<QAbstractTextDocumentLayout >
{
};

template<>
struct Converter<QAbstractTextDocumentLayout::Selection > : ValueTypeConverter<QAbstractTextDocumentLayout::Selection >
{
};

template<>
struct Converter<QAbstractTextDocumentLayout::PaintContext > : ValueTypeConverter<QAbstractTextDocumentLayout::PaintContext >
{
};

template<>
struct Converter<QTextLayout::CursorMode > : EnumConverter<QTextLayout::CursorMode >
{
};

template<>
struct Converter<QTextLayout* > : ObjectTypeConverter<QTextLayout >
{
};

template<>
struct Converter<QTextLayout& > : ObjectTypeReferenceConverter<QTextLayout >
{
};

template<>
struct Converter<QTextLayout::FormatRange > : ValueTypeConverter<QTextLayout::FormatRange >
{
};

template<>
struct Converter<QDrag* > : ObjectTypeConverter<QDrag >
{
};

template<>
struct Converter<QDrag& > : ObjectTypeReferenceConverter<QDrag >
{
};

template<>
struct Converter<QGraphicsItem::CacheMode > : EnumConverter<QGraphicsItem::CacheMode >
{
};

template<>
struct Converter<QGraphicsItem::PanelModality > : EnumConverter<QGraphicsItem::PanelModality >
{
};

template<>
struct Converter<QGraphicsItem::GraphicsItemFlag > : EnumConverter<QGraphicsItem::GraphicsItemFlag >
{
};
template<>
struct Converter<QFlags<QGraphicsItem::GraphicsItemFlag> > : EnumConverter<QFlags<QGraphicsItem::GraphicsItemFlag> >
{
};

template<>
struct Converter<QGraphicsItem::GraphicsItemChange > : EnumConverter<QGraphicsItem::GraphicsItemChange >
{
};

template<>
struct Converter<QGraphicsItem::Extension > : EnumConverter<QGraphicsItem::Extension >
{
};

template<>
struct Converter<QGraphicsItem* > : ObjectTypeConverter<QGraphicsItem >
{
};

template<>
struct Converter<QGraphicsItem& > : ObjectTypeReferenceConverter<QGraphicsItem >
{
};

template<>
struct Converter<QGraphicsPixmapItem::ShapeMode > : EnumConverter<QGraphicsPixmapItem::ShapeMode >
{
};

template<>
struct Converter<QGraphicsPixmapItem* > : ObjectTypeConverter<QGraphicsPixmapItem >
{
};

template<>
struct Converter<QGraphicsPixmapItem& > : ObjectTypeReferenceConverter<QGraphicsPixmapItem >
{
};

template<>
struct Converter<QAbstractGraphicsShapeItem* > : ObjectTypeConverter<QAbstractGraphicsShapeItem >
{
};

template<>
struct Converter<QAbstractGraphicsShapeItem& > : ObjectTypeReferenceConverter<QAbstractGraphicsShapeItem >
{
};

template<>
struct Converter<QGraphicsPolygonItem* > : ObjectTypeConverter<QGraphicsPolygonItem >
{
};

template<>
struct Converter<QGraphicsPolygonItem& > : ObjectTypeReferenceConverter<QGraphicsPolygonItem >
{
};

template<>
struct Converter<QGraphicsRectItem* > : ObjectTypeConverter<QGraphicsRectItem >
{
};

template<>
struct Converter<QGraphicsRectItem& > : ObjectTypeReferenceConverter<QGraphicsRectItem >
{
};

template<>
struct Converter<QIcon::Mode > : EnumConverter<QIcon::Mode >
{
};

template<>
struct Converter<QIcon::State > : EnumConverter<QIcon::State >
{
};

template<>
struct Converter<QIcon > : ValueTypeConverter<QIcon >
{
    static QIcon toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGraphicsItemGroup* > : ObjectTypeConverter<QGraphicsItemGroup >
{
};

template<>
struct Converter<QGraphicsItemGroup& > : ObjectTypeReferenceConverter<QGraphicsItemGroup >
{
};

template<>
struct Converter<QGraphicsEllipseItem* > : ObjectTypeConverter<QGraphicsEllipseItem >
{
};

template<>
struct Converter<QGraphicsEllipseItem& > : ObjectTypeReferenceConverter<QGraphicsEllipseItem >
{
};

template<>
struct Converter<QGraphicsSimpleTextItem* > : ObjectTypeConverter<QGraphicsSimpleTextItem >
{
};

template<>
struct Converter<QGraphicsSimpleTextItem& > : ObjectTypeReferenceConverter<QGraphicsSimpleTextItem >
{
};

template<>
struct Converter<QPaintDevice::PaintDeviceMetric > : EnumConverter<QPaintDevice::PaintDeviceMetric >
{
};

template<>
struct Converter<QPaintDevice* > : ObjectTypeConverter<QPaintDevice >
{
};

template<>
struct Converter<QPaintDevice& > : ObjectTypeReferenceConverter<QPaintDevice >
{
};

template<>
struct Converter<QPixmap::ShareMode > : EnumConverter<QPixmap::ShareMode >
{
};

template <>
struct SbkTypeInfo<QPixmap >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QPixmap >
{
    static QPixmap toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
    static inline PyObject* toPython(void* cppObj) { return toPython(*reinterpret_cast<QPixmap* >(cppObj)); }
    static PyObject* toPython(const QPixmap& cppObj);
};

template <>
struct SbkTypeInfo<QPicture >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QPicture > : ValueTypeConverter<QPicture >
{
};

template<>
struct Converter<QInputEvent* > : ObjectTypeConverter<QInputEvent >
{
};

template<>
struct Converter<QInputEvent& > : ObjectTypeReferenceConverter<QInputEvent >
{
};

template<>
struct Converter<QTouchEvent::DeviceType > : EnumConverter<QTouchEvent::DeviceType >
{
};

template <>
struct SbkTypeInfo<QTouchEvent >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTouchEvent > : ValueTypeConverter<QTouchEvent >
{
};

template<>
struct Converter<QTouchEvent::TouchPoint > : ValueTypeConverter<QTouchEvent::TouchPoint >
{
    static QTouchEvent::TouchPoint toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTabletEvent::TabletDevice > : EnumConverter<QTabletEvent::TabletDevice >
{
};

template<>
struct Converter<QTabletEvent::PointerType > : EnumConverter<QTabletEvent::PointerType >
{
};

template<>
struct Converter<QTabletEvent* > : ObjectTypeConverter<QTabletEvent >
{
};

template<>
struct Converter<QTabletEvent& > : ObjectTypeReferenceConverter<QTabletEvent >
{
};

template<>
struct Converter<QMouseEvent* > : ObjectTypeConverter<QMouseEvent >
{
};

template<>
struct Converter<QMouseEvent& > : ObjectTypeReferenceConverter<QMouseEvent >
{
};

template<>
struct Converter<QSwipeGesture::SwipeDirection > : EnumConverter<QSwipeGesture::SwipeDirection >
{
};

template<>
struct Converter<QSwipeGesture* > : ObjectTypeConverter<QSwipeGesture >
{
};

template<>
struct Converter<QSwipeGesture& > : ObjectTypeReferenceConverter<QSwipeGesture >
{
};

template<>
struct Converter<QDragLeaveEvent* > : ObjectTypeConverter<QDragLeaveEvent >
{
};

template<>
struct Converter<QDragLeaveEvent& > : ObjectTypeReferenceConverter<QDragLeaveEvent >
{
};

template<>
struct Converter<QStandardItemModel* > : ObjectTypeConverter<QStandardItemModel >
{
};

template<>
struct Converter<QStandardItemModel& > : ObjectTypeReferenceConverter<QStandardItemModel >
{
};

template<>
struct Converter<QProxyModel* > : ObjectTypeConverter<QProxyModel >
{
};

template<>
struct Converter<QProxyModel& > : ObjectTypeReferenceConverter<QProxyModel >
{
};

template<>
struct Converter<QFileSystemModel::Roles > : EnumConverter<QFileSystemModel::Roles >
{
};

template<>
struct Converter<QFileSystemModel* > : ObjectTypeConverter<QFileSystemModel >
{
};

template<>
struct Converter<QFileSystemModel& > : ObjectTypeReferenceConverter<QFileSystemModel >
{
};

template<>
struct Converter<QImageIOHandler::ImageOption > : EnumConverter<QImageIOHandler::ImageOption >
{
};

template<>
struct Converter<QImageIOHandler* > : ObjectTypeConverter<QImageIOHandler >
{
};

template<>
struct Converter<QImageIOHandler& > : ObjectTypeReferenceConverter<QImageIOHandler >
{
};

template<>
struct Converter<QFormLayout::FieldGrowthPolicy > : EnumConverter<QFormLayout::FieldGrowthPolicy >
{
};

template<>
struct Converter<QFormLayout::RowWrapPolicy > : EnumConverter<QFormLayout::RowWrapPolicy >
{
};

template<>
struct Converter<QFormLayout::ItemRole > : EnumConverter<QFormLayout::ItemRole >
{
};

template<>
struct Converter<QFormLayout* > : ObjectTypeConverter<QFormLayout >
{
};

template<>
struct Converter<QFormLayout& > : ObjectTypeReferenceConverter<QFormLayout >
{
};

template<>
struct Converter<QSyntaxHighlighter* > : ObjectTypeConverter<QSyntaxHighlighter >
{
};

template<>
struct Converter<QSyntaxHighlighter& > : ObjectTypeReferenceConverter<QSyntaxHighlighter >
{
};

template<>
struct Converter<QFontInfo > : ValueTypeConverter<QFontInfo >
{
    static QFontInfo toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOption::StyleOptionVersion > : EnumConverter<QStyleOption::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOption::StyleOptionType > : EnumConverter<QStyleOption::StyleOptionType >
{
};

template<>
struct Converter<QStyleOption::OptionType > : EnumConverter<QStyleOption::OptionType >
{
};

template<>
struct Converter<QStyleOption > : ValueTypeConverter<QStyleOption >
{
};

template<>
struct Converter<QStyleHintReturn::HintReturnType > : EnumConverter<QStyleHintReturn::HintReturnType >
{
};

template<>
struct Converter<QStyleHintReturn::StyleOptionVersion > : EnumConverter<QStyleHintReturn::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleHintReturn::StyleOptionType > : EnumConverter<QStyleHintReturn::StyleOptionType >
{
};

template<>
struct Converter<QStyleHintReturn* > : ObjectTypeConverter<QStyleHintReturn >
{
};

template<>
struct Converter<QStyleHintReturn& > : ObjectTypeReferenceConverter<QStyleHintReturn >
{
};

template<>
struct Converter<QStyleHintReturnMask::StyleOptionVersion > : EnumConverter<QStyleHintReturnMask::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleHintReturnMask::StyleOptionType > : EnumConverter<QStyleHintReturnMask::StyleOptionType >
{
};

template<>
struct Converter<QStyleHintReturnMask* > : ObjectTypeConverter<QStyleHintReturnMask >
{
};

template<>
struct Converter<QStyleHintReturnMask& > : ObjectTypeReferenceConverter<QStyleHintReturnMask >
{
};

template<>
struct Converter<QStyleHintReturnVariant::StyleOptionVersion > : EnumConverter<QStyleHintReturnVariant::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleHintReturnVariant::StyleOptionType > : EnumConverter<QStyleHintReturnVariant::StyleOptionType >
{
};

template<>
struct Converter<QStyleHintReturnVariant* > : ObjectTypeConverter<QStyleHintReturnVariant >
{
};

template<>
struct Converter<QStyleHintReturnVariant& > : ObjectTypeReferenceConverter<QStyleHintReturnVariant >
{
};

template<>
struct Converter<QStyleOptionRubberBand::StyleOptionVersion > : EnumConverter<QStyleOptionRubberBand::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionRubberBand::StyleOptionType > : EnumConverter<QStyleOptionRubberBand::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionRubberBand > : ValueTypeConverter<QStyleOptionRubberBand >
{
};

template<>
struct Converter<QStyleOptionTabWidgetFrame::StyleOptionVersion > : EnumConverter<QStyleOptionTabWidgetFrame::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTabWidgetFrame::StyleOptionType > : EnumConverter<QStyleOptionTabWidgetFrame::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionTabWidgetFrame > : ValueTypeConverter<QStyleOptionTabWidgetFrame >
{
};

template<>
struct Converter<QStyleOptionHeader::StyleOptionVersion > : EnumConverter<QStyleOptionHeader::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionHeader::SectionPosition > : EnumConverter<QStyleOptionHeader::SectionPosition >
{
};

template<>
struct Converter<QStyleOptionHeader::SelectedPosition > : EnumConverter<QStyleOptionHeader::SelectedPosition >
{
};

template<>
struct Converter<QStyleOptionHeader::StyleOptionType > : EnumConverter<QStyleOptionHeader::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionHeader::SortIndicator > : EnumConverter<QStyleOptionHeader::SortIndicator >
{
};

template<>
struct Converter<QStyleOptionHeader > : ValueTypeConverter<QStyleOptionHeader >
{
};

template<>
struct Converter<QStyleOptionButton::StyleOptionVersion > : EnumConverter<QStyleOptionButton::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionButton::ButtonFeature > : EnumConverter<QStyleOptionButton::ButtonFeature >
{
};
template<>
struct Converter<QFlags<QStyleOptionButton::ButtonFeature> > : EnumConverter<QFlags<QStyleOptionButton::ButtonFeature> >
{
};

template<>
struct Converter<QStyleOptionButton::StyleOptionType > : EnumConverter<QStyleOptionButton::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionButton > : ValueTypeConverter<QStyleOptionButton >
{
};

template<>
struct Converter<QStyleOptionDockWidget::StyleOptionVersion > : EnumConverter<QStyleOptionDockWidget::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionDockWidget::StyleOptionType > : EnumConverter<QStyleOptionDockWidget::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionDockWidget > : ValueTypeConverter<QStyleOptionDockWidget >
{
};

template<>
struct Converter<QStyleOptionDockWidgetV2::StyleOptionVersion > : EnumConverter<QStyleOptionDockWidgetV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionDockWidgetV2 > : ValueTypeConverter<QStyleOptionDockWidgetV2 >
{
    static QStyleOptionDockWidgetV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionToolBar::StyleOptionVersion > : EnumConverter<QStyleOptionToolBar::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionToolBar::StyleOptionType > : EnumConverter<QStyleOptionToolBar::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionToolBar::ToolBarPosition > : EnumConverter<QStyleOptionToolBar::ToolBarPosition >
{
};

template<>
struct Converter<QStyleOptionToolBar::ToolBarFeature > : EnumConverter<QStyleOptionToolBar::ToolBarFeature >
{
};
template<>
struct Converter<QFlags<QStyleOptionToolBar::ToolBarFeature> > : EnumConverter<QFlags<QStyleOptionToolBar::ToolBarFeature> >
{
};

template<>
struct Converter<QStyleOptionToolBar > : ValueTypeConverter<QStyleOptionToolBar >
{
};

template<>
struct Converter<QStyleOptionTabBarBase::StyleOptionVersion > : EnumConverter<QStyleOptionTabBarBase::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTabBarBase::StyleOptionType > : EnumConverter<QStyleOptionTabBarBase::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionTabBarBase > : ValueTypeConverter<QStyleOptionTabBarBase >
{
};

template<>
struct Converter<QStyleOptionTabBarBaseV2::StyleOptionVersion > : EnumConverter<QStyleOptionTabBarBaseV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTabBarBaseV2 > : ValueTypeConverter<QStyleOptionTabBarBaseV2 >
{
    static QStyleOptionTabBarBaseV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionToolBox::StyleOptionVersion > : EnumConverter<QStyleOptionToolBox::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionToolBox::StyleOptionType > : EnumConverter<QStyleOptionToolBox::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionToolBox > : ValueTypeConverter<QStyleOptionToolBox >
{
};

template<>
struct Converter<QStyleOptionTab::StyleOptionVersion > : EnumConverter<QStyleOptionTab::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTab::CornerWidget > : EnumConverter<QStyleOptionTab::CornerWidget >
{
};
template<>
struct Converter<QFlags<QStyleOptionTab::CornerWidget> > : EnumConverter<QFlags<QStyleOptionTab::CornerWidget> >
{
};

template<>
struct Converter<QStyleOptionTab::TabPosition > : EnumConverter<QStyleOptionTab::TabPosition >
{
};

template<>
struct Converter<QStyleOptionTab::SelectedPosition > : EnumConverter<QStyleOptionTab::SelectedPosition >
{
};

template<>
struct Converter<QStyleOptionTab::StyleOptionType > : EnumConverter<QStyleOptionTab::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionTab > : ValueTypeConverter<QStyleOptionTab >
{
};

template<>
struct Converter<QStyleOptionTabV2::StyleOptionVersion > : EnumConverter<QStyleOptionTabV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTabV2 > : ValueTypeConverter<QStyleOptionTabV2 >
{
    static QStyleOptionTabV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionTabV3::StyleOptionVersion > : EnumConverter<QStyleOptionTabV3::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTabV3 > : ValueTypeConverter<QStyleOptionTabV3 >
{
    static QStyleOptionTabV3 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionProgressBar::StyleOptionVersion > : EnumConverter<QStyleOptionProgressBar::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionProgressBar::StyleOptionType > : EnumConverter<QStyleOptionProgressBar::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionProgressBar > : ValueTypeConverter<QStyleOptionProgressBar >
{
};

template<>
struct Converter<QStyleOptionProgressBarV2::StyleOptionVersion > : EnumConverter<QStyleOptionProgressBarV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionProgressBarV2::StyleOptionType > : EnumConverter<QStyleOptionProgressBarV2::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionProgressBarV2 > : ValueTypeConverter<QStyleOptionProgressBarV2 >
{
    static QStyleOptionProgressBarV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionFrame::StyleOptionVersion > : EnumConverter<QStyleOptionFrame::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionFrame::StyleOptionType > : EnumConverter<QStyleOptionFrame::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionFrame > : ValueTypeConverter<QStyleOptionFrame >
{
};

template<>
struct Converter<QStyleOptionFrameV2::StyleOptionVersion > : EnumConverter<QStyleOptionFrameV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionFrameV2::FrameFeature > : EnumConverter<QStyleOptionFrameV2::FrameFeature >
{
};
template<>
struct Converter<QFlags<QStyleOptionFrameV2::FrameFeature> > : EnumConverter<QFlags<QStyleOptionFrameV2::FrameFeature> >
{
};

template<>
struct Converter<QStyleOptionFrameV2 > : ValueTypeConverter<QStyleOptionFrameV2 >
{
    static QStyleOptionFrameV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionFrameV3::StyleOptionVersion > : EnumConverter<QStyleOptionFrameV3::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionFrameV3 > : ValueTypeConverter<QStyleOptionFrameV3 >
{
    static QStyleOptionFrameV3 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTableWidgetSelectionRange > : ValueTypeConverter<QTableWidgetSelectionRange >
{
};

template<>
struct Converter<QGraphicsDropShadowEffect* > : ObjectTypeConverter<QGraphicsDropShadowEffect >
{
};

template<>
struct Converter<QGraphicsDropShadowEffect& > : ObjectTypeReferenceConverter<QGraphicsDropShadowEffect >
{
};

template<>
struct Converter<QGradient::CoordinateMode > : EnumConverter<QGradient::CoordinateMode >
{
};

template<>
struct Converter<QGradient::Spread > : EnumConverter<QGradient::Spread >
{
};

template<>
struct Converter<QGradient::Type > : EnumConverter<QGradient::Type >
{
};

template<>
struct Converter<QGradient::InterpolationMode > : EnumConverter<QGradient::InterpolationMode >
{
};

template<>
struct Converter<QGradient > : ValueTypeConverter<QGradient >
{
};

template<>
struct Converter<QConicalGradient > : ValueTypeConverter<QConicalGradient >
{
};

template<>
struct Converter<QRadialGradient > : ValueTypeConverter<QRadialGradient >
{
};

template<>
struct Converter<QPrintEngine::PrintEnginePropertyKey > : EnumConverter<QPrintEngine::PrintEnginePropertyKey >
{
};

template<>
struct Converter<QPrintEngine* > : ObjectTypeConverter<QPrintEngine >
{
};

template<>
struct Converter<QPrintEngine& > : ObjectTypeReferenceConverter<QPrintEngine >
{
};

template<>
struct Converter<QGraphicsPathItem* > : ObjectTypeConverter<QGraphicsPathItem >
{
};

template<>
struct Converter<QGraphicsPathItem& > : ObjectTypeReferenceConverter<QGraphicsPathItem >
{
};

template<>
struct Converter<QDragMoveEvent* > : ObjectTypeConverter<QDragMoveEvent >
{
};

template<>
struct Converter<QDragMoveEvent& > : ObjectTypeReferenceConverter<QDragMoveEvent >
{
};

template<>
struct Converter<QDragEnterEvent* > : ObjectTypeConverter<QDragEnterEvent >
{
};

template<>
struct Converter<QDragEnterEvent& > : ObjectTypeReferenceConverter<QDragEnterEvent >
{
};

template<>
struct Converter<QHoverEvent* > : ObjectTypeConverter<QHoverEvent >
{
};

template<>
struct Converter<QHoverEvent& > : ObjectTypeReferenceConverter<QHoverEvent >
{
};

template<>
struct Converter<QDoubleValidator::Notation > : EnumConverter<QDoubleValidator::Notation >
{
};

template<>
struct Converter<QDoubleValidator* > : ObjectTypeConverter<QDoubleValidator >
{
};

template<>
struct Converter<QDoubleValidator& > : ObjectTypeReferenceConverter<QDoubleValidator >
{
};

template<>
struct Converter<QPaintEvent* > : ObjectTypeConverter<QPaintEvent >
{
};

template<>
struct Converter<QPaintEvent& > : ObjectTypeReferenceConverter<QPaintEvent >
{
};

template<>
struct Converter<QPalette::ColorGroup > : EnumConverter<QPalette::ColorGroup >
{
};

template<>
struct Converter<QPalette::ColorRole > : EnumConverter<QPalette::ColorRole >
{
};

template<>
struct Converter<QPalette > : ValueTypeConverter<QPalette >
{
    static QPalette toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyle::PixelMetric > : EnumConverter<QStyle::PixelMetric >
{
};

template<>
struct Converter<QStyle::SubControl > : EnumConverter<QStyle::SubControl >
{
};
template<>
struct Converter<QFlags<QStyle::SubControl> > : EnumConverter<QFlags<QStyle::SubControl> >
{
};

template<>
struct Converter<QStyle::StandardPixmap > : EnumConverter<QStyle::StandardPixmap >
{
};

template<>
struct Converter<QStyle::StyleHint > : EnumConverter<QStyle::StyleHint >
{
};

template<>
struct Converter<QStyle::PrimitiveElement > : EnumConverter<QStyle::PrimitiveElement >
{
};

template<>
struct Converter<QStyle::ControlElement > : EnumConverter<QStyle::ControlElement >
{
};

template<>
struct Converter<QStyle::ContentsType > : EnumConverter<QStyle::ContentsType >
{
};

template<>
struct Converter<QStyle::StateFlag > : EnumConverter<QStyle::StateFlag >
{
};
template<>
struct Converter<QFlags<QStyle::StateFlag> > : EnumConverter<QFlags<QStyle::StateFlag> >
{
};

template<>
struct Converter<QStyle::ComplexControl > : EnumConverter<QStyle::ComplexControl >
{
};

template<>
struct Converter<QStyle::RequestSoftwareInputPanel > : EnumConverter<QStyle::RequestSoftwareInputPanel >
{
};

template<>
struct Converter<QStyle::SubElement > : EnumConverter<QStyle::SubElement >
{
};

template<>
struct Converter<QStyle* > : ObjectTypeConverter<QStyle >
{
};

template<>
struct Converter<QStyle& > : ObjectTypeReferenceConverter<QStyle >
{
};

template<>
struct Converter<QCommonStyle* > : ObjectTypeConverter<QCommonStyle >
{
};

template<>
struct Converter<QCommonStyle& > : ObjectTypeReferenceConverter<QCommonStyle >
{
};

template<>
struct Converter<QMotifStyle* > : ObjectTypeConverter<QMotifStyle >
{
};

template<>
struct Converter<QMotifStyle& > : ObjectTypeReferenceConverter<QMotifStyle >
{
};

template<>
struct Converter<QWindowsStyle* > : ObjectTypeConverter<QWindowsStyle >
{
};

template<>
struct Converter<QWindowsStyle& > : ObjectTypeReferenceConverter<QWindowsStyle >
{
};

template<>
struct Converter<QCDEStyle* > : ObjectTypeConverter<QCDEStyle >
{
};

template<>
struct Converter<QCDEStyle& > : ObjectTypeReferenceConverter<QCDEStyle >
{
};

template<>
struct Converter<QPlastiqueStyle* > : ObjectTypeConverter<QPlastiqueStyle >
{
};

template<>
struct Converter<QPlastiqueStyle& > : ObjectTypeReferenceConverter<QPlastiqueStyle >
{
};

template<>
struct Converter<QGraphicsTransform* > : ObjectTypeConverter<QGraphicsTransform >
{
};

template<>
struct Converter<QGraphicsTransform& > : ObjectTypeReferenceConverter<QGraphicsTransform >
{
};

template<>
struct Converter<QGraphicsRotation* > : ObjectTypeConverter<QGraphicsRotation >
{
};

template<>
struct Converter<QGraphicsRotation& > : ObjectTypeReferenceConverter<QGraphicsRotation >
{
};

template<>
struct Converter<QGraphicsScale* > : ObjectTypeConverter<QGraphicsScale >
{
};

template<>
struct Converter<QGraphicsScale& > : ObjectTypeReferenceConverter<QGraphicsScale >
{
};

template<>
struct Converter<QStyleOptionGraphicsItem::StyleOptionVersion > : EnumConverter<QStyleOptionGraphicsItem::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionGraphicsItem::StyleOptionType > : EnumConverter<QStyleOptionGraphicsItem::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionGraphicsItem > : ValueTypeConverter<QStyleOptionGraphicsItem >
{
};

template<>
struct Converter<QVector3D > : ValueTypeConverter<QVector3D >
{
    static QVector3D toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionMenuItem::StyleOptionVersion > : EnumConverter<QStyleOptionMenuItem::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionMenuItem::StyleOptionType > : EnumConverter<QStyleOptionMenuItem::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionMenuItem::CheckType > : EnumConverter<QStyleOptionMenuItem::CheckType >
{
};

template<>
struct Converter<QStyleOptionMenuItem::MenuItemType > : EnumConverter<QStyleOptionMenuItem::MenuItemType >
{
};

template<>
struct Converter<QStyleOptionMenuItem > : ValueTypeConverter<QStyleOptionMenuItem >
{
};

template<>
struct Converter<QVector2D > : ValueTypeConverter<QVector2D >
{
};

template<>
struct Converter<QPanGesture* > : ObjectTypeConverter<QPanGesture >
{
};

template<>
struct Converter<QPanGesture& > : ObjectTypeReferenceConverter<QPanGesture >
{
};

template<>
struct Converter<QWidget::RenderFlag > : EnumConverter<QWidget::RenderFlag >
{
};
template<>
struct Converter<QFlags<QWidget::RenderFlag> > : EnumConverter<QFlags<QWidget::RenderFlag> >
{
};

template<>
struct Converter<QWidget* > : ObjectTypeConverter<QWidget >
{
};

template<>
struct Converter<QWidget& > : ObjectTypeReferenceConverter<QWidget >
{
};

template<>
struct Converter<QSizeGrip* > : ObjectTypeConverter<QSizeGrip >
{
};

template<>
struct Converter<QSizeGrip& > : ObjectTypeReferenceConverter<QSizeGrip >
{
};

template<>
struct Converter<QWizardPage* > : ObjectTypeConverter<QWizardPage >
{
};

template<>
struct Converter<QWizardPage& > : ObjectTypeReferenceConverter<QWizardPage >
{
};

template<>
struct Converter<QTabBar::SelectionBehavior > : EnumConverter<QTabBar::SelectionBehavior >
{
};

template<>
struct Converter<QTabBar::ButtonPosition > : EnumConverter<QTabBar::ButtonPosition >
{
};

template<>
struct Converter<QTabBar::Shape > : EnumConverter<QTabBar::Shape >
{
};

template<>
struct Converter<QTabBar* > : ObjectTypeConverter<QTabBar >
{
};

template<>
struct Converter<QTabBar& > : ObjectTypeReferenceConverter<QTabBar >
{
};

template<>
struct Converter<QTabWidget::TabShape > : EnumConverter<QTabWidget::TabShape >
{
};

template<>
struct Converter<QTabWidget::TabPosition > : EnumConverter<QTabWidget::TabPosition >
{
};

template<>
struct Converter<QTabWidget* > : ObjectTypeConverter<QTabWidget >
{
};

template<>
struct Converter<QTabWidget& > : ObjectTypeReferenceConverter<QTabWidget >
{
};

template<>
struct Converter<QFocusFrame* > : ObjectTypeConverter<QFocusFrame >
{
};

template<>
struct Converter<QFocusFrame& > : ObjectTypeReferenceConverter<QFocusFrame >
{
};

template<>
struct Converter<QMainWindow::DockOption > : EnumConverter<QMainWindow::DockOption >
{
};
template<>
struct Converter<QFlags<QMainWindow::DockOption> > : EnumConverter<QFlags<QMainWindow::DockOption> >
{
};

template<>
struct Converter<QMainWindow* > : ObjectTypeConverter<QMainWindow >
{
};

template<>
struct Converter<QMainWindow& > : ObjectTypeReferenceConverter<QMainWindow >
{
};

template<>
struct Converter<QMenu* > : ObjectTypeConverter<QMenu >
{
};

template<>
struct Converter<QMenu& > : ObjectTypeReferenceConverter<QMenu >
{
};

template<>
struct Converter<QAbstractSlider::SliderAction > : EnumConverter<QAbstractSlider::SliderAction >
{
};

template<>
struct Converter<QAbstractSlider::SliderChange > : EnumConverter<QAbstractSlider::SliderChange >
{
};

template<>
struct Converter<QAbstractSlider* > : ObjectTypeConverter<QAbstractSlider >
{
};

template<>
struct Converter<QAbstractSlider& > : ObjectTypeReferenceConverter<QAbstractSlider >
{
};

template<>
struct Converter<QDial* > : ObjectTypeConverter<QDial >
{
};

template<>
struct Converter<QDial& > : ObjectTypeReferenceConverter<QDial >
{
};

template<>
struct Converter<QDialogButtonBox::ButtonLayout > : EnumConverter<QDialogButtonBox::ButtonLayout >
{
};

template<>
struct Converter<QDialogButtonBox::ButtonRole > : EnumConverter<QDialogButtonBox::ButtonRole >
{
};

template<>
struct Converter<QDialogButtonBox::StandardButton > : EnumConverter<QDialogButtonBox::StandardButton >
{
};
template<>
struct Converter<QFlags<QDialogButtonBox::StandardButton> > : EnumConverter<QFlags<QDialogButtonBox::StandardButton> >
{
};

template<>
struct Converter<QDialogButtonBox* > : ObjectTypeConverter<QDialogButtonBox >
{
};

template<>
struct Converter<QDialogButtonBox& > : ObjectTypeReferenceConverter<QDialogButtonBox >
{
};

template<>
struct Converter<QRubberBand::Shape > : EnumConverter<QRubberBand::Shape >
{
};

template<>
struct Converter<QRubberBand* > : ObjectTypeConverter<QRubberBand >
{
};

template<>
struct Converter<QRubberBand& > : ObjectTypeReferenceConverter<QRubberBand >
{
};

template<>
struct Converter<QFrame::StyleMask > : EnumConverter<QFrame::StyleMask >
{
};

template<>
struct Converter<QFrame::Shape > : EnumConverter<QFrame::Shape >
{
};

template<>
struct Converter<QFrame::Shadow > : EnumConverter<QFrame::Shadow >
{
};

template<>
struct Converter<QFrame* > : ObjectTypeConverter<QFrame >
{
};

template<>
struct Converter<QFrame& > : ObjectTypeReferenceConverter<QFrame >
{
};

template<>
struct Converter<QSplitter* > : ObjectTypeConverter<QSplitter >
{
};

template<>
struct Converter<QSplitter& > : ObjectTypeReferenceConverter<QSplitter >
{
};

template<>
struct Converter<QLCDNumber::Mode > : EnumConverter<QLCDNumber::Mode >
{
};

template<>
struct Converter<QLCDNumber::SegmentStyle > : EnumConverter<QLCDNumber::SegmentStyle >
{
};

template<>
struct Converter<QLCDNumber* > : ObjectTypeConverter<QLCDNumber >
{
};

template<>
struct Converter<QLCDNumber& > : ObjectTypeReferenceConverter<QLCDNumber >
{
};

template<>
struct Converter<QAbstractScrollArea* > : ObjectTypeConverter<QAbstractScrollArea >
{
};

template<>
struct Converter<QAbstractScrollArea& > : ObjectTypeReferenceConverter<QAbstractScrollArea >
{
};

template<>
struct Converter<QDockWidget::DockWidgetFeature > : EnumConverter<QDockWidget::DockWidgetFeature >
{
};
template<>
struct Converter<QFlags<QDockWidget::DockWidgetFeature> > : EnumConverter<QFlags<QDockWidget::DockWidgetFeature> >
{
};

template<>
struct Converter<QDockWidget* > : ObjectTypeConverter<QDockWidget >
{
};

template<>
struct Converter<QDockWidget& > : ObjectTypeReferenceConverter<QDockWidget >
{
};

template<>
struct Converter<QAbstractButton* > : ObjectTypeConverter<QAbstractButton >
{
};

template<>
struct Converter<QAbstractButton& > : ObjectTypeReferenceConverter<QAbstractButton >
{
};

template<>
struct Converter<QCheckBox* > : ObjectTypeConverter<QCheckBox >
{
};

template<>
struct Converter<QCheckBox& > : ObjectTypeReferenceConverter<QCheckBox >
{
};

template<>
struct Converter<QScrollArea* > : ObjectTypeConverter<QScrollArea >
{
};

template<>
struct Converter<QScrollArea& > : ObjectTypeReferenceConverter<QScrollArea >
{
};

template<>
struct Converter<QCalendarWidget::HorizontalHeaderFormat > : EnumConverter<QCalendarWidget::HorizontalHeaderFormat >
{
};

template<>
struct Converter<QCalendarWidget::VerticalHeaderFormat > : EnumConverter<QCalendarWidget::VerticalHeaderFormat >
{
};

template<>
struct Converter<QCalendarWidget::SelectionMode > : EnumConverter<QCalendarWidget::SelectionMode >
{
};

template<>
struct Converter<QCalendarWidget* > : ObjectTypeConverter<QCalendarWidget >
{
};

template<>
struct Converter<QCalendarWidget& > : ObjectTypeReferenceConverter<QCalendarWidget >
{
};

template<>
struct Converter<QAbstractSpinBox::StepEnabledFlag > : EnumConverter<QAbstractSpinBox::StepEnabledFlag >
{
};
template<>
struct Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> > : EnumConverter<QFlags<QAbstractSpinBox::StepEnabledFlag> >
{
};

template<>
struct Converter<QAbstractSpinBox::CorrectionMode > : EnumConverter<QAbstractSpinBox::CorrectionMode >
{
};

template<>
struct Converter<QAbstractSpinBox::ButtonSymbols > : EnumConverter<QAbstractSpinBox::ButtonSymbols >
{
};

template<>
struct Converter<QAbstractSpinBox* > : ObjectTypeConverter<QAbstractSpinBox >
{
};

template<>
struct Converter<QAbstractSpinBox& > : ObjectTypeReferenceConverter<QAbstractSpinBox >
{
};

template<>
struct Converter<QMdiArea::WindowOrder > : EnumConverter<QMdiArea::WindowOrder >
{
};

template<>
struct Converter<QMdiArea::ViewMode > : EnumConverter<QMdiArea::ViewMode >
{
};

template<>
struct Converter<QMdiArea::AreaOption > : EnumConverter<QMdiArea::AreaOption >
{
};
template<>
struct Converter<QFlags<QMdiArea::AreaOption> > : EnumConverter<QFlags<QMdiArea::AreaOption> >
{
};

template<>
struct Converter<QMdiArea* > : ObjectTypeConverter<QMdiArea >
{
};

template<>
struct Converter<QMdiArea& > : ObjectTypeReferenceConverter<QMdiArea >
{
};

template<>
struct Converter<QStackedWidget* > : ObjectTypeConverter<QStackedWidget >
{
};

template<>
struct Converter<QStackedWidget& > : ObjectTypeReferenceConverter<QStackedWidget >
{
};

template<>
struct Converter<QMdiSubWindow::SubWindowOption > : EnumConverter<QMdiSubWindow::SubWindowOption >
{
};
template<>
struct Converter<QFlags<QMdiSubWindow::SubWindowOption> > : EnumConverter<QFlags<QMdiSubWindow::SubWindowOption> >
{
};

template<>
struct Converter<QMdiSubWindow* > : ObjectTypeConverter<QMdiSubWindow >
{
};

template<>
struct Converter<QMdiSubWindow& > : ObjectTypeReferenceConverter<QMdiSubWindow >
{
};

template<>
struct Converter<QLabel* > : ObjectTypeConverter<QLabel >
{
};

template<>
struct Converter<QLabel& > : ObjectTypeReferenceConverter<QLabel >
{
};

template<>
struct Converter<QScrollBar* > : ObjectTypeConverter<QScrollBar >
{
};

template<>
struct Converter<QScrollBar& > : ObjectTypeReferenceConverter<QScrollBar >
{
};

template<>
struct Converter<QPrintPreviewWidget::ZoomMode > : EnumConverter<QPrintPreviewWidget::ZoomMode >
{
};

template<>
struct Converter<QPrintPreviewWidget::ViewMode > : EnumConverter<QPrintPreviewWidget::ViewMode >
{
};

template<>
struct Converter<QPrintPreviewWidget* > : ObjectTypeConverter<QPrintPreviewWidget >
{
};

template<>
struct Converter<QPrintPreviewWidget& > : ObjectTypeReferenceConverter<QPrintPreviewWidget >
{
};

template<>
struct Converter<QSplashScreen* > : ObjectTypeConverter<QSplashScreen >
{
};

template<>
struct Converter<QSplashScreen& > : ObjectTypeReferenceConverter<QSplashScreen >
{
};

template<>
struct Converter<QWorkspace::WindowOrder > : EnumConverter<QWorkspace::WindowOrder >
{
};

template<>
struct Converter<QWorkspace* > : ObjectTypeConverter<QWorkspace >
{
};

template<>
struct Converter<QWorkspace& > : ObjectTypeReferenceConverter<QWorkspace >
{
};

template<>
struct Converter<QSlider::TickPosition > : EnumConverter<QSlider::TickPosition >
{
};

template<>
struct Converter<QSlider* > : ObjectTypeConverter<QSlider >
{
};

template<>
struct Converter<QSlider& > : ObjectTypeReferenceConverter<QSlider >
{
};

template<>
struct Converter<QDesktopWidget* > : ObjectTypeConverter<QDesktopWidget >
{
};

template<>
struct Converter<QDesktopWidget& > : ObjectTypeReferenceConverter<QDesktopWidget >
{
};

template<>
struct Converter<QPainter::CompositionMode > : EnumConverter<QPainter::CompositionMode >
{
};

template<>
struct Converter<QPainter::RenderHint > : EnumConverter<QPainter::RenderHint >
{
};
template<>
struct Converter<QFlags<QPainter::RenderHint> > : EnumConverter<QFlags<QPainter::RenderHint> >
{
};

template<>
struct Converter<QPainter* > : ObjectTypeConverter<QPainter >
{
};

template<>
struct Converter<QPainter& > : ObjectTypeReferenceConverter<QPainter >
{
};

template<>
struct Converter<QStylePainter* > : ObjectTypeConverter<QStylePainter >
{
};

template<>
struct Converter<QStylePainter& > : ObjectTypeReferenceConverter<QStylePainter >
{
};

template<>
struct Converter<QGroupBox* > : ObjectTypeConverter<QGroupBox >
{
};

template<>
struct Converter<QGroupBox& > : ObjectTypeReferenceConverter<QGroupBox >
{
};

template<>
struct Converter<QStatusBar* > : ObjectTypeConverter<QStatusBar >
{
};

template<>
struct Converter<QStatusBar& > : ObjectTypeReferenceConverter<QStatusBar >
{
};

template<>
struct Converter<QSplitterHandle* > : ObjectTypeConverter<QSplitterHandle >
{
};

template<>
struct Converter<QSplitterHandle& > : ObjectTypeReferenceConverter<QSplitterHandle >
{
};

template<>
struct Converter<QToolBar* > : ObjectTypeConverter<QToolBar >
{
};

template<>
struct Converter<QToolBar& > : ObjectTypeReferenceConverter<QToolBar >
{
};

template<>
struct Converter<QLineEdit::EchoMode > : EnumConverter<QLineEdit::EchoMode >
{
};

template<>
struct Converter<QLineEdit* > : ObjectTypeConverter<QLineEdit >
{
};

template<>
struct Converter<QLineEdit& > : ObjectTypeReferenceConverter<QLineEdit >
{
};

template<>
struct Converter<QStyleOptionComplex::StyleOptionVersion > : EnumConverter<QStyleOptionComplex::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionComplex::StyleOptionType > : EnumConverter<QStyleOptionComplex::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionComplex > : ValueTypeConverter<QStyleOptionComplex >
{
};

template<>
struct Converter<QStyleOptionGroupBox::StyleOptionVersion > : EnumConverter<QStyleOptionGroupBox::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionGroupBox::StyleOptionType > : EnumConverter<QStyleOptionGroupBox::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionGroupBox > : ValueTypeConverter<QStyleOptionGroupBox >
{
};

template<>
struct Converter<QStyleOptionTitleBar::StyleOptionVersion > : EnumConverter<QStyleOptionTitleBar::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionTitleBar::StyleOptionType > : EnumConverter<QStyleOptionTitleBar::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionTitleBar > : ValueTypeConverter<QStyleOptionTitleBar >
{
};

template<>
struct Converter<QStyleOptionSlider::StyleOptionVersion > : EnumConverter<QStyleOptionSlider::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionSlider::StyleOptionType > : EnumConverter<QStyleOptionSlider::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionSlider > : ValueTypeConverter<QStyleOptionSlider >
{
};

template<>
struct Converter<QStyleOptionSizeGrip::StyleOptionVersion > : EnumConverter<QStyleOptionSizeGrip::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionSizeGrip::StyleOptionType > : EnumConverter<QStyleOptionSizeGrip::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionSizeGrip > : ValueTypeConverter<QStyleOptionSizeGrip >
{
};

template<>
struct Converter<QStyleOptionSpinBox::StyleOptionVersion > : EnumConverter<QStyleOptionSpinBox::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionSpinBox::StyleOptionType > : EnumConverter<QStyleOptionSpinBox::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionSpinBox > : ValueTypeConverter<QStyleOptionSpinBox >
{
};

template<>
struct Converter<QStyleOptionToolButton::StyleOptionVersion > : EnumConverter<QStyleOptionToolButton::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionToolButton::ToolButtonFeature > : EnumConverter<QStyleOptionToolButton::ToolButtonFeature >
{
};
template<>
struct Converter<QFlags<QStyleOptionToolButton::ToolButtonFeature> > : EnumConverter<QFlags<QStyleOptionToolButton::ToolButtonFeature> >
{
};

template<>
struct Converter<QStyleOptionToolButton::StyleOptionType > : EnumConverter<QStyleOptionToolButton::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionToolButton > : ValueTypeConverter<QStyleOptionToolButton >
{
};

template<>
struct Converter<QStyleOptionComboBox::StyleOptionVersion > : EnumConverter<QStyleOptionComboBox::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionComboBox::StyleOptionType > : EnumConverter<QStyleOptionComboBox::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionComboBox > : ValueTypeConverter<QStyleOptionComboBox >
{
};

template<>
struct Converter<QStyleOptionFocusRect::StyleOptionVersion > : EnumConverter<QStyleOptionFocusRect::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionFocusRect::StyleOptionType > : EnumConverter<QStyleOptionFocusRect::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionFocusRect > : ValueTypeConverter<QStyleOptionFocusRect >
{
};

template<>
struct Converter<QStyleOptionToolBoxV2::StyleOptionVersion > : EnumConverter<QStyleOptionToolBoxV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionToolBoxV2::TabPosition > : EnumConverter<QStyleOptionToolBoxV2::TabPosition >
{
};

template<>
struct Converter<QStyleOptionToolBoxV2::SelectedPosition > : EnumConverter<QStyleOptionToolBoxV2::SelectedPosition >
{
};

template<>
struct Converter<QStyleOptionToolBoxV2 > : ValueTypeConverter<QStyleOptionToolBoxV2 >
{
    static QStyleOptionToolBoxV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGraphicsSceneEvent* > : ObjectTypeConverter<QGraphicsSceneEvent >
{
};

template<>
struct Converter<QGraphicsSceneEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneEvent >
{
};

template<>
struct Converter<QGraphicsSceneResizeEvent* > : ObjectTypeConverter<QGraphicsSceneResizeEvent >
{
};

template<>
struct Converter<QGraphicsSceneResizeEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneResizeEvent >
{
};

template<>
struct Converter<QGraphicsSceneWheelEvent* > : ObjectTypeConverter<QGraphicsSceneWheelEvent >
{
};

template<>
struct Converter<QGraphicsSceneWheelEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneWheelEvent >
{
};

template<>
struct Converter<QGraphicsSceneDragDropEvent* > : ObjectTypeConverter<QGraphicsSceneDragDropEvent >
{
};

template<>
struct Converter<QGraphicsSceneDragDropEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneDragDropEvent >
{
};

template<>
struct Converter<QGraphicsSceneHelpEvent* > : ObjectTypeConverter<QGraphicsSceneHelpEvent >
{
};

template<>
struct Converter<QGraphicsSceneHelpEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneHelpEvent >
{
};

template<>
struct Converter<QGraphicsSceneMouseEvent* > : ObjectTypeConverter<QGraphicsSceneMouseEvent >
{
};

template<>
struct Converter<QGraphicsSceneMouseEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneMouseEvent >
{
};

template<>
struct Converter<QGraphicsSceneHoverEvent* > : ObjectTypeConverter<QGraphicsSceneHoverEvent >
{
};

template<>
struct Converter<QGraphicsSceneHoverEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneHoverEvent >
{
};

template<>
struct Converter<QGraphicsSceneMoveEvent* > : ObjectTypeConverter<QGraphicsSceneMoveEvent >
{
};

template<>
struct Converter<QGraphicsSceneMoveEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneMoveEvent >
{
};

template<>
struct Converter<QGraphicsSceneContextMenuEvent::Reason > : EnumConverter<QGraphicsSceneContextMenuEvent::Reason >
{
};

template<>
struct Converter<QGraphicsSceneContextMenuEvent* > : ObjectTypeConverter<QGraphicsSceneContextMenuEvent >
{
};

template<>
struct Converter<QGraphicsSceneContextMenuEvent& > : ObjectTypeReferenceConverter<QGraphicsSceneContextMenuEvent >
{
};

template<>
struct Converter<QInputMethodEvent::AttributeType > : EnumConverter<QInputMethodEvent::AttributeType >
{
};

template<>
struct Converter<QInputMethodEvent* > : ObjectTypeConverter<QInputMethodEvent >
{
};

template<>
struct Converter<QInputMethodEvent& > : ObjectTypeReferenceConverter<QInputMethodEvent >
{
};

template<>
struct Converter<QInputMethodEvent::Attribute > : ValueTypeConverter<QInputMethodEvent::Attribute >
{
};

template<>
struct Converter<QSpinBox* > : ObjectTypeConverter<QSpinBox >
{
};

template<>
struct Converter<QSpinBox& > : ObjectTypeReferenceConverter<QSpinBox >
{
};

template<>
struct Converter<QInputContext::StandardFormat > : EnumConverter<QInputContext::StandardFormat >
{
};

template<>
struct Converter<QInputContext* > : ObjectTypeConverter<QInputContext >
{
};

template<>
struct Converter<QInputContext& > : ObjectTypeReferenceConverter<QInputContext >
{
};

template<>
struct Converter<QDesktopServices::StandardLocation > : EnumConverter<QDesktopServices::StandardLocation >
{
};

template<>
struct Converter<QDesktopServices* > : ObjectTypeConverter<QDesktopServices >
{
};

template<>
struct Converter<QDesktopServices& > : ObjectTypeReferenceConverter<QDesktopServices >
{
};

template<>
struct Converter<QSessionManager::RestartHint > : EnumConverter<QSessionManager::RestartHint >
{
};

template<>
struct Converter<QSessionManager* > : ObjectTypeConverter<QSessionManager >
{
};

template<>
struct Converter<QSessionManager& > : ObjectTypeReferenceConverter<QSessionManager >
{
};

template<>
struct Converter<QFocusEvent* > : ObjectTypeConverter<QFocusEvent >
{
};

template<>
struct Converter<QFocusEvent& > : ObjectTypeReferenceConverter<QFocusEvent >
{
};

template<>
struct Converter<QGraphicsObject* > : ObjectTypeConverter<QGraphicsObject >
{
};

template<>
struct Converter<QGraphicsObject& > : ObjectTypeReferenceConverter<QGraphicsObject >
{
};

template<>
struct Converter<QGraphicsTextItem* > : ObjectTypeConverter<QGraphicsTextItem >
{
};

template<>
struct Converter<QGraphicsTextItem& > : ObjectTypeReferenceConverter<QGraphicsTextItem >
{
};

template<>
struct Converter<QPlainTextDocumentLayout* > : ObjectTypeConverter<QPlainTextDocumentLayout >
{
};

template<>
struct Converter<QPlainTextDocumentLayout& > : ObjectTypeReferenceConverter<QPlainTextDocumentLayout >
{
};

template<>
struct Converter<QTextBlockGroup* > : ObjectTypeConverter<QTextBlockGroup >
{
};

template<>
struct Converter<QTextBlockGroup& > : ObjectTypeReferenceConverter<QTextBlockGroup >
{
};

template<>
struct Converter<QTextList* > : ObjectTypeConverter<QTextList >
{
};

template<>
struct Converter<QTextList& > : ObjectTypeReferenceConverter<QTextList >
{
};

template<>
struct Converter<QItemSelectionRange > : ValueTypeConverter<QItemSelectionRange >
{
};

template<>
struct Converter<QFontMetrics > : ValueTypeConverter<QFontMetrics >
{
    static QFontMetrics toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QIntValidator* > : ObjectTypeConverter<QIntValidator >
{
};

template<>
struct Converter<QIntValidator& > : ObjectTypeReferenceConverter<QIntValidator >
{
};

template<>
struct Converter<QItemEditorCreatorBase* > : ObjectTypeConverter<QItemEditorCreatorBase >
{
};

template<>
struct Converter<QItemEditorCreatorBase& > : ObjectTypeReferenceConverter<QItemEditorCreatorBase >
{
};

template<>
struct Converter<QContextMenuEvent::Reason > : EnumConverter<QContextMenuEvent::Reason >
{
};

template<>
struct Converter<QContextMenuEvent* > : ObjectTypeConverter<QContextMenuEvent >
{
};

template<>
struct Converter<QContextMenuEvent& > : ObjectTypeReferenceConverter<QContextMenuEvent >
{
};

template<>
struct Converter<QDoubleSpinBox* > : ObjectTypeConverter<QDoubleSpinBox >
{
};

template<>
struct Converter<QDoubleSpinBox& > : ObjectTypeReferenceConverter<QDoubleSpinBox >
{
};

template<>
struct Converter<QRadioButton* > : ObjectTypeConverter<QRadioButton >
{
};

template<>
struct Converter<QRadioButton& > : ObjectTypeReferenceConverter<QRadioButton >
{
};

template<>
struct Converter<QWheelEvent* > : ObjectTypeConverter<QWheelEvent >
{
};

template<>
struct Converter<QWheelEvent& > : ObjectTypeReferenceConverter<QWheelEvent >
{
};

template<>
struct Converter<QAbstractItemView::DragDropMode > : EnumConverter<QAbstractItemView::DragDropMode >
{
};

template<>
struct Converter<QAbstractItemView::SelectionBehavior > : EnumConverter<QAbstractItemView::SelectionBehavior >
{
};

template<>
struct Converter<QAbstractItemView::EditTrigger > : EnumConverter<QAbstractItemView::EditTrigger >
{
};
template<>
struct Converter<QFlags<QAbstractItemView::EditTrigger> > : EnumConverter<QFlags<QAbstractItemView::EditTrigger> >
{
};

template<>
struct Converter<QAbstractItemView::ScrollMode > : EnumConverter<QAbstractItemView::ScrollMode >
{
};

template<>
struct Converter<QAbstractItemView::CursorAction > : EnumConverter<QAbstractItemView::CursorAction >
{
};

template<>
struct Converter<QAbstractItemView::DropIndicatorPosition > : EnumConverter<QAbstractItemView::DropIndicatorPosition >
{
};

template<>
struct Converter<QAbstractItemView::ScrollHint > : EnumConverter<QAbstractItemView::ScrollHint >
{
};

template<>
struct Converter<QAbstractItemView::SelectionMode > : EnumConverter<QAbstractItemView::SelectionMode >
{
};

template<>
struct Converter<QAbstractItemView::State > : EnumConverter<QAbstractItemView::State >
{
};

template<>
struct Converter<QAbstractItemView* > : ObjectTypeConverter<QAbstractItemView >
{
};

template<>
struct Converter<QAbstractItemView& > : ObjectTypeReferenceConverter<QAbstractItemView >
{
};

template<>
struct Converter<QTableView* > : ObjectTypeConverter<QTableView >
{
};

template<>
struct Converter<QTableView& > : ObjectTypeReferenceConverter<QTableView >
{
};

template<>
struct Converter<QTreeView* > : ObjectTypeConverter<QTreeView >
{
};

template<>
struct Converter<QTreeView& > : ObjectTypeReferenceConverter<QTreeView >
{
};

template<>
struct Converter<QColumnView* > : ObjectTypeConverter<QColumnView >
{
};

template<>
struct Converter<QColumnView& > : ObjectTypeReferenceConverter<QColumnView >
{
};

template<>
struct Converter<QListView::ResizeMode > : EnumConverter<QListView::ResizeMode >
{
};

template<>
struct Converter<QListView::LayoutMode > : EnumConverter<QListView::LayoutMode >
{
};

template<>
struct Converter<QListView::ViewMode > : EnumConverter<QListView::ViewMode >
{
};

template<>
struct Converter<QListView::Flow > : EnumConverter<QListView::Flow >
{
};

template<>
struct Converter<QListView::Movement > : EnumConverter<QListView::Movement >
{
};

template<>
struct Converter<QListView* > : ObjectTypeConverter<QListView >
{
};

template<>
struct Converter<QListView& > : ObjectTypeReferenceConverter<QListView >
{
};

template<>
struct Converter<QListWidget* > : ObjectTypeConverter<QListWidget >
{
};

template<>
struct Converter<QListWidget& > : ObjectTypeReferenceConverter<QListWidget >
{
};

template<>
struct Converter<QUndoView* > : ObjectTypeConverter<QUndoView >
{
};

template<>
struct Converter<QUndoView& > : ObjectTypeReferenceConverter<QUndoView >
{
};

template<>
struct Converter<QHeaderView::ResizeMode > : EnumConverter<QHeaderView::ResizeMode >
{
};

template<>
struct Converter<QHeaderView* > : ObjectTypeConverter<QHeaderView >
{
};

template<>
struct Converter<QHeaderView& > : ObjectTypeReferenceConverter<QHeaderView >
{
};

template<>
struct Converter<QVector4D > : ValueTypeConverter<QVector4D >
{
    static QVector4D toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QToolBarChangeEvent* > : ObjectTypeConverter<QToolBarChangeEvent >
{
};

template<>
struct Converter<QToolBarChangeEvent& > : ObjectTypeReferenceConverter<QToolBarChangeEvent >
{
};

template<>
struct Converter<QCursor > : ValueTypeConverter<QCursor >
{
    static QCursor toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QPushButton* > : ObjectTypeConverter<QPushButton >
{
};

template<>
struct Converter<QPushButton& > : ObjectTypeReferenceConverter<QPushButton >
{
};

template<>
struct Converter<QCommandLinkButton* > : ObjectTypeConverter<QCommandLinkButton >
{
};

template<>
struct Converter<QCommandLinkButton& > : ObjectTypeReferenceConverter<QCommandLinkButton >
{
};

template<>
struct Converter<QTextItem::RenderFlag > : EnumConverter<QTextItem::RenderFlag >
{
};
template<>
struct Converter<QFlags<QTextItem::RenderFlag> > : EnumConverter<QFlags<QTextItem::RenderFlag> >
{
};

template<>
struct Converter<QTextItem* > : ObjectTypeConverter<QTextItem >
{
};

template<>
struct Converter<QTextItem& > : ObjectTypeReferenceConverter<QTextItem >
{
};

template<>
struct Converter<QGraphicsLineItem* > : ObjectTypeConverter<QGraphicsLineItem >
{
};

template<>
struct Converter<QGraphicsLineItem& > : ObjectTypeReferenceConverter<QGraphicsLineItem >
{
};

template<>
struct Converter<QDirModel::Roles > : EnumConverter<QDirModel::Roles >
{
};

template<>
struct Converter<QDirModel* > : ObjectTypeConverter<QDirModel >
{
};

template<>
struct Converter<QDirModel& > : ObjectTypeReferenceConverter<QDirModel >
{
};

template<>
struct Converter<QTreeWidget* > : ObjectTypeConverter<QTreeWidget >
{
};

template<>
struct Converter<QTreeWidget& > : ObjectTypeReferenceConverter<QTreeWidget >
{
};

template<>
struct Converter<QTransform::TransformationType > : EnumConverter<QTransform::TransformationType >
{
};

template<>
struct Converter<QTransform > : ValueTypeConverter<QTransform >
{
};

template<>
struct Converter<QIconEngineV2::IconEngineHook > : EnumConverter<QIconEngineV2::IconEngineHook >
{
};

template<>
struct Converter<QIconEngineV2* > : ObjectTypeConverter<QIconEngineV2 >
{
};

template<>
struct Converter<QIconEngineV2& > : ObjectTypeReferenceConverter<QIconEngineV2 >
{
};

template<>
struct Converter<QLinearGradient > : ValueTypeConverter<QLinearGradient >
{
};

template<>
struct Converter<QCleanlooksStyle* > : ObjectTypeConverter<QCleanlooksStyle >
{
};

template<>
struct Converter<QCleanlooksStyle& > : ObjectTypeReferenceConverter<QCleanlooksStyle >
{
};

template<>
struct Converter<QFont::StyleStrategy > : EnumConverter<QFont::StyleStrategy >
{
};

template<>
struct Converter<QFont::SpacingType > : EnumConverter<QFont::SpacingType >
{
};

template<>
struct Converter<QFont::StyleHint > : EnumConverter<QFont::StyleHint >
{
};

template<>
struct Converter<QFont::Weight > : EnumConverter<QFont::Weight >
{
};

template<>
struct Converter<QFont::Capitalization > : EnumConverter<QFont::Capitalization >
{
};

template<>
struct Converter<QFont::Stretch > : EnumConverter<QFont::Stretch >
{
};

template<>
struct Converter<QFont::Style > : EnumConverter<QFont::Style >
{
};

template<>
struct Converter<QFont > : ValueTypeConverter<QFont >
{
    static QFont toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QGraphicsScene::SceneLayer > : EnumConverter<QGraphicsScene::SceneLayer >
{
};
template<>
struct Converter<QFlags<QGraphicsScene::SceneLayer> > : EnumConverter<QFlags<QGraphicsScene::SceneLayer> >
{
};

template<>
struct Converter<QGraphicsScene::ItemIndexMethod > : EnumConverter<QGraphicsScene::ItemIndexMethod >
{
};

template<>
struct Converter<QGraphicsScene* > : ObjectTypeConverter<QGraphicsScene >
{
};

template<>
struct Converter<QGraphicsScene& > : ObjectTypeReferenceConverter<QGraphicsScene >
{
};

template<>
struct Converter<QGraphicsView::OptimizationFlag > : EnumConverter<QGraphicsView::OptimizationFlag >
{
};
template<>
struct Converter<QFlags<QGraphicsView::OptimizationFlag> > : EnumConverter<QFlags<QGraphicsView::OptimizationFlag> >
{
};

template<>
struct Converter<QGraphicsView::ViewportAnchor > : EnumConverter<QGraphicsView::ViewportAnchor >
{
};

template<>
struct Converter<QGraphicsView::ViewportUpdateMode > : EnumConverter<QGraphicsView::ViewportUpdateMode >
{
};

template<>
struct Converter<QGraphicsView::CacheModeFlag > : EnumConverter<QGraphicsView::CacheModeFlag >
{
};
template<>
struct Converter<QFlags<QGraphicsView::CacheModeFlag> > : EnumConverter<QFlags<QGraphicsView::CacheModeFlag> >
{
};

template<>
struct Converter<QGraphicsView::DragMode > : EnumConverter<QGraphicsView::DragMode >
{
};

template<>
struct Converter<QGraphicsView* > : ObjectTypeConverter<QGraphicsView >
{
};

template<>
struct Converter<QGraphicsView& > : ObjectTypeReferenceConverter<QGraphicsView >
{
};

template<>
struct Converter<QStyleOptionViewItem::StyleOptionVersion > : EnumConverter<QStyleOptionViewItem::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionViewItem::StyleOptionType > : EnumConverter<QStyleOptionViewItem::StyleOptionType >
{
};

template<>
struct Converter<QStyleOptionViewItem::Position > : EnumConverter<QStyleOptionViewItem::Position >
{
};

template<>
struct Converter<QStyleOptionViewItem > : ValueTypeConverter<QStyleOptionViewItem >
{
};

template<>
struct Converter<QStyleOptionViewItemV2::StyleOptionVersion > : EnumConverter<QStyleOptionViewItemV2::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionViewItemV2::ViewItemFeature > : EnumConverter<QStyleOptionViewItemV2::ViewItemFeature >
{
};
template<>
struct Converter<QFlags<QStyleOptionViewItemV2::ViewItemFeature> > : EnumConverter<QFlags<QStyleOptionViewItemV2::ViewItemFeature> >
{
};

template<>
struct Converter<QStyleOptionViewItemV2 > : ValueTypeConverter<QStyleOptionViewItemV2 >
{
    static QStyleOptionViewItemV2 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionViewItemV3::StyleOptionVersion > : EnumConverter<QStyleOptionViewItemV3::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionViewItemV3 > : ValueTypeConverter<QStyleOptionViewItemV3 >
{
    static QStyleOptionViewItemV3 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QStyleOptionViewItemV4::ViewItemPosition > : EnumConverter<QStyleOptionViewItemV4::ViewItemPosition >
{
};

template<>
struct Converter<QStyleOptionViewItemV4::StyleOptionVersion > : EnumConverter<QStyleOptionViewItemV4::StyleOptionVersion >
{
};

template<>
struct Converter<QStyleOptionViewItemV4 > : ValueTypeConverter<QStyleOptionViewItemV4 >
{
    static QStyleOptionViewItemV4 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QWhatsThisClickedEvent* > : ObjectTypeConverter<QWhatsThisClickedEvent >
{
};

template<>
struct Converter<QWhatsThisClickedEvent& > : ObjectTypeReferenceConverter<QWhatsThisClickedEvent >
{
};

template<>
struct Converter<QPrinter::OutputFormat > : EnumConverter<QPrinter::OutputFormat >
{
};

template<>
struct Converter<QPrinter::DuplexMode > : EnumConverter<QPrinter::DuplexMode >
{
};

template<>
struct Converter<QPrinter::PrintRange > : EnumConverter<QPrinter::PrintRange >
{
};

template<>
struct Converter<QPrinter::Unit > : EnumConverter<QPrinter::Unit >
{
};

template<>
struct Converter<QPrinter::PrinterMode > : EnumConverter<QPrinter::PrinterMode >
{
};

template<>
struct Converter<QPrinter::Orientation > : EnumConverter<QPrinter::Orientation >
{
};

template<>
struct Converter<QPrinter::PrinterState > : EnumConverter<QPrinter::PrinterState >
{
};

template<>
struct Converter<QPrinter::ColorMode > : EnumConverter<QPrinter::ColorMode >
{
};

template<>
struct Converter<QPrinter::PaperSource > : EnumConverter<QPrinter::PaperSource >
{
};

template<>
struct Converter<QPrinter::PageOrder > : EnumConverter<QPrinter::PageOrder >
{
};

template<>
struct Converter<QPrinter::PageSize > : EnumConverter<QPrinter::PageSize >
{
};

template<>
struct Converter<QPrinter* > : ObjectTypeConverter<QPrinter >
{
};

template<>
struct Converter<QPrinter& > : ObjectTypeReferenceConverter<QPrinter >
{
};

template<>
struct Converter<QGridLayout* > : ObjectTypeConverter<QGridLayout >
{
};

template<>
struct Converter<QGridLayout& > : ObjectTypeReferenceConverter<QGridLayout >
{
};

template<>
struct Converter<QSizePolicy::ControlType > : EnumConverter<QSizePolicy::ControlType >
{
};
template<>
struct Converter<QFlags<QSizePolicy::ControlType> > : EnumConverter<QFlags<QSizePolicy::ControlType> >
{
};

template<>
struct Converter<QSizePolicy::PolicyFlag > : EnumConverter<QSizePolicy::PolicyFlag >
{
};

template<>
struct Converter<QSizePolicy::Policy > : EnumConverter<QSizePolicy::Policy >
{
};

template<>
struct Converter<QSizePolicy > : ValueTypeConverter<QSizePolicy >
{
};

template<>
struct Converter<QSpacerItem* > : ObjectTypeConverter<QSpacerItem >
{
};

template<>
struct Converter<QSpacerItem& > : ObjectTypeReferenceConverter<QSpacerItem >
{
};

template<>
struct Converter<QProgressBar::Direction > : EnumConverter<QProgressBar::Direction >
{
};

template<>
struct Converter<QProgressBar* > : ObjectTypeConverter<QProgressBar >
{
};

template<>
struct Converter<QProgressBar& > : ObjectTypeReferenceConverter<QProgressBar >
{
};

template<>
struct Converter<QListWidgetItem::ItemType > : EnumConverter<QListWidgetItem::ItemType >
{
};

template<>
struct Converter<QListWidgetItem* > : ObjectTypeConverter<QListWidgetItem >
{
};

template<>
struct Converter<QListWidgetItem& > : ObjectTypeReferenceConverter<QListWidgetItem >
{
};

template<>
struct Converter<QQuaternion > : ValueTypeConverter<QQuaternion >
{
};

template<>
struct Converter<QMatrix4x4 > : ValueTypeConverter<QMatrix4x4 >
{
    static QMatrix4x4 toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QMatrix > : ValueTypeConverter<QMatrix >
{
};

template<>
struct Converter<QPainterPath::ElementType > : EnumConverter<QPainterPath::ElementType >
{
};

template<>
struct Converter<QPainterPath > : ValueTypeConverter<QPainterPath >
{
};

template<>
struct Converter<QPainterPath::Element > : ValueTypeConverter<QPainterPath::Element >
{
};

template<>
struct Converter<QWhatsThis* > : ObjectTypeConverter<QWhatsThis >
{
};

template<>
struct Converter<QWhatsThis& > : ObjectTypeReferenceConverter<QWhatsThis >
{
};

template<>
struct Converter<QComboBox::InsertPolicy > : EnumConverter<QComboBox::InsertPolicy >
{
};

template<>
struct Converter<QComboBox::SizeAdjustPolicy > : EnumConverter<QComboBox::SizeAdjustPolicy >
{
};

template<>
struct Converter<QComboBox* > : ObjectTypeConverter<QComboBox >
{
};

template<>
struct Converter<QComboBox& > : ObjectTypeReferenceConverter<QComboBox >
{
};

template<>
struct Converter<QFontComboBox::FontFilter > : EnumConverter<QFontComboBox::FontFilter >
{
};
template<>
struct Converter<QFlags<QFontComboBox::FontFilter> > : EnumConverter<QFlags<QFontComboBox::FontFilter> >
{
};

template<>
struct Converter<QFontComboBox* > : ObjectTypeConverter<QFontComboBox >
{
};

template<>
struct Converter<QFontComboBox& > : ObjectTypeReferenceConverter<QFontComboBox >
{
};

template<>
struct Converter<QToolButton::ToolButtonPopupMode > : EnumConverter<QToolButton::ToolButtonPopupMode >
{
};

template<>
struct Converter<QToolButton* > : ObjectTypeConverter<QToolButton >
{
};

template<>
struct Converter<QToolButton& > : ObjectTypeReferenceConverter<QToolButton >
{
};

template<>
struct Converter<QDialog::DialogCode > : EnumConverter<QDialog::DialogCode >
{
};

template<>
struct Converter<QDialog* > : ObjectTypeConverter<QDialog >
{
};

template<>
struct Converter<QDialog& > : ObjectTypeReferenceConverter<QDialog >
{
};

template<>
struct Converter<QProgressDialog* > : ObjectTypeConverter<QProgressDialog >
{
};

template<>
struct Converter<QProgressDialog& > : ObjectTypeReferenceConverter<QProgressDialog >
{
};

template<>
struct Converter<QWizard::WizardButton > : EnumConverter<QWizard::WizardButton >
{
};

template<>
struct Converter<QWizard::WizardStyle > : EnumConverter<QWizard::WizardStyle >
{
};

template<>
struct Converter<QWizard::WizardPixmap > : EnumConverter<QWizard::WizardPixmap >
{
};

template<>
struct Converter<QWizard::WizardOption > : EnumConverter<QWizard::WizardOption >
{
};
template<>
struct Converter<QFlags<QWizard::WizardOption> > : EnumConverter<QFlags<QWizard::WizardOption> >
{
};

template<>
struct Converter<QWizard* > : ObjectTypeConverter<QWizard >
{
};

template<>
struct Converter<QWizard& > : ObjectTypeReferenceConverter<QWizard >
{
};

template<>
struct Converter<QAbstractPrintDialog::PrintRange > : EnumConverter<QAbstractPrintDialog::PrintRange >
{
};

template<>
struct Converter<QAbstractPrintDialog::PrintDialogOption > : EnumConverter<QAbstractPrintDialog::PrintDialogOption >
{
};
template<>
struct Converter<QFlags<QAbstractPrintDialog::PrintDialogOption> > : EnumConverter<QFlags<QAbstractPrintDialog::PrintDialogOption> >
{
};

template<>
struct Converter<QAbstractPrintDialog* > : ObjectTypeConverter<QAbstractPrintDialog >
{
};

template<>
struct Converter<QAbstractPrintDialog& > : ObjectTypeReferenceConverter<QAbstractPrintDialog >
{
};

template<>
struct Converter<QPrintDialog* > : ObjectTypeConverter<QPrintDialog >
{
};

template<>
struct Converter<QPrintDialog& > : ObjectTypeReferenceConverter<QPrintDialog >
{
};

template<>
struct Converter<QColorDialog::ColorDialogOption > : EnumConverter<QColorDialog::ColorDialogOption >
{
};
template<>
struct Converter<QFlags<QColorDialog::ColorDialogOption> > : EnumConverter<QFlags<QColorDialog::ColorDialogOption> >
{
};

template<>
struct Converter<QColorDialog* > : ObjectTypeConverter<QColorDialog >
{
};

template<>
struct Converter<QColorDialog& > : ObjectTypeReferenceConverter<QColorDialog >
{
};

template<>
struct Converter<QPrintPreviewDialog* > : ObjectTypeConverter<QPrintPreviewDialog >
{
};

template<>
struct Converter<QPrintPreviewDialog& > : ObjectTypeReferenceConverter<QPrintPreviewDialog >
{
};

template<>
struct Converter<QAbstractPageSetupDialog* > : ObjectTypeConverter<QAbstractPageSetupDialog >
{
};

template<>
struct Converter<QAbstractPageSetupDialog& > : ObjectTypeReferenceConverter<QAbstractPageSetupDialog >
{
};

template<>
struct Converter<QPageSetupDialog::PageSetupDialogOption > : EnumConverter<QPageSetupDialog::PageSetupDialogOption >
{
};
template<>
struct Converter<QFlags<QPageSetupDialog::PageSetupDialogOption> > : EnumConverter<QFlags<QPageSetupDialog::PageSetupDialogOption> >
{
};

template<>
struct Converter<QPageSetupDialog* > : ObjectTypeConverter<QPageSetupDialog >
{
};

template<>
struct Converter<QPageSetupDialog& > : ObjectTypeReferenceConverter<QPageSetupDialog >
{
};

template<>
struct Converter<QErrorMessage* > : ObjectTypeConverter<QErrorMessage >
{
};

template<>
struct Converter<QErrorMessage& > : ObjectTypeReferenceConverter<QErrorMessage >
{
};

template<>
struct Converter<QFileIconProvider::IconType > : EnumConverter<QFileIconProvider::IconType >
{
};

template<>
struct Converter<QFileIconProvider* > : ObjectTypeConverter<QFileIconProvider >
{
};

template<>
struct Converter<QFileIconProvider& > : ObjectTypeReferenceConverter<QFileIconProvider >
{
};

template<>
struct Converter<QApplication::Type > : EnumConverter<QApplication::Type >
{
};

template<>
struct Converter<QApplication::ColorSpec > : EnumConverter<QApplication::ColorSpec >
{
};

template<>
struct Converter<QApplication* > : ObjectTypeConverter<QApplication >
{
};

template<>
struct Converter<QApplication& > : ObjectTypeReferenceConverter<QApplication >
{
};

template<>
struct Converter<QTableWidget* > : ObjectTypeConverter<QTableWidget >
{
};

template<>
struct Converter<QTableWidget& > : ObjectTypeReferenceConverter<QTableWidget >
{
};

template<>
struct Converter<QGraphicsLayoutItem* > : ObjectTypeConverter<QGraphicsLayoutItem >
{
};

template<>
struct Converter<QGraphicsLayoutItem& > : ObjectTypeReferenceConverter<QGraphicsLayoutItem >
{
};

template<>
struct Converter<QGraphicsWidget* > : ObjectTypeConverter<QGraphicsWidget >
{
};

template<>
struct Converter<QGraphicsWidget& > : ObjectTypeReferenceConverter<QGraphicsWidget >
{
};

template<>
struct Converter<QGraphicsProxyWidget* > : ObjectTypeConverter<QGraphicsProxyWidget >
{
};

template<>
struct Converter<QGraphicsProxyWidget& > : ObjectTypeReferenceConverter<QGraphicsProxyWidget >
{
};

template<>
struct Converter<QGraphicsLayout* > : ObjectTypeConverter<QGraphicsLayout >
{
};

template<>
struct Converter<QGraphicsLayout& > : ObjectTypeReferenceConverter<QGraphicsLayout >
{
};

template<>
struct Converter<QGraphicsAnchorLayout* > : ObjectTypeConverter<QGraphicsAnchorLayout >
{
};

template<>
struct Converter<QGraphicsAnchorLayout& > : ObjectTypeReferenceConverter<QGraphicsAnchorLayout >
{
};

template<>
struct Converter<QGraphicsGridLayout* > : ObjectTypeConverter<QGraphicsGridLayout >
{
};

template<>
struct Converter<QGraphicsGridLayout& > : ObjectTypeReferenceConverter<QGraphicsGridLayout >
{
};

template<>
struct Converter<QGraphicsLinearLayout* > : ObjectTypeConverter<QGraphicsLinearLayout >
{
};

template<>
struct Converter<QGraphicsLinearLayout& > : ObjectTypeReferenceConverter<QGraphicsLinearLayout >
{
};

template<>
struct Converter<QToolBox* > : ObjectTypeConverter<QToolBox >
{
};

template<>
struct Converter<QToolBox& > : ObjectTypeReferenceConverter<QToolBox >
{
};

template<>
struct Converter<QTextFormat::Property > : EnumConverter<QTextFormat::Property >
{
};

template<>
struct Converter<QTextFormat::FormatType > : EnumConverter<QTextFormat::FormatType >
{
};

template<>
struct Converter<QTextFormat::ObjectTypes > : EnumConverter<QTextFormat::ObjectTypes >
{
};

template<>
struct Converter<QTextFormat::PageBreakFlag > : EnumConverter<QTextFormat::PageBreakFlag >
{
};
template<>
struct Converter<QFlags<QTextFormat::PageBreakFlag> > : EnumConverter<QFlags<QTextFormat::PageBreakFlag> >
{
};

template <>
struct SbkTypeInfo<QTextFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextFormat > : ValueTypeConverter<QTextFormat >
{
};

template <>
struct SbkTypeInfo<QTextBlockFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextBlockFormat > : ValueTypeConverter<QTextBlockFormat >
{
};

template<>
struct Converter<QTextListFormat::Style > : EnumConverter<QTextListFormat::Style >
{
};

template <>
struct SbkTypeInfo<QTextListFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextListFormat > : ValueTypeConverter<QTextListFormat >
{
};

template<>
struct Converter<QTextFrameFormat::Position > : EnumConverter<QTextFrameFormat::Position >
{
};

template<>
struct Converter<QTextFrameFormat::BorderStyle > : EnumConverter<QTextFrameFormat::BorderStyle >
{
};

template <>
struct SbkTypeInfo<QTextFrameFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextFrameFormat > : ValueTypeConverter<QTextFrameFormat >
{
};

template <>
struct SbkTypeInfo<QTextTableFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextTableFormat > : ValueTypeConverter<QTextTableFormat >
{
};

template<>
struct Converter<QTextCharFormat::VerticalAlignment > : EnumConverter<QTextCharFormat::VerticalAlignment >
{
};

template<>
struct Converter<QTextCharFormat::UnderlineStyle > : EnumConverter<QTextCharFormat::UnderlineStyle >
{
};

template <>
struct SbkTypeInfo<QTextCharFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextCharFormat > : ValueTypeConverter<QTextCharFormat >
{
};

template <>
struct SbkTypeInfo<QTextImageFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextImageFormat > : ValueTypeConverter<QTextImageFormat >
{
};

template <>
struct SbkTypeInfo<QTextTableCellFormat >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QTextTableCellFormat > : ValueTypeConverter<QTextTableCellFormat >
{
};

template<>
struct Converter<QDateTimeEdit::Section > : EnumConverter<QDateTimeEdit::Section >
{
};
template<>
struct Converter<QFlags<QDateTimeEdit::Section> > : EnumConverter<QFlags<QDateTimeEdit::Section> >
{
};

template<>
struct Converter<QDateTimeEdit* > : ObjectTypeConverter<QDateTimeEdit >
{
};

template<>
struct Converter<QDateTimeEdit& > : ObjectTypeReferenceConverter<QDateTimeEdit >
{
};

template<>
struct Converter<QTimeEdit* > : ObjectTypeConverter<QTimeEdit >
{
};

template<>
struct Converter<QTimeEdit& > : ObjectTypeReferenceConverter<QTimeEdit >
{
};

template<>
struct Converter<QDateEdit* > : ObjectTypeConverter<QDateEdit >
{
};

template<>
struct Converter<QDateEdit& > : ObjectTypeReferenceConverter<QDateEdit >
{
};

template<>
struct Converter<QTextBlockUserData* > : ObjectTypeConverter<QTextBlockUserData >
{
};

template<>
struct Converter<QTextBlockUserData& > : ObjectTypeReferenceConverter<QTextBlockUserData >
{
};

template<>
struct Converter<QItemSelectionModel::SelectionFlag > : EnumConverter<QItemSelectionModel::SelectionFlag >
{
};
template<>
struct Converter<QFlags<QItemSelectionModel::SelectionFlag> > : EnumConverter<QFlags<QItemSelectionModel::SelectionFlag> >
{
};

template<>
struct Converter<QItemSelectionModel* > : ObjectTypeConverter<QItemSelectionModel >
{
};

template<>
struct Converter<QItemSelectionModel& > : ObjectTypeReferenceConverter<QItemSelectionModel >
{
};

template<>
struct Converter<QMovie::CacheMode > : EnumConverter<QMovie::CacheMode >
{
};

template<>
struct Converter<QMovie::MovieState > : EnumConverter<QMovie::MovieState >
{
};

template<>
struct Converter<QMovie* > : ObjectTypeConverter<QMovie >
{
};

template<>
struct Converter<QMovie& > : ObjectTypeReferenceConverter<QMovie >
{
};

template<>
struct Converter<QTextTable* > : ObjectTypeConverter<QTextTable >
{
};

template<>
struct Converter<QTextTable& > : ObjectTypeReferenceConverter<QTextTable >
{
};

template<>
struct Converter<QInputDialog::InputMode > : EnumConverter<QInputDialog::InputMode >
{
};

template<>
struct Converter<QInputDialog::InputDialogOption > : EnumConverter<QInputDialog::InputDialogOption >
{
};

template<>
struct Converter<QInputDialog* > : ObjectTypeConverter<QInputDialog >
{
};

template<>
struct Converter<QInputDialog& > : ObjectTypeReferenceConverter<QInputDialog >
{
};

template<>
struct Converter<QGtkStyle* > : ObjectTypeConverter<QGtkStyle >
{
};

template<>
struct Converter<QGtkStyle& > : ObjectTypeReferenceConverter<QGtkStyle >
{
};

template<>
struct Converter<QUndoGroup* > : ObjectTypeConverter<QUndoGroup >
{
};

template<>
struct Converter<QUndoGroup& > : ObjectTypeReferenceConverter<QUndoGroup >
{
};

template<>
struct Converter<QFileDialog::FileMode > : EnumConverter<QFileDialog::FileMode >
{
};

template<>
struct Converter<QFileDialog::Option > : EnumConverter<QFileDialog::Option >
{
};
template<>
struct Converter<QFlags<QFileDialog::Option> > : EnumConverter<QFlags<QFileDialog::Option> >
{
};

template<>
struct Converter<QFileDialog::DialogLabel > : EnumConverter<QFileDialog::DialogLabel >
{
};

template<>
struct Converter<QFileDialog::ViewMode > : EnumConverter<QFileDialog::ViewMode >
{
};

template<>
struct Converter<QFileDialog::AcceptMode > : EnumConverter<QFileDialog::AcceptMode >
{
};

template<>
struct Converter<QFileDialog* > : ObjectTypeConverter<QFileDialog >
{
};

template<>
struct Converter<QFileDialog& > : ObjectTypeReferenceConverter<QFileDialog >
{
};

template<>
struct Converter<QUndoStack* > : ObjectTypeConverter<QUndoStack >
{
};

template<>
struct Converter<QUndoStack& > : ObjectTypeReferenceConverter<QUndoStack >
{
};

template<>
struct Converter<QTextCursor::MoveMode > : EnumConverter<QTextCursor::MoveMode >
{
};

template<>
struct Converter<QTextCursor::MoveOperation > : EnumConverter<QTextCursor::MoveOperation >
{
};

template<>
struct Converter<QTextCursor::SelectionType > : EnumConverter<QTextCursor::SelectionType >
{
};

template<>
struct Converter<QTextCursor > : ValueTypeConverter<QTextCursor >
{
};

template<>
struct Converter<QPlainTextEdit::LineWrapMode > : EnumConverter<QPlainTextEdit::LineWrapMode >
{
};

template<>
struct Converter<QPlainTextEdit* > : ObjectTypeConverter<QPlainTextEdit >
{
};

template<>
struct Converter<QPlainTextEdit& > : ObjectTypeReferenceConverter<QPlainTextEdit >
{
};

template<>
struct Converter<QImage::InvertMode > : EnumConverter<QImage::InvertMode >
{
};

template<>
struct Converter<QImage::Format > : EnumConverter<QImage::Format >
{
};

template <>
struct SbkTypeInfo<QImage >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QImage > : ValueTypeConverter<QImage >
{
};

template <>
struct SbkTypeInfo<QBitmap >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QBitmap > : ValueTypeConverter<QBitmap >
{
    static QBitmap toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QFontDatabase::WritingSystem > : EnumConverter<QFontDatabase::WritingSystem >
{
};

template<>
struct Converter<QFontDatabase > : ValueTypeConverter<QFontDatabase >
{
};

template<>
struct Converter<QKeyEvent* > : ObjectTypeConverter<QKeyEvent >
{
};

template<>
struct Converter<QKeyEvent& > : ObjectTypeReferenceConverter<QKeyEvent >
{
};

template<>
struct Converter<QMessageBox::ButtonRole > : EnumConverter<QMessageBox::ButtonRole >
{
};

template<>
struct Converter<QMessageBox::StandardButton > : EnumConverter<QMessageBox::StandardButton >
{
};
template<>
struct Converter<QFlags<QMessageBox::StandardButton> > : EnumConverter<QFlags<QMessageBox::StandardButton> >
{
};

template<>
struct Converter<QMessageBox::Icon > : EnumConverter<QMessageBox::Icon >
{
};

template<>
struct Converter<QMessageBox* > : ObjectTypeConverter<QMessageBox >
{
};

template<>
struct Converter<QMessageBox& > : ObjectTypeReferenceConverter<QMessageBox >
{
};

template<>
struct Converter<QTextEdit::AutoFormattingFlag > : EnumConverter<QTextEdit::AutoFormattingFlag >
{
};
template<>
struct Converter<QFlags<QTextEdit::AutoFormattingFlag> > : EnumConverter<QFlags<QTextEdit::AutoFormattingFlag> >
{
};

template<>
struct Converter<QTextEdit::LineWrapMode > : EnumConverter<QTextEdit::LineWrapMode >
{
};

template<>
struct Converter<QTextEdit* > : ObjectTypeConverter<QTextEdit >
{
};

template<>
struct Converter<QTextEdit& > : ObjectTypeReferenceConverter<QTextEdit >
{
};

template<>
struct Converter<QTextBrowser* > : ObjectTypeConverter<QTextBrowser >
{
};

template<>
struct Converter<QTextBrowser& > : ObjectTypeReferenceConverter<QTextBrowser >
{
};

template<>
struct Converter<QTextEdit::ExtraSelection > : ValueTypeConverter<QTextEdit::ExtraSelection >
{
};

template<>
struct Converter<QMenuBar* > : ObjectTypeConverter<QMenuBar >
{
};

template<>
struct Converter<QMenuBar& > : ObjectTypeReferenceConverter<QMenuBar >
{
};

template<>
struct Converter<QTextTableCell > : ValueTypeConverter<QTextTableCell >
{
};

template<>
struct Converter<QTextObjectInterface* > : ObjectTypeConverter<QTextObjectInterface >
{
};

template<>
struct Converter<QTextObjectInterface& > : ObjectTypeReferenceConverter<QTextObjectInterface >
{
};

template<>
struct Converter<QAbstractProxyModel* > : ObjectTypeConverter<QAbstractProxyModel >
{
};

template<>
struct Converter<QAbstractProxyModel& > : ObjectTypeReferenceConverter<QAbstractProxyModel >
{
};

template<>
struct Converter<QSortFilterProxyModel* > : ObjectTypeConverter<QSortFilterProxyModel >
{
};

template<>
struct Converter<QSortFilterProxyModel& > : ObjectTypeReferenceConverter<QSortFilterProxyModel >
{
};

template<>
struct Converter<QFontDialog::FontDialogOption > : EnumConverter<QFontDialog::FontDialogOption >
{
};
template<>
struct Converter<QFlags<QFontDialog::FontDialogOption> > : EnumConverter<QFlags<QFontDialog::FontDialogOption> >
{
};

template<>
struct Converter<QFontDialog* > : ObjectTypeConverter<QFontDialog >
{
};

template<>
struct Converter<QFontDialog& > : ObjectTypeReferenceConverter<QFontDialog >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Conversion rule for: QPixmap
namespace Shiboken {
inline bool Converter< QPixmap >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPixmap>::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPixmap>());
    bool isVariant = SbkQVariant_Check(pyobj);
    if (isVariant) {
        QVariant var(Converter<QVariant>::toCpp(pyobj));
        return var.type() == QVariant::Pixmap;
    } else if (SbkQSize_Check(pyobj) || SbkQString_Check(pyobj)) {
        return true;
    } else if (shiboType->ext_isconvertible) {
        return shiboType->ext_isconvertible(pyobj);
    }
    return false;

}

inline QPixmap Converter< QPixmap >::toCpp(PyObject* pyobj)
{
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPixmap>());
    bool isVariant = SbkQVariant_Check(pyobj);
    if (isVariant) {
        QVariant var(Converter<QVariant>::toCpp(pyobj));
        return var.value<QPixmap>();
    } else if (SbkQSize_Check(pyobj)) {
        return QPixmap(Shiboken::Converter<QSize& >::toCpp(pyobj));
    } else if (SbkQString_Check(pyobj)) {
        return QPixmap(Shiboken::Converter<QString& >::toCpp(pyobj));
    } else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
        QPixmap* cptr = reinterpret_cast<QPixmap*>(shiboType->ext_tocpp(pyobj));
        std::auto_ptr<QPixmap> cptr_auto_ptr(cptr);
        return *cptr;
    }

    return *Converter<QPixmap*>::toCpp(pyobj);
}

inline PyObject* Converter<QPixmap>::toPython(const QPixmap& cppObj)
{
    return ValueTypeConverter<QPixmap>::toPython(cppObj);
}
}
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QTileRules >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QTileRules >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QTileRules >());
    return Shiboken::Converter<Qt::TileRule >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QTileRules Shiboken::Converter<QTileRules >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QTileRules)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QTileRules >());
        if (Shiboken::Converter<Qt::TileRule >::isConvertible(pyobj))
            return QTileRules(Shiboken::Converter<Qt::TileRule >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QTileRules* cptr = reinterpret_cast<QTileRules*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QTileRules > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QTileRules* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QFontMetricsF >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QFontMetricsF >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFontMetricsF >());
    return Shiboken::Converter<QFont & >::isConvertible(pyobj)
         || Shiboken::Converter<QFontMetrics & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QFontMetricsF Shiboken::Converter<QFontMetricsF >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QFontMetricsF)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFontMetricsF >());
        if (Shiboken::Converter<QFont & >::isConvertible(pyobj))
            return QFontMetricsF(Shiboken::Converter<QFont & >::toCpp(pyobj));
        else if (Shiboken::Converter<QFontMetrics & >::isConvertible(pyobj))
            return QFontMetricsF(Shiboken::Converter<QFontMetrics & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QFontMetricsF* cptr = reinterpret_cast<QFontMetricsF*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QFontMetricsF > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QKeySequence >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QKeySequence >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QKeySequence >());
    return Shiboken::Converter<QKeySequence::StandardKey >::isConvertible(pyobj)
         || Shiboken::Converter<QString & >::isConvertible(pyobj)
         || PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QKeySequence Shiboken::Converter<QKeySequence >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QKeySequence)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QKeySequence >());
        if (Shiboken::Converter<QKeySequence::StandardKey >::isConvertible(pyobj))
            return QKeySequence(Shiboken::Converter<QKeySequence::StandardKey >::toCpp(pyobj));
        else if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QKeySequence(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QKeySequence(Shiboken::Converter<int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QKeySequence* cptr = reinterpret_cast<QKeySequence*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QKeySequence > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QTextOption >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QTextOption >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QTextOption >());
    return Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QTextOption Shiboken::Converter<QTextOption >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QTextOption)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QTextOption >());
        if (Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::isConvertible(pyobj))
            return QTextOption(Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QTextOption* cptr = reinterpret_cast<QTextOption*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QTextOption > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QTextOption* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QBrush >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QBrush >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QBrush >());
    return Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyobj)
         || Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyobj)
         || Shiboken::Converter<QColor & >::isConvertible(pyobj)
         || Shiboken::Converter<QGradient & >::isConvertible(pyobj)
         || Shiboken::Converter<QImage & >::isConvertible(pyobj)
         || Shiboken::Converter<QPixmap & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QBrush Shiboken::Converter<QBrush >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QBrush)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QBrush >());
        if (Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyobj))
            return QBrush(Shiboken::Converter<Qt::BrushStyle >::toCpp(pyobj));
        else if (Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyobj))
            return QBrush(Shiboken::Converter<Qt::GlobalColor >::toCpp(pyobj));
        else if (Shiboken::Converter<QColor & >::isConvertible(pyobj))
            return QBrush(Shiboken::Converter<QColor & >::toCpp(pyobj));
        else if (Shiboken::Converter<QGradient & >::isConvertible(pyobj))
            return QBrush(Shiboken::Converter<QGradient & >::toCpp(pyobj));
        else if (Shiboken::Converter<QImage & >::isConvertible(pyobj))
            return QBrush(Shiboken::Converter<QImage & >::toCpp(pyobj));
        else if (Shiboken::Converter<QPixmap & >::isConvertible(pyobj))
            return QBrush(Shiboken::Converter<QPixmap & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QBrush* cptr = reinterpret_cast<QBrush*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QBrush > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QBrush* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QPrinterInfo >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPrinterInfo >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPrinterInfo >());
    return Shiboken::Converter<QPrinter & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPrinterInfo Shiboken::Converter<QPrinterInfo >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPrinterInfo)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPrinterInfo >());
        if (Shiboken::Converter<QPrinter & >::isConvertible(pyobj))
            return QPrinterInfo(Shiboken::Converter<QPrinter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPrinterInfo* cptr = reinterpret_cast<QPrinterInfo*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPrinterInfo > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPrinterInfo* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QPolygonF >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPolygonF >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPolygonF >());
    return Shiboken::Converter<QPolygon & >::isConvertible(pyobj)
         || Shiboken::Converter<QRectF & >::isConvertible(pyobj)
         || Shiboken::Converter<QVector<QPointF >  >::isConvertible(pyobj)
         || PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPolygonF Shiboken::Converter<QPolygonF >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPolygonF)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPolygonF >());
        if (Shiboken::Converter<QPolygon & >::isConvertible(pyobj))
            return QPolygonF(Shiboken::Converter<QPolygon & >::toCpp(pyobj));
        else if (Shiboken::Converter<QRectF & >::isConvertible(pyobj))
            return QPolygonF(Shiboken::Converter<QRectF & >::toCpp(pyobj));
        else if (Shiboken::Converter<QVector<QPointF >  >::isConvertible(pyobj))
            return QPolygonF(Shiboken::Converter<QVector<QPointF >  >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QPolygonF(Shiboken::Converter<int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPolygonF* cptr = reinterpret_cast<QPolygonF*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPolygonF > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QPolygon >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPolygon >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPolygon >());
    return Shiboken::Converter<QRect & >::isConvertible(pyobj)
         || Shiboken::Converter<QVector<QPoint >  >::isConvertible(pyobj)
         || PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPolygon Shiboken::Converter<QPolygon >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPolygon)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPolygon >());
        if (Shiboken::Converter<QRect & >::isConvertible(pyobj))
            return QPolygon(Shiboken::Converter<QRect & >::toCpp(pyobj));
        else if (Shiboken::Converter<QVector<QPoint >  >::isConvertible(pyobj))
            return QPolygon(Shiboken::Converter<QVector<QPoint >  >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QPolygon(Shiboken::Converter<int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPolygon* cptr = reinterpret_cast<QPolygon*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPolygon > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPolygon* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QColor >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QColor >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QColor >());
    return Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyobj)
         || Shiboken::Converter<QString & >::isConvertible(pyobj)
         || PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QColor Shiboken::Converter<QColor >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QColor)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QColor >());
        if (Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyobj))
            return QColor(Shiboken::Converter<Qt::GlobalColor >::toCpp(pyobj));
        else if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QColor(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QColor(Shiboken::Converter<unsigned int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QColor* cptr = reinterpret_cast<QColor*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QColor > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QColor* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QRegion >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QRegion >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QRegion >());
    return Shiboken::Converter<QBitmap & >::isConvertible(pyobj)
         || Shiboken::Converter<QPolygon & >::isConvertible(pyobj)
         || Shiboken::Converter<QRect & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QRegion Shiboken::Converter<QRegion >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QRegion)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QRegion >());
        if (Shiboken::Converter<QBitmap & >::isConvertible(pyobj))
            return QRegion(Shiboken::Converter<QBitmap & >::toCpp(pyobj));
        else if (Shiboken::Converter<QPolygon & >::isConvertible(pyobj))
            return QRegion(Shiboken::Converter<QPolygon & >::toCpp(pyobj));
        else if (Shiboken::Converter<QRect & >::isConvertible(pyobj))
            return QRegion(Shiboken::Converter<QRect & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QRegion* cptr = reinterpret_cast<QRegion*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QRegion > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QRegion* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QPen >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPen >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPen >());
    return Shiboken::Converter<Qt::PenStyle >::isConvertible(pyobj)
         || Shiboken::Converter<QColor & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPen Shiboken::Converter<QPen >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPen)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPen >());
        if (Shiboken::Converter<Qt::PenStyle >::isConvertible(pyobj))
            return QPen(Shiboken::Converter<Qt::PenStyle >::toCpp(pyobj));
        else if (Shiboken::Converter<QColor & >::isConvertible(pyobj))
            return QPen(Shiboken::Converter<QColor & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPen* cptr = reinterpret_cast<QPen*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPen > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPen* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QIcon >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QIcon >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QIcon >());
    return Shiboken::Converter<QPixmap & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QIcon Shiboken::Converter<QIcon >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QIcon)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QIcon >());
        if (Shiboken::Converter<QPixmap & >::isConvertible(pyobj))
            return QIcon(Shiboken::Converter<QPixmap & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QIcon* cptr = reinterpret_cast<QIcon*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QIcon > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QIcon* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QTouchEvent::TouchPoint >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QTouchEvent::TouchPoint >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QTouchEvent::TouchPoint >());
    return PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QTouchEvent::TouchPoint Shiboken::Converter<QTouchEvent::TouchPoint >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QTouchEvent::TouchPoint)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QTouchEvent::TouchPoint >());
        if (PyInt_Check(pyobj))
            return QTouchEvent::TouchPoint(Shiboken::Converter<int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QTouchEvent::TouchPoint* cptr = reinterpret_cast<QTouchEvent::TouchPoint*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QTouchEvent::TouchPoint > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QFontInfo >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QFontInfo >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFontInfo >());
    return Shiboken::Converter<QFont & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QFontInfo Shiboken::Converter<QFontInfo >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QFontInfo)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFontInfo >());
        if (Shiboken::Converter<QFont & >::isConvertible(pyobj))
            return QFontInfo(Shiboken::Converter<QFont & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QFontInfo* cptr = reinterpret_cast<QFontInfo*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QFontInfo > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QFontInfo* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionDockWidgetV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionDockWidgetV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionDockWidgetV2 >());
    return Shiboken::Converter<QStyleOptionDockWidget & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionDockWidgetV2 Shiboken::Converter<QStyleOptionDockWidgetV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionDockWidgetV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionDockWidgetV2 >());
        if (Shiboken::Converter<QStyleOptionDockWidget & >::isConvertible(pyobj))
            return QStyleOptionDockWidgetV2(Shiboken::Converter<QStyleOptionDockWidget & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionDockWidgetV2* cptr = reinterpret_cast<QStyleOptionDockWidgetV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionDockWidgetV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionDockWidgetV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionTabBarBaseV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionTabBarBaseV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionTabBarBaseV2 >());
    return Shiboken::Converter<QStyleOptionTabBarBase & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionTabBarBaseV2 Shiboken::Converter<QStyleOptionTabBarBaseV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionTabBarBaseV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionTabBarBaseV2 >());
        if (Shiboken::Converter<QStyleOptionTabBarBase & >::isConvertible(pyobj))
            return QStyleOptionTabBarBaseV2(Shiboken::Converter<QStyleOptionTabBarBase & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionTabBarBaseV2* cptr = reinterpret_cast<QStyleOptionTabBarBaseV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionTabBarBaseV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionTabBarBaseV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionTabV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionTabV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionTabV2 >());
    return Shiboken::Converter<QStyleOptionTab & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionTabV2 Shiboken::Converter<QStyleOptionTabV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionTabV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionTabV2 >());
        if (Shiboken::Converter<QStyleOptionTab & >::isConvertible(pyobj))
            return QStyleOptionTabV2(Shiboken::Converter<QStyleOptionTab & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionTabV2* cptr = reinterpret_cast<QStyleOptionTabV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionTabV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionTabV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionTabV3 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionTabV3 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionTabV3 >());
    return Shiboken::Converter<QStyleOptionTab & >::isConvertible(pyobj)
         || Shiboken::Converter<QStyleOptionTabV2 & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionTabV3 Shiboken::Converter<QStyleOptionTabV3 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionTabV3)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionTabV3 >());
        if (Shiboken::Converter<QStyleOptionTab & >::isConvertible(pyobj))
            return QStyleOptionTabV3(Shiboken::Converter<QStyleOptionTab & >::toCpp(pyobj));
        else if (Shiboken::Converter<QStyleOptionTabV2 & >::isConvertible(pyobj))
            return QStyleOptionTabV3(Shiboken::Converter<QStyleOptionTabV2 & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionTabV3* cptr = reinterpret_cast<QStyleOptionTabV3*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionTabV3 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionTabV3* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionProgressBarV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionProgressBarV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionProgressBarV2 >());
    return Shiboken::Converter<QStyleOptionProgressBar & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionProgressBarV2 Shiboken::Converter<QStyleOptionProgressBarV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionProgressBarV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionProgressBarV2 >());
        if (Shiboken::Converter<QStyleOptionProgressBar & >::isConvertible(pyobj))
            return QStyleOptionProgressBarV2(Shiboken::Converter<QStyleOptionProgressBar & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionProgressBarV2* cptr = reinterpret_cast<QStyleOptionProgressBarV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionProgressBarV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionProgressBarV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionFrameV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionFrameV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionFrameV2 >());
    return Shiboken::Converter<QStyleOptionFrame & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionFrameV2 Shiboken::Converter<QStyleOptionFrameV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionFrameV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionFrameV2 >());
        if (Shiboken::Converter<QStyleOptionFrame & >::isConvertible(pyobj))
            return QStyleOptionFrameV2(Shiboken::Converter<QStyleOptionFrame & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionFrameV2* cptr = reinterpret_cast<QStyleOptionFrameV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionFrameV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionFrameV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionFrameV3 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionFrameV3 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionFrameV3 >());
    return Shiboken::Converter<QStyleOptionFrame & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionFrameV3 Shiboken::Converter<QStyleOptionFrameV3 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionFrameV3)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionFrameV3 >());
        if (Shiboken::Converter<QStyleOptionFrame & >::isConvertible(pyobj))
            return QStyleOptionFrameV3(Shiboken::Converter<QStyleOptionFrame & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionFrameV3* cptr = reinterpret_cast<QStyleOptionFrameV3*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionFrameV3 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionFrameV3* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QPalette >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPalette >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPalette >());
    return Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyobj)
         || Shiboken::Converter<QColor & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPalette Shiboken::Converter<QPalette >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPalette)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPalette >());
        if (Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyobj))
            return QPalette(Shiboken::Converter<Qt::GlobalColor >::toCpp(pyobj));
        else if (Shiboken::Converter<QColor & >::isConvertible(pyobj))
            return QPalette(Shiboken::Converter<QColor & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPalette* cptr = reinterpret_cast<QPalette*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPalette > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPalette* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QVector3D >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QVector3D >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QVector3D >());
    return Shiboken::Converter<QVector2D & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QVector3D Shiboken::Converter<QVector3D >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QVector3D)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QVector3D >());
        if (Shiboken::Converter<QVector2D & >::isConvertible(pyobj))
            return QVector3D(Shiboken::Converter<QVector2D & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QVector3D* cptr = reinterpret_cast<QVector3D*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QVector3D > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QVector3D* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionToolBoxV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionToolBoxV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionToolBoxV2 >());
    return Shiboken::Converter<QStyleOptionToolBox & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionToolBoxV2 Shiboken::Converter<QStyleOptionToolBoxV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionToolBoxV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionToolBoxV2 >());
        if (Shiboken::Converter<QStyleOptionToolBox & >::isConvertible(pyobj))
            return QStyleOptionToolBoxV2(Shiboken::Converter<QStyleOptionToolBox & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionToolBoxV2* cptr = reinterpret_cast<QStyleOptionToolBoxV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionToolBoxV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionToolBoxV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QFontMetrics >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QFontMetrics >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFontMetrics >());
    return Shiboken::Converter<QFont & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QFontMetrics Shiboken::Converter<QFontMetrics >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QFontMetrics)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFontMetrics >());
        if (Shiboken::Converter<QFont & >::isConvertible(pyobj))
            return QFontMetrics(Shiboken::Converter<QFont & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QFontMetrics* cptr = reinterpret_cast<QFontMetrics*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QFontMetrics > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QFontMetrics* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QVector4D >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QVector4D >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QVector4D >());
    return Shiboken::Converter<QVector2D & >::isConvertible(pyobj)
         || Shiboken::Converter<QVector3D & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QVector4D Shiboken::Converter<QVector4D >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QVector4D)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QVector4D >());
        if (Shiboken::Converter<QVector2D & >::isConvertible(pyobj))
            return QVector4D(Shiboken::Converter<QVector2D & >::toCpp(pyobj));
        else if (Shiboken::Converter<QVector3D & >::isConvertible(pyobj))
            return QVector4D(Shiboken::Converter<QVector3D & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QVector4D* cptr = reinterpret_cast<QVector4D*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QVector4D > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QVector4D* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QCursor >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QCursor >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QCursor >());
    return Shiboken::Converter<Qt::CursorShape >::isConvertible(pyobj)
         || PyLong_Check(pyobj)
         || Shiboken::Converter<QPixmap & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QCursor Shiboken::Converter<QCursor >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QCursor)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QCursor >());
        if (Shiboken::Converter<Qt::CursorShape >::isConvertible(pyobj))
            return QCursor(Shiboken::Converter<Qt::CursorShape >::toCpp(pyobj));
        else if (PyLong_Check(pyobj))
            return QCursor(Shiboken::Converter<Qt::HANDLE >::toCpp(pyobj));
        else if (Shiboken::Converter<QPixmap & >::isConvertible(pyobj))
            return QCursor(Shiboken::Converter<QPixmap & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QCursor* cptr = reinterpret_cast<QCursor*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QCursor > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QCursor* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QFont >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QFont >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFont >());
    return Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QFont Shiboken::Converter<QFont >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QFont)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFont >());
        if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QFont(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QFont* cptr = reinterpret_cast<QFont*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QFont > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QFont* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionViewItemV2 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionViewItemV2 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionViewItemV2 >());
    return Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionViewItemV2 Shiboken::Converter<QStyleOptionViewItemV2 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionViewItemV2)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionViewItemV2 >());
        if (Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyobj))
            return QStyleOptionViewItemV2(Shiboken::Converter<QStyleOptionViewItem & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionViewItemV2* cptr = reinterpret_cast<QStyleOptionViewItemV2*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionViewItemV2 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionViewItemV2* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionViewItemV3 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionViewItemV3 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionViewItemV3 >());
    return Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionViewItemV3 Shiboken::Converter<QStyleOptionViewItemV3 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionViewItemV3)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionViewItemV3 >());
        if (Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyobj))
            return QStyleOptionViewItemV3(Shiboken::Converter<QStyleOptionViewItem & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionViewItemV3* cptr = reinterpret_cast<QStyleOptionViewItemV3*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionViewItemV3 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionViewItemV3* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStyleOptionViewItemV4 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStyleOptionViewItemV4 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionViewItemV4 >());
    return Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStyleOptionViewItemV4 Shiboken::Converter<QStyleOptionViewItemV4 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStyleOptionViewItemV4)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStyleOptionViewItemV4 >());
        if (Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyobj))
            return QStyleOptionViewItemV4(Shiboken::Converter<QStyleOptionViewItem & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStyleOptionViewItemV4* cptr = reinterpret_cast<QStyleOptionViewItemV4*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStyleOptionViewItemV4 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QMatrix4x4 >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QMatrix4x4 >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QMatrix4x4 >());
    return Shiboken::Converter<QMatrix & >::isConvertible(pyobj)
         || Shiboken::Converter<QTransform & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QMatrix4x4 Shiboken::Converter<QMatrix4x4 >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QMatrix4x4)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QMatrix4x4 >());
        if (Shiboken::Converter<QMatrix & >::isConvertible(pyobj))
            return QMatrix4x4(Shiboken::Converter<QMatrix & >::toCpp(pyobj));
        else if (Shiboken::Converter<QTransform & >::isConvertible(pyobj))
            return QMatrix4x4(Shiboken::Converter<QTransform & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QMatrix4x4* cptr = reinterpret_cast<QMatrix4x4*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QMatrix4x4 > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QBitmap >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QBitmap >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QBitmap >());
    return Shiboken::Converter<QPixmap & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QBitmap Shiboken::Converter<QBitmap >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QBitmap)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QBitmap >());
        if (Shiboken::Converter<QPixmap & >::isConvertible(pyobj))
            return QBitmap(Shiboken::Converter<QPixmap & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QBitmap* cptr = reinterpret_cast<QBitmap*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QBitmap > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QBitmap* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTGUI_PYTHON_H

