/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qurl_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <QStringList>
#include <qbytearray.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qurl.h>

using namespace Shiboken;

static int
SbkQUrl_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QUrl* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QUrl", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QUrl()
        cptr = new QUrl();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QUrl(QString)
            cptr = new QUrl(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QUrl::ParsingMode >::isConvertible(pyargs[1])) {
            QUrl::ParsingMode cpp_arg1 = Shiboken::Converter<QUrl::ParsingMode >::toCpp(pyargs[1]);
            // QUrl(QString,QUrl::ParsingMode)
            cptr = new QUrl(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQUrl_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // QUrl(QUrl)
        cptr = new QUrl(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrl_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QUrl >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQUrl_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQUrl_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QUrl.ParsingMode", "PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl", overloads);
        return -1;
}

static PyObject* SbkQUrlFunc_addEncodedQueryItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addEncodedQueryItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!SbkQByteArray_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // addEncodedQueryItem(QByteArray,QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::addEncodedQueryItem(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_addEncodedQueryItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_addEncodedQueryItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.addEncodedQueryItem", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_addQueryItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addQueryItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // addQueryItem(QString,QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::addQueryItem(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_addQueryItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_addQueryItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.addQueryItem", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_allEncodedQueryItemValues(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // allEncodedQueryItemValues(QByteArray)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QList<QByteArray > cpp_result = cppSelf->QUrl::allEncodedQueryItemValues(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_allEncodedQueryItemValues_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_allEncodedQueryItemValues_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.allEncodedQueryItemValues", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_allQueryItemValues(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // allQueryItemValues(QString)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QUrl::allQueryItemValues(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_allQueryItemValues_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_allQueryItemValues_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.allQueryItemValues", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_authority(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // authority()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::authority();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    cppSelf->QUrl::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUrlFunc_encodedFragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedFragment()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QUrl::encodedFragment();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_encodedHost(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedHost()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QUrl::encodedHost();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_encodedPassword(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedPassword()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QUrl::encodedPassword();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_encodedPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedPath()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QUrl::encodedPath();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_encodedQuery(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedQuery()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QUrl::encodedQuery();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_encodedQueryItemValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // encodedQueryItemValue(QByteArray)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QUrl::encodedQueryItemValue(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_encodedQueryItemValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_encodedQueryItemValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.encodedQueryItemValue", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_encodedQueryItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedQueryItems()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QList<QPair<QByteArray, QByteArray > > cpp_result = cppSelf->QUrl::encodedQueryItems();
    py_result = Shiboken::Converter<QList<QPair<QByteArray, QByteArray > > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_encodedUserName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encodedUserName()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QUrl::encodedUserName();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_fragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fragment()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::fragment();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_fromAce(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // fromAce(QByteArray)
        QString cpp_result = QUrl::fromAce(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_fromAce_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_fromAce_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.fromAce", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_fromEncoded(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromEncoded", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // fromEncoded(QByteArray)
            QUrl cpp_result = QUrl::fromEncoded(*cpp_arg0);
            py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QUrl::ParsingMode >::isConvertible(pyargs[1])) {
            QUrl::ParsingMode cpp_arg1 = Shiboken::Converter<QUrl::ParsingMode >::toCpp(pyargs[1]);
            // fromEncoded(QByteArray,QUrl::ParsingMode)
            QUrl cpp_result = QUrl::fromEncoded(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQUrlFunc_fromEncoded_TypeError;
    } else goto SbkQUrlFunc_fromEncoded_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_fromEncoded_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QByteArray, PySide.QtCore.QUrl.ParsingMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.fromEncoded", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_fromLocalFile(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromLocalFile(QString)
        QUrl cpp_result = QUrl::fromLocalFile(*cpp_arg0);
        py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_fromLocalFile_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_fromLocalFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.fromLocalFile", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_fromPercentEncoding(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // fromPercentEncoding(QByteArray)
        QString cpp_result = QUrl::fromPercentEncoding(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_fromPercentEncoding_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_fromPercentEncoding_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.fromPercentEncoding", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_fromPunycode(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // fromPunycode(QByteArray)
        QString cpp_result = QUrl::fromPunycode(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_fromPunycode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_fromPunycode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.fromPunycode", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_fromUserInput(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromUserInput(QString)
        QUrl cpp_result = QUrl::fromUserInput(*cpp_arg0);
        py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_fromUserInput_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_fromUserInput_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.fromUserInput", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_hasEncodedQueryItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // hasEncodedQueryItem(QByteArray)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QUrl::hasEncodedQueryItem(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_hasEncodedQueryItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_hasEncodedQueryItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.hasEncodedQueryItem", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_hasFragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFragment()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrl::hasFragment();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_hasQuery(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasQuery()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrl::hasQuery();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_hasQueryItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasQueryItem(QString)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QUrl::hasQueryItem(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_hasQueryItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_hasQueryItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.hasQueryItem", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_host(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // host()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::host();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_idnWhitelist(PyObject* self)
{
    PyObject* py_result = 0;

    // idnWhitelist()
    QStringList cpp_result = QUrl::idnWhitelist();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrl::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_isParentOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // isParentOf(QUrl)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QUrl::isParentOf(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_isParentOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_isParentOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.isParentOf", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_isRelative(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRelative()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrl::isRelative();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrl::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_password(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // password()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::password();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_path(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // path()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::path();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_port(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // port()const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QUrl::port();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // port(int)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QUrl::port(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_port_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_port_TypeError:
        const char* overloads[] = {"", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.port", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_queryItemValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // queryItemValue(QString)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QUrl::queryItemValue(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_queryItemValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_queryItemValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.queryItemValue", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_queryItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // queryItems()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QList<QPair<QString, QString > > cpp_result = cppSelf->QUrl::queryItems();
    py_result = Shiboken::Converter<QList<QPair<QString, QString > > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_queryPairDelimiter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // queryPairDelimiter()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    char cpp_result = cppSelf->QUrl::queryPairDelimiter();
    py_result = Shiboken::Converter<char >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_queryValueDelimiter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // queryValueDelimiter()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    char cpp_result = cppSelf->QUrl::queryValueDelimiter();
    py_result = Shiboken::Converter<char >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_removeAllEncodedQueryItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // removeAllEncodedQueryItems(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::removeAllEncodedQueryItems(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_removeAllEncodedQueryItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_removeAllEncodedQueryItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.removeAllEncodedQueryItems", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_removeAllQueryItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeAllQueryItems(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::removeAllQueryItems(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_removeAllQueryItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_removeAllQueryItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.removeAllQueryItems", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_removeEncodedQueryItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // removeEncodedQueryItem(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::removeEncodedQueryItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_removeEncodedQueryItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_removeEncodedQueryItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.removeEncodedQueryItem", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_removeQueryItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeQueryItem(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::removeQueryItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_removeQueryItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_removeQueryItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.removeQueryItem", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_resolved(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // resolved(QUrl)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QUrl cpp_result = cppSelf->QUrl::resolved(*cpp_arg0);
        py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_resolved_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_resolved_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.resolved", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_scheme(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scheme()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::scheme();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_setAuthority(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAuthority(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setAuthority(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setAuthority_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setAuthority_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setAuthority", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedFragment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setEncodedFragment(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedFragment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedFragment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedFragment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedFragment", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedHost(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setEncodedHost(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedHost(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedHost_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedHost_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedHost", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedPassword(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setEncodedPassword(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedPassword(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedPassword_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedPassword_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedPassword", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setEncodedPath(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedPath", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setEncodedQuery(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedQuery(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedQuery_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedQuery", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedQueryItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QPair<QByteArray, QByteArray > >  >::isConvertible(arg)) {
        QList<QPair<QByteArray, QByteArray > >  cpp_arg0 = Shiboken::Converter<QList<QPair<QByteArray, QByteArray > >  >::toCpp(arg);
        // setEncodedQueryItems(QList<QPair<QByteArray,QByteArray> >)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedQueryItems(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedQueryItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedQueryItems_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedQueryItems", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedUrl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEncodedUrl", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // setEncodedUrl(QByteArray)
            QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
            cppSelf->QUrl::setEncodedUrl(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QUrl::ParsingMode >::isConvertible(pyargs[1])) {
            QUrl::ParsingMode cpp_arg1 = Shiboken::Converter<QUrl::ParsingMode >::toCpp(pyargs[1]);
            // setEncodedUrl(QByteArray,QUrl::ParsingMode)
            QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
            cppSelf->QUrl::setEncodedUrl(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQUrlFunc_setEncodedUrl_TypeError;
    } else goto SbkQUrlFunc_setEncodedUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QByteArray, PySide.QtCore.QUrl.ParsingMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.setEncodedUrl", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setEncodedUserName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setEncodedUserName(QByteArray)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setEncodedUserName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setEncodedUserName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setEncodedUserName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setEncodedUserName", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setFragment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFragment(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setFragment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setFragment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setFragment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setFragment", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setHost(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHost(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setHost(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setHost_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setHost_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setHost", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setIdnWhitelist(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setIdnWhitelist(QStringList)
        QUrl::setIdnWhitelist(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setIdnWhitelist_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setIdnWhitelist_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setIdnWhitelist", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setPassword(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPassword(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setPassword(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setPassword_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setPassword_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setPassword", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPath(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setPath", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setPort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPort(int)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setPort(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setPort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setPort_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setPort", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setQueryDelimiters(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setQueryDelimiters", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char >::isConvertible(pyargs[0]) && Shiboken::Converter<char >::isConvertible(pyargs[1])) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(pyargs[0]);
        char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
        // setQueryDelimiters(char,char)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setQueryDelimiters(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setQueryDelimiters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setQueryDelimiters_TypeError:
        const char* overloads[] = {"char, char", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.setQueryDelimiters", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setQueryItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QPair<QString, QString > >  >::isConvertible(arg)) {
        QList<QPair<QString, QString > >  cpp_arg0 = Shiboken::Converter<QList<QPair<QString, QString > >  >::toCpp(arg);
        // setQueryItems(QList<QPair<QString,QString> >)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setQueryItems(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setQueryItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setQueryItems_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setQueryItems", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setScheme(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setScheme(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setScheme(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setScheme_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setScheme_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setScheme", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setUrl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setUrl", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setUrl(QString)
            QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
            cppSelf->QUrl::setUrl(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QUrl::ParsingMode >::isConvertible(pyargs[1])) {
            QUrl::ParsingMode cpp_arg1 = Shiboken::Converter<QUrl::ParsingMode >::toCpp(pyargs[1]);
            // setUrl(QString,QUrl::ParsingMode)
            QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
            cppSelf->QUrl::setUrl(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQUrlFunc_setUrl_TypeError;
    } else goto SbkQUrlFunc_setUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QUrl.ParsingMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.setUrl", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setUserInfo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setUserInfo(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setUserInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setUserInfo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setUserInfo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setUserInfo", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_setUserName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setUserName(QString)
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        cppSelf->QUrl::setUserName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_setUserName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlFunc_setUserName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.setUserName", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_toAce(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toAce(QString)
        QByteArray cpp_result = QUrl::toAce(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_toAce_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_toAce_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.toAce", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_toEncoded(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toEncoded(QFlags<QUrl::FormattingOption>)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QUrl::toEncoded();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtCore_QUrl_FormattingOption_Check(arg)) {
        QFlags<QUrl::FormattingOption> cpp_arg0 = Shiboken::Converter<QFlags<QUrl::FormattingOption> >::toCpp(arg);
        // toEncoded(QFlags<QUrl::FormattingOption>)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QUrl::toEncoded(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_toEncoded_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_toEncoded_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl.FormattingOptions = QUrl.None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.toEncoded", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_toLocalFile(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toLocalFile()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::toLocalFile();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_toPercentEncoding(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "toPercentEncoding", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toPercentEncoding(QString,QByteArray,QByteArray)
            QByteArray cpp_result = QUrl::toPercentEncoding(*cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // toPercentEncoding(QString,QByteArray,QByteArray)
                QByteArray cpp_result = QUrl::toPercentEncoding(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QByteArray > cpp_arg2_auto_ptr;
                QByteArray* cpp_arg2 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[2]);
                if (!SbkQByteArray_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg2);
                // toPercentEncoding(QString,QByteArray,QByteArray)
                QByteArray cpp_result = QUrl::toPercentEncoding(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQUrlFunc_toPercentEncoding_TypeError;
        } else goto SbkQUrlFunc_toPercentEncoding_TypeError;
    } else goto SbkQUrlFunc_toPercentEncoding_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_toPercentEncoding_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QByteArray = QByteArray(), PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUrl.toPercentEncoding", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_toPunycode(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toPunycode(QString)
        QByteArray cpp_result = QUrl::toPunycode(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_toPunycode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_toPunycode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.toPunycode", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_toString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toString(QFlags<QUrl::FormattingOption>)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QUrl::toString();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtCore_QUrl_FormattingOption_Check(arg)) {
        QFlags<QUrl::FormattingOption> cpp_arg0 = Shiboken::Converter<QFlags<QUrl::FormattingOption> >::toCpp(arg);
        // toString(QFlags<QUrl::FormattingOption>)const
        QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QUrl::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUrlFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUrlFunc_toString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl.FormattingOptions = QUrl.None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QUrl.toString", overloads);
        return 0;
}

static PyObject* SbkQUrlFunc_userInfo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userInfo()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::userInfo();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUrlFunc_userName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userName()const
    QUrl* cppSelf = Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrl::userName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQUrl_methods[] = {
    {"addEncodedQueryItem", (PyCFunction)SbkQUrlFunc_addEncodedQueryItem, METH_VARARGS},
    {"addQueryItem", (PyCFunction)SbkQUrlFunc_addQueryItem, METH_VARARGS},
    {"allEncodedQueryItemValues", (PyCFunction)SbkQUrlFunc_allEncodedQueryItemValues, METH_O},
    {"allQueryItemValues", (PyCFunction)SbkQUrlFunc_allQueryItemValues, METH_O},
    {"authority", (PyCFunction)SbkQUrlFunc_authority, METH_NOARGS},
    {"clear", (PyCFunction)SbkQUrlFunc_clear, METH_NOARGS},
    {"encodedFragment", (PyCFunction)SbkQUrlFunc_encodedFragment, METH_NOARGS},
    {"encodedHost", (PyCFunction)SbkQUrlFunc_encodedHost, METH_NOARGS},
    {"encodedPassword", (PyCFunction)SbkQUrlFunc_encodedPassword, METH_NOARGS},
    {"encodedPath", (PyCFunction)SbkQUrlFunc_encodedPath, METH_NOARGS},
    {"encodedQuery", (PyCFunction)SbkQUrlFunc_encodedQuery, METH_NOARGS},
    {"encodedQueryItemValue", (PyCFunction)SbkQUrlFunc_encodedQueryItemValue, METH_O},
    {"encodedQueryItems", (PyCFunction)SbkQUrlFunc_encodedQueryItems, METH_NOARGS},
    {"encodedUserName", (PyCFunction)SbkQUrlFunc_encodedUserName, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQUrlFunc_errorString, METH_NOARGS},
    {"fragment", (PyCFunction)SbkQUrlFunc_fragment, METH_NOARGS},
    {"fromAce", (PyCFunction)SbkQUrlFunc_fromAce, METH_O|METH_STATIC},
    {"fromEncoded", (PyCFunction)SbkQUrlFunc_fromEncoded, METH_VARARGS|METH_STATIC},
    {"fromLocalFile", (PyCFunction)SbkQUrlFunc_fromLocalFile, METH_O|METH_STATIC},
    {"fromPercentEncoding", (PyCFunction)SbkQUrlFunc_fromPercentEncoding, METH_O|METH_STATIC},
    {"fromPunycode", (PyCFunction)SbkQUrlFunc_fromPunycode, METH_O|METH_STATIC},
    {"fromUserInput", (PyCFunction)SbkQUrlFunc_fromUserInput, METH_O|METH_STATIC},
    {"hasEncodedQueryItem", (PyCFunction)SbkQUrlFunc_hasEncodedQueryItem, METH_O},
    {"hasFragment", (PyCFunction)SbkQUrlFunc_hasFragment, METH_NOARGS},
    {"hasQuery", (PyCFunction)SbkQUrlFunc_hasQuery, METH_NOARGS},
    {"hasQueryItem", (PyCFunction)SbkQUrlFunc_hasQueryItem, METH_O},
    {"host", (PyCFunction)SbkQUrlFunc_host, METH_NOARGS},
    {"idnWhitelist", (PyCFunction)SbkQUrlFunc_idnWhitelist, METH_NOARGS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQUrlFunc_isEmpty, METH_NOARGS},
    {"isParentOf", (PyCFunction)SbkQUrlFunc_isParentOf, METH_O},
    {"isRelative", (PyCFunction)SbkQUrlFunc_isRelative, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQUrlFunc_isValid, METH_NOARGS},
    {"password", (PyCFunction)SbkQUrlFunc_password, METH_NOARGS},
    {"path", (PyCFunction)SbkQUrlFunc_path, METH_NOARGS},
    {"port", (PyCFunction)SbkQUrlFunc_port, METH_NOARGS|METH_O},
    {"queryItemValue", (PyCFunction)SbkQUrlFunc_queryItemValue, METH_O},
    {"queryItems", (PyCFunction)SbkQUrlFunc_queryItems, METH_NOARGS},
    {"queryPairDelimiter", (PyCFunction)SbkQUrlFunc_queryPairDelimiter, METH_NOARGS},
    {"queryValueDelimiter", (PyCFunction)SbkQUrlFunc_queryValueDelimiter, METH_NOARGS},
    {"removeAllEncodedQueryItems", (PyCFunction)SbkQUrlFunc_removeAllEncodedQueryItems, METH_O},
    {"removeAllQueryItems", (PyCFunction)SbkQUrlFunc_removeAllQueryItems, METH_O},
    {"removeEncodedQueryItem", (PyCFunction)SbkQUrlFunc_removeEncodedQueryItem, METH_O},
    {"removeQueryItem", (PyCFunction)SbkQUrlFunc_removeQueryItem, METH_O},
    {"resolved", (PyCFunction)SbkQUrlFunc_resolved, METH_O},
    {"scheme", (PyCFunction)SbkQUrlFunc_scheme, METH_NOARGS},
    {"setAuthority", (PyCFunction)SbkQUrlFunc_setAuthority, METH_O},
    {"setEncodedFragment", (PyCFunction)SbkQUrlFunc_setEncodedFragment, METH_O},
    {"setEncodedHost", (PyCFunction)SbkQUrlFunc_setEncodedHost, METH_O},
    {"setEncodedPassword", (PyCFunction)SbkQUrlFunc_setEncodedPassword, METH_O},
    {"setEncodedPath", (PyCFunction)SbkQUrlFunc_setEncodedPath, METH_O},
    {"setEncodedQuery", (PyCFunction)SbkQUrlFunc_setEncodedQuery, METH_O},
    {"setEncodedQueryItems", (PyCFunction)SbkQUrlFunc_setEncodedQueryItems, METH_O},
    {"setEncodedUrl", (PyCFunction)SbkQUrlFunc_setEncodedUrl, METH_VARARGS},
    {"setEncodedUserName", (PyCFunction)SbkQUrlFunc_setEncodedUserName, METH_O},
    {"setFragment", (PyCFunction)SbkQUrlFunc_setFragment, METH_O},
    {"setHost", (PyCFunction)SbkQUrlFunc_setHost, METH_O},
    {"setIdnWhitelist", (PyCFunction)SbkQUrlFunc_setIdnWhitelist, METH_O|METH_STATIC},
    {"setPassword", (PyCFunction)SbkQUrlFunc_setPassword, METH_O},
    {"setPath", (PyCFunction)SbkQUrlFunc_setPath, METH_O},
    {"setPort", (PyCFunction)SbkQUrlFunc_setPort, METH_O},
    {"setQueryDelimiters", (PyCFunction)SbkQUrlFunc_setQueryDelimiters, METH_VARARGS},
    {"setQueryItems", (PyCFunction)SbkQUrlFunc_setQueryItems, METH_O},
    {"setScheme", (PyCFunction)SbkQUrlFunc_setScheme, METH_O},
    {"setUrl", (PyCFunction)SbkQUrlFunc_setUrl, METH_VARARGS},
    {"setUserInfo", (PyCFunction)SbkQUrlFunc_setUserInfo, METH_O},
    {"setUserName", (PyCFunction)SbkQUrlFunc_setUserName, METH_O},
    {"toAce", (PyCFunction)SbkQUrlFunc_toAce, METH_O|METH_STATIC},
    {"toEncoded", (PyCFunction)SbkQUrlFunc_toEncoded, METH_NOARGS|METH_O},
    {"toLocalFile", (PyCFunction)SbkQUrlFunc_toLocalFile, METH_NOARGS},
    {"toPercentEncoding", (PyCFunction)SbkQUrlFunc_toPercentEncoding, METH_VARARGS|METH_STATIC},
    {"toPunycode", (PyCFunction)SbkQUrlFunc_toPunycode, METH_O|METH_STATIC},
    {"toString", (PyCFunction)SbkQUrlFunc_toString, METH_NOARGS|METH_O},
    {"userInfo", (PyCFunction)SbkQUrlFunc_userInfo, METH_NOARGS},
    {"userName", (PyCFunction)SbkQUrlFunc_userName, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQUrl_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QUrl& cpp_self = *Shiboken::Converter<QUrl* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QUrl & >::isConvertible(other)) {
                // operator!=(const QUrl & url) const
                QUrl* cpp_other = Shiboken::Converter<QUrl* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUrl  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QUrl >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUrl > cpp_other_auto_ptr;
                QUrl* cpp_other = Shiboken::Converter<QUrl* >::toCpp(other);
                if (!SbkQUrl_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUrl >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQUrl_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QUrl & >::isConvertible(other)) {
                // operator<(const QUrl & url) const
                QUrl* cpp_other = Shiboken::Converter<QUrl* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUrl  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QUrl >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUrl > cpp_other_auto_ptr;
                QUrl* cpp_other = Shiboken::Converter<QUrl* >::toCpp(other);
                if (!SbkQUrl_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUrl >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQUrl_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QUrl & >::isConvertible(other)) {
                // operator==(const QUrl & url) const
                QUrl* cpp_other = Shiboken::Converter<QUrl* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUrl  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QUrl >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUrl > cpp_other_auto_ptr;
                QUrl* cpp_other = Shiboken::Converter<QUrl* >::toCpp(other);
                if (!SbkQUrl_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUrl >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQUrl_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQUrl_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQUrl_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QUrl",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQUrl_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQUrl_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQUrl_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QUrl >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QUrl_ParsingMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QUrl_ParsingMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QUrl_ParsingMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ParsingMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QUrl_ParsingMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QUrl_ParsingMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QUrl_ParsingMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_QUrl_FormattingOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QUrl::FormattingOptions >::toPython(
        ((QUrl::FormattingOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QUrl::FormattingOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QUrl_FormattingOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QUrl::FormattingOptions >::toPython(
        ((QUrl::FormattingOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QUrl::FormattingOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QUrl_FormattingOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QUrl::FormattingOptions >::toPython(
        ((QUrl::FormattingOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QUrl::FormattingOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QUrl_FormattingOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QUrl::FormattingOptions >::toPython(
        ~ Shiboken::Converter< QUrl::FormattingOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QUrl_FormattingOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QUrl_FormattingOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QUrl_FormattingOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QUrl_FormattingOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QUrl_FormattingOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QUrl_FormattingOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QUrl_FormattingOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QUrl_FormattingOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FormattingOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QUrl_FormattingOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QUrl_FormattingOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QUrl_FormattingOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QUrl_FormattingOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QUrl_FormattingOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QUrl_FormattingOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FormattingOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QUrl_FormattingOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QUrl_FormattingOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QUrl_FormattingOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QUrl_FormattingOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QUrl(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QURL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQUrl_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQUrl_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQUrl_Type));
    PyModule_AddObject(module, "QUrl",
        ((PyObject*)&SbkQUrl_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ParsingMode
    SbkPySide_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX] = &SbkPySide_QtCore_QUrl_ParsingMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QUrl_ParsingMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QUrl_ParsingMode_Type);
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
            "ParsingMode",((PyObject*)&SbkPySide_QtCore_QUrl_ParsingMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_ParsingMode_Type,
        (long) QUrl::TolerantMode, "TolerantMode");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "TolerantMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_ParsingMode_Type.tp_dict,
        "TolerantMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_ParsingMode_Type,
        (long) QUrl::StrictMode, "StrictMode");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "StrictMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_ParsingMode_Type.tp_dict,
        "StrictMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QUrl::ParsingMode");

    // init enum class: FormattingOption
    SbkPySide_QtCoreTypes[SBK_QURL_FORMATTINGOPTION_IDX] = &SbkPySide_QtCore_QUrl_FormattingOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QUrl_FormattingOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QUrl_FormattingOption_Type);
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
            "FormattingOption",((PyObject*)&SbkPySide_QtCore_QUrl_FormattingOption_Type));

    // init flags class: QFlags<QUrl::FormattingOption>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QURL_FORMATTINGOPTION__IDX] = &SbkPySide_QtCore_QUrl_FormattingOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QUrl_FormattingOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QUrl_FormattingOptions_Type);
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
            "FormattingOptions",((PyObject*)&SbkPySide_QtCore_QUrl_FormattingOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::None, "None");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemoveScheme, "RemoveScheme");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemoveScheme", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemoveScheme", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemovePassword, "RemovePassword");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemovePassword", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemovePassword", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemoveUserInfo, "RemoveUserInfo");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemoveUserInfo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemoveUserInfo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemovePort, "RemovePort");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemovePort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemovePort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemoveAuthority, "RemoveAuthority");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemoveAuthority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemoveAuthority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemovePath, "RemovePath");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemovePath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemovePath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemoveQuery, "RemoveQuery");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemoveQuery", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemoveQuery", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::RemoveFragment, "RemoveFragment");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "RemoveFragment", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "RemoveFragment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUrl_FormattingOption_Type,
        (long) QUrl::StripTrailingSlash, "StripTrailingSlash");
    PyDict_SetItemString(SbkQUrl_Type.super.ht_type.tp_dict,
        "StripTrailingSlash", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUrl_FormattingOption_Type.tp_dict,
        "StripTrailingSlash", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QUrl::FormattingOption");

    Shiboken::TypeResolver::createValueTypeResolver<QUrl >("QUrl");
    Shiboken::TypeResolver::createValueTypeResolver<QUrl >(typeid(QUrl).name());
}


} // extern "C"

