/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtcore_python.h"

#include <qbytearray.h>
#include <qmath.h>
#include <qnumeric.h>
#include <qglobal.h>

    // Begin code injection
    
    extern bool
    qRegisterResourceData(int,
                        const unsigned char *,
                        const unsigned char *,
                        const unsigned char *);
    
    extern bool
    qUnregisterResourceData(int,
                            const unsigned char *,
                            const unsigned char *,
                            const unsigned char *);
    
    // End of code injection

// Global functions ------------------------------------------------------------
static PyObject* SbkQtCoreModule_QT_TRANSLATE_NOOP(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // QT_TRANSLATE_NOOP(const char*)
        // Begin code injection
        (void)cpp_arg0;py_result = arg;
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_QT_TRANSLATE_NOOP_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_QT_TRANSLATE_NOOP_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QT_TRANSLATE_NOOP", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // QT_TRANSLATE_NOOP_UTF8(const char*)
        // Begin code injection
        (void)cpp_arg0;py_result = arg;
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QT_TRANSLATE_NOOP_UTF8", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_QT_TR_NOOP(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // QT_TR_NOOP(const char*)
        // Begin code injection
        (void)cpp_arg0;py_result = arg;
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_QT_TR_NOOP_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_QT_TR_NOOP_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QT_TR_NOOP", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_QT_TR_NOOP_UTF8(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // QT_TR_NOOP_UTF8(const char*)
        // Begin code injection
        (void)cpp_arg0;py_result = arg;
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_QT_TR_NOOP_UTF8_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_QT_TR_NOOP_UTF8_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QT_TR_NOOP_UTF8", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_SIGNAL(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // SIGNAL(const char*)
        // Begin code injection
        
        py_result = PyString_FromFormat("2%s", QMetaObject::normalizedSignature(cpp_arg0).constData());
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_SIGNAL_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_SIGNAL_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "SIGNAL", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_SLOT(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // SLOT(const char*)
        // Begin code injection
        
        py_result = PyString_FromFormat("1%s", QMetaObject::normalizedSignature(cpp_arg0).constData());
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_SLOT_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_SLOT_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "SLOT", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qAbs(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        long cpp_arg0 = Shiboken::Converter<long >::toCpp(arg);
        // qAbs(long)
        // Begin code injection
        
        py_result = Shiboken::Converter<long >::toPython(qAbs(cpp_arg0));
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qAbs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qAbs_TypeError:
        const char* overloads[] = {"long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qAbs", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qAcos(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qAcos(qreal)
        qreal cpp_result = qAcos(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qAcos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qAcos_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qAcos", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qAsin(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qAsin(qreal)
        qreal cpp_result = qAsin(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qAsin_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qAsin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qAsin", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qAtan(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qAtan(qreal)
        qreal cpp_result = qAtan(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qAtan_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qAtan_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qAtan", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qAtan2(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "qAtan2", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // qAtan2(qreal,qreal)
        qreal cpp_result = qAtan2(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qAtan2_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qAtan2_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qAtan2", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qChecksum(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "qChecksum", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        uint cpp_arg1 = Shiboken::Converter<uint >::toCpp(pyargs[1]);
        // qChecksum(const char*,uint)
        quint16 cpp_result = qChecksum(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<unsigned short >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qChecksum_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qChecksum_TypeError:
        const char* overloads[] = {"str, unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qChecksum", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qCritical(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // qCritical(const char*)
        qCritical(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qCritical_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qCritical_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qCritical", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qDebug(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // qDebug(const char*)
        qDebug(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qDebug_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qDebug_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qDebug", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qExp(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qExp(qreal)
        qreal cpp_result = qExp(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qExp_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qExp_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qExp", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qFabs(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qFabs(qreal)
        qreal cpp_result = qFabs(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qFabs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qFabs_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qFabs", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qFastCos(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qFastCos(qreal)
        qreal cpp_result = qFastCos(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qFastCos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qFastCos_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qFastCos", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qFastSin(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qFastSin(qreal)
        qreal cpp_result = qFastSin(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qFastSin_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qFastSin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qFastSin", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qFatal(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // qFatal(const char*)
        qFatal(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qFatal_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qFatal_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qFatal", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qFuzzyCompare(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "qFuzzyCompare", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
        // qFuzzyCompare(double,double)
        bool cpp_result = qFuzzyCompare(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qFuzzyCompare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qFuzzyCompare_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qFuzzyCompare", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qFuzzyIsNull(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // qFuzzyIsNull(double)
        bool cpp_result = qFuzzyIsNull(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qFuzzyIsNull_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qFuzzyIsNull_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qFuzzyIsNull", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qIsFinite(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // qIsFinite(double)
        bool cpp_result = qIsFinite(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qIsFinite_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qIsFinite_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qIsFinite", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qIsInf(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // qIsInf(double)
        bool cpp_result = qIsInf(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qIsInf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qIsInf_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qIsInf", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qIsNaN(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // qIsNaN(double)
        bool cpp_result = qIsNaN(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qIsNaN_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qIsNaN_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qIsNaN", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qIsNull(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // qIsNull(double)
        bool cpp_result = qIsNull(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qIsNull_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qIsNull_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qIsNull", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qRegisterResourceData(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qRegisterResourceData", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2]) && Shiboken::Converter<const char * >::isConvertible(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
        // qRegisterResourceData(int,const char*,const char*,const char*)
        // Begin code injection
        
        py_result = Shiboken::Converter<bool >::toPython(qRegisterResourceData(cpp_arg0, (uchar*)cpp_arg1, (uchar*)cpp_arg2, (uchar*)cpp_arg3));
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qRegisterResourceData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qRegisterResourceData_TypeError:
        const char* overloads[] = {"int, str, str, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qRegisterResourceData", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qRound(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qRound(qreal)
        int cpp_result = qRound(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qRound_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qRound_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qRound", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qTan(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // qTan(qreal)
        qreal cpp_result = qTan(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qTan_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qTan_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qTan", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qUnregisterResourceData(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qUnregisterResourceData", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2]) && Shiboken::Converter<const char * >::isConvertible(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
        // qUnregisterResourceData(int,const char*,const char*,const char*)
        // Begin code injection
        
        py_result = Shiboken::Converter<bool >::toPython(qUnregisterResourceData(cpp_arg0, (uchar*)cpp_arg1, (uchar*)cpp_arg2, (uchar*)cpp_arg3));
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qUnregisterResourceData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQtCoreModule_qUnregisterResourceData_TypeError:
        const char* overloads[] = {"int, str, str, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qUnregisterResourceData", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qVersion(PyObject* self)
{
    PyObject* py_result = 0;

    // qVersion()
    const char * cpp_result = qVersion();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQtCoreModule_qWarning(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // qWarning(const char*)
        qWarning(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qWarning_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qWarning_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qWarning", overloads);
        return 0;
}

static PyObject* SbkQtCoreModule_qrand(PyObject* self)
{
    PyObject* py_result = 0;

    // qrand()
    int cpp_result = qrand();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQtCoreModule_qsrand(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // qsrand(uint)
        qsrand(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQtCoreModule_qsrand_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtCoreModule_qsrand_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qsrand", overloads);
        return 0;
}


static PyMethodDef QtCore_methods[] = {
    {"QT_TRANSLATE_NOOP", (PyCFunction)SbkQtCoreModule_QT_TRANSLATE_NOOP, METH_O},
    {"QT_TRANSLATE_NOOP_UTF8", (PyCFunction)SbkQtCoreModule_QT_TRANSLATE_NOOP_UTF8, METH_O},
    {"QT_TR_NOOP", (PyCFunction)SbkQtCoreModule_QT_TR_NOOP, METH_O},
    {"QT_TR_NOOP_UTF8", (PyCFunction)SbkQtCoreModule_QT_TR_NOOP_UTF8, METH_O},
    {"SIGNAL", (PyCFunction)SbkQtCoreModule_SIGNAL, METH_O},
    {"SLOT", (PyCFunction)SbkQtCoreModule_SLOT, METH_O},
    {"qAbs", (PyCFunction)SbkQtCoreModule_qAbs, METH_O},
    {"qAcos", (PyCFunction)SbkQtCoreModule_qAcos, METH_O},
    {"qAsin", (PyCFunction)SbkQtCoreModule_qAsin, METH_O},
    {"qAtan", (PyCFunction)SbkQtCoreModule_qAtan, METH_O},
    {"qAtan2", (PyCFunction)SbkQtCoreModule_qAtan2, METH_VARARGS},
    {"qChecksum", (PyCFunction)SbkQtCoreModule_qChecksum, METH_VARARGS},
    {"qCritical", (PyCFunction)SbkQtCoreModule_qCritical, METH_O},
    {"qDebug", (PyCFunction)SbkQtCoreModule_qDebug, METH_O},
    {"qExp", (PyCFunction)SbkQtCoreModule_qExp, METH_O},
    {"qFabs", (PyCFunction)SbkQtCoreModule_qFabs, METH_O},
    {"qFastCos", (PyCFunction)SbkQtCoreModule_qFastCos, METH_O},
    {"qFastSin", (PyCFunction)SbkQtCoreModule_qFastSin, METH_O},
    {"qFatal", (PyCFunction)SbkQtCoreModule_qFatal, METH_O},
    {"qFuzzyCompare", (PyCFunction)SbkQtCoreModule_qFuzzyCompare, METH_VARARGS},
    {"qFuzzyIsNull", (PyCFunction)SbkQtCoreModule_qFuzzyIsNull, METH_O},
    {"qIsFinite", (PyCFunction)SbkQtCoreModule_qIsFinite, METH_O},
    {"qIsInf", (PyCFunction)SbkQtCoreModule_qIsInf, METH_O},
    {"qIsNaN", (PyCFunction)SbkQtCoreModule_qIsNaN, METH_O},
    {"qIsNull", (PyCFunction)SbkQtCoreModule_qIsNull, METH_O},
    {"qRegisterResourceData", (PyCFunction)SbkQtCoreModule_qRegisterResourceData, METH_VARARGS},
    {"qRound", (PyCFunction)SbkQtCoreModule_qRound, METH_O},
    {"qTan", (PyCFunction)SbkQtCoreModule_qTan, METH_O},
    {"qUnregisterResourceData", (PyCFunction)SbkQtCoreModule_qUnregisterResourceData, METH_VARARGS},
    {"qVersion", (PyCFunction)SbkQtCoreModule_qVersion, METH_NOARGS},
    {"qWarning", (PyCFunction)SbkQtCoreModule_qWarning, METH_O},
    {"qrand", (PyCFunction)SbkQtCoreModule_qrand, METH_NOARGS},
    {"qsrand", (PyCFunction)SbkQtCoreModule_qsrand, METH_O},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QtConcurrent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Qt(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamEntityDeclaration(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMetaEnum(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRegExp(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QModelIndex(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamNotationDeclaration(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFactoryInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamNamespaceDeclaration(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSemaphore(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QBitArray(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractFileEngineHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGenericArgument(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStringList(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPointF(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMutex(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QVariant(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFileSystemWatcher(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractEventDispatcher(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractAnimation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QVariantAnimation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPauseAnimation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSignalMapper(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUuid(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFileInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractTransition(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractFileEngineIterator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QEventTransition(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractFileEngine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSystemLocale(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSysInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QByteArray(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamAttributes(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QByteArrayMatcher(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGenericReturnArgument(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSignalTransition(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDynamicPropertyChangeEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QChildEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMetaObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamAttribute(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDataStream(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLatin1Char(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QBasicTimer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QReadLocker(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamEntityResolver(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStringMatcher(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDate(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRectF(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSize(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextStreamManipulator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTimer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextBoundaryFinder(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextEncoder(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractItemModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractListModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractTableModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMetaClassInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QEasingCurve(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMargins(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCryptographicHash(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextCodec(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextCodec_ConverterState(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMetaProperty(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTime(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIODevice(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFile(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QProcess(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QBuffer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSystemSemaphore(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextStream(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPoint(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMutexLocker(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLibraryInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPersistentModelIndex(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLocale(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAnimationGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QParallelAnimationGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSequentialAnimationGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractState(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFinalState(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSocketNotifier(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUrl(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QChar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWriteLocker(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLineF(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QThread(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTimeLine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLatin1String(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMimeData(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDateTime(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStringRef(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QEventLoop(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCoreApplication(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHistoryState(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSizeF(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTemporaryFile(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWaitCondition(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPropertyAnimation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QString(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamWriter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDir(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDirIterator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QResource(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFSFileEngine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTranslator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlStreamReader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QProcessEnvironment(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSettings(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTimerEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QReadWriteLock(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QState(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStateMachine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStateMachine_WrappedEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStateMachine_SignalEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextDecoder(PyObject* module);

// Enum definitions ------------------------------------------------------------
static PyGetSetDef SbkPySide_QtCore_QtValidLicenseForOpenVGModule_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QtValidLicenseForOpenVGModule_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtValidLicenseForOpenVGModule",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QtValidLicenseForOpenVGModule_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QtValidLicenseForOpenVGModule_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QtValidLicenseForOpenVGModule_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_QtValidLicenseForMultimediaModule_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QtValidLicenseForMultimediaModule_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtValidLicenseForMultimediaModule",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QtValidLicenseForMultimediaModule_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QtValidLicenseForMultimediaModule_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QtValidLicenseForMultimediaModule_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_QtMsgType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QtMsgType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QtMsgType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMsgType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QtMsgType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QtMsgType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QtMsgType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTCORE_API PyMODINIT_FUNC
initQtCore()
{

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtCore", QtCore_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtCore_IDX_COUNT];
    SbkPySide_QtCoreTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QtConcurrent(module);
    init_Qt(module);
    init_QXmlStreamEntityDeclaration(module);
    init_QMetaEnum(module);
    init_QRegExp(module);
    init_QModelIndex(module);
    init_QXmlStreamNotationDeclaration(module);
    init_QFactoryInterface(module);
    init_QXmlStreamNamespaceDeclaration(module);
    init_QSemaphore(module);
    init_QBitArray(module);
    init_QAbstractFileEngineHandler(module);
    init_QGenericArgument(module);
    init_QStringList(module);
    init_QPointF(module);
    init_QMutex(module);
    init_QVariant(module);
    init_QObject(module);
    init_QFileSystemWatcher(module);
    init_QAbstractEventDispatcher(module);
    init_QAbstractAnimation(module);
    init_QVariantAnimation(module);
    init_QPauseAnimation(module);
    init_QSignalMapper(module);
    init_QUuid(module);
    init_QRect(module);
    init_QFileInfo(module);
    init_QAbstractTransition(module);
    init_QAbstractFileEngineIterator(module);
    init_QEventTransition(module);
    init_QAbstractFileEngine(module);
    init_QSystemLocale(module);
    init_QSysInfo(module);
    init_QByteArray(module);
    init_QXmlStreamAttributes(module);
    init_QByteArrayMatcher(module);
    init_QGenericReturnArgument(module);
    init_QSignalTransition(module);
    init_QEvent(module);
    init_QDynamicPropertyChangeEvent(module);
    init_QChildEvent(module);
    init_QMetaObject(module);
    init_QXmlStreamAttribute(module);
    init_QDataStream(module);
    init_QLatin1Char(module);
    init_QBasicTimer(module);
    init_QReadLocker(module);
    init_QXmlStreamEntityResolver(module);
    init_QStringMatcher(module);
    init_QDate(module);
    init_QRectF(module);
    init_QSize(module);
    init_QTextStreamManipulator(module);
    init_QTimer(module);
    init_QTextBoundaryFinder(module);
    init_QTextEncoder(module);
    init_QAbstractItemModel(module);
    init_QAbstractListModel(module);
    init_QAbstractTableModel(module);
    init_QMetaClassInfo(module);
    init_QEasingCurve(module);
    init_QLine(module);
    init_QMargins(module);
    init_QCryptographicHash(module);
    init_QTextCodec(module);
    init_QTextCodec_ConverterState(SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_IDX]->tp_dict);
    init_QMetaProperty(module);
    init_QTime(module);
    init_QIODevice(module);
    init_QFile(module);
    init_QProcess(module);
    init_QBuffer(module);
    init_QSystemSemaphore(module);
    init_QTextStream(module);
    init_QPoint(module);
    init_QMutexLocker(module);
    init_QLibraryInfo(module);
    init_QPersistentModelIndex(module);
    init_QLocale(module);
    init_QAnimationGroup(module);
    init_QParallelAnimationGroup(module);
    init_QSequentialAnimationGroup(module);
    init_QAbstractState(module);
    init_QFinalState(module);
    init_QSocketNotifier(module);
    init_QUrl(module);
    init_QChar(module);
    init_QWriteLocker(module);
    init_QLineF(module);
    init_QThread(module);
    init_QTimeLine(module);
    init_QLatin1String(module);
    init_QMimeData(module);
    init_QDateTime(module);
    init_QStringRef(module);
    init_QEventLoop(module);
    init_QCoreApplication(module);
    init_QHistoryState(module);
    init_QSizeF(module);
    init_QTemporaryFile(module);
    init_QWaitCondition(module);
    init_QPropertyAnimation(module);
    init_QString(module);
    init_QXmlStreamWriter(module);
    init_QDir(module);
    init_QDirIterator(module);
    init_QResource(module);
    init_QFSFileEngine(module);
    init_QTranslator(module);
    init_QXmlStreamReader(module);
    init_QProcessEnvironment(module);
    init_QSettings(module);
    init_QTimerEvent(module);
    init_QReadWriteLock(module);
    init_QState(module);
    init_QStateMachine(module);
    init_QStateMachine_WrappedEvent(SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_IDX]->tp_dict);
    init_QStateMachine_SignalEvent(SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_IDX]->tp_dict);
    init_QTextDecoder(module);

    // Initialize enums
    PyObject* enum_item;

    // init enum class: QtValidLicenseForOpenVGModule
    SbkPySide_QtCoreTypes[SBK_QTVALIDLICENSEFOROPENVGMODULE_IDX] = &SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type);
    PyModule_AddObject(module,
            "QtValidLicenseForOpenVGModule",((PyObject*)&SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type,
        (long) LicensedOpenVG, "LicensedOpenVG");
    PyModule_AddObject(module,
        "LicensedOpenVG", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Type.tp_dict,
        "LicensedOpenVG", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtValidLicenseForOpenVGModule");

    // init enum class: QtValidLicenseForMultimediaModule
    SbkPySide_QtCoreTypes[SBK_QTVALIDLICENSEFORMULTIMEDIAMODULE_IDX] = &SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type);
    PyModule_AddObject(module,
            "QtValidLicenseForMultimediaModule",((PyObject*)&SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type,
        (long) LicensedMultimedia, "LicensedMultimedia");
    PyModule_AddObject(module,
        "LicensedMultimedia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Type.tp_dict,
        "LicensedMultimedia", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtValidLicenseForMultimediaModule");

    // init enum class: QtMsgType
    SbkPySide_QtCoreTypes[SBK_QTMSGTYPE_IDX] = &SbkPySide_QtCore_QtMsgType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QtMsgType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QtMsgType_Type);
    PyModule_AddObject(module,
            "QtMsgType",((PyObject*)&SbkPySide_QtCore_QtMsgType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtMsgType_Type,
        (long) QtDebugMsg, "QtDebugMsg");
    PyModule_AddObject(module,
        "QtDebugMsg", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtMsgType_Type.tp_dict,
        "QtDebugMsg", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtMsgType_Type,
        (long) QtWarningMsg, "QtWarningMsg");
    PyModule_AddObject(module,
        "QtWarningMsg", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtMsgType_Type.tp_dict,
        "QtWarningMsg", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtMsgType_Type,
        (long) QtCriticalMsg, "QtCriticalMsg");
    PyModule_AddObject(module,
        "QtCriticalMsg", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtMsgType_Type.tp_dict,
        "QtCriticalMsg", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtMsgType_Type,
        (long) QtFatalMsg, "QtFatalMsg");
    PyModule_AddObject(module,
        "QtFatalMsg", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtMsgType_Type.tp_dict,
        "QtFatalMsg", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtMsgType_Type,
        (long) QtSystemMsg, "QtSystemMsg");
    PyModule_AddObject(module,
        "QtSystemMsg", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtMsgType_Type.tp_dict,
        "QtSystemMsg", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMsgType");


    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtCore");
    }
}

} // extern "C"


