/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qregexp_wrapper.h"

// Extra includes
#include <QStringList>
#include <qregexp.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQRegExp_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QRegExp* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QRegExp", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QRegExp()
        cptr = new QRegExp();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
            cptr = new QRegExp(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
                cptr = new QRegExp(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QRegExp::PatternSyntax >::isConvertible(pyargs[2])) {
                QRegExp::PatternSyntax cpp_arg2 = Shiboken::Converter<QRegExp::PatternSyntax >::toCpp(pyargs[2]);
                // QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
                cptr = new QRegExp(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQRegExp_Init_TypeError;
        } else goto SbkQRegExp_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        // QRegExp(QRegExp)
        cptr = new QRegExp(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExp_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QRegExp >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQRegExp_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQRegExp_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QRegExp", "PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive, PySide.QtCore.QRegExp.PatternSyntax = RegExp", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRegExp", overloads);
        return -1;
}

static PyObject* SbkQRegExpFunc_cap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // cap(int)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QRegExp::cap();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // cap(int)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QRegExp::cap(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_cap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpFunc_cap_TypeError:
        const char* overloads[] = {"int = 0", "int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.cap", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_captureCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // captureCount()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRegExp::captureCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_capturedTexts(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capturedTexts()
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QRegExp::capturedTexts();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_caseSensitivity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // caseSensitivity()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    Qt::CaseSensitivity cpp_result = cppSelf->QRegExp::caseSensitivity();
    py_result = Shiboken::Converter<Qt::CaseSensitivity >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QRegExp::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_escape(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // escape(QString)
        QString cpp_result = QRegExp::escape(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_escape_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpFunc_escape_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.escape", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_exactMatch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // exactMatch(QString)const
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRegExp::exactMatch(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_exactMatch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpFunc_exactMatch_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.exactMatch", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_indexIn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "indexIn", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // indexIn(QString,int,QRegExp::CaretMode)const
            QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QRegExp::indexIn(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // indexIn(QString,int,QRegExp::CaretMode)const
                QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QRegExp::indexIn(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QRegExp::CaretMode >::isConvertible(pyargs[2])) {
                QRegExp::CaretMode cpp_arg2 = Shiboken::Converter<QRegExp::CaretMode >::toCpp(pyargs[2]);
                // indexIn(QString,int,QRegExp::CaretMode)const
                QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QRegExp::indexIn(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQRegExpFunc_indexIn_TypeError;
        } else goto SbkQRegExpFunc_indexIn_TypeError;
    } else goto SbkQRegExpFunc_indexIn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpFunc_indexIn_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int = 0, PySide.QtCore.QRegExp.CaretMode = CaretAtZero", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRegExp.indexIn", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRegExp::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_isMinimal(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMinimal()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRegExp::isMinimal();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRegExp::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_lastIndexIn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexIn", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // lastIndexIn(QString,int,QRegExp::CaretMode)const
            QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QRegExp::lastIndexIn(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // lastIndexIn(QString,int,QRegExp::CaretMode)const
                QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QRegExp::lastIndexIn(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QRegExp::CaretMode >::isConvertible(pyargs[2])) {
                QRegExp::CaretMode cpp_arg2 = Shiboken::Converter<QRegExp::CaretMode >::toCpp(pyargs[2]);
                // lastIndexIn(QString,int,QRegExp::CaretMode)const
                QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QRegExp::lastIndexIn(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQRegExpFunc_lastIndexIn_TypeError;
        } else goto SbkQRegExpFunc_lastIndexIn_TypeError;
    } else goto SbkQRegExpFunc_lastIndexIn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpFunc_lastIndexIn_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int = -1, PySide.QtCore.QRegExp.CaretMode = CaretAtZero", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRegExp.lastIndexIn", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_matchedLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // matchedLength()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRegExp::matchedLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_numCaptures(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numCaptures()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRegExp::numCaptures();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_pattern(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pattern()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QRegExp::pattern();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_patternSyntax(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // patternSyntax()const
    QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
    QRegExp::PatternSyntax cpp_result = cppSelf->QRegExp::patternSyntax();
    py_result = Shiboken::Converter<QRegExp::PatternSyntax >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpFunc_pos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // pos(int)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QRegExp::pos();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // pos(int)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QRegExp::pos(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_pos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpFunc_pos_TypeError:
        const char* overloads[] = {"int = 0", "int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.pos", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_setCaseSensitivity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(arg)) {
        Qt::CaseSensitivity cpp_arg0 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(arg);
        // setCaseSensitivity(Qt::CaseSensitivity)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        cppSelf->QRegExp::setCaseSensitivity(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_setCaseSensitivity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegExpFunc_setCaseSensitivity_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.setCaseSensitivity", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_setMinimal(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setMinimal(bool)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        cppSelf->QRegExp::setMinimal(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_setMinimal_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegExpFunc_setMinimal_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.setMinimal", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_setPattern(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPattern(QString)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        cppSelf->QRegExp::setPattern(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_setPattern_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegExpFunc_setPattern_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.setPattern", overloads);
        return 0;
}

static PyObject* SbkQRegExpFunc_setPatternSyntax(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRegExp::PatternSyntax >::isConvertible(arg)) {
        QRegExp::PatternSyntax cpp_arg0 = Shiboken::Converter<QRegExp::PatternSyntax >::toCpp(arg);
        // setPatternSyntax(QRegExp::PatternSyntax)
        QRegExp* cppSelf = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);
        cppSelf->QRegExp::setPatternSyntax(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpFunc_setPatternSyntax_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegExpFunc_setPatternSyntax_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp.PatternSyntax", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRegExp.setPatternSyntax", overloads);
        return 0;
}

static PyMethodDef SbkQRegExp_methods[] = {
    {"cap", (PyCFunction)SbkQRegExpFunc_cap, METH_NOARGS|METH_O},
    {"captureCount", (PyCFunction)SbkQRegExpFunc_captureCount, METH_NOARGS},
    {"capturedTexts", (PyCFunction)SbkQRegExpFunc_capturedTexts, METH_NOARGS},
    {"caseSensitivity", (PyCFunction)SbkQRegExpFunc_caseSensitivity, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQRegExpFunc_errorString, METH_NOARGS},
    {"escape", (PyCFunction)SbkQRegExpFunc_escape, METH_O|METH_STATIC},
    {"exactMatch", (PyCFunction)SbkQRegExpFunc_exactMatch, METH_O},
    {"indexIn", (PyCFunction)SbkQRegExpFunc_indexIn, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQRegExpFunc_isEmpty, METH_NOARGS},
    {"isMinimal", (PyCFunction)SbkQRegExpFunc_isMinimal, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQRegExpFunc_isValid, METH_NOARGS},
    {"lastIndexIn", (PyCFunction)SbkQRegExpFunc_lastIndexIn, METH_VARARGS},
    {"matchedLength", (PyCFunction)SbkQRegExpFunc_matchedLength, METH_NOARGS},
    {"numCaptures", (PyCFunction)SbkQRegExpFunc_numCaptures, METH_NOARGS},
    {"pattern", (PyCFunction)SbkQRegExpFunc_pattern, METH_NOARGS},
    {"patternSyntax", (PyCFunction)SbkQRegExpFunc_patternSyntax, METH_NOARGS},
    {"pos", (PyCFunction)SbkQRegExpFunc_pos, METH_NOARGS|METH_O},
    {"setCaseSensitivity", (PyCFunction)SbkQRegExpFunc_setCaseSensitivity, METH_O},
    {"setMinimal", (PyCFunction)SbkQRegExpFunc_setMinimal, METH_O},
    {"setPattern", (PyCFunction)SbkQRegExpFunc_setPattern, METH_O},
    {"setPatternSyntax", (PyCFunction)SbkQRegExpFunc_setPatternSyntax, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQRegExp_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QRegExp& cpp_self = *Shiboken::Converter<QRegExp* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QRegExp & >::isConvertible(other)) {
                // operator!=(const QRegExp & rx) const
                QRegExp* cpp_other = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QRegExp  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQRegExp_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QRegExp & >::isConvertible(other)) {
                // operator==(const QRegExp & rx) const
                QRegExp* cpp_other = Shiboken::Converter<QRegExp* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QRegExp  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQRegExp_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQRegExp_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQRegExp_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QRegExp",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQRegExp_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQRegExp_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQRegExp_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QRegExp >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QRegExp_PatternSyntax_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QRegExp_PatternSyntax_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QRegExp_PatternSyntax_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PatternSyntax",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QRegExp_PatternSyntax_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QRegExp_PatternSyntax_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QRegExp_PatternSyntax_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QRegExp_CaretMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QRegExp_CaretMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QRegExp_CaretMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CaretMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QRegExp_CaretMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QRegExp_CaretMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QRegExp_CaretMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QRegExp(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QREGEXP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQRegExp_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQRegExp_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQRegExp_Type));
    PyModule_AddObject(module, "QRegExp",
        ((PyObject*)&SbkQRegExp_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PatternSyntax
    SbkPySide_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX] = &SbkPySide_QtCore_QRegExp_PatternSyntax_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QRegExp_PatternSyntax_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type);
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
            "PatternSyntax",((PyObject*)&SbkPySide_QtCore_QRegExp_PatternSyntax_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type,
        (long) QRegExp::RegExp, "RegExp");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "RegExp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_PatternSyntax_Type.tp_dict,
        "RegExp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type,
        (long) QRegExp::Wildcard, "Wildcard");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "Wildcard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_PatternSyntax_Type.tp_dict,
        "Wildcard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type,
        (long) QRegExp::FixedString, "FixedString");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "FixedString", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_PatternSyntax_Type.tp_dict,
        "FixedString", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type,
        (long) QRegExp::RegExp2, "RegExp2");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "RegExp2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_PatternSyntax_Type.tp_dict,
        "RegExp2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type,
        (long) QRegExp::WildcardUnix, "WildcardUnix");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "WildcardUnix", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_PatternSyntax_Type.tp_dict,
        "WildcardUnix", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_PatternSyntax_Type,
        (long) QRegExp::W3CXmlSchema11, "W3CXmlSchema11");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "W3CXmlSchema11", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_PatternSyntax_Type.tp_dict,
        "W3CXmlSchema11", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QRegExp::PatternSyntax");

    // init enum class: CaretMode
    SbkPySide_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX] = &SbkPySide_QtCore_QRegExp_CaretMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QRegExp_CaretMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QRegExp_CaretMode_Type);
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
            "CaretMode",((PyObject*)&SbkPySide_QtCore_QRegExp_CaretMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_CaretMode_Type,
        (long) QRegExp::CaretAtZero, "CaretAtZero");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "CaretAtZero", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_CaretMode_Type.tp_dict,
        "CaretAtZero", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_CaretMode_Type,
        (long) QRegExp::CaretAtOffset, "CaretAtOffset");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "CaretAtOffset", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_CaretMode_Type.tp_dict,
        "CaretAtOffset", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QRegExp_CaretMode_Type,
        (long) QRegExp::CaretWontMatch, "CaretWontMatch");
    PyDict_SetItemString(SbkQRegExp_Type.super.ht_type.tp_dict,
        "CaretWontMatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QRegExp_CaretMode_Type.tp_dict,
        "CaretWontMatch", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QRegExp::CaretMode");

    Shiboken::TypeResolver::createValueTypeResolver<QRegExp >("QRegExp");
    Shiboken::TypeResolver::createValueTypeResolver<QRegExp >(typeid(QRegExp).name());
}


} // extern "C"

