/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qbitarray_wrapper.h"

// Extra includes
#include <qbitarray.h>

using namespace Shiboken;

static int
SbkQBitArray_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QBitArray* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QBitArray", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QBitArray()
        cptr = new QBitArray();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QBitArray(int,bool)
            cptr = new QBitArray(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // QBitArray(int,bool)
            cptr = new QBitArray(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQBitArray_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QBitArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(pyargs[0]);
        // QBitArray(QBitArray)
        cptr = new QBitArray(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArray_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QBitArray >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQBitArray_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQBitArray_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QBitArray", "int, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QBitArray", overloads);
        return -1;
}

static PyObject* SbkQBitArrayFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QBitArray::at(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.at", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    cppSelf->QBitArray::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQBitArrayFunc_clearBit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // clearBit(int)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        cppSelf->QBitArray::clearBit(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_clearBit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBitArrayFunc_clearBit_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.clearBit", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QBitArray::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // count(bool)const
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QBitArray::count(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc_count_TypeError:
        const char* overloads[] = {"", "bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.count", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_fill(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fill", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // fill(bool,int,int)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        cppSelf->QBitArray::fill(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_fill_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBitArrayFunc_fill_TypeError:
        const char* overloads[] = {"bool, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QBitArray.fill", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QBitArray::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQBitArrayFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QBitArray::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQBitArrayFunc_resize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resize(int)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        cppSelf->QBitArray::resize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBitArrayFunc_resize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.resize", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_setBit(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setBit", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setBit(int)
            QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
            cppSelf->QBitArray::setBit(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setBit(int,bool)
            QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
            cppSelf->QBitArray::setBit(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQBitArrayFunc_setBit_TypeError;
    } else goto SbkQBitArrayFunc_setBit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBitArrayFunc_setBit_TypeError:
        const char* overloads[] = {"int", "int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QBitArray.setBit", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QBitArray::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQBitArrayFunc_testBit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // testBit(int)const
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QBitArray::testBit(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_testBit_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc_testBit_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.testBit", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_toggleBit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toggleBit(int)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QBitArray::toggleBit(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_toggleBit_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc_toggleBit_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.toggleBit", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc_truncate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // truncate(int)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        cppSelf->QBitArray::truncate(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc_truncate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBitArrayFunc_truncate_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.truncate", overloads);
        return 0;
}

static PyMethodDef SbkQBitArray_methods[] = {
    {"at", (PyCFunction)SbkQBitArrayFunc_at, METH_O},
    {"clear", (PyCFunction)SbkQBitArrayFunc_clear, METH_NOARGS},
    {"clearBit", (PyCFunction)SbkQBitArrayFunc_clearBit, METH_O},
    {"count", (PyCFunction)SbkQBitArrayFunc_count, METH_NOARGS|METH_O},
    {"fill", (PyCFunction)SbkQBitArrayFunc_fill, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQBitArrayFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQBitArrayFunc_isNull, METH_NOARGS},
    {"resize", (PyCFunction)SbkQBitArrayFunc_resize, METH_O},
    {"setBit", (PyCFunction)SbkQBitArrayFunc_setBit, METH_VARARGS},
    {"size", (PyCFunction)SbkQBitArrayFunc_size, METH_NOARGS},
    {"testBit", (PyCFunction)SbkQBitArrayFunc_testBit, METH_O},
    {"toggleBit", (PyCFunction)SbkQBitArrayFunc_toggleBit, METH_O},
    {"truncate", (PyCFunction)SbkQBitArrayFunc_truncate, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQBitArrayFunc___and__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQBitArray_Check(arg) && !SbkQBitArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rand__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rand__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator&(QBitArray,QBitArray)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        QBitArray cpp_result = (*cppSelf) & (*cpp_arg0);
        py_result = Shiboken::Converter<QBitArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc___and___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc___and___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.__and__", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc___iand__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQBitArray_Check(arg) && !SbkQBitArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator&=(QBitArray)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        (*cppSelf) &= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc___iand___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQBitArrayFunc___iand___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.__iand__", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc___xor__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQBitArray_Check(arg) && !SbkQBitArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rxor__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rxor__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator^(QBitArray,QBitArray)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        QBitArray cpp_result = (*cppSelf) ^ (*cpp_arg0);
        py_result = Shiboken::Converter<QBitArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc___xor___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc___xor___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.__xor__", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc___ixor__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQBitArray_Check(arg) && !SbkQBitArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator^=(QBitArray)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        (*cppSelf) ^= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc___ixor___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQBitArrayFunc___ixor___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.__ixor__", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc___or__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQBitArray_Check(arg) && !SbkQBitArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__ror__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__ror__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator|(QBitArray,QBitArray)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        QBitArray cpp_result = (*cppSelf) | (*cpp_arg0);
        py_result = Shiboken::Converter<QBitArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc___or___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitArrayFunc___or___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.__or__", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc___ior__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQBitArray_Check(arg) && !SbkQBitArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator|=(QBitArray)
        QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
        (*cppSelf) |= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitArrayFunc___ior___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQBitArrayFunc___ior___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QBitArray.__ior__", overloads);
        return 0;
}

static PyObject* SbkQBitArrayFunc___invert__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    // operator~()const
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    QBitArray cpp_result = ~ (*cppSelf);
    py_result = Shiboken::Converter<QBitArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

// type has number operators
static PyNumberMethods SbkQBitArray_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQBitArrayFunc___invert__,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)SbkQBitArrayFunc___and__,
    /*nb_xor*/                  (binaryfunc)SbkQBitArrayFunc___xor__,
    /*nb_or*/                   (binaryfunc)SbkQBitArrayFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQBitArrayFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)SbkQBitArrayFunc___ixor__,
    /*nb_inplace_or*/           (binaryfunc)SbkQBitArrayFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

Py_ssize_t SbkQBitArrayFunc___len__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    return cppSelf->size();
    
    // End of code injection
}

PyObject* SbkQBitArrayFunc___getitem__(PyObject* self, Py_ssize_t _i)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    if (_i < 0 || _i >= cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    }
    return Shiboken::Converter<bool >::toPython(cppSelf->at(_i));
    
    // End of code injection
}

int SbkQBitArrayFunc___setitem__(PyObject* self, Py_ssize_t _i, PyObject* _value)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QBitArray* cppSelf = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    PyObject* args = Py_BuildValue("(iiO)", _i, 1, _value);
    PyObject* result = SbkQBitArrayFunc_setBit(self, args);
    Py_DECREF(args);
    Py_XDECREF(result);
    return !result ? -1 : 0;
    
    // End of code injection
}

static PySequenceMethods PyQBitArray_as_sequence = {
    /*sq_length*/ &SbkQBitArrayFunc___len__,
    /*sq_concat*/ 0,
    /*sq_repeat*/ 0,
    /*sq_item*/ &SbkQBitArrayFunc___getitem__,
    /*sq_slice*/ 0,
    /*sq_ass_item*/ &SbkQBitArrayFunc___setitem__,
    /*sq_ass_slice*/ 0,
    /*sq_contains*/ 0,
    /*sq_inplace_concat*/ 0,
    /*sq_inplace_repeat*/ 0
};

// Rich comparison
static PyObject* SbkQBitArray_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QBitArray& cpp_self = *Shiboken::Converter<QBitArray* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QBitArray & >::isConvertible(other)) {
                // operator!=(const QBitArray & a) const
                QBitArray* cpp_other = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QBitArray  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQBitArray_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QBitArray & >::isConvertible(other)) {
                // operator==(const QBitArray & a) const
                QBitArray* cpp_other = Shiboken::Converter<QBitArray* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QBitArray  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQBitArray_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQBitArray_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

static long SbkQBitArray_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QBitArray >::toCpp(obj));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQBitArray_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QBitArray",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQBitArray_as_number,
    /*tp_as_sequence*/      &PyQBitArray_as_sequence,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQBitArray_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQBitArray_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQBitArray_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQBitArray_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QBitArray >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QBitArray(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QBITARRAY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQBitArray_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQBitArray_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQBitArray_Type));
    PyModule_AddObject(module, "QBitArray",
        ((PyObject*)&SbkQBitArray_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QBitArray >("QBitArray");
    Shiboken::TypeResolver::createValueTypeResolver<QBitArray >(typeid(QBitArray).name());
}


} // extern "C"

