/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmlreader_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxml.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlReaderWrapper::QXmlReaderWrapper() : QXmlReader() {
    // ... middle
}

QXmlDTDHandler * QXmlReaderWrapper::DTDHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "DTDHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.DTDHandler()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlDTDHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.DTDHandler");
        return 0        ;
    }
    QXmlDTDHandler* cpp_result(Shiboken::Converter<QXmlDTDHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlContentHandler * QXmlReaderWrapper::contentHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contentHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.contentHandler()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlContentHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.contentHandler");
        return 0        ;
    }
    QXmlContentHandler* cpp_result(Shiboken::Converter<QXmlContentHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlDeclHandler * QXmlReaderWrapper::declHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "declHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.declHandler()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlDeclHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.declHandler");
        return 0        ;
    }
    QXmlDeclHandler* cpp_result(Shiboken::Converter<QXmlDeclHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlEntityResolver * QXmlReaderWrapper::entityResolver() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "entityResolver"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.entityResolver()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlEntityResolver* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.entityResolver");
        return 0        ;
    }
    QXmlEntityResolver* cpp_result(Shiboken::Converter<QXmlEntityResolver* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlErrorHandler * QXmlReaderWrapper::errorHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.errorHandler()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlErrorHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.errorHandler");
        return 0        ;
    }
    QXmlErrorHandler* cpp_result(Shiboken::Converter<QXmlErrorHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

bool QXmlReaderWrapper::feature(const QString & name, bool * ok) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "feature"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.feature()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PySequence_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.feature");
        return bool(0)        ;
    }
    // Begin code injection
    
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - START
    AutoDecRef _py_ret_(PySequence_GetItem(py_result, 0));
    AutoDecRef _py_ok_(PySequence_GetItem(py_result, 1));
    bool cpp_result = Shiboken::Converter<bool >::toCpp(_py_ret_);
    *ok = Shiboken::Converter<bool >::toCpp(_py_ok_);
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - END
    
    // End of code injection

    return cpp_result;
}

bool QXmlReaderWrapper::hasFeature(const QString & name) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasFeature"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.hasFeature()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.hasFeature");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlReaderWrapper::hasProperty(const QString & name) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasProperty"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.hasProperty()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.hasProperty");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlLexicalHandler * QXmlReaderWrapper::lexicalHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "lexicalHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.lexicalHandler()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlLexicalHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.lexicalHandler");
        return 0        ;
    }
    QXmlLexicalHandler* cpp_result(Shiboken::Converter<QXmlLexicalHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

bool QXmlReaderWrapper::parse(const QXmlInputSource & input)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parse"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.parse()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlInputSource& >::toPython(input)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.parse");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlReaderWrapper::parse(const QXmlInputSource * input)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parse"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.parse()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlInputSource* >::toPython(input)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.parse");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

void * QXmlReaderWrapper::property(const QString & name, bool * ok) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "property"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.property()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = PySequence_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlReader.property");
        return 0        ;
    }
    // Begin code injection
    
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - START
    AutoDecRef _py_ret_(PySequence_GetItem(py_result, 0));
    AutoDecRef _py_ok_(PySequence_GetItem(py_result, 1));
    void * cpp_result = Shiboken::Converter<void * >::toCpp(_py_ret_);
    *ok = Shiboken::Converter<bool >::toCpp(_py_ok_);
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - END
    
    // End of code injection

    return cpp_result;
}

void QXmlReaderWrapper::setContentHandler(QXmlContentHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setContentHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setContentHandler()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlContentHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setDTDHandler(QXmlDTDHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDTDHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setDTDHandler()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlDTDHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setDeclHandler(QXmlDeclHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDeclHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setDeclHandler()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlDeclHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setEntityResolver(QXmlEntityResolver * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setEntityResolver"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setEntityResolver()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlEntityResolver* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setErrorHandler(QXmlErrorHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setErrorHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setErrorHandler()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlErrorHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setFeature(const QString & name, bool value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setFeature"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setFeature()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<bool >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setLexicalHandler(QXmlLexicalHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setLexicalHandler"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setLexicalHandler()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlLexicalHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlReaderWrapper::setProperty(const QString & name, void * value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setProperty"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setProperty()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O?)",
        Shiboken::Converter<QString& >::toPython(name),
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QXmlReaderWrapper::~QXmlReaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static PyObject*
SbkQXmlReaderFunc_DTDHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // DTDHandler()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.DTDHandler()' not implemented.");
        return 0;
    }
    QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
    QXmlDTDHandler * cpp_result = cppSelf->DTDHandler();
    py_result = Shiboken::Converter<QXmlDTDHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static int
SbkQXmlReader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlReaderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLREADER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QXmlReader' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QXmlReader()
    cptr = new QXmlReaderWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlReaderFunc_contentHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentHandler()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.contentHandler()' not implemented.");
        return 0;
    }
    QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
    QXmlContentHandler * cpp_result = cppSelf->contentHandler();
    py_result = Shiboken::Converter<QXmlContentHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlReaderFunc_declHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // declHandler()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.declHandler()' not implemented.");
        return 0;
    }
    QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
    QXmlDeclHandler * cpp_result = cppSelf->declHandler();
    py_result = Shiboken::Converter<QXmlDeclHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlReaderFunc_entityResolver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // entityResolver()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.entityResolver()' not implemented.");
        return 0;
    }
    QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
    QXmlEntityResolver * cpp_result = cppSelf->entityResolver();
    py_result = Shiboken::Converter<QXmlEntityResolver* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlReaderFunc_errorHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorHandler()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.errorHandler()' not implemented.");
        return 0;
    }
    QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
    QXmlErrorHandler * cpp_result = cppSelf->errorHandler();
    py_result = Shiboken::Converter<QXmlErrorHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlReaderFunc_feature(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // feature(QString,bool*)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.feature()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        bool retval_ = cppSelf->feature(*cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


    } else goto SbkQXmlReaderFunc_feature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlReaderFunc_feature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.feature", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_hasFeature(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasFeature(QString)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.hasFeature()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->hasFeature(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlReaderFunc_hasFeature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlReaderFunc_hasFeature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.hasFeature", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_hasProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasProperty(QString)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.hasProperty()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->hasProperty(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlReaderFunc_hasProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlReaderFunc_hasProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.hasProperty", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_lexicalHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lexicalHandler()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.lexicalHandler()' not implemented.");
        return 0;
    }
    QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
    QXmlLexicalHandler * cpp_result = cppSelf->lexicalHandler();
    py_result = Shiboken::Converter<QXmlLexicalHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlReaderFunc_parse(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlInputSource& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlInputSource* cpp_arg0 = Shiboken::Converter<QXmlInputSource* >::toCpp(arg);
        // parse(QXmlInputSource)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.parse()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->parse(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlReaderFunc_parse_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlReaderFunc_parse_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlInputSource", "PySide.QtXml.QXmlInputSource", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.parse", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // property(QString,bool*)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.property()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        void * retval_ = cppSelf->property(*cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


    } else goto SbkQXmlReaderFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlReaderFunc_property_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.property", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setContentHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlContentHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlContentHandler* cpp_arg0 = Shiboken::Converter<QXmlContentHandler* >::toCpp(arg);
        // setContentHandler(QXmlContentHandler*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setContentHandler()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setContentHandler(cpp_arg0);
    } else goto SbkQXmlReaderFunc_setContentHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setContentHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlContentHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.setContentHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setDTDHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlDTDHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlDTDHandler* cpp_arg0 = Shiboken::Converter<QXmlDTDHandler* >::toCpp(arg);
        // setDTDHandler(QXmlDTDHandler*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setDTDHandler()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setDTDHandler(cpp_arg0);
    } else goto SbkQXmlReaderFunc_setDTDHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setDTDHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlDTDHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.setDTDHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setDeclHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlDeclHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlDeclHandler* cpp_arg0 = Shiboken::Converter<QXmlDeclHandler* >::toCpp(arg);
        // setDeclHandler(QXmlDeclHandler*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setDeclHandler()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setDeclHandler(cpp_arg0);
    } else goto SbkQXmlReaderFunc_setDeclHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setDeclHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlDeclHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.setDeclHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setEntityResolver(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlEntityResolver* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlEntityResolver* cpp_arg0 = Shiboken::Converter<QXmlEntityResolver* >::toCpp(arg);
        // setEntityResolver(QXmlEntityResolver*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setEntityResolver()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setEntityResolver(cpp_arg0);
    } else goto SbkQXmlReaderFunc_setEntityResolver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setEntityResolver_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlEntityResolver", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.setEntityResolver", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setErrorHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlErrorHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlErrorHandler* cpp_arg0 = Shiboken::Converter<QXmlErrorHandler* >::toCpp(arg);
        // setErrorHandler(QXmlErrorHandler*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setErrorHandler()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setErrorHandler(cpp_arg0);
    } else goto SbkQXmlReaderFunc_setErrorHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setErrorHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlErrorHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.setErrorHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setFeature(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFeature", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setFeature(QString,bool)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setFeature()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setFeature(*cpp_arg0, cpp_arg1);
    } else goto SbkQXmlReaderFunc_setFeature_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setFeature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlReader.setFeature", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setLexicalHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlLexicalHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlLexicalHandler* cpp_arg0 = Shiboken::Converter<QXmlLexicalHandler* >::toCpp(arg);
        // setLexicalHandler(QXmlLexicalHandler*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setLexicalHandler()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setLexicalHandler(cpp_arg0);
    } else goto SbkQXmlReaderFunc_setLexicalHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setLexicalHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlLexicalHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlReader.setLexicalHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlReaderFunc_setProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<void * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        void * cpp_arg1 = Shiboken::Converter<void * >::toCpp(pyargs[1]);
        // setProperty(QString,void*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlReader.setProperty()' not implemented.");
            return 0;
        }
        QXmlReader* cppSelf = Shiboken::Converter<QXmlReader* >::toCpp((PyObject*)self);
        cppSelf->setProperty(*cpp_arg0, cpp_arg1);
    } else goto SbkQXmlReaderFunc_setProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlReaderFunc_setProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, void", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlReader.setProperty", overloads);
        return 0;
}

static PyMethodDef SbkQXmlReader_methods[] = {
    {"DTDHandler", (PyCFunction)SbkQXmlReaderFunc_DTDHandler, METH_NOARGS},
    {"contentHandler", (PyCFunction)SbkQXmlReaderFunc_contentHandler, METH_NOARGS},
    {"declHandler", (PyCFunction)SbkQXmlReaderFunc_declHandler, METH_NOARGS},
    {"entityResolver", (PyCFunction)SbkQXmlReaderFunc_entityResolver, METH_NOARGS},
    {"errorHandler", (PyCFunction)SbkQXmlReaderFunc_errorHandler, METH_NOARGS},
    {"feature", (PyCFunction)SbkQXmlReaderFunc_feature, METH_O},
    {"hasFeature", (PyCFunction)SbkQXmlReaderFunc_hasFeature, METH_O},
    {"hasProperty", (PyCFunction)SbkQXmlReaderFunc_hasProperty, METH_O},
    {"lexicalHandler", (PyCFunction)SbkQXmlReaderFunc_lexicalHandler, METH_NOARGS},
    {"parse", (PyCFunction)SbkQXmlReaderFunc_parse, METH_O},
    {"property", (PyCFunction)SbkQXmlReaderFunc_property, METH_O},
    {"setContentHandler", (PyCFunction)SbkQXmlReaderFunc_setContentHandler, METH_O},
    {"setDTDHandler", (PyCFunction)SbkQXmlReaderFunc_setDTDHandler, METH_O},
    {"setDeclHandler", (PyCFunction)SbkQXmlReaderFunc_setDeclHandler, METH_O},
    {"setEntityResolver", (PyCFunction)SbkQXmlReaderFunc_setEntityResolver, METH_O},
    {"setErrorHandler", (PyCFunction)SbkQXmlReaderFunc_setErrorHandler, METH_O},
    {"setFeature", (PyCFunction)SbkQXmlReaderFunc_setFeature, METH_VARARGS},
    {"setLexicalHandler", (PyCFunction)SbkQXmlReaderFunc_setLexicalHandler, METH_O},
    {"setProperty", (PyCFunction)SbkQXmlReaderFunc_setProperty, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlReader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlReader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlReaderWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlReader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlReader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQXmlReader_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQXmlReader_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QXmlReader*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QXmlReader(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLREADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlReader_Type);

    // Fill type discovery information
    SbkQXmlReader_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQXmlReader_Type.type_discovery->addTypeDiscoveryFunction(&SbkQXmlReader_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlReader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlReader_Type));
    PyModule_AddObject(module, "QXmlReader",
        ((PyObject*)&SbkQXmlReader_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlReader >("QXmlReader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlReader >(typeid(QXmlReader).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

