/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <set>
#include "pyside_qtxml_python.h"

#include "qxmldefaulthandler_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxml.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlDefaultHandlerWrapper::QXmlDefaultHandlerWrapper() : QXmlDefaultHandler() {
    // ... middle
}

bool QXmlDefaultHandlerWrapper::attributeDecl(const QString & eName, const QString & aName, const QString & type, const QString & valueDefault, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "attributeDecl"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::attributeDecl(eName, aName, type, valueDefault, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOOO)",
        Shiboken::Converter<QString& >::toPython(eName),
        Shiboken::Converter<QString& >::toPython(aName),
        Shiboken::Converter<QString& >::toPython(type),
        Shiboken::Converter<QString& >::toPython(valueDefault),
        Shiboken::Converter<QString& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.attributeDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::characters(const QString & ch)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "characters"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::characters(ch);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(ch)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.characters");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::comment(const QString & ch)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "comment"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::comment(ch);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(ch)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.comment");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::endCDATA()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endCDATA"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::endCDATA();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.endCDATA");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::endDTD()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDTD"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::endDTD();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.endDTD");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::endDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDocument"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::endDocument();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.endDocument");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::endElement(const QString & namespaceURI, const QString & localName, const QString & qName)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endElement"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::endElement(namespaceURI, localName, qName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(namespaceURI),
        Shiboken::Converter<QString& >::toPython(localName),
        Shiboken::Converter<QString& >::toPython(qName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.endElement");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::endEntity(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endEntity"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::endEntity(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.endEntity");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::endPrefixMapping(const QString & prefix)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endPrefixMapping"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::endPrefixMapping(prefix);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(prefix)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.endPrefixMapping");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::error(const QXmlParseException & exception)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "error"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::error(exception);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlParseException& >::toPython(exception)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.error");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QXmlDefaultHandlerWrapper::errorString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorString"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::errorString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.errorString");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::externalEntityDecl(const QString & name, const QString & publicId, const QString & systemId)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "externalEntityDecl"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::externalEntityDecl(name, publicId, systemId);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.externalEntityDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::fatalError(const QXmlParseException & exception)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fatalError"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::fatalError(exception);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlParseException& >::toPython(exception)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.fatalError");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::ignorableWhitespace(const QString & ch)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ignorableWhitespace"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::ignorableWhitespace(ch);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(ch)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.ignorableWhitespace");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::internalEntityDecl(const QString & name, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "internalEntityDecl"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::internalEntityDecl(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.internalEntityDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::notationDecl(const QString & name, const QString & publicId, const QString & systemId)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "notationDecl"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::notationDecl(name, publicId, systemId);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.notationDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::processingInstruction(const QString & target, const QString & data)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "processingInstruction"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::processingInstruction(target, data);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(target),
        Shiboken::Converter<QString& >::toPython(data)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.processingInstruction");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::resolveEntity(const QString & publicId, const QString & systemId, QXmlInputSource *& ret)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resolveEntity"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::resolveEntity(publicId, systemId, ret);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PySequence_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.resolveEntity");
        return bool(0)        ;
    }
    // Begin code injection
    
    // TEMPLATE - QXmlEntityResolver_resolveEntity_return_conversion_native - START
    AutoDecRef _py_ok_(PySequence_GetItem(py_result, 0));
    AutoDecRef _py_ret_(PySequence_GetItem(py_result, 1));
    bool cpp_result = Shiboken::Converter<bool >::toCpp(_py_ok_);
    ret = Shiboken::Converter<QXmlInputSource* >::toCpp(_py_ret_);
    // TEMPLATE - QXmlEntityResolver_resolveEntity_return_conversion_native - END
    
    // End of code injection

    return cpp_result;
}

void QXmlDefaultHandlerWrapper::setDocumentLocator(QXmlLocator * locator)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDocumentLocator"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::setDocumentLocator(locator);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlLocator* >::toPython(locator)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QXmlDefaultHandlerWrapper::skippedEntity(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "skippedEntity"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::skippedEntity(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.skippedEntity");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::startCDATA()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startCDATA"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::startCDATA();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.startCDATA");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::startDTD(const QString & name, const QString & publicId, const QString & systemId)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDTD"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::startDTD(name, publicId, systemId);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.startDTD");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::startDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDocument"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::startDocument();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.startDocument");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::startElement(const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startElement"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::startElement(namespaceURI, localName, qName, atts);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QString& >::toPython(namespaceURI),
        Shiboken::Converter<QString& >::toPython(localName),
        Shiboken::Converter<QString& >::toPython(qName),
        Shiboken::Converter<QXmlAttributes& >::toPython(atts)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.startElement");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::startEntity(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startEntity"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::startEntity(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.startEntity");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::startPrefixMapping(const QString & prefix, const QString & uri)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startPrefixMapping"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::startPrefixMapping(prefix, uri);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(prefix),
        Shiboken::Converter<QString& >::toPython(uri)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.startPrefixMapping");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::unparsedEntityDecl(const QString & name, const QString & publicId, const QString & systemId, const QString & notationName)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unparsedEntityDecl"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId),
        Shiboken::Converter<QString& >::toPython(notationName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.unparsedEntityDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDefaultHandlerWrapper::warning(const QXmlParseException & exception)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "warning"));
    if (py_override.isNull()) {
        return this->QXmlDefaultHandler::warning(exception);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlParseException& >::toPython(exception)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDefaultHandler.warning");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlDefaultHandlerWrapper::~QXmlDefaultHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlDefaultHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlDefaultHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLDEFAULTHANDLER_IDX]);
    if (type != myType) {
        type->mi_init = myType->mi_init;
        type->mi_offsets = myType->mi_offsets;
        type->mi_specialcast = myType->mi_specialcast;
    }

    // QXmlDefaultHandler()
    cptr = new QXmlDefaultHandlerWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_attributeDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "attributeDecl", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3]) && Shiboken::Converter<QString& >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        std::auto_ptr<QString > cpp_arg4_auto_ptr;
        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
        // attributeDecl(QString,QString,QString,QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::attributeDecl(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_attributeDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_attributeDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.attributeDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_characters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // characters(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::characters(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_characters_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_characters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.characters", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_comment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // comment(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::comment(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_comment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_comment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.comment", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_endCDATA(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endCDATA()
    QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlDefaultHandler::endCDATA();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_endDTD(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endDTD()
    QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlDefaultHandler::endDTD();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_endDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endDocument()
    QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlDefaultHandler::endDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_endElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "endElement", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // endElement(QString,QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::endElement(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_endElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_endElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.endElement", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_endEntity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // endEntity(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::endEntity(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_endEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_endEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.endEntity", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_endPrefixMapping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // endPrefixMapping(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::endPrefixMapping(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_endPrefixMapping_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_endPrefixMapping_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.endPrefixMapping", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_error(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlParseException& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlParseException* cpp_arg0 = Shiboken::Converter<QXmlParseException* >::toCpp(arg);
        // error(QXmlParseException)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::error(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_error_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_error_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlParseException", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.error", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QXmlDefaultHandler::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_externalEntityDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "externalEntityDecl", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // externalEntityDecl(QString,QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::externalEntityDecl(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_externalEntityDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_externalEntityDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.externalEntityDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_fatalError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlParseException& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlParseException* cpp_arg0 = Shiboken::Converter<QXmlParseException* >::toCpp(arg);
        // fatalError(QXmlParseException)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::fatalError(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_fatalError_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_fatalError_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlParseException", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.fatalError", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_ignorableWhitespace(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // ignorableWhitespace(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::ignorableWhitespace(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_ignorableWhitespace_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_ignorableWhitespace_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.ignorableWhitespace", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_internalEntityDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "internalEntityDecl", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // internalEntityDecl(QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::internalEntityDecl(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_internalEntityDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_internalEntityDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.internalEntityDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_notationDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "notationDecl", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // notationDecl(QString,QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::notationDecl(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_notationDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_notationDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.notationDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_processingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processingInstruction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // processingInstruction(QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::processingInstruction(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_processingInstruction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_processingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.processingInstruction", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_resolveEntity(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resolveEntity", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // resolveEntity(QString,QString,QXmlInputSource*&)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);


        // Begin code injection
        
        QXmlInputSource* _qxmlinputsource_arg_ = 0;
        bool cpp_result = cppSelf->QXmlDefaultHandler::resolveEntity((*cpp_arg0), (*cpp_arg1), _qxmlinputsource_arg_);
        py_result = Shiboken::makeTuple(cpp_result, _qxmlinputsource_arg_);
        
        // End of code injection
    } else goto SbkQXmlDefaultHandlerFunc_resolveEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_resolveEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtXml.QXmlInputSource", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.resolveEntity", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_setDocumentLocator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlLocator* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlLocator* cpp_arg0 = Shiboken::Converter<QXmlLocator* >::toCpp(arg);
        // setDocumentLocator(QXmlLocator*)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        cppSelf->QXmlDefaultHandler::setDocumentLocator(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
    } else goto SbkQXmlDefaultHandlerFunc_setDocumentLocator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlDefaultHandlerFunc_setDocumentLocator_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlLocator", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.setDocumentLocator", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_skippedEntity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // skippedEntity(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::skippedEntity(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_skippedEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_skippedEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.skippedEntity", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_startCDATA(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startCDATA()
    QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlDefaultHandler::startCDATA();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_startDTD(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "startDTD", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // startDTD(QString,QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::startDTD(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_startDTD_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_startDTD_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.startDTD", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_startDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startDocument()
    QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlDefaultHandler::startDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_startElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "startElement", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QXmlAttributes& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QXmlAttributes* cpp_arg3 = Shiboken::Converter<QXmlAttributes* >::toCpp(pyargs[3]);
        // startElement(QString,QString,QString,QXmlAttributes)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::startElement(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_startElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_startElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtXml.QXmlAttributes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.startElement", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_startEntity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // startEntity(QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::startEntity(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_startEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_startEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.startEntity", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_startPrefixMapping(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "startPrefixMapping", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // startPrefixMapping(QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::startPrefixMapping(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_startPrefixMapping_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_startPrefixMapping_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.startPrefixMapping", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_unparsedEntityDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "unparsedEntityDecl", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // unparsedEntityDecl(QString,QString,QString,QString)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::unparsedEntityDecl(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_unparsedEntityDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_unparsedEntityDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDefaultHandler.unparsedEntityDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDefaultHandlerFunc_warning(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlParseException& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlParseException* cpp_arg0 = Shiboken::Converter<QXmlParseException* >::toCpp(arg);
        // warning(QXmlParseException)
        QXmlDefaultHandler* cppSelf = Shiboken::Converter<QXmlDefaultHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlDefaultHandler::warning(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDefaultHandlerFunc_warning_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDefaultHandlerFunc_warning_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlParseException", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlDefaultHandler.warning", overloads);
        return 0;
}

static PyMethodDef SbkQXmlDefaultHandler_methods[] = {
    {"attributeDecl", (PyCFunction)SbkQXmlDefaultHandlerFunc_attributeDecl, METH_VARARGS},
    {"characters", (PyCFunction)SbkQXmlDefaultHandlerFunc_characters, METH_O},
    {"comment", (PyCFunction)SbkQXmlDefaultHandlerFunc_comment, METH_O},
    {"endCDATA", (PyCFunction)SbkQXmlDefaultHandlerFunc_endCDATA, METH_NOARGS},
    {"endDTD", (PyCFunction)SbkQXmlDefaultHandlerFunc_endDTD, METH_NOARGS},
    {"endDocument", (PyCFunction)SbkQXmlDefaultHandlerFunc_endDocument, METH_NOARGS},
    {"endElement", (PyCFunction)SbkQXmlDefaultHandlerFunc_endElement, METH_VARARGS},
    {"endEntity", (PyCFunction)SbkQXmlDefaultHandlerFunc_endEntity, METH_O},
    {"endPrefixMapping", (PyCFunction)SbkQXmlDefaultHandlerFunc_endPrefixMapping, METH_O},
    {"error", (PyCFunction)SbkQXmlDefaultHandlerFunc_error, METH_O},
    {"errorString", (PyCFunction)SbkQXmlDefaultHandlerFunc_errorString, METH_NOARGS},
    {"externalEntityDecl", (PyCFunction)SbkQXmlDefaultHandlerFunc_externalEntityDecl, METH_VARARGS},
    {"fatalError", (PyCFunction)SbkQXmlDefaultHandlerFunc_fatalError, METH_O},
    {"ignorableWhitespace", (PyCFunction)SbkQXmlDefaultHandlerFunc_ignorableWhitespace, METH_O},
    {"internalEntityDecl", (PyCFunction)SbkQXmlDefaultHandlerFunc_internalEntityDecl, METH_VARARGS},
    {"notationDecl", (PyCFunction)SbkQXmlDefaultHandlerFunc_notationDecl, METH_VARARGS},
    {"processingInstruction", (PyCFunction)SbkQXmlDefaultHandlerFunc_processingInstruction, METH_VARARGS},
    {"resolveEntity", (PyCFunction)SbkQXmlDefaultHandlerFunc_resolveEntity, METH_VARARGS},
    {"setDocumentLocator", (PyCFunction)SbkQXmlDefaultHandlerFunc_setDocumentLocator, METH_O},
    {"skippedEntity", (PyCFunction)SbkQXmlDefaultHandlerFunc_skippedEntity, METH_O},
    {"startCDATA", (PyCFunction)SbkQXmlDefaultHandlerFunc_startCDATA, METH_NOARGS},
    {"startDTD", (PyCFunction)SbkQXmlDefaultHandlerFunc_startDTD, METH_VARARGS},
    {"startDocument", (PyCFunction)SbkQXmlDefaultHandlerFunc_startDocument, METH_NOARGS},
    {"startElement", (PyCFunction)SbkQXmlDefaultHandlerFunc_startElement, METH_VARARGS},
    {"startEntity", (PyCFunction)SbkQXmlDefaultHandlerFunc_startEntity, METH_O},
    {"startPrefixMapping", (PyCFunction)SbkQXmlDefaultHandlerFunc_startPrefixMapping, METH_VARARGS},
    {"unparsedEntityDecl", (PyCFunction)SbkQXmlDefaultHandlerFunc_unparsedEntityDecl, METH_VARARGS},
    {"warning", (PyCFunction)SbkQXmlDefaultHandlerFunc_warning, METH_O},
    {0} // Sentinel
};

extern "C"
{

static int mi_offsets[] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };
int*
SbkQXmlDefaultHandler_mi_init(const void* cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        std::set<int>::iterator it;
        const QXmlDefaultHandler* class_ptr = reinterpret_cast<const QXmlDefaultHandler*>(cptr);
        size_t base = (size_t) class_ptr;
        offsets.insert(((size_t) static_cast<const QXmlContentHandler*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QXmlContentHandler*>((QXmlDefaultHandler*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QXmlErrorHandler*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QXmlErrorHandler*>((QXmlDefaultHandler*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QXmlDTDHandler*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QXmlDTDHandler*>((QXmlDefaultHandler*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QXmlEntityResolver*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QXmlEntityResolver*>((QXmlDefaultHandler*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QXmlLexicalHandler*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QXmlLexicalHandler*>((QXmlDefaultHandler*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QXmlDeclHandler*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QXmlDeclHandler*>((QXmlDefaultHandler*)((void*)class_ptr))) - base);

        offsets.erase(0);

        int i = 0;
        for (it = offsets.begin(); it != offsets.end(); it++) {
            mi_offsets[i] = *it;
            i++;
        }
    }
    return mi_offsets;
}
static void* SbkQXmlDefaultHandlerSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QXmlDefaultHandler* me = reinterpret_cast<QXmlDefaultHandler*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLCONTENTHANDLER_IDX]))
        return static_cast<QXmlContentHandler*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLERRORHANDLER_IDX]))
        return static_cast<QXmlErrorHandler*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLDTDHANDLER_IDX]))
        return static_cast<QXmlDTDHandler*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLENTITYRESOLVER_IDX]))
        return static_cast<QXmlEntityResolver*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLLEXICALHANDLER_IDX]))
        return static_cast<QXmlLexicalHandler*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX]))
        return static_cast<QXmlDeclHandler*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlDefaultHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlDefaultHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlDefaultHandlerWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlDefaultHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlDefaultHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             SbkQXmlDefaultHandler_mi_init,
    /*mi_specialcast*/      &SbkQXmlDefaultHandlerSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QXmlDefaultHandler(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLDEFAULTHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlDefaultHandler_Type);

    SbkQXmlDefaultHandler_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX];
    SbkQXmlDefaultHandler_Type.super.ht_type.tp_bases = PyTuple_Pack(6,
        (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLCONTENTHANDLER_IDX], (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLERRORHANDLER_IDX], (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLDTDHANDLER_IDX], (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLENTITYRESOLVER_IDX], (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLLEXICALHANDLER_IDX], (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX]);

    // Fill type discovery information
    SbkQXmlDefaultHandler_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQXmlDefaultHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlDefaultHandler_Type));
    PyModule_AddObject(module, "QXmlDefaultHandler",
        ((PyObject*)&SbkQXmlDefaultHandler_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlDefaultHandler >("QXmlDefaultHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlDefaultHandler >(typeid(QXmlDefaultHandler).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

