/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmlcontenthandler_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxml.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlContentHandlerWrapper::QXmlContentHandlerWrapper() : QXmlContentHandler() {
    // ... middle
}

bool QXmlContentHandlerWrapper::characters(const QString & ch)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "characters"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.characters()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(ch)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.characters");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::endDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDocument"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.endDocument()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.endDocument");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::endElement(const QString & namespaceURI, const QString & localName, const QString & qName)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endElement"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.endElement()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(namespaceURI),
        Shiboken::Converter<QString& >::toPython(localName),
        Shiboken::Converter<QString& >::toPython(qName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.endElement");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::endPrefixMapping(const QString & prefix)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endPrefixMapping"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.endPrefixMapping()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(prefix)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.endPrefixMapping");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QXmlContentHandlerWrapper::errorString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorString"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.errorString()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.errorString");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::ignorableWhitespace(const QString & ch)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ignorableWhitespace"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.ignorableWhitespace()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(ch)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.ignorableWhitespace");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::processingInstruction(const QString & target, const QString & data)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "processingInstruction"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.processingInstruction()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(target),
        Shiboken::Converter<QString& >::toPython(data)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.processingInstruction");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QXmlContentHandlerWrapper::setDocumentLocator(QXmlLocator * locator)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDocumentLocator"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.setDocumentLocator()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlLocator* >::toPython(locator)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QXmlContentHandlerWrapper::skippedEntity(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "skippedEntity"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.skippedEntity()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.skippedEntity");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::startDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDocument"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.startDocument()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.startDocument");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::startElement(const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startElement"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.startElement()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QString& >::toPython(namespaceURI),
        Shiboken::Converter<QString& >::toPython(localName),
        Shiboken::Converter<QString& >::toPython(qName),
        Shiboken::Converter<QXmlAttributes& >::toPython(atts)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.startElement");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlContentHandlerWrapper::startPrefixMapping(const QString & prefix, const QString & uri)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startPrefixMapping"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.startPrefixMapping()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(prefix),
        Shiboken::Converter<QString& >::toPython(uri)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlContentHandler.startPrefixMapping");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlContentHandlerWrapper::~QXmlContentHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlContentHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlContentHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLCONTENTHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QXmlContentHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QXmlContentHandler()
    cptr = new QXmlContentHandlerWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlContentHandlerFunc_characters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // characters(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.characters()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->characters(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_characters_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_characters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlContentHandler.characters", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_endDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endDocument()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.endDocument()' not implemented.");
        return 0;
    }
    QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->endDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlContentHandlerFunc_endElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "endElement", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // endElement(QString,QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.endElement()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->endElement(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_endElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_endElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlContentHandler.endElement", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_endPrefixMapping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // endPrefixMapping(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.endPrefixMapping()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->endPrefixMapping(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_endPrefixMapping_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_endPrefixMapping_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlContentHandler.endPrefixMapping", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.errorString()' not implemented.");
        return 0;
    }
    QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlContentHandlerFunc_ignorableWhitespace(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // ignorableWhitespace(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.ignorableWhitespace()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->ignorableWhitespace(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_ignorableWhitespace_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_ignorableWhitespace_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlContentHandler.ignorableWhitespace", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_processingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processingInstruction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // processingInstruction(QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.processingInstruction()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->processingInstruction(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_processingInstruction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_processingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlContentHandler.processingInstruction", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_setDocumentLocator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlLocator* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlLocator* cpp_arg0 = Shiboken::Converter<QXmlLocator* >::toCpp(arg);
        // setDocumentLocator(QXmlLocator*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.setDocumentLocator()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        cppSelf->setDocumentLocator(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
    } else goto SbkQXmlContentHandlerFunc_setDocumentLocator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlContentHandlerFunc_setDocumentLocator_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlLocator", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlContentHandler.setDocumentLocator", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_skippedEntity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // skippedEntity(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.skippedEntity()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->skippedEntity(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_skippedEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_skippedEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlContentHandler.skippedEntity", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_startDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startDocument()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.startDocument()' not implemented.");
        return 0;
    }
    QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->startDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlContentHandlerFunc_startElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "startElement", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QXmlAttributes& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QXmlAttributes* cpp_arg3 = Shiboken::Converter<QXmlAttributes* >::toCpp(pyargs[3]);
        // startElement(QString,QString,QString,QXmlAttributes)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.startElement()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->startElement(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_startElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_startElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtXml.QXmlAttributes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlContentHandler.startElement", overloads);
        return 0;
}

static PyObject*
SbkQXmlContentHandlerFunc_startPrefixMapping(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "startPrefixMapping", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // startPrefixMapping(QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlContentHandler.startPrefixMapping()' not implemented.");
            return 0;
        }
        QXmlContentHandler* cppSelf = Shiboken::Converter<QXmlContentHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->startPrefixMapping(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlContentHandlerFunc_startPrefixMapping_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlContentHandlerFunc_startPrefixMapping_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlContentHandler.startPrefixMapping", overloads);
        return 0;
}

static PyMethodDef SbkQXmlContentHandler_methods[] = {
    {"characters", (PyCFunction)SbkQXmlContentHandlerFunc_characters, METH_O},
    {"endDocument", (PyCFunction)SbkQXmlContentHandlerFunc_endDocument, METH_NOARGS},
    {"endElement", (PyCFunction)SbkQXmlContentHandlerFunc_endElement, METH_VARARGS},
    {"endPrefixMapping", (PyCFunction)SbkQXmlContentHandlerFunc_endPrefixMapping, METH_O},
    {"errorString", (PyCFunction)SbkQXmlContentHandlerFunc_errorString, METH_NOARGS},
    {"ignorableWhitespace", (PyCFunction)SbkQXmlContentHandlerFunc_ignorableWhitespace, METH_O},
    {"processingInstruction", (PyCFunction)SbkQXmlContentHandlerFunc_processingInstruction, METH_VARARGS},
    {"setDocumentLocator", (PyCFunction)SbkQXmlContentHandlerFunc_setDocumentLocator, METH_O},
    {"skippedEntity", (PyCFunction)SbkQXmlContentHandlerFunc_skippedEntity, METH_O},
    {"startDocument", (PyCFunction)SbkQXmlContentHandlerFunc_startDocument, METH_NOARGS},
    {"startElement", (PyCFunction)SbkQXmlContentHandlerFunc_startElement, METH_VARARGS},
    {"startPrefixMapping", (PyCFunction)SbkQXmlContentHandlerFunc_startPrefixMapping, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlContentHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlContentHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlContentHandlerWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlContentHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlContentHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQXmlContentHandler_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQXmlContentHandler_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QXmlContentHandler*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QXmlContentHandler(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLCONTENTHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlContentHandler_Type);

    // Fill type discovery information
    SbkQXmlContentHandler_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQXmlContentHandler_Type.type_discovery->addTypeDiscoveryFunction(&SbkQXmlContentHandler_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlContentHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlContentHandler_Type));
    PyModule_AddObject(module, "QXmlContentHandler",
        ((PyObject*)&SbkQXmlContentHandler_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlContentHandler >("QXmlContentHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlContentHandler >(typeid(QXmlContentHandler).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

