/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomentity_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>

using namespace Shiboken;

static int
SbkQDomEntity_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomEntity* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomEntity", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomEntity()
        cptr = new QDomEntity();
    } else if (numArgs == 1 && Shiboken::Converter<QDomEntity& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomEntity* cpp_arg0 = Shiboken::Converter<QDomEntity* >::toCpp(pyargs[0]);
        // QDomEntity(QDomEntity)
        cptr = new QDomEntity(*cpp_arg0);
    } else goto SbkQDomEntity_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomEntity_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDomEntity_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomEntity", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomEntity", overloads);
        return -1;
}

static PyObject*
SbkQDomEntityFunc_notationName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // notationName()const
    QDomEntity* cppSelf = Shiboken::Converter<QDomEntity* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomEntity::notationName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomEntityFunc_publicId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // publicId()const
    QDomEntity* cppSelf = Shiboken::Converter<QDomEntity* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomEntity::publicId();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomEntityFunc_systemId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // systemId()const
    QDomEntity* cppSelf = Shiboken::Converter<QDomEntity* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomEntity::systemId();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQDomEntity_methods[] = {
    {"notationName", (PyCFunction)SbkQDomEntityFunc_notationName, METH_NOARGS},
    {"publicId", (PyCFunction)SbkQDomEntityFunc_publicId, METH_NOARGS},
    {"systemId", (PyCFunction)SbkQDomEntityFunc_systemId, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomEntity_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomEntity",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDomEntity >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomEntity_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomEntity_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QDomEntity(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMENTITY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomEntity_Type);

    SbkQDomEntity_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQDomEntity_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomEntity_Type));
    PyModule_AddObject(module, "QDomEntity",
        ((PyObject*)&SbkQDomEntity_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomEntity >("QDomEntity");
    Shiboken::TypeResolver::createValueTypeResolver<QDomEntity >(typeid(QDomEntity).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

