/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebdatabase_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qwebdatabase.h>
#include <qwebsecurityorigin.h>

using namespace Shiboken;

static int
SbkQWebDatabase_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebDatabase* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebDatabase", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QWebDatabase& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebDatabase* cpp_arg0 = Shiboken::Converter<QWebDatabase* >::toCpp(pyargs[0]);
        // QWebDatabase(QWebDatabase)
        cptr = new QWebDatabase(*cpp_arg0);
    } else goto SbkQWebDatabase_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebDatabase_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQWebDatabase_Init_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebDatabase", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebDatabase", overloads);
        return -1;
}

static PyObject*
SbkQWebDatabaseFunc_displayName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // displayName()const
    QWebDatabase* cppSelf = Shiboken::Converter<QWebDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebDatabase::displayName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebDatabaseFunc_expectedSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expectedSize()const
    QWebDatabase* cppSelf = Shiboken::Converter<QWebDatabase* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QWebDatabase::expectedSize();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebDatabaseFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QWebDatabase* cppSelf = Shiboken::Converter<QWebDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebDatabase::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebDatabaseFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QWebDatabase* cppSelf = Shiboken::Converter<QWebDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebDatabase::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebDatabaseFunc_origin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // origin()const
    QWebDatabase* cppSelf = Shiboken::Converter<QWebDatabase* >::toCpp((PyObject*)self);
    QWebSecurityOrigin cpp_result = cppSelf->QWebDatabase::origin();
    py_result = Shiboken::Converter<QWebSecurityOrigin >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebDatabaseFunc_removeAllDatabases(PyObject* self)
{

    // removeAllDatabases()
    QWebDatabase::removeAllDatabases();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWebDatabaseFunc_removeDatabase(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QWebDatabase& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebDatabase* cpp_arg0 = Shiboken::Converter<QWebDatabase* >::toCpp(arg);
        // removeDatabase(QWebDatabase)
        QWebDatabase::removeDatabase(*cpp_arg0);
    } else goto SbkQWebDatabaseFunc_removeDatabase_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebDatabaseFunc_removeDatabase_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebDatabase", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebDatabase.removeDatabase", overloads);
        return 0;
}

static PyObject*
SbkQWebDatabaseFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QWebDatabase* cppSelf = Shiboken::Converter<QWebDatabase* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QWebDatabase::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQWebDatabase_methods[] = {
    {"displayName", (PyCFunction)SbkQWebDatabaseFunc_displayName, METH_NOARGS},
    {"expectedSize", (PyCFunction)SbkQWebDatabaseFunc_expectedSize, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQWebDatabaseFunc_fileName, METH_NOARGS},
    {"name", (PyCFunction)SbkQWebDatabaseFunc_name, METH_NOARGS},
    {"origin", (PyCFunction)SbkQWebDatabaseFunc_origin, METH_NOARGS},
    {"removeAllDatabases", (PyCFunction)SbkQWebDatabaseFunc_removeAllDatabases, METH_NOARGS|METH_STATIC},
    {"removeDatabase", (PyCFunction)SbkQWebDatabaseFunc_removeDatabase, METH_O|METH_STATIC},
    {"size", (PyCFunction)SbkQWebDatabaseFunc_size, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebDatabase_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebDatabase",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QWebDatabase >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebDatabase_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebDatabase_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QWebDatabase(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBDATABASE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebDatabase_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebDatabase_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebDatabase_Type));
    PyModule_AddObject(module, "QWebDatabase",
        ((PyObject*)&SbkQWebDatabase_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QWebDatabase >("QWebDatabase");
    Shiboken::TypeResolver::createValueTypeResolver<QWebDatabase >(typeid(QWebDatabase).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

