/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTWEBKIT_PYTHON_H
#define SBK_QTWEBKIT_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>

#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTWEBKIT_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTWEBKIT_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTWEBKIT_API
#endif
#endif

// Module Includes
#include <pyside_qtcore_python.h>
#include <pyside_qtgui_python.h>
#include <pyside_qtnetwork_python.h>

// Class Includes
#include <qwebsettings.h>
#include <qwebsecurityorigin.h>
#include <qwebhistory.h>
#include <qwebpage.h>
#include <qwebpluginfactory.h>
#include <qwebpluginfactory.h>
#include <qwebpluginfactory.h>
#include <qwebhistoryinterface.h>
#include <qwebinspector.h>
#include <qwebhistory.h>
#include <qwebdatabase.h>
#include <qwebframe.h>
#include <qwebframe.h>
#include <qwebsettings.h>
#include <qwebelement.h>
#include <qwebview.h>
#include <qgraphicswebview.h>
#include <qwebelement.h>

// Conversion Includes - Primitive Types
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QMap>
#include <QPair>
#include <QList>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QSet>
#include <QVector>

extern "C"
{

// Type indices
#define SBK_QWEBSECURITYORIGIN_IDX                                   0
#define SBK_QWEBPLUGINFACTORY_MIMETYPE_IDX                           1
#define SBK_QWEBPLUGINFACTORY_PLUGIN_IDX                             2
#define SBK_QWEBHISTORY_IDX                                          3
#define SBK_QWEBPAGE_IDX                                             4
#define SBK_QWEBPAGE_NAVIGATIONTYPE_IDX                              5
#define SBK_QWEBPAGE_WEBACTION_IDX                                   6
#define SBK_QWEBPAGE_WEBWINDOWTYPE_IDX                               7
#define SBK_QWEBPAGE_FINDFLAG_IDX                                    8
#define SBK_QFLAGS_QWEBPAGE_FINDFLAG__IDX                            9
#define SBK_QWEBPAGE_EXTENSION_IDX                                   10
#define SBK_QWEBPAGE_LINKDELEGATIONPOLICY_IDX                        11
#define SBK_QWEBPLUGINFACTORY_IDX                                    12
#define SBK_QWEBPLUGINFACTORY_EXTENSION_IDX                          13
#define SBK_QWEBHISTORYINTERFACE_IDX                                 14
#define SBK_QWEBINSPECTOR_IDX                                        15
#define SBK_QWEBHISTORYITEM_IDX                                      16
#define SBK_QWEBDATABASE_IDX                                         17
#define SBK_QWEBHITTESTRESULT_IDX                                    18
#define SBK_QWEBFRAME_IDX                                            19
#define SBK_QWEBFRAME_RENDERLAYER_IDX                                20
#define SBK_QWEBSETTINGS_IDX                                         21
#define SBK_QWEBSETTINGS_FONTSIZE_IDX                                22
#define SBK_QWEBSETTINGS_WEBGRAPHIC_IDX                              23
#define SBK_QWEBSETTINGS_FONTFAMILY_IDX                              24
#define SBK_QWEBSETTINGS_WEBATTRIBUTE_IDX                            25
#define SBK_QWEBELEMENT_IDX                                          26
#define SBK_QWEBELEMENT_STYLERESOLVESTRATEGY_IDX                     27
#define SBK_QWEBVIEW_IDX                                             28
#define SBK_QGRAPHICSWEBVIEW_IDX                                     29
#define SBK_QWEBELEMENTCOLLECTION_IDX                                30
#define SBK_QtWebKit_IDX_COUNT                                       31

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtWebKitTypes;

// Useful macros
#define SbkQWebSecurityOrigin_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSECURITYORIGIN_IDX])
#define SbkQWebSecurityOrigin_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSECURITYORIGIN_IDX])
#define SbkQWebHistory_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHISTORY_IDX])
#define SbkQWebHistory_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHISTORY_IDX])
#define SbkPySide_QtWebKit_QWebPage_NavigationType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_NAVIGATIONTYPE_IDX])
#define SbkPySide_QtWebKit_QWebPage_NavigationType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_NAVIGATIONTYPE_IDX])

#define SbkPySide_QtWebKit_QWebPage_WebAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBACTION_IDX])
#define SbkPySide_QtWebKit_QWebPage_WebAction_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBACTION_IDX])

#define SbkPySide_QtWebKit_QWebPage_WebWindowType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBWINDOWTYPE_IDX])
#define SbkPySide_QtWebKit_QWebPage_WebWindowType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBWINDOWTYPE_IDX])

#define SbkPySide_QtWebKit_QWebPage_FindFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_FINDFLAG_IDX])
#define SbkPySide_QtWebKit_QWebPage_FindFlag_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_FINDFLAG_IDX])
#define SbkPySide_QtWebKit_QWebPage_FindFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QFLAGS_QWEBPAGE_FINDFLAG__IDX])
#define SbkPySide_QtWebKit_QWebPage_FindFlags_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QFLAGS_QWEBPAGE_FINDFLAG__IDX])

#define SbkPySide_QtWebKit_QWebPage_Extension_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_EXTENSION_IDX])
#define SbkPySide_QtWebKit_QWebPage_Extension_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_EXTENSION_IDX])

#define SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_LINKDELEGATIONPOLICY_IDX])
#define SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_LINKDELEGATIONPOLICY_IDX])

#define SbkQWebPage_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_IDX])
#define SbkQWebPage_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_IDX])
#define SbkPySide_QtWebKit_QWebPluginFactory_Extension_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_EXTENSION_IDX])
#define SbkPySide_QtWebKit_QWebPluginFactory_Extension_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_EXTENSION_IDX])

#define SbkQWebPluginFactory_MimeType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_MIMETYPE_IDX])
#define SbkQWebPluginFactory_MimeType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_MIMETYPE_IDX])
#define SbkQWebPluginFactory_Plugin_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_PLUGIN_IDX])
#define SbkQWebPluginFactory_Plugin_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_PLUGIN_IDX])
#define SbkQWebPluginFactory_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX])
#define SbkQWebPluginFactory_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX])
#define SbkQWebHistoryInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYINTERFACE_IDX])
#define SbkQWebHistoryInterface_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYINTERFACE_IDX])
#define SbkQWebInspector_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBINSPECTOR_IDX])
#define SbkQWebInspector_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBINSPECTOR_IDX])
#define SbkQWebHistoryItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYITEM_IDX])
#define SbkQWebHistoryItem_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYITEM_IDX])
#define SbkQWebDatabase_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBDATABASE_IDX])
#define SbkQWebDatabase_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBDATABASE_IDX])
#define SbkQWebHitTestResult_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHITTESTRESULT_IDX])
#define SbkQWebHitTestResult_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBHITTESTRESULT_IDX])
#define SbkPySide_QtWebKit_QWebFrame_RenderLayer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_RENDERLAYER_IDX])
#define SbkPySide_QtWebKit_QWebFrame_RenderLayer_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_RENDERLAYER_IDX])

#define SbkQWebFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_IDX])
#define SbkQWebFrame_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_IDX])
#define SbkPySide_QtWebKit_QWebSettings_FontSize_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTSIZE_IDX])
#define SbkPySide_QtWebKit_QWebSettings_FontSize_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTSIZE_IDX])

#define SbkPySide_QtWebKit_QWebSettings_WebGraphic_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBGRAPHIC_IDX])
#define SbkPySide_QtWebKit_QWebSettings_WebGraphic_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBGRAPHIC_IDX])

#define SbkPySide_QtWebKit_QWebSettings_FontFamily_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTFAMILY_IDX])
#define SbkPySide_QtWebKit_QWebSettings_FontFamily_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTFAMILY_IDX])

#define SbkPySide_QtWebKit_QWebSettings_WebAttribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBATTRIBUTE_IDX])
#define SbkPySide_QtWebKit_QWebSettings_WebAttribute_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBATTRIBUTE_IDX])

#define SbkQWebSettings_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_IDX])
#define SbkQWebSettings_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_IDX])
#define SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_STYLERESOLVESTRATEGY_IDX])
#define SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_STYLERESOLVESTRATEGY_IDX])

#define SbkQWebElement_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_IDX])
#define SbkQWebElement_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_IDX])
#define SbkQWebView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBVIEW_IDX])
#define SbkQWebView_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBVIEW_IDX])
#define SbkQGraphicsWebView_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QGRAPHICSWEBVIEW_IDX])
#define SbkQGraphicsWebView_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QGRAPHICSWEBVIEW_IDX])
#define SbkQWebElementCollection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBELEMENTCOLLECTION_IDX])
#define SbkQWebElementCollection_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtWebKitTypes[SBK_QWEBELEMENTCOLLECTION_IDX])

} // extern "C"

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<>
inline PyTypeObject* SbkType<QWebSecurityOrigin >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBSECURITYORIGIN_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebHistory >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBHISTORY_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebPage::NavigationType >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_NAVIGATIONTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPage::WebAction >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBACTION_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPage::WebWindowType >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBWINDOWTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPage::FindFlag >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_FINDFLAG_IDX]; }
template<>
inline PyTypeObject* SbkType<QFlags<QWebPage::FindFlag> >() { return SbkPySide_QtWebKitTypes[SBK_QFLAGS_QWEBPAGE_FINDFLAG__IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPage::Extension >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_EXTENSION_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPage::LinkDelegationPolicy >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_LINKDELEGATIONPOLICY_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPage >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebPluginFactory::Extension >() { return SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_EXTENSION_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebPluginFactory >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebPluginFactory::MimeType >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_MIMETYPE_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebPluginFactory::Plugin >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_PLUGIN_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebHistoryInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYINTERFACE_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebInspector >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBINSPECTOR_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebHistoryItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYITEM_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebDatabase >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBDATABASE_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebHitTestResult >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBHITTESTRESULT_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebFrame::RenderLayer >() { return SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_RENDERLAYER_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBFRAME_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebSettings::FontSize >() { return SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTSIZE_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebSettings::WebGraphic >() { return SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBGRAPHIC_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebSettings::FontFamily >() { return SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTFAMILY_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebSettings::WebAttribute >() { return SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBATTRIBUTE_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebSettings >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebElement::StyleResolveStrategy >() { return SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_STYLERESOLVESTRATEGY_IDX]; }
template<>
inline PyTypeObject* SbkType<QWebElement >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBVIEW_IDX]); }
template<>
inline PyTypeObject* SbkType<QGraphicsWebView >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QGRAPHICSWEBVIEW_IDX]); }
template<>
inline PyTypeObject* SbkType<QWebElementCollection >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtWebKitTypes[SBK_QWEBELEMENTCOLLECTION_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QWebSecurityOrigin > : ValueTypeConverter<QWebSecurityOrigin >
{
};

template<>
struct Converter<QWebHistory* > : ObjectTypeConverter<QWebHistory >
{
};

template<>
struct Converter<QWebHistory& > : ObjectTypeReferenceConverter<QWebHistory >
{
};


template<>
struct Converter<QWebPage::NavigationType > : EnumConverter<QWebPage::NavigationType >
{
};

template<>
struct Converter<QWebPage::WebAction > : EnumConverter<QWebPage::WebAction >
{
};

template<>
struct Converter<QWebPage::WebWindowType > : EnumConverter<QWebPage::WebWindowType >
{
};

template<>
struct Converter<QWebPage::FindFlag > : EnumConverter<QWebPage::FindFlag >
{
};
template<>
struct Converter<QFlags<QWebPage::FindFlag> > : EnumConverter<QFlags<QWebPage::FindFlag> >
{
};

template<>
struct Converter<QWebPage::Extension > : EnumConverter<QWebPage::Extension >
{
};

template<>
struct Converter<QWebPage::LinkDelegationPolicy > : EnumConverter<QWebPage::LinkDelegationPolicy >
{
};

template<>
struct Converter<QWebPage* > : ObjectTypeConverter<QWebPage >
{
};

template<>
struct Converter<QWebPage& > : ObjectTypeReferenceConverter<QWebPage >
{
};


template<>
struct Converter<QWebPluginFactory::Extension > : EnumConverter<QWebPluginFactory::Extension >
{
};

template <>
struct SbkTypeInfo<QWebPluginFactory::MimeType >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QWebPluginFactory::MimeType > : ValueTypeConverter<QWebPluginFactory::MimeType >
{
};

template <>
struct SbkTypeInfo<QWebPluginFactory::Plugin >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QWebPluginFactory::Plugin > : ValueTypeConverter<QWebPluginFactory::Plugin >
{
};

template<>
struct Converter<QWebPluginFactory* > : ObjectTypeConverter<QWebPluginFactory >
{
};

template<>
struct Converter<QWebPluginFactory& > : ObjectTypeReferenceConverter<QWebPluginFactory >
{
};


template<>
struct Converter<QWebHistoryInterface* > : ObjectTypeConverter<QWebHistoryInterface >
{
};

template<>
struct Converter<QWebHistoryInterface& > : ObjectTypeReferenceConverter<QWebHistoryInterface >
{
};


template<>
struct Converter<QWebInspector* > : ObjectTypeConverter<QWebInspector >
{
};

template<>
struct Converter<QWebInspector& > : ObjectTypeReferenceConverter<QWebInspector >
{
};


template<>
struct Converter<QWebHistoryItem > : ValueTypeConverter<QWebHistoryItem >
{
};

template<>
struct Converter<QWebDatabase > : ValueTypeConverter<QWebDatabase >
{
};

template<>
struct Converter<QWebHitTestResult > : ValueTypeConverter<QWebHitTestResult >
{
};

template<>
struct Converter<QWebFrame::RenderLayer > : EnumConverter<QWebFrame::RenderLayer >
{
};

template<>
struct Converter<QWebFrame* > : ObjectTypeConverter<QWebFrame >
{
};

template<>
struct Converter<QWebFrame& > : ObjectTypeReferenceConverter<QWebFrame >
{
};


template<>
struct Converter<QWebSettings::FontSize > : EnumConverter<QWebSettings::FontSize >
{
};

template<>
struct Converter<QWebSettings::WebGraphic > : EnumConverter<QWebSettings::WebGraphic >
{
};

template<>
struct Converter<QWebSettings::FontFamily > : EnumConverter<QWebSettings::FontFamily >
{
};

template<>
struct Converter<QWebSettings::WebAttribute > : EnumConverter<QWebSettings::WebAttribute >
{
};

template<>
struct Converter<QWebSettings* > : ObjectTypeConverter<QWebSettings >
{
};

template<>
struct Converter<QWebSettings& > : ObjectTypeReferenceConverter<QWebSettings >
{
};


template<>
struct Converter<QWebElement::StyleResolveStrategy > : EnumConverter<QWebElement::StyleResolveStrategy >
{
};

template<>
struct Converter<QWebElement > : ValueTypeConverter<QWebElement >
{
};

template<>
struct Converter<QWebView* > : ObjectTypeConverter<QWebView >
{
};

template<>
struct Converter<QWebView& > : ObjectTypeReferenceConverter<QWebView >
{
};


template<>
struct Converter<QGraphicsWebView* > : ObjectTypeConverter<QGraphicsWebView >
{
};

template<>
struct Converter<QGraphicsWebView& > : ObjectTypeReferenceConverter<QGraphicsWebView >
{
};


template<>
struct Converter<QWebElementCollection > : ValueTypeConverter<QWebElementCollection >
{
};


} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTWEBKIT_PYTHON_H

