/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtsvg_python.h"

#include "qsvgrenderer_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmatrix.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qxmlstream.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSvgRendererWrapper::QSvgRendererWrapper(QObject * parent) : QSvgRenderer(parent), m_metaObject(0) {
    // ... middle
}

QSvgRendererWrapper::QSvgRendererWrapper(QXmlStreamReader * contents, QObject * parent) : QSvgRenderer(contents, parent), m_metaObject(0) {
    // ... middle
}

QSvgRendererWrapper::QSvgRendererWrapper(const QByteArray & contents, QObject * parent) : QSvgRenderer(contents, parent), m_metaObject(0) {
    // ... middle
}

QSvgRendererWrapper::QSvgRendererWrapper(const QString & filename, QObject * parent) : QSvgRenderer(filename, parent), m_metaObject(0) {
    // ... middle
}

void QSvgRendererWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSvgRendererWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSvgRendererWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSvgRendererWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSvgRendererWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSvgRenderer.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSvgRendererWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSvgRenderer.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSvgRendererWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSvgRendererWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSvgRenderer::staticMetaObject);
}
    return m_metaObject;
}

int QSvgRendererWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSvgRenderer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSvgRendererWrapper::~QSvgRendererWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSvgRenderer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSvgRendererWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSvgRenderer", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSvgRenderer(QObject*)
        cptr = new QSvgRendererWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // QSvgRenderer(QByteArray,QObject*)
            cptr = new QSvgRendererWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QSvgRenderer(QByteArray,QObject*)
            cptr = new QSvgRendererWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQSvgRenderer_Init_TypeError;
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSvgRenderer(QString,QObject*)
            cptr = new QSvgRendererWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QSvgRenderer(QString,QObject*)
            cptr = new QSvgRendererWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQSvgRenderer_Init_TypeError;
    } else if (Shiboken::Converter<QXmlStreamReader* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlStreamReader* cpp_arg0 = Shiboken::Converter<QXmlStreamReader* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QSvgRenderer(QXmlStreamReader*,QObject*)
            cptr = new QSvgRendererWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QSvgRenderer(QXmlStreamReader*,QObject*)
            cptr = new QSvgRendererWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQSvgRenderer_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSvgRenderer(QObject*)
        cptr = new QSvgRendererWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSvgRenderer_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSvgRenderer_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSvgRenderer_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QXmlStreamReader, PySide.QtCore.QObject = None", "PySide.QtCore.QByteArray, PySide.QtCore.QObject = None", "PySide.QtCore.QString, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSvg.QSvgRenderer", overloads);
        return -1;
}

static PyObject*
SbkQSvgRendererFunc_animated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // animated()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSvgRenderer::animated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_animationDuration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // animationDuration()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSvgRenderer::animationDuration();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_boundsOnElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // boundsOnElement(QString)const
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QSvgRenderer::boundsOnElement(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQSvgRendererFunc_boundsOnElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSvgRendererFunc_boundsOnElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.boundsOnElement", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_currentFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFrame()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSvgRenderer::currentFrame();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_defaultSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultSize()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QSvgRenderer::defaultSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_elementExists(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // elementExists(QString)const
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSvgRenderer::elementExists(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSvgRendererFunc_elementExists_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSvgRendererFunc_elementExists_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.elementExists", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_framesPerSecond(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // framesPerSecond()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSvgRenderer::framesPerSecond();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSvgRenderer::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_load(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // load(QByteArray)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSvgRenderer::load(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // load(QString)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSvgRenderer::load(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QXmlStreamReader* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamReader* cpp_arg0 = Shiboken::Converter<QXmlStreamReader* >::toCpp(arg);
        // load(QXmlStreamReader*)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSvgRenderer::load(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSvgRendererFunc_load_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSvgRendererFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamReader", "PySide.QtCore.QByteArray", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.load", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_matrixForElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // matrixForElement(QString)const
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        QMatrix cpp_result = cppSelf->QSvgRenderer::matrixForElement(*cpp_arg0);
        py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);
    } else goto SbkQSvgRendererFunc_matrixForElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSvgRendererFunc_matrixForElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.matrixForElement", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_render(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "render", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // render(QPainter*)
            QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
            cppSelf->QSvgRenderer::render(cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // render(QPainter*,QString,QRectF)
                QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
                cppSelf->QSvgRenderer::render(cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QRectF > cpp_arg2_auto_ptr;
                QRectF* cpp_arg2 = Shiboken::Converter<QRectF* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QRectF >(cpp_arg2);
                // render(QPainter*,QString,QRectF)
                QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
                cppSelf->QSvgRenderer::render(cpp_arg0, *cpp_arg1, *cpp_arg2);
            } else goto SbkQSvgRendererFunc_render_TypeError;
        } else if (numArgs == 2 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
            QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
            // render(QPainter*,QRectF)
            QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
            cppSelf->QSvgRenderer::render(cpp_arg0, *cpp_arg1);
        } else goto SbkQSvgRendererFunc_render_TypeError;
    } else goto SbkQSvgRendererFunc_render_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgRendererFunc_render_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", "PySide.QtGui.QPainter, PySide.QtCore.QRectF", "PySide.QtGui.QPainter, PySide.QtCore.QString, PySide.QtCore.QRectF = QRectF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSvg.QSvgRenderer.render", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_setCurrentFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentFrame(int)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        cppSelf->QSvgRenderer::setCurrentFrame(cpp_arg0);
    } else goto SbkQSvgRendererFunc_setCurrentFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgRendererFunc_setCurrentFrame_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.setCurrentFrame", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_setFramesPerSecond(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFramesPerSecond(int)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        cppSelf->QSvgRenderer::setFramesPerSecond(cpp_arg0);
    } else goto SbkQSvgRendererFunc_setFramesPerSecond_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgRendererFunc_setFramesPerSecond_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.setFramesPerSecond", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_setViewBox(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setViewBox(QRect)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        cppSelf->QSvgRenderer::setViewBox(*cpp_arg0);
    } else if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setViewBox(QRectF)
        QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
        cppSelf->QSvgRenderer::setViewBox(*cpp_arg0);
    } else goto SbkQSvgRendererFunc_setViewBox_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgRendererFunc_setViewBox_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgRenderer.setViewBox", overloads);
        return 0;
}

static PyObject*
SbkQSvgRendererFunc_viewBox(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewBox()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QSvgRenderer::viewBox();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgRendererFunc_viewBoxF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewBoxF()const
    QSvgRenderer* cppSelf = Shiboken::Converter<QSvgRenderer* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QSvgRenderer::viewBoxF();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSvgRenderer_methods[] = {
    {"animated", (PyCFunction)SbkQSvgRendererFunc_animated, METH_NOARGS},
    {"animationDuration", (PyCFunction)SbkQSvgRendererFunc_animationDuration, METH_NOARGS},
    {"boundsOnElement", (PyCFunction)SbkQSvgRendererFunc_boundsOnElement, METH_O},
    {"currentFrame", (PyCFunction)SbkQSvgRendererFunc_currentFrame, METH_NOARGS},
    {"defaultSize", (PyCFunction)SbkQSvgRendererFunc_defaultSize, METH_NOARGS},
    {"elementExists", (PyCFunction)SbkQSvgRendererFunc_elementExists, METH_O},
    {"framesPerSecond", (PyCFunction)SbkQSvgRendererFunc_framesPerSecond, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSvgRendererFunc_isValid, METH_NOARGS},
    {"load", (PyCFunction)SbkQSvgRendererFunc_load, METH_O},
    {"matrixForElement", (PyCFunction)SbkQSvgRendererFunc_matrixForElement, METH_O},
    {"render", (PyCFunction)SbkQSvgRendererFunc_render, METH_VARARGS},
    {"setCurrentFrame", (PyCFunction)SbkQSvgRendererFunc_setCurrentFrame, METH_O},
    {"setFramesPerSecond", (PyCFunction)SbkQSvgRendererFunc_setFramesPerSecond, METH_O},
    {"setViewBox", (PyCFunction)SbkQSvgRendererFunc_setViewBox, METH_O},
    {"viewBox", (PyCFunction)SbkQSvgRendererFunc_viewBox, METH_NOARGS},
    {"viewBoxF", (PyCFunction)SbkQSvgRendererFunc_viewBoxF, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSvgRenderer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSvg.QSvgRenderer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSvgRendererWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSvgRenderer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSvgRenderer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSvgRenderer(PyObject* module)
{
    SbkPySide_QtSvgTypes[SBK_QSVGRENDERER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSvgRenderer_Type);

    SbkQSvgRenderer_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQSvgRenderer_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSvgRenderer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSvgRenderer_Type));
    PyModule_AddObject(module, "QSvgRenderer",
        ((PyObject*)&SbkQSvgRenderer_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSvgRenderer >("QSvgRenderer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSvgRenderer >(typeid(QSvgRenderer).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

