/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqlresult_wrapper.h"

// Extra includes
#include <QSize>
#include <QSqlError>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QStringList>
#include <QVector>
#include <qsqldriver.h>
#include <qsqlerror.h>
#include <qsqlrecord.h>
#include <qsqlresult.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSqlResultWrapper::QSqlResultWrapper(const QSqlDriver * db) : QSqlResult(db) {
    // ... middle
}

void QSqlResultWrapper::bindValue(const QString & placeholder, const QVariant & val, QFlags<QSql::ParamTypeFlag> type)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bindValue"));
    if (py_override.isNull()) {
        return this->QSqlResult::bindValue(placeholder, val, type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(placeholder),
        Shiboken::Converter<QVariant& >::toPython(val),
        Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlResultWrapper::bindValue(int pos, const QVariant & val, QFlags<QSql::ParamTypeFlag> type)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bindValue"));
    if (py_override.isNull()) {
        return this->QSqlResult::bindValue(pos, val, type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOO)",
        pos,
        Shiboken::Converter<QVariant& >::toPython(val),
        Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QSqlResultWrapper::data(int i)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.data()' not implemented.");
        return QVariant();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        i
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::exec()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "exec_"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlResult::exec();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.exec_");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::fetch(int i)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetch"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.fetch()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        i
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.fetch");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::fetchFirst()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchFirst"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.fetchFirst()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.fetchFirst");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::fetchLast()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchLast"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.fetchLast()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.fetchLast");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::fetchNext()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchNext"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlResult::fetchNext();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.fetchNext");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::fetchPrevious()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchPrevious"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlResult::fetchPrevious();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.fetchPrevious");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QSqlResultWrapper::handle() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "handle"));
    if (py_override.isNull()) {
        return this->QSqlResult::handle();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.handle");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::isNull(int i)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isNull"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.isNull()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        i
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.isNull");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QSqlResultWrapper::lastInsertId() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "lastInsertId"));
    if (py_override.isNull()) {
        return this->QSqlResult::lastInsertId();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.lastInsertId");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

int QSqlResultWrapper::numRowsAffected()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "numRowsAffected"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.numRowsAffected()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.numRowsAffected");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::prepare(const QString & query)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "prepare"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlResult::prepare(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.prepare");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QSqlRecord QSqlResultWrapper::record() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "record"));
    if (py_override.isNull()) {
        return this->QSqlResult::record();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSqlRecord();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSqlRecord >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.record");
        return QSqlRecord()        ;
    }
    QSqlRecord cpp_result(Shiboken::Converter<QSqlRecord >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::reset(const QString & sqlquery)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.reset()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(sqlquery)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.reset");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlResultWrapper::savePrepare(const QString & sqlquery)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "savePrepare"));
    if (py_override.isNull()) {
        return this->QSqlResult::savePrepare(sqlquery);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(sqlquery)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.savePrepare");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlResultWrapper::setActive(bool a)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setActive"));
    if (py_override.isNull()) {
        return this->QSqlResult::setActive(a);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(a)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlResultWrapper::setAt(int at)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setAt"));
    if (py_override.isNull()) {
        return this->QSqlResult::setAt(at);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        at
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlResultWrapper::setForwardOnly(bool forward)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setForwardOnly"));
    if (py_override.isNull()) {
        return this->QSqlResult::setForwardOnly(forward);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(forward)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlResultWrapper::setLastError(const QSqlError & e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setLastError"));
    if (py_override.isNull()) {
        return this->QSqlResult::setLastError(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QSqlError& >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlResultWrapper::setQuery(const QString & query)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setQuery"));
    if (py_override.isNull()) {
        return this->QSqlResult::setQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlResultWrapper::setSelect(bool s)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelect"));
    if (py_override.isNull()) {
        return this->QSqlResult::setSelect(s);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(s)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QSqlResultWrapper::size()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.size()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlResult.size");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSqlResultWrapper::~QSqlResultWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQSqlResult_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlResultWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtSqlTypes[SBK_QSQLRESULT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSqlResult' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSqlResult", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QSqlDriver* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlDriver* cpp_arg0 = Shiboken::Converter<QSqlDriver* >::toCpp(pyargs[0]);
        // QSqlResult(const QSqlDriver*)
        cptr = new QSqlResultWrapper(cpp_arg0);
    } else goto SbkQSqlResult_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlResult_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlResult_Init_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlDriver", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlResult", overloads);
        return -1;
}

static PyObject*
SbkQSqlResultFunc_addBindValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addBindValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QVariant& >::isConvertible(pyargs[0]) && SbkPySide_QtSql_QSql_ParamTypeFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        QFlags<QSql::ParamTypeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toCpp(pyargs[1]);
        // addBindValue(QVariant,QFlags<QSql::ParamTypeFlag>)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::addBindValue(*cpp_arg0, cpp_arg1);
    } else goto SbkQSqlResultFunc_addBindValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_addBindValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant, PySide.QtSql.QSql.ParamType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlResult.addBindValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_at(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // at()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlResult::at();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_bindValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "bindValue", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]) && SbkPySide_QtSql_QSql_ParamTypeFlag_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        QFlags<QSql::ParamTypeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toCpp(pyargs[2]);
        // bindValue(int,QVariant,QFlags<QSql::ParamTypeFlag>)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::bindValue(cpp_arg0, *cpp_arg1, cpp_arg2);
    } else if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]) && SbkPySide_QtSql_QSql_ParamTypeFlag_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        QFlags<QSql::ParamTypeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toCpp(pyargs[2]);
        // bindValue(QString,QVariant,QFlags<QSql::ParamTypeFlag>)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::bindValue(*cpp_arg0, *cpp_arg1, cpp_arg2);
    } else goto SbkQSqlResultFunc_bindValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_bindValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant, PySide.QtSql.QSql.ParamType", "int, PySide.QtCore.QVariant, PySide.QtSql.QSql.ParamType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlResult.bindValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_bindValueType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // bindValueType(int)const
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        QFlags<QSql::ParamTypeFlag> cpp_result = cppSelf->QSqlResult::bindValueType(cpp_arg0);
        py_result = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // bindValueType(QString)const
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        QFlags<QSql::ParamTypeFlag> cpp_result = cppSelf->QSqlResult::bindValueType(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_bindValueType_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_bindValueType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.bindValueType", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_bindingSyntax(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bindingSyntax()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QSqlResult::BindingSyntax cpp_result = cppSelf->QSqlResult::bindingSyntax();
    py_result = Shiboken::Converter<QSqlResult::BindingSyntax >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_boundValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // boundValue(int)const
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlResult::boundValue(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // boundValue(QString)const
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlResult::boundValue(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_boundValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_boundValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.boundValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_boundValueCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundValueCount()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlResult::boundValueCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_boundValueName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // boundValueName(int)const
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QSqlResult::boundValueName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_boundValueName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_boundValueName_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.boundValueName", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_boundValues(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundValues()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QVector<QVariant > & cpp_result = cppSelf->QSqlResult::boundValues();
    py_result = Shiboken::Converter<QVector<QVariant >  >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    cppSelf->QSqlResult::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlResultFunc_data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // data(int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.data()' not implemented.");
            return 0;
        }
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->data(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_data_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.data", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_detachFromResultSet(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // detachFromResultSet()
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    cppSelf->QSqlResult::detachFromResultSet();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlResultFunc_driver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // driver()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    const QSqlDriver * cpp_result = cppSelf->QSqlResult::driver();
    py_result = Shiboken::Converter<QSqlDriver* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_execBatch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // execBatch(bool)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlResult::execBatch();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // execBatch(bool)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlResult::execBatch(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_execBatch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_execBatch_TypeError:
        const char* overloads[] = {"bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.execBatch", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_exec_(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // exec()
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlResult::exec();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_executedQuery(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // executedQuery()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlResult::executedQuery();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_fetch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // fetch(int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.fetch()' not implemented.");
            return 0;
        }
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->fetch(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_fetch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_fetch_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.fetch", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_fetchFirst(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // fetchFirst()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.fetchFirst()' not implemented.");
        return 0;
    }
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->fetchFirst();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_fetchLast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // fetchLast()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.fetchLast()' not implemented.");
        return 0;
    }
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->fetchLast();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_fetchNext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // fetchNext()
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlResult::fetchNext();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_fetchPrevious(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // fetchPrevious()
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlResult::fetchPrevious();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QSqlResult::handle();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_hasOutValues(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasOutValues()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlResult::hasOutValues();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlResult::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_isForwardOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isForwardOnly()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlResult::isForwardOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_isNull(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isNull(int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.isNull()' not implemented.");
            return 0;
        }
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->isNull(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_isNull_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_isNull_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.isNull", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_isSelect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelect()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlResult::isSelect();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlResult::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_lastError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastError()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QSqlError cpp_result = cppSelf->QSqlResult::lastError();
    py_result = Shiboken::Converter<QSqlError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_lastInsertId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastInsertId()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QSqlResult::lastInsertId();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_lastQuery(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastQuery()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlResult::lastQuery();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_nextResult(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextResult()
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlResult::nextResult();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_numRowsAffected(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numRowsAffected()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.numRowsAffected()' not implemented.");
        return 0;
    }
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->numRowsAffected();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_numericalPrecisionPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numericalPrecisionPolicy()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QSql::NumericalPrecisionPolicy cpp_result = cppSelf->QSqlResult::numericalPrecisionPolicy();
    py_result = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_prepare(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prepare(QString)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSqlResult::prepare(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_prepare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_prepare_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.prepare", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_record(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // record()const
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    QSqlRecord cpp_result = cppSelf->QSqlResult::record();
    py_result = Shiboken::Converter<QSqlRecord >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlResultFunc_reset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // reset(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.reset()' not implemented.");
            return 0;
        }
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->reset(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_reset_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_reset_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.reset", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_savePrepare(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // savePrepare(QString)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlResult::savePrepare(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlResultFunc_savePrepare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlResultFunc_savePrepare_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.savePrepare", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setActive(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setActive(bool)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setActive(cpp_arg0);
    } else goto SbkQSqlResultFunc_setActive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setActive_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setActive", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAt(int)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setAt(cpp_arg0);
    } else goto SbkQSqlResultFunc_setAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setAt", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setForwardOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setForwardOnly(bool)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setForwardOnly(cpp_arg0);
    } else goto SbkQSqlResultFunc_setForwardOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setForwardOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setForwardOnly", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setLastError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSqlError& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSqlError* cpp_arg0 = Shiboken::Converter<QSqlError* >::toCpp(arg);
        // setLastError(QSqlError)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setLastError(*cpp_arg0);
    } else goto SbkQSqlResultFunc_setLastError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setLastError_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlError", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setLastError", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setNumericalPrecisionPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSql::NumericalPrecisionPolicy >::isConvertible(arg)) {
        QSql::NumericalPrecisionPolicy cpp_arg0 = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toCpp(arg);
        // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setNumericalPrecisionPolicy(cpp_arg0);
    } else goto SbkQSqlResultFunc_setNumericalPrecisionPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setNumericalPrecisionPolicy_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSql.NumericalPrecisionPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setNumericalPrecisionPolicy", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setQuery(QString)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setQuery(*cpp_arg0);
    } else goto SbkQSqlResultFunc_setQuery_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setQuery", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_setSelect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSelect(bool)
        QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
        cppSelf->QSqlResult::setSelect(cpp_arg0);
    } else goto SbkQSqlResultFunc_setSelect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlResultFunc_setSelect_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlResult.setSelect", overloads);
        return 0;
}

static PyObject*
SbkQSqlResultFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlResult.size()' not implemented.");
        return 0;
    }
    QSqlResult* cppSelf = Shiboken::Converter<QSqlResult* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSqlResult_methods[] = {
    {"addBindValue", (PyCFunction)SbkQSqlResultFunc_addBindValue, METH_VARARGS},
    {"at", (PyCFunction)SbkQSqlResultFunc_at, METH_NOARGS},
    {"bindValue", (PyCFunction)SbkQSqlResultFunc_bindValue, METH_VARARGS},
    {"bindValueType", (PyCFunction)SbkQSqlResultFunc_bindValueType, METH_O},
    {"bindingSyntax", (PyCFunction)SbkQSqlResultFunc_bindingSyntax, METH_NOARGS},
    {"boundValue", (PyCFunction)SbkQSqlResultFunc_boundValue, METH_O},
    {"boundValueCount", (PyCFunction)SbkQSqlResultFunc_boundValueCount, METH_NOARGS},
    {"boundValueName", (PyCFunction)SbkQSqlResultFunc_boundValueName, METH_O},
    {"boundValues", (PyCFunction)SbkQSqlResultFunc_boundValues, METH_NOARGS},
    {"clear", (PyCFunction)SbkQSqlResultFunc_clear, METH_NOARGS},
    {"data", (PyCFunction)SbkQSqlResultFunc_data, METH_O},
    {"detachFromResultSet", (PyCFunction)SbkQSqlResultFunc_detachFromResultSet, METH_NOARGS},
    {"driver", (PyCFunction)SbkQSqlResultFunc_driver, METH_NOARGS},
    {"execBatch", (PyCFunction)SbkQSqlResultFunc_execBatch, METH_NOARGS|METH_O},
    {"exec_", (PyCFunction)SbkQSqlResultFunc_exec_, METH_NOARGS},
    {"executedQuery", (PyCFunction)SbkQSqlResultFunc_executedQuery, METH_NOARGS},
    {"fetch", (PyCFunction)SbkQSqlResultFunc_fetch, METH_O},
    {"fetchFirst", (PyCFunction)SbkQSqlResultFunc_fetchFirst, METH_NOARGS},
    {"fetchLast", (PyCFunction)SbkQSqlResultFunc_fetchLast, METH_NOARGS},
    {"fetchNext", (PyCFunction)SbkQSqlResultFunc_fetchNext, METH_NOARGS},
    {"fetchPrevious", (PyCFunction)SbkQSqlResultFunc_fetchPrevious, METH_NOARGS},
    {"handle", (PyCFunction)SbkQSqlResultFunc_handle, METH_NOARGS},
    {"hasOutValues", (PyCFunction)SbkQSqlResultFunc_hasOutValues, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQSqlResultFunc_isActive, METH_NOARGS},
    {"isForwardOnly", (PyCFunction)SbkQSqlResultFunc_isForwardOnly, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSqlResultFunc_isNull, METH_O},
    {"isSelect", (PyCFunction)SbkQSqlResultFunc_isSelect, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSqlResultFunc_isValid, METH_NOARGS},
    {"lastError", (PyCFunction)SbkQSqlResultFunc_lastError, METH_NOARGS},
    {"lastInsertId", (PyCFunction)SbkQSqlResultFunc_lastInsertId, METH_NOARGS},
    {"lastQuery", (PyCFunction)SbkQSqlResultFunc_lastQuery, METH_NOARGS},
    {"nextResult", (PyCFunction)SbkQSqlResultFunc_nextResult, METH_NOARGS},
    {"numRowsAffected", (PyCFunction)SbkQSqlResultFunc_numRowsAffected, METH_NOARGS},
    {"numericalPrecisionPolicy", (PyCFunction)SbkQSqlResultFunc_numericalPrecisionPolicy, METH_NOARGS},
    {"prepare", (PyCFunction)SbkQSqlResultFunc_prepare, METH_O},
    {"record", (PyCFunction)SbkQSqlResultFunc_record, METH_NOARGS},
    {"reset", (PyCFunction)SbkQSqlResultFunc_reset, METH_O},
    {"savePrepare", (PyCFunction)SbkQSqlResultFunc_savePrepare, METH_O},
    {"setActive", (PyCFunction)SbkQSqlResultFunc_setActive, METH_O},
    {"setAt", (PyCFunction)SbkQSqlResultFunc_setAt, METH_O},
    {"setForwardOnly", (PyCFunction)SbkQSqlResultFunc_setForwardOnly, METH_O},
    {"setLastError", (PyCFunction)SbkQSqlResultFunc_setLastError, METH_O},
    {"setNumericalPrecisionPolicy", (PyCFunction)SbkQSqlResultFunc_setNumericalPrecisionPolicy, METH_O},
    {"setQuery", (PyCFunction)SbkQSqlResultFunc_setQuery, METH_O},
    {"setSelect", (PyCFunction)SbkQSqlResultFunc_setSelect, METH_O},
    {"size", (PyCFunction)SbkQSqlResultFunc_size, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlResult_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlResult",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlResultWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlResult_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlResult_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQSqlResult_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQSqlResult_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QSqlResult*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtSql_QSqlResult_BindingSyntax_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlResult_BindingSyntax_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlResult_BindingSyntax_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BindingSyntax",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlResult_BindingSyntax_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlResult_BindingSyntax_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlResult_BindingSyntax_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtSql_QSqlResult_VirtualHookOperation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlResult_VirtualHookOperation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "VirtualHookOperation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlResult_VirtualHookOperation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlResult_VirtualHookOperation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlResult_VirtualHookOperation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSqlResult(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLRESULT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlResult_Type);

    // Fill type discovery information
    SbkQSqlResult_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQSqlResult_Type.type_discovery->addTypeDiscoveryFunction(&SbkQSqlResult_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQSqlResult_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlResult_Type));
    PyModule_AddObject(module, "QSqlResult",
        ((PyObject*)&SbkQSqlResult_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: BindingSyntax
    SbkPySide_QtSqlTypes[SBK_QSQLRESULT_BINDINGSYNTAX_IDX] = &SbkPySide_QtSql_QSqlResult_BindingSyntax_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlResult_BindingSyntax_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlResult_BindingSyntax_Type);
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
            "BindingSyntax",((PyObject*)&SbkPySide_QtSql_QSqlResult_BindingSyntax_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlResult_BindingSyntax_Type,
        (long) QSqlResult::PositionalBinding, "PositionalBinding");
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
        "PositionalBinding", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlResult_BindingSyntax_Type.tp_dict,
        "PositionalBinding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlResult_BindingSyntax_Type,
        (long) QSqlResult::NamedBinding, "NamedBinding");
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
        "NamedBinding", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlResult_BindingSyntax_Type.tp_dict,
        "NamedBinding", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlResult::BindingSyntax");

    // init enum class: VirtualHookOperation
    SbkPySide_QtSqlTypes[SBK_QSQLRESULT_VIRTUALHOOKOPERATION_IDX] = &SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type);
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
            "VirtualHookOperation",((PyObject*)&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type,
        (long) QSqlResult::BatchOperation, "BatchOperation");
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
        "BatchOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type.tp_dict,
        "BatchOperation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type,
        (long) QSqlResult::DetachFromResultSet, "DetachFromResultSet");
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
        "DetachFromResultSet", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type.tp_dict,
        "DetachFromResultSet", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type,
        (long) QSqlResult::SetNumericalPrecision, "SetNumericalPrecision");
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
        "SetNumericalPrecision", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type.tp_dict,
        "SetNumericalPrecision", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type,
        (long) QSqlResult::NextResult, "NextResult");
    PyDict_SetItemString(SbkQSqlResult_Type.super.ht_type.tp_dict,
        "NextResult", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Type.tp_dict,
        "NextResult", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlResult::VirtualHookOperation");

    Shiboken::TypeResolver::createObjectTypeResolver<QSqlResult >("QSqlResult*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSqlResult >(typeid(QSqlResult).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

