/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqlerror_wrapper.h"

// Extra includes
#include <qsqlerror.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQSqlError_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlError* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QSqlError", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QSqlError(QString,QString,QSqlError::ErrorType,int)
        cptr = new QSqlError();
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSqlError(QString,QString,QSqlError::ErrorType,int)
            cptr = new QSqlError(*cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QSqlError(QString,QString,QSqlError::ErrorType,int)
                cptr = new QSqlError(*cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QSqlError::ErrorType >::isConvertible(pyargs[2])) {
                QSqlError::ErrorType cpp_arg2 = Shiboken::Converter<QSqlError::ErrorType >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QSqlError(QString,QString,QSqlError::ErrorType,int)
                    cptr = new QSqlError(*cpp_arg0, *cpp_arg1, cpp_arg2);
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // QSqlError(QString,QString,QSqlError::ErrorType,int)
                    cptr = new QSqlError(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                } else goto SbkQSqlError_Init_TypeError;
            } else goto SbkQSqlError_Init_TypeError;
        } else goto SbkQSqlError_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSqlError& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlError* cpp_arg0 = Shiboken::Converter<QSqlError* >::toCpp(pyargs[0]);
        // QSqlError(QSqlError)
        cptr = new QSqlError(*cpp_arg0);
    } else goto SbkQSqlError_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlError_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlError_Init_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlError", "PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtSql.QSqlError.ErrorType = NoError, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlError", overloads);
        return -1;
}

static PyObject*
SbkQSqlErrorFunc_databaseText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // databaseText()const
    QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlError::databaseText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlErrorFunc_driverText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // driverText()const
    QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlError::driverText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlErrorFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlError::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlErrorFunc_number(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // number()const
    QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlError::number();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlErrorFunc_setDatabaseText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDatabaseText(QString)
        QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
        cppSelf->QSqlError::setDatabaseText(*cpp_arg0);
    } else goto SbkQSqlErrorFunc_setDatabaseText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlErrorFunc_setDatabaseText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlError.setDatabaseText", overloads);
        return 0;
}

static PyObject*
SbkQSqlErrorFunc_setDriverText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDriverText(QString)
        QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
        cppSelf->QSqlError::setDriverText(*cpp_arg0);
    } else goto SbkQSqlErrorFunc_setDriverText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlErrorFunc_setDriverText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlError.setDriverText", overloads);
        return 0;
}

static PyObject*
SbkQSqlErrorFunc_setNumber(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setNumber(int)
        QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
        cppSelf->QSqlError::setNumber(cpp_arg0);
    } else goto SbkQSqlErrorFunc_setNumber_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlErrorFunc_setNumber_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlError.setNumber", overloads);
        return 0;
}

static PyObject*
SbkQSqlErrorFunc_setType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSqlError::ErrorType >::isConvertible(arg)) {
        QSqlError::ErrorType cpp_arg0 = Shiboken::Converter<QSqlError::ErrorType >::toCpp(arg);
        // setType(QSqlError::ErrorType)
        QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
        cppSelf->QSqlError::setType(cpp_arg0);
    } else goto SbkQSqlErrorFunc_setType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlErrorFunc_setType_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlError.ErrorType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlError.setType", overloads);
        return 0;
}

static PyObject*
SbkQSqlErrorFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlError::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlErrorFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QSqlError* cppSelf = Shiboken::Converter<QSqlError* >::toCpp((PyObject*)self);
    QSqlError::ErrorType cpp_result = cppSelf->QSqlError::type();
    py_result = Shiboken::Converter<QSqlError::ErrorType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSqlError_methods[] = {
    {"databaseText", (PyCFunction)SbkQSqlErrorFunc_databaseText, METH_NOARGS},
    {"driverText", (PyCFunction)SbkQSqlErrorFunc_driverText, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSqlErrorFunc_isValid, METH_NOARGS},
    {"number", (PyCFunction)SbkQSqlErrorFunc_number, METH_NOARGS},
    {"setDatabaseText", (PyCFunction)SbkQSqlErrorFunc_setDatabaseText, METH_O},
    {"setDriverText", (PyCFunction)SbkQSqlErrorFunc_setDriverText, METH_O},
    {"setNumber", (PyCFunction)SbkQSqlErrorFunc_setNumber, METH_O},
    {"setType", (PyCFunction)SbkQSqlErrorFunc_setType, METH_O},
    {"text", (PyCFunction)SbkQSqlErrorFunc_text, METH_NOARGS},
    {"type", (PyCFunction)SbkQSqlErrorFunc_type, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlError_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlError >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlError_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlError_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtSql_QSqlError_ErrorType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlError_ErrorType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlError_ErrorType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ErrorType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlError_ErrorType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlError_ErrorType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlError_ErrorType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSqlError(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLERROR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlError_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSqlError_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlError_Type));
    PyModule_AddObject(module, "QSqlError",
        ((PyObject*)&SbkQSqlError_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ErrorType
    SbkPySide_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX] = &SbkPySide_QtSql_QSqlError_ErrorType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlError_ErrorType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlError_ErrorType_Type);
    PyDict_SetItemString(SbkQSqlError_Type.super.ht_type.tp_dict,
            "ErrorType",((PyObject*)&SbkPySide_QtSql_QSqlError_ErrorType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlError_ErrorType_Type,
        (long) QSqlError::NoError, "NoError");
    PyDict_SetItemString(SbkQSqlError_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlError_ErrorType_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlError_ErrorType_Type,
        (long) QSqlError::ConnectionError, "ConnectionError");
    PyDict_SetItemString(SbkQSqlError_Type.super.ht_type.tp_dict,
        "ConnectionError", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlError_ErrorType_Type.tp_dict,
        "ConnectionError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlError_ErrorType_Type,
        (long) QSqlError::StatementError, "StatementError");
    PyDict_SetItemString(SbkQSqlError_Type.super.ht_type.tp_dict,
        "StatementError", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlError_ErrorType_Type.tp_dict,
        "StatementError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlError_ErrorType_Type,
        (long) QSqlError::TransactionError, "TransactionError");
    PyDict_SetItemString(SbkQSqlError_Type.super.ht_type.tp_dict,
        "TransactionError", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlError_ErrorType_Type.tp_dict,
        "TransactionError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlError_ErrorType_Type,
        (long) QSqlError::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQSqlError_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlError_ErrorType_Type.tp_dict,
        "UnknownError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlError::ErrorType");

    Shiboken::TypeResolver::createValueTypeResolver<QSqlError >("QSqlError");
    Shiboken::TypeResolver::createValueTypeResolver<QSqlError >(typeid(QSqlError).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

