/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsql_wrapper.h"

// Extra includes
#include <QtSql/qsql.h>

using namespace Shiboken;

static PyMethodDef SbkQSql_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSql_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSql",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSql_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NumericalPrecisionPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtSql_QSql_Location_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSql_Location_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSql_Location_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Location",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSql_Location_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSql_Location_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSql_Location_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtSql_QSql_ParamTypeFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSql::ParamType >::toPython(
        ((QSql::ParamType) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QSql::ParamType >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtSql_QSql_ParamTypeFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSql::ParamType >::toPython(
        ((QSql::ParamType) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QSql::ParamType >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtSql_QSql_ParamTypeFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSql::ParamType >::toPython(
        ((QSql::ParamType) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QSql::ParamType >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtSql_QSql_ParamTypeFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSql::ParamType >::toPython(
        ~ Shiboken::Converter< QSql::ParamType >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtSql_QSql_ParamTypeFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtSql_QSql_ParamTypeFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtSql_QSql_ParamTypeFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtSql_QSql_ParamTypeFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtSql_QSql_ParamTypeFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtSql_QSql_ParamTypeFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSql_ParamTypeFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSql_ParamTypeFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ParamTypeFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtSql_QSql_ParamTypeFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSql_ParamTypeFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSql_ParamTypeFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSql_ParamTypeFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSql_ParamType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSql_ParamType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ParamType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtSql_QSql_ParamTypeFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSql_ParamType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSql_ParamType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtSql_QSql_ParamType_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtSql_QSql_TableType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSql_TableType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSql_TableType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TableType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSql_TableType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSql_TableType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSql_TableType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSql(PyObject* module)
{
    if (PyType_Ready((PyTypeObject*)&SbkQSql_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSql_Type));
    PyModule_AddObject(module, "QSql",
        ((PyObject*)&SbkQSql_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: NumericalPrecisionPolicy
    SbkPySide_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX] = &SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type);
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
            "NumericalPrecisionPolicy",((PyObject*)&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type,
        (long) QSql::LowPrecisionInt32, "LowPrecisionInt32");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "LowPrecisionInt32", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type.tp_dict,
        "LowPrecisionInt32", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type,
        (long) QSql::LowPrecisionInt64, "LowPrecisionInt64");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "LowPrecisionInt64", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type.tp_dict,
        "LowPrecisionInt64", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type,
        (long) QSql::LowPrecisionDouble, "LowPrecisionDouble");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "LowPrecisionDouble", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type.tp_dict,
        "LowPrecisionDouble", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type,
        (long) QSql::HighPrecision, "HighPrecision");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "HighPrecision", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Type.tp_dict,
        "HighPrecision", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSql::NumericalPrecisionPolicy");

    // init enum class: Location
    SbkPySide_QtSqlTypes[SBK_QSQL_LOCATION_IDX] = &SbkPySide_QtSql_QSql_Location_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSql_Location_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSql_Location_Type);
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
            "Location",((PyObject*)&SbkPySide_QtSql_QSql_Location_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_Location_Type,
        (long) QSql::BeforeFirstRow, "BeforeFirstRow");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "BeforeFirstRow", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_Location_Type.tp_dict,
        "BeforeFirstRow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_Location_Type,
        (long) QSql::AfterLastRow, "AfterLastRow");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "AfterLastRow", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_Location_Type.tp_dict,
        "AfterLastRow", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSql::Location");

    // init enum class: ParamTypeFlag
    SbkPySide_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX] = &SbkPySide_QtSql_QSql_ParamTypeFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSql_ParamTypeFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSql_ParamTypeFlag_Type);
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
            "ParamTypeFlag",((PyObject*)&SbkPySide_QtSql_QSql_ParamTypeFlag_Type));

    // init flags class: QFlags<QSql::ParamTypeFlag>
    SbkPySide_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG__IDX] = &SbkPySide_QtSql_QSql_ParamType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSql_ParamType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSql_ParamType_Type);
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
            "ParamType",((PyObject*)&SbkPySide_QtSql_QSql_ParamType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_ParamTypeFlag_Type,
        (long) QSql::In, "In");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "In", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_ParamTypeFlag_Type.tp_dict,
        "In", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_ParamTypeFlag_Type,
        (long) QSql::Out, "Out");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "Out", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_ParamTypeFlag_Type.tp_dict,
        "Out", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_ParamTypeFlag_Type,
        (long) QSql::InOut, "InOut");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "InOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_ParamTypeFlag_Type.tp_dict,
        "InOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_ParamTypeFlag_Type,
        (long) QSql::Binary, "Binary");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "Binary", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_ParamTypeFlag_Type.tp_dict,
        "Binary", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSql::ParamTypeFlag");

    // init enum class: TableType
    SbkPySide_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX] = &SbkPySide_QtSql_QSql_TableType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSql_TableType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSql_TableType_Type);
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
            "TableType",((PyObject*)&SbkPySide_QtSql_QSql_TableType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_TableType_Type,
        (long) QSql::Tables, "Tables");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "Tables", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_TableType_Type.tp_dict,
        "Tables", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_TableType_Type,
        (long) QSql::SystemTables, "SystemTables");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "SystemTables", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_TableType_Type.tp_dict,
        "SystemTables", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_TableType_Type,
        (long) QSql::Views, "Views");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "Views", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_TableType_Type.tp_dict,
        "Views", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSql_TableType_Type,
        (long) QSql::AllTables, "AllTables");
    PyDict_SetItemString(SbkQSql_Type.super.ht_type.tp_dict,
        "AllTables", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSql_TableType_Type.tp_dict,
        "AllTables", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSql::TableType");

}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

