/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTSQL_PYTHON_H
#define SBK_QTSQL_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>

#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTSQL_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTSQL_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTSQL_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Class Includes
#include <qsql.h>
#include <qsqldatabase.h>
#include <qsqlresult.h>
#include <qsqlrecord.h>
#include <qsqlrelationaltablemodel.h>
#include <qsqlrelationaldelegate.h>
#include <qsqlerror.h>
#include <qsqlfield.h>
#include <qsqldatabase.h>
#include <qsqlquery.h>
#include <qsqlquerymodel.h>
#include <qsqltablemodel.h>
#include <qsqlrelationaltablemodel.h>
#include <qsqldriver.h>
#include <qsqlindex.h>

// Conversion Includes - Primitive Types
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QMap>
#include <QPair>
#include <QList>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QSet>
#include <QVector>

extern "C"
{

// Type indices
#define SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX                        0
#define SBK_QSQL_LOCATION_IDX                                        1
#define SBK_QSQL_PARAMTYPEFLAG_IDX                                   2
#define SBK_QFLAGS_QSQL_PARAMTYPEFLAG__IDX                           3
#define SBK_QSQL_TABLETYPE_IDX                                       4
#define SBK_QSQLDRIVERCREATORBASE_IDX                                5
#define SBK_QSQLRESULT_IDX                                           6
#define SBK_QSQLRESULT_BINDINGSYNTAX_IDX                             7
#define SBK_QSQLRESULT_VIRTUALHOOKOPERATION_IDX                      8
#define SBK_QSQLRECORD_IDX                                           9
#define SBK_QSQLRELATION_IDX                                         10
#define SBK_QSQLRELATIONALDELEGATE_IDX                               11
#define SBK_QSQLERROR_IDX                                            12
#define SBK_QSQLERROR_ERRORTYPE_IDX                                  13
#define SBK_QSQLFIELD_IDX                                            14
#define SBK_QSQLFIELD_REQUIREDSTATUS_IDX                             15
#define SBK_QSQLDATABASE_IDX                                         16
#define SBK_QSQLQUERY_IDX                                            17
#define SBK_QSQLQUERY_BATCHEXECUTIONMODE_IDX                         18
#define SBK_QSQLQUERYMODEL_IDX                                       19
#define SBK_QSQLTABLEMODEL_IDX                                       20
#define SBK_QSQLTABLEMODEL_EDITSTRATEGY_IDX                          21
#define SBK_QSQLRELATIONALTABLEMODEL_IDX                             22
#define SBK_QSQLDRIVER_IDX                                           23
#define SBK_QSQLDRIVER_STATEMENTTYPE_IDX                             24
#define SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX                            25
#define SBK_QSQLDRIVER_DRIVERFEATURE_IDX                             26
#define SBK_QSQLINDEX_IDX                                            27
#define SBK_QtSql_IDX_COUNT                                          28

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtSqlTypes;

// Useful macros
#define SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])
#define SbkPySide_QtSql_QSql_NumericalPrecisionPolicy_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])

#define SbkPySide_QtSql_QSql_Location_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_LOCATION_IDX])
#define SbkPySide_QtSql_QSql_Location_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_LOCATION_IDX])

#define SbkPySide_QtSql_QSql_ParamTypeFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX])
#define SbkPySide_QtSql_QSql_ParamTypeFlag_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX])
#define SbkPySide_QtSql_QSql_ParamType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG__IDX])
#define SbkPySide_QtSql_QSql_ParamType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG__IDX])

#define SbkPySide_QtSql_QSql_TableType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])
#define SbkPySide_QtSql_QSql_TableType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])

#define SbkQSqlDriverCreatorBase_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX])
#define SbkQSqlDriverCreatorBase_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX])
#define SbkPySide_QtSql_QSqlResult_BindingSyntax_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRESULT_BINDINGSYNTAX_IDX])
#define SbkPySide_QtSql_QSqlResult_BindingSyntax_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRESULT_BINDINGSYNTAX_IDX])

#define SbkPySide_QtSql_QSqlResult_VirtualHookOperation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRESULT_VIRTUALHOOKOPERATION_IDX])
#define SbkPySide_QtSql_QSqlResult_VirtualHookOperation_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRESULT_VIRTUALHOOKOPERATION_IDX])

#define SbkQSqlResult_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRESULT_IDX])
#define SbkQSqlResult_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRESULT_IDX])
#define SbkQSqlRecord_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRECORD_IDX])
#define SbkQSqlRecord_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRECORD_IDX])
#define SbkQSqlRelation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRELATION_IDX])
#define SbkQSqlRelation_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRELATION_IDX])
#define SbkQSqlRelationalDelegate_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRELATIONALDELEGATE_IDX])
#define SbkQSqlRelationalDelegate_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRELATIONALDELEGATE_IDX])
#define SbkPySide_QtSql_QSqlError_ErrorType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])
#define SbkPySide_QtSql_QSqlError_ErrorType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])

#define SbkQSqlError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLERROR_IDX])
#define SbkQSqlError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLERROR_IDX])
#define SbkPySide_QtSql_QSqlField_RequiredStatus_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLFIELD_REQUIREDSTATUS_IDX])
#define SbkPySide_QtSql_QSqlField_RequiredStatus_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLFIELD_REQUIREDSTATUS_IDX])

#define SbkQSqlField_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLFIELD_IDX])
#define SbkQSqlField_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLFIELD_IDX])
#define SbkQSqlDatabase_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDATABASE_IDX])
#define SbkQSqlDatabase_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDATABASE_IDX])
#define SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLQUERY_BATCHEXECUTIONMODE_IDX])
#define SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLQUERY_BATCHEXECUTIONMODE_IDX])

#define SbkQSqlQuery_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLQUERY_IDX])
#define SbkQSqlQuery_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLQUERY_IDX])
#define SbkQSqlQueryModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLQUERYMODEL_IDX])
#define SbkQSqlQueryModel_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLQUERYMODEL_IDX])
#define SbkPySide_QtSql_QSqlTableModel_EditStrategy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLTABLEMODEL_EDITSTRATEGY_IDX])
#define SbkPySide_QtSql_QSqlTableModel_EditStrategy_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLTABLEMODEL_EDITSTRATEGY_IDX])

#define SbkQSqlTableModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLTABLEMODEL_IDX])
#define SbkQSqlTableModel_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLTABLEMODEL_IDX])
#define SbkQSqlRelationalTableModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRELATIONALTABLEMODEL_IDX])
#define SbkQSqlRelationalTableModel_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLRELATIONALTABLEMODEL_IDX])
#define SbkPySide_QtSql_QSqlDriver_StatementType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX])
#define SbkPySide_QtSql_QSqlDriver_StatementType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX])

#define SbkPySide_QtSql_QSqlDriver_IdentifierType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])
#define SbkPySide_QtSql_QSqlDriver_IdentifierType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])

#define SbkPySide_QtSql_QSqlDriver_DriverFeature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX])
#define SbkPySide_QtSql_QSqlDriver_DriverFeature_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX])

#define SbkQSqlDriver_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDX])
#define SbkQSqlDriver_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDX])
#define SbkQSqlIndex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLINDEX_IDX])
#define SbkQSqlIndex_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSqlTypes[SBK_QSQLINDEX_IDX])

} // extern "C"

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<>
inline PyTypeObject* SbkType<QSql::NumericalPrecisionPolicy >() { return SbkPySide_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX]; }
template<>
inline PyTypeObject* SbkType<QSql::Location >() { return SbkPySide_QtSqlTypes[SBK_QSQL_LOCATION_IDX]; }
template<>
inline PyTypeObject* SbkType<QSql::ParamTypeFlag >() { return SbkPySide_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX]; }
template<>
inline PyTypeObject* SbkType<QFlags<QSql::ParamTypeFlag> >() { return SbkPySide_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG__IDX]; }
template<>
inline PyTypeObject* SbkType<QSql::TableType >() { return SbkPySide_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlDriverCreatorBase >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlResult::BindingSyntax >() { return SbkPySide_QtSqlTypes[SBK_QSQLRESULT_BINDINGSYNTAX_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlResult::VirtualHookOperation >() { return SbkPySide_QtSqlTypes[SBK_QSQLRESULT_VIRTUALHOOKOPERATION_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlResult >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLRESULT_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlRecord >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLRECORD_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlRelation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLRELATION_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlRelationalDelegate >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLRELATIONALDELEGATE_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlError::ErrorType >() { return SbkPySide_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlError >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLERROR_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlField::RequiredStatus >() { return SbkPySide_QtSqlTypes[SBK_QSQLFIELD_REQUIREDSTATUS_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlField >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLFIELD_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlDatabase >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLDATABASE_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlQuery::BatchExecutionMode >() { return SbkPySide_QtSqlTypes[SBK_QSQLQUERY_BATCHEXECUTIONMODE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlQuery >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLQUERY_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlQueryModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLQUERYMODEL_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlTableModel::EditStrategy >() { return SbkPySide_QtSqlTypes[SBK_QSQLTABLEMODEL_EDITSTRATEGY_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlTableModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLTABLEMODEL_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlRelationalTableModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLRELATIONALTABLEMODEL_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlDriver::StatementType >() { return SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlDriver::IdentifierType >() { return SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlDriver::DriverFeature >() { return SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSqlDriver >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDX]); }
template<>
inline PyTypeObject* SbkType<QSqlIndex >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSqlTypes[SBK_QSQLINDEX_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QSql::NumericalPrecisionPolicy > : EnumConverter<QSql::NumericalPrecisionPolicy >
{
};

template<>
struct Converter<QSql::Location > : EnumConverter<QSql::Location >
{
};

template<>
struct Converter<QSql::ParamTypeFlag > : EnumConverter<QSql::ParamTypeFlag >
{
};
template<>
struct Converter<QFlags<QSql::ParamTypeFlag> > : EnumConverter<QFlags<QSql::ParamTypeFlag> >
{
};

template<>
struct Converter<QSql::TableType > : EnumConverter<QSql::TableType >
{
};

template<>
struct Converter<QSqlDriverCreatorBase* > : ObjectTypeConverter<QSqlDriverCreatorBase >
{
};

template<>
struct Converter<QSqlDriverCreatorBase& > : ObjectTypeReferenceConverter<QSqlDriverCreatorBase >
{
};


template<>
struct Converter<QSqlResult::BindingSyntax > : EnumConverter<QSqlResult::BindingSyntax >
{
};

template<>
struct Converter<QSqlResult::VirtualHookOperation > : EnumConverter<QSqlResult::VirtualHookOperation >
{
};

template<>
struct Converter<QSqlResult* > : ObjectTypeConverter<QSqlResult >
{
};

template<>
struct Converter<QSqlResult& > : ObjectTypeReferenceConverter<QSqlResult >
{
};


template <>
struct SbkTypeInfo<QSqlRecord >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QSqlRecord > : ValueTypeConverter<QSqlRecord >
{
};

template<>
struct Converter<QSqlRelation > : ValueTypeConverter<QSqlRelation >
{
};

template<>
struct Converter<QSqlRelationalDelegate* > : ObjectTypeConverter<QSqlRelationalDelegate >
{
};

template<>
struct Converter<QSqlRelationalDelegate& > : ObjectTypeReferenceConverter<QSqlRelationalDelegate >
{
};


template<>
struct Converter<QSqlError::ErrorType > : EnumConverter<QSqlError::ErrorType >
{
};

template<>
struct Converter<QSqlError > : ValueTypeConverter<QSqlError >
{
};

template<>
struct Converter<QSqlField::RequiredStatus > : EnumConverter<QSqlField::RequiredStatus >
{
};

template<>
struct Converter<QSqlField > : ValueTypeConverter<QSqlField >
{
};

template<>
struct Converter<QSqlDatabase > : ValueTypeConverter<QSqlDatabase >
{
};

template<>
struct Converter<QSqlQuery::BatchExecutionMode > : EnumConverter<QSqlQuery::BatchExecutionMode >
{
};

template<>
struct Converter<QSqlQuery > : ValueTypeConverter<QSqlQuery >
{
    static QSqlQuery toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QSqlQueryModel* > : ObjectTypeConverter<QSqlQueryModel >
{
};

template<>
struct Converter<QSqlQueryModel& > : ObjectTypeReferenceConverter<QSqlQueryModel >
{
};


template<>
struct Converter<QSqlTableModel::EditStrategy > : EnumConverter<QSqlTableModel::EditStrategy >
{
};

template<>
struct Converter<QSqlTableModel* > : ObjectTypeConverter<QSqlTableModel >
{
};

template<>
struct Converter<QSqlTableModel& > : ObjectTypeReferenceConverter<QSqlTableModel >
{
};


template<>
struct Converter<QSqlRelationalTableModel* > : ObjectTypeConverter<QSqlRelationalTableModel >
{
};

template<>
struct Converter<QSqlRelationalTableModel& > : ObjectTypeReferenceConverter<QSqlRelationalTableModel >
{
};


template<>
struct Converter<QSqlDriver::StatementType > : EnumConverter<QSqlDriver::StatementType >
{
};

template<>
struct Converter<QSqlDriver::IdentifierType > : EnumConverter<QSqlDriver::IdentifierType >
{
};

template<>
struct Converter<QSqlDriver::DriverFeature > : EnumConverter<QSqlDriver::DriverFeature >
{
};

template<>
struct Converter<QSqlDriver* > : ObjectTypeConverter<QSqlDriver >
{
};

template<>
struct Converter<QSqlDriver& > : ObjectTypeReferenceConverter<QSqlDriver >
{
};


template <>
struct SbkTypeInfo<QSqlIndex >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QSqlIndex > : ValueTypeConverter<QSqlIndex >
{
};


} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QSqlQuery >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QSqlQuery >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSqlQuery >());
    return Shiboken::Converter<QSqlResult* >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QSqlQuery Shiboken::Converter<QSqlQuery >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QSqlQuery)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSqlQuery >());
        if (Shiboken::Converter<QSqlResult* >::isConvertible(pyobj))
            return QSqlQuery(Shiboken::Converter<QSqlResult* >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QSqlQuery* cptr = reinterpret_cast<QSqlQuery*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QSqlQuery > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTSQL_PYTHON_H

